/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.RangedListEntryBuilder;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.core.entry.AbstractListEntry;
import endorh.simpleconfig.ui.impl.builders.RangedListFieldBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RangedListEntry<V extends Comparable<V>, Config, Gui extends Comparable<Gui>, Self extends RangedListEntry<V, Config, Gui, Self>>
extends AbstractListEntry<V, Config, Gui, Self> {
    protected V min;
    protected V max;
    protected double commentMin = -2.147483648E9;
    protected double commentMax = 2.147483647E9;

    public RangedListEntry(ConfigEntryHolder parent, String name, @Nullable List<V> value) {
        super(parent, name, value);
    }

    protected String getRangeComment() {
        if (this.max == null && this.min == null) {
            return "~";
        }
        if (this.max instanceof Number || this.min instanceof Number) {
            boolean noMin;
            assert (this.max == null || this.max instanceof Number);
            assert (this.min == null || this.min instanceof Number);
            Number x = (Number)this.max;
            Number n = (Number)this.min;
            boolean noMax = x == null || x.doubleValue() >= this.commentMax;
            boolean bl = noMin = n == null || n.doubleValue() <= this.commentMin;
            if (noMax && noMin) {
                return "~";
            }
            if (noMax) {
                return ">= " + n;
            }
            if (noMin) {
                return "<= " + x;
            }
            return n + " ~ " + x;
        }
        if (this.max == null) {
            return ">= " + this.min;
        }
        if (this.min == null) {
            return "<= " + this.max;
        }
        return this.min + " ~ " + this.max;
    }

    @Override
    @Nullable
    protected String getListTypeComment() {
        return this.innerType.getSimpleName() + ", Range: " + this.getRangeComment();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected <F extends RangedListFieldBuilder<Gui, ?, ?, F>> F decorate(F builder) {
        builder = super.decorate(builder);
        ((RangedListFieldBuilder)builder.setMin((Comparable)((Comparable)this.elemForGui(this.min)))).setMax((Comparable)this.elemForGui(this.max));
        return builder;
    }

    public static abstract class Builder<V extends Comparable<V>, Config, Gui extends Comparable<Gui>, Entry extends RangedListEntry<V, Config, Gui, Entry>, Self extends RangedListEntryBuilder<V, Config, Gui, Self>, SelfImpl extends Builder<V, Config, Gui, Entry, Self, SelfImpl>>
    extends AbstractListEntry.Builder<V, Config, Gui, Entry, Self, SelfImpl>
    implements RangedListEntryBuilder<V, Config, Gui, Self> {
        protected V min = null;
        protected V max = null;

        public Builder(List<V> value, EntryType<?> type) {
            super(value, type);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Self min(@NotNull V min) {
            Builder copy = (Builder)this.copy();
            copy.min = min;
            return (Self)copy.elemError((Function)this.clamp(this.elemErrorSupplier));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Self max(@NotNull V max) {
            Builder copy = (Builder)this.copy();
            copy.max = max;
            return (Self)copy.elemError((Function)this.clamp(this.elemErrorSupplier));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Self range(V min, V max) {
            Builder copy = (Builder)this.copy();
            copy.min = min;
            copy.max = max;
            return (Self)copy.elemError((Function)this.clamp(this.elemErrorSupplier));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Self elemError(Function<V, Optional<Component>> errorSupplier) {
            return (Self)((RangedListEntryBuilder)super.elemError(this.clamp(errorSupplier)));
        }

        protected Function<V, Optional<Component>> clamp(@Nullable Function<V, Optional<Component>> validator) {
            this.checkBounds();
            return t -> {
                if (t.compareTo(this.min) < 0) {
                    return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.too_small", (Object[])new Object[]{Builder.coloredBound(this.min)}));
                }
                if (t.compareTo(this.max) > 0) {
                    return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.too_large", (Object[])new Object[]{Builder.coloredBound(this.max)}));
                }
                return validator != null ? (Optional)validator.apply(t) : Optional.empty();
            };
        }

        protected static MutableComponent coloredBound(Object bound) {
            return Component.m_237113_((String)String.valueOf(bound)).m_130940_(ChatFormatting.DARK_AQUA);
        }

        protected void checkBounds() {
        }

        @Override
        protected Entry build(@NotNull ConfigEntryHolder parent, String name) {
            this.checkBounds();
            RangedListEntry e = (RangedListEntry)super.build(parent, name);
            e.min = this.min;
            e.max = this.max;
            return (Entry)e;
        }

        @Override
        public SelfImpl copy(List<V> value) {
            Builder copy = (Builder)super.copy(value);
            copy.min = this.min;
            copy.max = this.max;
            return (SelfImpl)copy;
        }
    }
}

