/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import endorh.simpleconfig.api.ConfigBuilderFactoryProxy;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.PresetSwitcherEntryBuilder;
import endorh.simpleconfig.core.AbstractSimpleConfigEntryHolder;
import endorh.simpleconfig.core.DummyEntryHolder;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.core.entry.GUIOnlyEntry;
import endorh.simpleconfig.core.entry.StringEntry;
import endorh.simpleconfig.ui.api.AbstractConfigListEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.gui.AbstractConfigScreen;
import endorh.simpleconfig.ui.impl.builders.EntryButtonFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PresetSwitcherEntry
extends GUIOnlyEntry<String, String, PresetSwitcherEntry> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected StringEntry inner;
    protected Map<String, Map<String, Object>> presets;
    protected boolean global;
    protected String path;

    public PresetSwitcherEntry(ConfigEntryHolder parent, String name, Map<String, Map<String, Object>> presets, String path, boolean global) {
        super(parent, name, PresetSwitcherEntry.firstKey(presets), false, String.class);
        if (!(parent instanceof AbstractSimpleConfigEntryHolder)) {
            throw new IllegalArgumentException("Invalid parent for Preset Switcher Entry");
        }
        this.presets = presets;
        this.path = path;
        this.global = global;
        this.inner = (StringEntry)DummyEntryHolder.build(parent, ConfigBuilderFactoryProxy.string(PresetSwitcherEntry.firstKey(presets)).restrict(new ArrayList<String>(presets.keySet())));
    }

    protected static String firstKey(Map<String, Map<String, Object>> presets) {
        return (String)presets.keySet().stream().findFirst().orElseThrow(() -> new IllegalArgumentException("At least one preset must be specified"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void applyPreset(String name) {
        if (!this.presets.containsKey(name)) {
            throw new IllegalArgumentException("Unknown preset: \"" + name + "\"");
        }
        Map<String, Object> preset = this.presets.get(name);
        ConfigEntryHolder h = (this.global ? this.parent.getRoot() : (AbstractSimpleConfigEntryHolder)this.parent).getChild(this.path);
        AbstractConfigListEntry guiEntry = this.getGuiEntry();
        if (guiEntry != null) {
            AbstractConfigScreen screen = guiEntry.getScreen();
            screen.runAtomicTransparentAction(() -> {
                for (Map.Entry entry : preset.entrySet()) {
                    try {
                        h.setForGUI((String)entry.getKey(), entry.getValue());
                    }
                    catch (RuntimeException e) {
                        LOGGER.warn("Unable to set preset (" + name + ") entry: \"" + (String)entry.getKey() + "\"\nDetails: " + e.getClass().getSimpleName() + ": " + e.getLocalizedMessage());
                    }
                }
            });
        }
    }

    public <E extends AbstractConfigListEntry<String>, B extends FieldBuilder<String, E, B>> EntryButtonFieldBuilder<String, E, B> makeGUIEntry(ConfigFieldBuilder builder, FieldBuilder<String, ?, ?> entryBuilder, Consumer<String> action) {
        return builder.startButton(this.getDisplayName(), entryBuilder, action);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<String, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        EntryButtonFieldBuilder entryBuilder = this.makeGUIEntry(builder, (FieldBuilder<String, ?, ?>)this.inner.buildAtomicChildGUIEntry(builder), this::applyPreset).withButtonLabel(() -> Component.m_237115_((String)"simpleconfig.label.preset.apply"));
        return Optional.of(entryBuilder);
    }

    public static class Builder
    extends GUIOnlyEntry.Builder<String, String, PresetSwitcherEntry, PresetSwitcherEntryBuilder, Builder>
    implements PresetSwitcherEntryBuilder {
        protected Map<String, Map<String, Object>> presets;
        protected String path;
        protected boolean global;

        public Builder(Map<String, Map<String, Object>> presets, String path, boolean global) {
            super(PresetSwitcherEntry.firstKey(presets), EntryType.of(String.class, new EntryType[0]));
            this.presets = presets;
            this.path = path;
            this.global = global;
        }

        @Override
        protected PresetSwitcherEntry buildEntry(ConfigEntryHolder parent, String name) {
            return new PresetSwitcherEntry(parent, name, this.presets, this.path, this.global);
        }

        @Override
        protected Builder createCopy(String value) {
            return new Builder(new HashMap<String, Map<String, Object>>(this.presets), this.path, this.global);
        }
    }
}

