/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.PatternEntryBuilder;
import endorh.simpleconfig.api.ui.TextFormatter;
import endorh.simpleconfig.core.entry.AbstractSerializableEntry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatternEntry
extends AbstractSerializableEntry<Pattern> {
    protected final int flags;
    private static final Map<Integer, String> FLAG_NAMES = new HashMap<Integer, String>();

    @ApiStatus.Internal
    public PatternEntry(ConfigEntryHolder parent, String name, Pattern value) {
        super(parent, name, value, Pattern.class);
        this.flags = value.flags();
    }

    @Override
    protected String serialize(Pattern value) {
        return value.pattern();
    }

    @Override
    @Nullable
    protected Pattern deserialize(String value) {
        try {
            return Pattern.compile(value, this.flags);
        }
        catch (PatternSyntaxException e) {
            return null;
        }
    }

    @Override
    protected List<Component> addExtraTooltip(String value) {
        List<Component> extra = super.addExtraTooltip(value);
        if (this.flags != 0) {
            extra.add(0, (Component)Component.m_237110_((String)"simpleconfig.config.help.pattern_flags", (Object[])new Object[]{PatternEntry.displayFlags(this.flags)}).m_130940_(ChatFormatting.GRAY));
        }
        return extra;
    }

    public static String displayFlags(int flags) {
        if (flags == 0) {
            return "";
        }
        StringBuilder f = new StringBuilder("(?");
        for (int k : FLAG_NAMES.keySet()) {
            if ((k & flags) == 0) continue;
            f.append(FLAG_NAMES.get(k));
        }
        if ((flags & 0x10) != 0) {
            f.append("+LITERAL");
        }
        if ((flags & 0x80) != 0) {
            f.append("+CANON_EQ");
        }
        return f + ")";
    }

    @Override
    protected Optional<Component> getErrorMessage(String value) {
        try {
            Pattern.compile(value, this.flags);
            return super.getErrorMessage(value);
        }
        catch (PatternSyntaxException e) {
            return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.invalid_pattern", (Object[])new Object[]{e.getMessage().trim().replace("\r\n", ": ")}));
        }
    }

    @Override
    public List<String> getConfigCommentTooltips() {
        List<String> tooltips = super.getConfigCommentTooltips();
        if (this.flags != 0) {
            tooltips.add("Flags: " + PatternEntry.displayFlags(this.flags));
        }
        return tooltips;
    }

    @Override
    protected TextFormatter getTextFormatter() {
        return TextFormatter.forLanguageOrDefault("regex", TextFormatter.DEFAULT);
    }

    static {
        FLAG_NAMES.put(1, "d");
        FLAG_NAMES.put(2, "i");
        FLAG_NAMES.put(4, "x");
        FLAG_NAMES.put(8, "m");
        FLAG_NAMES.put(16, "");
        FLAG_NAMES.put(32, "s");
        FLAG_NAMES.put(64, "u");
        FLAG_NAMES.put(128, "");
        FLAG_NAMES.put(256, "U");
    }

    public static class Builder
    extends AbstractSerializableEntry.Builder<Pattern, PatternEntry, PatternEntryBuilder, Builder>
    implements PatternEntryBuilder {
        public Builder(Pattern value) {
            super(value, Pattern.class);
        }

        public Builder(String pattern) {
            this(Pattern.compile(pattern));
        }

        public Builder(String pattern, int flags) {
            this(Pattern.compile(pattern, flags));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder flags(int flags) {
            Builder copy = (Builder)this.copy();
            try {
                copy.value = Pattern.compile(((Pattern)this.value).pattern(), flags);
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException("Cannot compile default pattern value with the new flags");
            }
            return copy;
        }

        @Override
        protected PatternEntry buildEntry(ConfigEntryHolder parent, String name) {
            return new PatternEntry(parent, name, (Pattern)this.value);
        }

        @Override
        protected Builder createCopy(Pattern value) {
            return new Builder(value);
        }
    }
}

