/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.OptionEntryBuilder;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractConfigEntryBuilder;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import endorh.simpleconfig.ui.impl.builders.SelectorBuilder;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionEntry<T>
extends AbstractConfigEntry<T, String, T> {
    private static final Gson GSON = new Gson();
    public Supplier<List<T>> valueSupplier;
    public Function<T, String> serializer;
    public Function<String, @Nullable T> deserializer;
    public Function<T, Component> displayer;

    protected OptionEntry(ConfigEntryHolder parent, String name, T defValue) {
        super(parent, name, defValue);
    }

    @Override
    public String forConfig(T value) {
        return this.serializer.apply(value);
    }

    @Override
    @Nullable
    public T fromConfig(@Nullable String value) {
        return this.deserializer.apply(value);
    }

    @Override
    public List<String> getConfigCommentTooltips() {
        List<String> tooltips = super.getConfigCommentTooltips();
        tooltips.add(0, "[Option: " + this.valueSupplier.get().stream().map(this.serializer).collect(Collectors.joining(" | ")) + "]");
        return tooltips;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<T, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        SelectorBuilder<Object> entryBuilder = builder.startSelector(this.getDisplayName(), this.valueSupplier.get().toArray(), this.forGui(this.get())).setNameProvider(this.displayer);
        return Optional.of(this.decorate(entryBuilder));
    }

    public static class Builder<T>
    extends AbstractConfigEntryBuilder<T, String, T, OptionEntry<T>, OptionEntryBuilder<T>, Builder<T>>
    implements OptionEntryBuilder<T> {
        Supplier<List<T>> valueSupplier = () -> Lists.newArrayList((Object[])new Object[]{this.value});
        Function<T, String> serializer = Object::toString;
        @Nullable
        @Nullable Function<String, @Nullable T> deserializer = null;
        Function<T, Component> displayer = t -> Component.m_237113_((String)t.toString());

        public Builder(T value) {
            this(value, value.getClass());
        }

        public Builder(T value, Class<?> typeClass) {
            super(value, EntryType.unchecked(typeClass));
        }

        public Builder(T value, EntryType<?> type) {
            super(value, type);
        }

        @Override
        @NotNull
        public OptionEntryBuilder<T> withOptions(Supplier<List<T>> options) {
            Builder copy = (Builder)this.copy();
            copy.valueSupplier = options;
            return copy;
        }

        @Override
        @NotNull
        public OptionEntryBuilder<T> withOptions(List<T> options) {
            return this.withOptions(() -> options);
        }

        @Override
        @SafeVarargs
        @NotNull
        public final OptionEntryBuilder<T> withOptions(T ... options) {
            return this.withOptions(Lists.newArrayList((Object[])options));
        }

        @Override
        @NotNull
        public OptionEntryBuilder<T> withDisplay(Function<T, Component> display) {
            Builder copy = (Builder)this.copy();
            copy.displayer = display;
            return copy;
        }

        @Override
        @NotNull
        public OptionEntryBuilder<T> withCodec(Codec<T> codec) {
            Builder copy = (Builder)this.copy();
            copy.serializer = t -> {
                if (t == null) {
                    return "";
                }
                DataResult dr = codec.encodeStart((DynamicOps)JsonOps.INSTANCE, t);
                if (dr.error().isPresent()) {
                    dr = codec.encodeStart((DynamicOps)JsonOps.INSTANCE, this.value);
                }
                if (dr.error().isPresent()) {
                    return "";
                }
                return dr.result().map(arg_0 -> ((Gson)GSON).toJson(arg_0)).orElse("");
            };
            copy.deserializer = s -> {
                JsonReader reader = new JsonReader((Reader)new StringReader(s == null || s.isEmpty() ? "\"\"" : s));
                JsonElement elem = JsonParser.parseReader((JsonReader)reader);
                DataResult dr = codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)elem);
                if (dr.error().isPresent()) {
                    return null;
                }
                return dr.result().orElse(null);
            };
            return copy;
        }

        @Override
        @NotNull
        public OptionEntryBuilder<T> withSerializer(Function<T, String> serializer) {
            Builder copy = (Builder)this.copy();
            copy.serializer = serializer;
            copy.deserializer = null;
            return copy;
        }

        @Override
        @NotNull
        public OptionEntryBuilder<T> withSerializer(Function<T, String> serializer, Function<String, T> deserializer) {
            Builder copy = (Builder)this.copy();
            copy.serializer = serializer;
            copy.deserializer = deserializer;
            return copy;
        }

        @Override
        protected OptionEntry<T> buildEntry(ConfigEntryHolder parent, String name) {
            OptionEntry<Object> entry = new OptionEntry<Object>(parent, name, this.value);
            entry.valueSupplier = this.valueSupplier;
            entry.serializer = this.serializer;
            entry.deserializer = Objects.requireNonNullElseGet(this.deserializer, () -> s -> entry.valueSupplier.get().stream().filter(t -> entry.serializer.apply(t).equals(s)).findFirst().orElse(null));
            entry.displayer = this.displayer;
            return entry;
        }

        @Override
        protected Builder<T> createCopy(T value) {
            Builder<T> copy = new Builder<T>(value, this.typeClass);
            copy.valueSupplier = this.valueSupplier;
            copy.serializer = this.serializer;
            copy.deserializer = this.deserializer;
            copy.displayer = this.displayer;
            return copy;
        }
    }
}

