/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.LongRangeEntryBuilder;
import endorh.simpleconfig.api.range.LongRange;
import endorh.simpleconfig.core.entry.AbstractRangeEntry;
import endorh.simpleconfig.ui.api.AbstractConfigListEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.LongFieldBuilder;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class LongRangeEntry
extends AbstractRangeEntry.AbstractSizedRangeEntry<Long, LongRange, LongRangeEntry> {
    protected LongRangeEntry(ConfigEntryHolder parent, String name, LongRange value) {
        super(parent, name, value);
    }

    @Override
    protected Long deserializeElement(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected <EE extends AbstractConfigListEntry<Long>> EE buildLimitGUIEntry(ConfigFieldBuilder builder, String name, Long value) {
        return (EE)((LongFieldBuilder)((LongFieldBuilder)((LongFieldBuilder)((LongFieldBuilder)builder.startLongField((Component)Component.m_237113_((String)name), value).setDefaultValue(value)).setMin((Long)this.min)).setMax((Long)this.max)).setName(name)).build();
    }

    @Override
    public Optional<Component> getErrorFromGUI(LongRange value) {
        if (value.getMin() == null || value.getMax() == null) {
            return Optional.of(Component.m_237115_((String)"simpleconfig.config.error.invalid_integer"));
        }
        return super.getErrorFromGUI(value);
    }

    public static class Builder
    extends AbstractRangeEntry.AbstractSizedRangeEntry.Builder<Long, LongRange, LongRangeEntry, LongRangeEntryBuilder, Builder>
    implements LongRangeEntryBuilder {
        public Builder(LongRange value) {
            super(value, LongRange.class);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public LongRangeEntryBuilder min(long min) {
            return (LongRangeEntryBuilder)this.min(Long.valueOf(min));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public LongRangeEntryBuilder max(long max) {
            return (LongRangeEntryBuilder)this.max(Long.valueOf(max));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public LongRangeEntryBuilder withBounds(long min, long max) {
            return (LongRangeEntryBuilder)this.withBounds(Long.valueOf(min), Long.valueOf(max));
        }

        @Override
        protected LongRangeEntry buildEntry(ConfigEntryHolder parent, String name) {
            return new LongRangeEntry(parent, name, (LongRange)this.value);
        }

        @Override
        protected Builder createCopy(LongRange value) {
            return new Builder(value);
        }
    }
}

