/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.LongListEntryBuilder;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.core.entry.RangedListEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import endorh.simpleconfig.ui.impl.builders.LongListBuilder;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LongListEntry
extends RangedListEntry<Long, Number, Long, LongListEntry> {
    @ApiStatus.Internal
    public LongListEntry(ConfigEntryHolder parent, String name, @Nullable List<Long> value) {
        super(parent, name, value);
    }

    @Override
    protected Long elemFromConfig(Number value) {
        return value != null ? Long.valueOf(value.longValue()) : null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<List<Long>, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        LongListBuilder valBuilder = builder.startLongList(this.getDisplayName(), (List)this.get());
        return Optional.of(this.decorate(valBuilder));
    }

    public static class Builder
    extends RangedListEntry.Builder<Long, Number, Long, LongListEntry, LongListEntryBuilder, Builder>
    implements LongListEntryBuilder {
        public Builder(List<Long> value) {
            super(value, EntryType.of(Long.class, new EntryType[0]));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public LongListEntryBuilder min(long min) {
            return (LongListEntryBuilder)super.min(min);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public LongListEntryBuilder max(long max) {
            return (LongListEntryBuilder)super.max(max);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public LongListEntryBuilder range(long min, long max) {
            return (LongListEntryBuilder)super.range(min, max);
        }

        @Override
        protected void checkBounds() {
            this.min = Long.valueOf(this.min != null ? (Long)this.min : Long.MIN_VALUE);
            this.max = Long.valueOf(this.max != null ? (Long)this.max : Long.MAX_VALUE);
        }

        @Override
        protected LongListEntry buildEntry(ConfigEntryHolder parent, String name) {
            return new LongListEntry(parent, name, (List)this.value);
        }

        @Override
        protected Builder createCopy(List<Long> value) {
            return new Builder((List<Long>)new LongArrayList(value));
        }
    }
}

