/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.LongEntryBuilder;
import endorh.simpleconfig.core.AtomicEntry;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.core.entry.AbstractRangedEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import endorh.simpleconfig.ui.impl.builders.LongFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.LongSliderBuilder;
import java.util.Optional;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class LongEntry
extends AbstractRangedEntry<Long, Number, Long>
implements AtomicEntry<Long> {
    @ApiStatus.Internal
    public LongEntry(ConfigEntryHolder parent, String name, long value) {
        super(parent, name, value);
        this.commentMin = -9.223372036854776E18;
        this.commentMax = 9.223372036854776E18;
    }

    @Override
    @Nullable
    public Long fromConfig(@Nullable Number value) {
        return value != null ? Long.valueOf(value.longValue()) : null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<Long, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        if (!this.asSlider) {
            LongFieldBuilder valBuilder = (LongFieldBuilder)((LongFieldBuilder)builder.startLongField(this.getDisplayName(), (Long)this.get()).setMin((Long)this.min)).setMax((Long)this.max);
            return Optional.of(this.decorate(valBuilder));
        }
        LongSliderBuilder valBuilder = (LongSliderBuilder)((LongSliderBuilder)((LongSliderBuilder)((LongSliderBuilder)builder.startLongSlider(this.getDisplayName(), (Long)this.get(), (Long)this.min, (Long)this.max).setSliderMin((Long)this.sliderMin)).setSliderMax((Long)this.sliderMax)).setSliderMap(this.sliderMap)).setTextGetter(this.sliderTextSupplier);
        return Optional.of(this.decorate(valBuilder));
    }

    public static class Builder
    extends AbstractRangedEntry.Builder<Long, Number, Long, LongEntry, LongEntryBuilder, Builder>
    implements LongEntryBuilder {
        public Builder(Long value) {
            super(value, EntryType.of(Long.class, new EntryType[0]));
        }

        @Override
        protected void checkBounds() {
            this.min = Long.valueOf(this.min == null ? Long.MIN_VALUE : (Long)this.min);
            this.max = Long.valueOf(this.max == null ? Long.MAX_VALUE : (Long)this.max);
            super.checkBounds();
        }

        @Override
        protected LongEntry buildEntry(ConfigEntryHolder parent, String name) {
            return new LongEntry(parent, name, (Long)this.value);
        }

        @Override
        protected Builder createCopy(Long value) {
            return new Builder(value);
        }
    }
}

