/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.KeyBindEntryBuilder;
import endorh.simpleconfig.api.ui.hotkey.ExtendedKeyBind;
import endorh.simpleconfig.api.ui.hotkey.ExtendedKeyBindProvider;
import endorh.simpleconfig.api.ui.hotkey.ExtendedKeyBindSettings;
import endorh.simpleconfig.api.ui.hotkey.KeyBindMapping;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractConfigEntryBuilder;
import endorh.simpleconfig.core.AtomicEntry;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.core.SimpleConfigGUIManagerImpl;
import endorh.simpleconfig.ui.api.AbstractConfigListEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.hotkey.ExtendedKeyBindDispatcher;
import endorh.simpleconfig.ui.hotkey.ExtendedKeyBindImpl;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import endorh.simpleconfig.ui.impl.builders.KeyBindFieldBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class KeyBindEntry
extends AbstractConfigEntry<KeyBindMapping, String, KeyBindMapping>
implements AtomicEntry<KeyBindMapping> {
    private static final Int2ObjectMap<List<ExtendedKeyBind>> UNBOUND = new Int2ObjectOpenHashMap();
    private static final ExtendedKeyBindProvider UNBOUND_PROVIDER = new ExtendedKeyBindProvider(){

        @Override
        @NotNull
        public Iterable<ExtendedKeyBind> getActiveKeyBinds() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public Iterable<ExtendedKeyBind> getAllKeyBinds() {
            return KeyBindEntry.getUnbound();
        }

        @Override
        public int getPriority() {
            return -1000;
        }
    };
    protected ExtendedKeyBindSettings defaultSettings;
    @Nullable
    protected ExtendedKeyBindImpl keyBind;
    protected boolean reportOverlaps = true;
    private ExtendedKeyBind pendingKeyBind = null;

    private static List<ExtendedKeyBind> getUnbound() {
        int session = SimpleConfigGUIManagerImpl.INSTANCE.getGuiSession();
        UNBOUND.keySet().removeIf(i -> i < session - 1);
        return (List)UNBOUND.computeIfAbsent(session, s -> new ArrayList());
    }

    public KeyBindEntry(ConfigEntryHolder parent, String name, KeyBindMapping value) {
        super(parent, name, value);
    }

    @Override
    public String forConfig(KeyBindMapping value) {
        return value != null ? value.serialize() : "";
    }

    @Override
    public KeyBindMapping fromConfig(@Nullable String value) {
        return value == null ? null : KeyBindMapping.parse(value);
    }

    @Override
    protected void setGuiEntry(@Nullable AbstractConfigListEntry<KeyBindMapping> guiEntry) {
        if (guiEntry != null && this.pendingKeyBind != null) {
            KeyBindEntry.getUnbound().add(this.pendingKeyBind);
            this.pendingKeyBind = null;
        }
        super.setGuiEntry(guiEntry);
        if (this.keyBind != null) {
            this.keyBind.setCandidateDefinition(null);
        }
    }

    protected String getTypeComment() {
        return "Hotkey";
    }

    protected String getFormatComment() {
        return "!key+\"char\"+mouse.left!>:press#game";
    }

    @Override
    public List<String> getConfigCommentTooltips() {
        List<String> tooltips = super.getConfigCommentTooltips();
        tooltips.add(this.getTypeComment() + ": " + this.getFormatComment());
        return tooltips;
    }

    @Nullable
    protected ExtendedKeyBindImpl createFallbackKeyBind() {
        ExtendedKeyBindImpl keyBind = new ExtendedKeyBindImpl(this.parent.getRoot().getModId(), this.getDisplayName(), (KeyBindMapping)this.get(), () -> {});
        this.pendingKeyBind = keyBind;
        return keyBind;
    }

    @Override
    protected void bakeField() {
        super.bakeField();
        if (this.keyBind != null) {
            this.keyBind.setDefinition((KeyBindMapping)this.get());
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<KeyBindMapping, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        KeyBindFieldBuilder valBuilder = builder.startKeyBindField(this.getDisplayName(), (KeyBindMapping)this.forGui((KeyBindMapping)this.get())).setAssociatedKeyBind(this.keyBind != null ? this.keyBind : this.createFallbackKeyBind()).setReportOverlaps(this.reportOverlaps).setDefaultSettings(this.defaultSettings);
        return Optional.of(this.decorate(valBuilder));
    }

    static {
        ExtendedKeyBindDispatcher.registerProvider(UNBOUND_PROVIDER);
    }

    public static class Builder
    extends AbstractConfigEntryBuilder<KeyBindMapping, String, KeyBindMapping, KeyBindEntry, KeyBindEntryBuilder, Builder>
    implements KeyBindEntryBuilder {
        protected ExtendedKeyBindSettings defaultSettings = ExtendedKeyBindSettings.ingame().build();
        @Nullable
        protected ExtendedKeyBindImpl keyBind = null;
        protected boolean reportOverlaps = true;
        protected boolean inheritTitle = false;

        public Builder() {
            this(KeyBindMapping.unset());
        }

        public Builder(String key) {
            this(KeyBindMapping.parse(key));
        }

        public Builder(KeyBindMapping value) {
            super(value, EntryType.of(KeyBindMapping.class, new EntryType[0]));
        }

        @Override
        @NotNull
        public Builder withDefaultSettings(ExtendedKeyBindSettings settings) {
            Builder copy = (Builder)this.copy();
            copy.defaultSettings = settings;
            return copy;
        }

        @Override
        @NotNull
        public Builder bakeTo(ExtendedKeyBind keyBind) {
            Builder copy = (Builder)this.copy();
            if (!(keyBind instanceof ExtendedKeyBindImpl)) {
                throw new IllegalArgumentException("Keybind is not instance of ExtendedKeyBindImpl");
            }
            copy.keyBind = (ExtendedKeyBindImpl)keyBind;
            return copy;
        }

        @Override
        @NotNull
        public Builder reportOverlaps(boolean reportOverlaps) {
            Builder copy = (Builder)this.copy();
            copy.reportOverlaps = reportOverlaps;
            return copy;
        }

        @Override
        @NotNull
        public Builder inheritTitle() {
            return this.inheritTitle(true);
        }

        @Override
        @NotNull
        public Builder inheritTitle(boolean inheritTitle) {
            Builder copy = (Builder)this.copy();
            copy.inheritTitle = inheritTitle;
            return copy;
        }

        @Override
        protected KeyBindEntry buildEntry(ConfigEntryHolder parent, String name) {
            KeyBindEntry entry = new KeyBindEntry(parent, name, (KeyBindMapping)this.value);
            entry.defaultSettings = this.defaultSettings;
            entry.keyBind = this.keyBind;
            entry.reportOverlaps = this.reportOverlaps;
            if (this.inheritTitle && this.keyBind != null) {
                this.keyBind.setTitle(entry.getDisplayName());
            }
            return entry;
        }

        @Override
        @Contract(value="_ -> new", pure=true)
        protected Builder createCopy(KeyBindMapping value) {
            Builder copy = new Builder(value.copy());
            copy.defaultSettings = this.defaultSettings;
            copy.keyBind = this.keyBind;
            copy.reportOverlaps = this.reportOverlaps;
            return copy;
        }
    }
}

