/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.api.entry.ItemNameEntryBuilder;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.core.entry.AbstractResourceEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.ComboBoxFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemNameEntry
extends AbstractResourceEntry<ItemNameEntry> {
    @ApiStatus.Internal
    public ItemNameEntry(ConfigEntryHolder parent, String name, @Nullable ResourceLocation value) {
        super(parent, name, value != null ? value : new ResourceLocation(""));
    }

    @Override
    @Nullable
    protected String getTypeComment() {
        return "Item";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<ResourceLocation, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        ComboBoxFieldBuilder<ResourceLocation> entryBuilder = builder.startComboBox(this.getDisplayName(), ComboBoxFieldBuilder.ofItemName(), (ResourceLocation)this.forGui((ResourceLocation)this.get()));
        return Optional.of(this.decorate(entryBuilder));
    }

    @Override
    public boolean addCommandSuggestions(SuggestionsBuilder builder) {
        super.addCommandSuggestions(builder);
        ResourceLocation current = (ResourceLocation)this.get();
        for (ResourceLocation o : ForgeRegistries.ITEMS.getKeys()) {
            if (o.equals((Object)current) || o.equals(this.defValue) || !this.isValidValue(o)) continue;
            builder.suggest(this.forCommand(o));
        }
        return true;
    }

    public static class Builder
    extends AbstractResourceEntry.Builder<ItemNameEntry, ItemNameEntryBuilder, Builder>
    implements ItemNameEntryBuilder {
        protected TagKey<Item> tag = null;

        public Builder(ResourceLocation value) {
            super(value, EntryType.of(ResourceLocation.class, new EntryType[0]));
            this.suggestionSupplier = () -> ForgeRegistries.ITEMS.getValues().stream().map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getKey(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder suggest(Ingredient ingredient) {
            Builder copy = (Builder)this.copy();
            copy.suggestionSupplier = () -> Arrays.stream(ingredient.m_43908_()).map(s -> ForgeRegistries.ITEMS.getKey((Object)s.m_41720_())).filter(Objects::nonNull).collect(Collectors.toList());
            return copy;
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder suggest(TagKey<Item> tag) {
            Builder copy = (Builder)this.copy();
            copy.tag = tag;
            return copy;
        }

        @Override
        protected ItemNameEntry buildEntry(ConfigEntryHolder parent, String name) {
            if (parent.getRoot().getType() != SimpleConfig.Type.SERVER && this.tag != null) {
                throw new IllegalArgumentException("Cannot use tag item filters in non-server config entry");
            }
            if (this.tag != null) {
                Supplier supplier = this.suggestionSupplier;
                this.suggestionSupplier = () -> this.lambda$buildEntry$3((Supplier)supplier);
            }
            return new ItemNameEntry(parent, name, (ResourceLocation)this.value);
        }

        @Override
        protected Builder createCopy(ResourceLocation value) {
            Builder copy = new Builder(value);
            copy.tag = this.tag;
            return copy;
        }

        private /* synthetic */ List lambda$buildEntry$3(Supplier supplier) {
            return Stream.concat(supplier != null ? ((List)supplier.get()).stream() : Stream.empty(), ForgeRegistries.ITEMS.tags().getTag(this.tag).stream().map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getKey(arg_0))).collect(Collectors.toList());
        }
    }
}

