/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.api.entry.ItemEntryBuilder;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractConfigEntryBuilder;
import endorh.simpleconfig.core.AtomicEntry;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.gui.widget.combobox.SimpleComboBoxModel;
import endorh.simpleconfig.ui.impl.builders.ComboBoxFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ItemEntry
extends AbstractConfigEntry<Item, String, Item>
implements AtomicEntry<Item> {
    @NotNull
    protected Predicate<Item> filter;

    @ApiStatus.Internal
    public ItemEntry(ConfigEntryHolder parent, String name, @Nullable Item value, Predicate<Item> filter) {
        super(parent, name, value != null ? value : Items.f_41852_);
        this.filter = filter != null ? filter : i -> true;
    }

    protected List<Item> supplyOptions() {
        return ForgeRegistries.ITEMS.getValues().stream().filter(this.filter).collect(Collectors.toList());
    }

    @Override
    public String forConfig(Item value) {
        return ForgeRegistries.ITEMS.getKey((Object)value).toString();
    }

    @Override
    @Nullable
    public Item fromConfig(@Nullable String value) {
        if (value == null) {
            return null;
        }
        try {
            ResourceLocation name = new ResourceLocation(value);
            Item item = ForgeRegistries.ITEMS.containsKey(name) ? (Item)ForgeRegistries.ITEMS.getValue(name) : null;
            return this.filter.test(item) || item == this.defValue ? item : null;
        }
        catch (ResourceLocationException e) {
            return null;
        }
    }

    @Override
    public List<String> getConfigCommentTooltips() {
        List<String> tooltips = super.getConfigCommentTooltips();
        tooltips.add("Item: namespace:path");
        return tooltips;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<Item, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        ComboBoxFieldBuilder<Item> entryBuilder = builder.startComboBox(this.getDisplayName(), ComboBoxFieldBuilder.ofItem(), (Item)this.forGui((Item)this.get())).setSuggestionProvider(new SimpleComboBoxModel(this::supplyOptions)).setSuggestionMode(false);
        return Optional.of(this.decorate(entryBuilder));
    }

    @Override
    public boolean addCommandSuggestions(SuggestionsBuilder builder) {
        super.addCommandSuggestions(builder);
        Item current = (Item)this.get();
        for (Item o : this.supplyOptions()) {
            if (o.equals(current) || o.equals(this.defValue) || !this.isValidValue(o)) continue;
            builder.suggest(this.forCommand(o));
        }
        return true;
    }

    public static class Builder
    extends AbstractConfigEntryBuilder<Item, String, Item, ItemEntry, ItemEntryBuilder, Builder>
    implements ItemEntryBuilder {
        private static final Logger LOGGER = LogManager.getLogger();
        @Nullable
        protected Predicate<Item> filter = null;
        @Nullable
        protected TagKey<Item> tag = null;

        public Builder(Item value) {
            super(value, EntryType.of(Item.class, new EntryType[0]));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder setRequireGroup(boolean requireGroup) {
            return (Builder)this.copy();
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder from(Ingredient filter) {
            return this.from(i -> filter.test(new ItemStack((ItemLike)i)));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder from(Predicate<Item> filter) {
            Builder copy = (Builder)this.copy();
            copy.filter = filter;
            return copy;
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder from(List<Item> items) {
            ArrayList<Item> listCopy = new ArrayList<Item>(items);
            return this.from(listCopy::contains);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder from(Item ... items) {
            return this.from(Ingredient.m_43929_((ItemLike[])items));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder from(TagKey<Item> tag) {
            Builder copy = (Builder)this.copy();
            copy.tag = tag;
            return copy;
        }

        @Override
        protected ItemEntry buildEntry(ConfigEntryHolder parent, String name) {
            if (parent.getRoot().getType() != SimpleConfig.Type.SERVER && this.tag != null) {
                throw new IllegalArgumentException("Cannot use tag item filters in non-server config entry");
            }
            if (this.tag != null) {
                Predicate<Item> inTag = i -> ForgeRegistries.ITEMS.tags().getTag(this.tag).contains(i);
                Predicate<Item> predicate = this.filter = this.filter != null ? this.filter.and(inTag) : inTag;
            }
            if (this.filter != null && !this.filter.test((Item)this.value)) {
                LOGGER.warn("Item entry's default value doesn't match its filter");
            }
            Predicate<Item> filter = this.filter != null ? this.filter : i -> true;
            return new ItemEntry(parent, name, (Item)this.value, filter);
        }

        @Override
        protected Builder createCopy(Item value) {
            Builder copy = new Builder(value);
            copy.filter = this.filter;
            copy.tag = this.tag;
            return copy;
        }
    }
}

