/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.IntegerRangeEntryBuilder;
import endorh.simpleconfig.api.range.IntRange;
import endorh.simpleconfig.core.entry.AbstractRangeEntry;
import endorh.simpleconfig.ui.api.AbstractConfigListEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.IntFieldBuilder;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class IntegerRangeEntry
extends AbstractRangeEntry.AbstractSizedRangeEntry<Integer, IntRange, IntegerRangeEntry> {
    protected IntegerRangeEntry(ConfigEntryHolder parent, String name, IntRange value) {
        super(parent, name, value);
    }

    @Override
    protected Integer deserializeElement(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected <EE extends AbstractConfigListEntry<Integer>> EE buildLimitGUIEntry(ConfigFieldBuilder builder, String name, Integer value) {
        return (EE)((IntFieldBuilder)((IntFieldBuilder)((IntFieldBuilder)((IntFieldBuilder)builder.startIntField((Component)Component.m_237113_((String)name), value).setDefaultValue(value)).setMin((Integer)this.min)).setMax((Integer)this.max)).setName(name)).build();
    }

    @Override
    public Optional<Component> getErrorFromGUI(IntRange value) {
        if (value.getMin() == null || value.getMax() == null) {
            return Optional.of(Component.m_237115_((String)"simpleconfig.config.error.invalid_integer"));
        }
        return super.getErrorFromGUI(value);
    }

    public static class Builder
    extends AbstractRangeEntry.AbstractSizedRangeEntry.Builder<Integer, IntRange, IntegerRangeEntry, IntegerRangeEntryBuilder, Builder>
    implements IntegerRangeEntryBuilder {
        public Builder(IntRange value) {
            super(value, IntRange.class);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public IntegerRangeEntryBuilder min(int min) {
            return (IntegerRangeEntryBuilder)this.min(Integer.valueOf(min));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public IntegerRangeEntryBuilder max(int max) {
            return (IntegerRangeEntryBuilder)this.max(Integer.valueOf(max));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public IntegerRangeEntryBuilder withBounds(int min, int max) {
            return (IntegerRangeEntryBuilder)this.withBounds(Integer.valueOf(min), Integer.valueOf(max));
        }

        @Override
        protected IntegerRangeEntry buildEntry(ConfigEntryHolder parent, String name) {
            return new IntegerRangeEntry(parent, name, (IntRange)this.value);
        }

        @Override
        protected Builder createCopy(IntRange value) {
            return new Builder(value);
        }
    }
}

