/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.IntegerListEntryBuilder;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.core.entry.RangedListEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import endorh.simpleconfig.ui.impl.builders.IntListBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntegerListEntry
extends RangedListEntry<Integer, Number, Integer, IntegerListEntry> {
    @ApiStatus.Internal
    public IntegerListEntry(ConfigEntryHolder parent, String name, @Nullable List<Integer> value) {
        super(parent, name, value);
    }

    @Override
    protected Integer elemFromConfig(Number value) {
        return value != null ? Integer.valueOf(value.intValue()) : null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<List<Integer>, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        IntListBuilder valBuilder = builder.startIntList(this.getDisplayName(), (List)this.get());
        return Optional.of(this.decorate(valBuilder));
    }

    public static class Builder
    extends RangedListEntry.Builder<Integer, Number, Integer, IntegerListEntry, IntegerListEntryBuilder, Builder>
    implements IntegerListEntryBuilder {
        public Builder(List<Integer> value) {
            super(value, EntryType.of(Integer.class, new EntryType[0]));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public IntegerListEntryBuilder min(int min) {
            return (IntegerListEntryBuilder)super.min(min);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public IntegerListEntryBuilder max(int max) {
            return (IntegerListEntryBuilder)super.max(max);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public IntegerListEntryBuilder range(int min, int max) {
            return (IntegerListEntryBuilder)super.range(min, max);
        }

        @Override
        protected void checkBounds() {
            this.min = Integer.valueOf(this.min != null ? (Integer)this.min : Integer.MIN_VALUE);
            this.max = Integer.valueOf(this.max != null ? (Integer)this.max : Integer.MAX_VALUE);
        }

        @Override
        protected IntegerListEntry buildEntry(ConfigEntryHolder parent, String name) {
            return new IntegerListEntry(parent, name, (List)this.value);
        }

        @Override
        protected Builder createCopy(List<Integer> value) {
            return new Builder((List<Integer>)new IntArrayList(value));
        }
    }
}

