/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.IntegerEntryBuilder;
import endorh.simpleconfig.core.AtomicEntry;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.core.entry.AbstractRangedEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import endorh.simpleconfig.ui.impl.builders.IntFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.IntSliderBuilder;
import java.util.Optional;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class IntegerEntry
extends AbstractRangedEntry<Integer, Number, Integer>
implements AtomicEntry<Integer> {
    @ApiStatus.Internal
    public IntegerEntry(ConfigEntryHolder parent, String name, int value) {
        super(parent, name, value);
    }

    @Override
    @Nullable
    public Integer fromConfig(@Nullable Number value) {
        return value != null ? Integer.valueOf(value.intValue()) : null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<Integer, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        if (!this.asSlider) {
            IntFieldBuilder valBuilder = (IntFieldBuilder)((IntFieldBuilder)builder.startIntField(this.getDisplayName(), (Integer)this.get()).setMin((Integer)this.min)).setMax((Integer)this.max);
            return Optional.of(this.decorate(valBuilder));
        }
        IntSliderBuilder valBuilder = (IntSliderBuilder)((IntSliderBuilder)((IntSliderBuilder)((IntSliderBuilder)builder.startIntSlider(this.getDisplayName(), (Integer)this.get(), (Integer)this.min, (Integer)this.max).setSliderMin((Integer)this.sliderMin)).setSliderMax((Integer)this.sliderMax)).setSliderMap(this.sliderMap)).setTextGetter(this.sliderTextSupplier);
        return Optional.of(this.decorate(valBuilder));
    }

    public static class Builder
    extends AbstractRangedEntry.Builder<Integer, Number, Integer, IntegerEntry, IntegerEntryBuilder, Builder>
    implements IntegerEntryBuilder {
        public Builder(Integer value) {
            super(value, EntryType.of(Integer.class, new EntryType[0]));
        }

        @Override
        protected void checkBounds() {
            this.min = Integer.valueOf(this.min == null ? Integer.MIN_VALUE : (Integer)this.min);
            this.max = Integer.valueOf(this.max == null ? Integer.MAX_VALUE : (Integer)this.max);
            super.checkBounds();
        }

        @Override
        protected IntegerEntry buildEntry(ConfigEntryHolder parent, String name) {
            return new IntegerEntry(parent, name, (Integer)this.value);
        }

        @Override
        protected Builder createCopy(Integer value) {
            return new Builder(value);
        }
    }
}

