/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.api.entry.FluidNameEntryBuilder;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.core.entry.AbstractResourceEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.ComboBoxFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidNameEntry
extends AbstractResourceEntry<FluidNameEntry> {
    @ApiStatus.Internal
    public FluidNameEntry(ConfigEntryHolder parent, String name, @Nullable ResourceLocation value) {
        super(parent, name, value != null ? value : new ResourceLocation(""));
    }

    @Override
    @Nullable
    protected String getTypeComment() {
        return "Fluid";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<ResourceLocation, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        ComboBoxFieldBuilder<ResourceLocation> entryBuilder = builder.startComboBox(this.getDisplayName(), ComboBoxFieldBuilder.ofFluidName(), (ResourceLocation)this.forGui((ResourceLocation)this.get()));
        return Optional.of(this.decorate(entryBuilder));
    }

    @Override
    public boolean addCommandSuggestions(SuggestionsBuilder builder) {
        super.addCommandSuggestions(builder);
        ResourceLocation current = (ResourceLocation)this.get();
        for (ResourceLocation o : ForgeRegistries.FLUIDS.getKeys()) {
            if (o.equals((Object)current) || o.equals(this.defValue) || !this.isValidValue(o)) continue;
            builder.suggest(this.forCommand(o));
        }
        return true;
    }

    public static class Builder
    extends AbstractResourceEntry.Builder<FluidNameEntry, FluidNameEntryBuilder, Builder>
    implements FluidNameEntryBuilder {
        protected Supplier<List<ResourceLocation>> suggestionSupplier = () -> ForgeRegistries.FLUIDS.getValues().stream().filter(f -> !(f instanceof FlowingFluid) || ((FlowingFluid)f).m_5613_() == f).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.FLUIDS).getKey(arg_0)).collect(Collectors.toList());
        protected TagKey<Fluid> tag = null;

        public Builder(ResourceLocation value) {
            super(value, EntryType.of(ResourceLocation.class, new EntryType[0]));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder suggest(TagKey<Fluid> tag) {
            Builder copy = (Builder)this.copy();
            copy.tag = tag;
            return copy;
        }

        @Override
        protected FluidNameEntry buildEntry(ConfigEntryHolder parent, String name) {
            if (parent.getRoot().getType() != SimpleConfig.Type.SERVER && this.tag != null) {
                throw new IllegalArgumentException("Cannot use tag item filters in non-server config entry");
            }
            if (this.tag != null) {
                Supplier<List<ResourceLocation>> supplier = this.suggestionSupplier;
                this.suggestionSupplier = () -> Stream.concat(supplier != null ? ((List)supplier.get()).stream() : Stream.empty(), ForgeRegistries.FLUIDS.tags().getTag(this.tag).stream().map(arg_0 -> ((IForgeRegistry)ForgeRegistries.FLUIDS).getKey(arg_0))).collect(Collectors.toList());
            }
            return new FluidNameEntry(parent, name, (ResourceLocation)this.value);
        }

        @Override
        protected Builder createCopy(ResourceLocation value) {
            Builder copy = new Builder(value);
            copy.tag = this.tag;
            return copy;
        }
    }
}

