/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.api.entry.FluidEntryBuilder;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractConfigEntryBuilder;
import endorh.simpleconfig.core.AtomicEntry;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.gui.widget.combobox.SimpleComboBoxModel;
import endorh.simpleconfig.ui.impl.builders.ComboBoxFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class FluidEntry
extends AbstractConfigEntry<Fluid, String, Fluid>
implements AtomicEntry<Fluid> {
    @NotNull
    protected Predicate<Fluid> filter;

    @ApiStatus.Internal
    public FluidEntry(ConfigEntryHolder parent, String name, @Nullable Fluid value, Predicate<Fluid> filter) {
        super(parent, name, value != null ? value : Fluids.f_76193_);
        this.filter = filter != null ? filter : f -> true;
    }

    @Override
    public String forConfig(Fluid value) {
        return ForgeRegistries.FLUIDS.getKey((Object)value).toString();
    }

    @Override
    @Nullable
    public Fluid fromConfig(@Nullable String value) {
        if (value == null) {
            return null;
        }
        try {
            ResourceLocation registryName = new ResourceLocation(value);
            Fluid item = ForgeRegistries.FLUIDS.containsKey(registryName) ? (Fluid)ForgeRegistries.FLUIDS.getValue(registryName) : null;
            return this.filter.test(item) || item == this.defValue ? item : null;
        }
        catch (ResourceLocationException e) {
            return null;
        }
    }

    protected List<Fluid> supplyOptions() {
        return ForgeRegistries.FLUIDS.getValues().stream().filter(this.filter).collect(Collectors.toList());
    }

    @Override
    public List<String> getConfigCommentTooltips() {
        List<String> tooltips = super.getConfigCommentTooltips();
        tooltips.add("Fluid: namespace:path");
        return tooltips;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<Fluid, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        ComboBoxFieldBuilder<Fluid> entryBuilder = builder.startComboBox(this.getDisplayName(), ComboBoxFieldBuilder.ofFluid(), (Fluid)this.forGui((Fluid)this.get())).setSuggestionProvider(new SimpleComboBoxModel(this::supplyOptions)).setSuggestionMode(false);
        return Optional.of(this.decorate(entryBuilder));
    }

    @Override
    public boolean addCommandSuggestions(SuggestionsBuilder builder) {
        super.addCommandSuggestions(builder);
        Fluid current = (Fluid)this.get();
        for (Fluid o : this.supplyOptions()) {
            if (o.equals(current) || o.equals(this.defValue) || !this.isValidValue(o)) continue;
            builder.suggest(this.forCommand(o));
        }
        return true;
    }

    public static class Builder
    extends AbstractConfigEntryBuilder<Fluid, String, Fluid, FluidEntry, FluidEntryBuilder, Builder>
    implements FluidEntryBuilder {
        private static final Logger LOGGER = LogManager.getLogger();
        @Nullable
        protected Predicate<Fluid> filter = null;
        @Nullable
        protected TagKey<Fluid> tag = null;
        protected boolean excludeFlowing = true;

        public Builder(Fluid value) {
            super(value, EntryType.of(Fluid.class, new EntryType[0]));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder setRequireGroup(boolean requireGroup) {
            return (Builder)this.copy();
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder setExcludeFlowing(boolean excludeFlowing) {
            Builder copy = (Builder)this.copy();
            copy.excludeFlowing = excludeFlowing;
            return copy;
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder from(Predicate<Fluid> filter) {
            Builder copy = (Builder)this.copy();
            copy.filter = filter;
            return copy;
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder from(List<Fluid> choices) {
            ArrayList<Fluid> listCopy = new ArrayList<Fluid>(choices);
            return this.from(listCopy::contains);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder from(Fluid ... choices) {
            List<Fluid> listCopy = Arrays.asList(choices);
            return this.from(listCopy::contains);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder from(TagKey<Fluid> tag) {
            Builder copy = (Builder)this.copy();
            copy.tag = tag;
            return copy;
        }

        @Override
        protected FluidEntry buildEntry(ConfigEntryHolder parent, String name) {
            Predicate<Fluid> filter;
            if (parent.getRoot().getType() != SimpleConfig.Type.SERVER && this.tag != null) {
                throw new IllegalArgumentException("Cannot use tag item filters in non-server config entry");
            }
            if (this.tag != null) {
                Predicate<Fluid> inTag = f -> ForgeRegistries.FLUIDS.tags().getTag(this.tag).contains(f);
                Predicate<Fluid> predicate = this.filter = this.filter != null ? this.filter.and(inTag) : inTag;
            }
            if (this.filter != null && !this.filter.test((Fluid)this.value)) {
                LOGGER.warn("Fluid entry's default value doesn't match its filter");
            }
            Predicate<Fluid> predicate = filter = this.filter != null ? this.filter : f -> true;
            if (this.excludeFlowing) {
                filter = filter.and(f -> !(f instanceof FlowingFluid) || ((FlowingFluid)f).m_5613_() == f);
            }
            return new FluidEntry(parent, name, (Fluid)this.value, filter);
        }

        @Override
        protected Builder createCopy(Fluid value) {
            Builder copy = new Builder(value);
            copy.filter = this.filter;
            copy.tag = this.tag;
            return copy;
        }
    }
}

