/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.FloatRangeEntryBuilder;
import endorh.simpleconfig.api.range.FloatRange;
import endorh.simpleconfig.core.BackingField;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.core.entry.AbstractRangeEntry;
import endorh.simpleconfig.ui.api.AbstractConfigListEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.FloatFieldBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class FloatRangeEntry
extends AbstractRangeEntry.AbstractSizedRangeEntry<Float, FloatRange, FloatRangeEntry> {
    protected FloatRangeEntry(ConfigEntryHolder parent, String name, FloatRange value) {
        super(parent, name, value);
    }

    @Override
    protected Float deserializeElement(String value) {
        try {
            return Float.valueOf(Float.parseFloat(value));
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected <EE extends AbstractConfigListEntry<Float>> EE buildLimitGUIEntry(ConfigFieldBuilder builder, String name, Float value) {
        return (EE)((FloatFieldBuilder)((FloatFieldBuilder)((FloatFieldBuilder)((FloatFieldBuilder)builder.startFloatField((Component)Component.m_237113_((String)name), value.floatValue()).setDefaultValue(value)).setMin((Float)this.min)).setMax((Float)this.max)).setName(name)).build();
    }

    @Override
    public Optional<Component> getErrorFromGUI(FloatRange value) {
        if (value.getMin() == null || value.getMax() == null) {
            return Optional.of(Component.m_237115_((String)"simpleconfig.config.error.invalid_float"));
        }
        return super.getErrorFromGUI(value);
    }

    public static class Builder
    extends AbstractRangeEntry.AbstractSizedRangeEntry.Builder<Float, FloatRange, FloatRangeEntry, FloatRangeEntryBuilder, Builder>
    implements FloatRangeEntryBuilder {
        public Builder(FloatRange value) {
            super(value, FloatRange.class);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public FloatRangeEntryBuilder min(float min) {
            return (FloatRangeEntryBuilder)this.min(Float.valueOf(min));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public FloatRangeEntryBuilder max(float max) {
            return (FloatRangeEntryBuilder)this.max(Float.valueOf(max));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public FloatRangeEntryBuilder withBounds(float min, float max) {
            return (FloatRangeEntryBuilder)this.withBounds(Float.valueOf(min), Float.valueOf(max));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public FloatRangeEntryBuilder fieldScale(float scale) {
            return (FloatRangeEntryBuilder)this.field(Builder.scale(scale), Builder.scale(1.0f / scale), FloatRange.class);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public FloatRangeEntryBuilder fieldScale(String name, float scale) {
            return (FloatRangeEntryBuilder)this.addField(BackingField.BackingFieldBinding.withName(name, BackingField.BackingFieldBuilder.of(Builder.scale(scale), EntryType.of(FloatRange.class, new EntryType[0]))));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public FloatRangeEntryBuilder addFieldScale(String suffix, float scale) {
            return (FloatRangeEntryBuilder)this.addField(suffix, Builder.scale(scale), FloatRange.class);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public FloatRangeEntryBuilder add_field_scale(String suffix, float scale) {
            return (FloatRangeEntryBuilder)this.add_field(suffix, Builder.scale(scale), FloatRange.class);
        }

        private static Function<FloatRange, FloatRange> scale(float scale) {
            if ((double)scale == 0.0 || !Float.isFinite(scale)) {
                throw new IllegalArgumentException("Scale must be a non-zero finite number");
            }
            return d -> FloatRange.of(((Float)d.getMin()).floatValue() * scale, d.isExclusiveMin(), ((Float)d.getMax()).floatValue() * scale, d.isExclusiveMax());
        }

        @Override
        protected FloatRangeEntry buildEntry(ConfigEntryHolder parent, String name) {
            return new FloatRangeEntry(parent, name, (FloatRange)this.value);
        }

        @Override
        protected Builder createCopy(FloatRange value) {
            return new Builder(value);
        }
    }
}

