/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.FloatListEntryBuilder;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.core.entry.RangedListEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import endorh.simpleconfig.ui.impl.builders.FloatListBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FloatListEntry
extends RangedListEntry<Float, Number, Float, FloatListEntry> {
    @ApiStatus.Internal
    public FloatListEntry(ConfigEntryHolder parent, String name, @Nullable List<Float> value) {
        super(parent, name, value);
    }

    @Override
    protected Float elemFromConfig(Number value) {
        return value != null ? Float.valueOf(value.floatValue()) : null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<List<Float>, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        FloatListBuilder valBuilder = builder.startFloatList(this.getDisplayName(), (List)this.get());
        return Optional.of(this.decorate(valBuilder));
    }

    public static class Builder
    extends RangedListEntry.Builder<Float, Number, Float, FloatListEntry, FloatListEntryBuilder, Builder>
    implements FloatListEntryBuilder {
        public Builder(List<Float> value) {
            super(value, EntryType.of(Float.class, new EntryType[0]));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public FloatListEntryBuilder min(float min) {
            return (FloatListEntryBuilder)super.min(Float.valueOf(min));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public FloatListEntryBuilder max(float max) {
            return (FloatListEntryBuilder)super.max(Float.valueOf(max));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public FloatListEntryBuilder range(float min, float max) {
            return (FloatListEntryBuilder)super.range(Float.valueOf(min), Float.valueOf(max));
        }

        @Override
        protected void checkBounds() {
            this.min = Float.valueOf(this.min != null ? ((Float)this.min).floatValue() : Float.NEGATIVE_INFINITY);
            this.max = Float.valueOf(this.max != null ? ((Float)this.max).floatValue() : Float.POSITIVE_INFINITY);
        }

        @Override
        protected FloatListEntry buildEntry(ConfigEntryHolder parent, String name) {
            return new FloatListEntry(parent, name, (List)this.value);
        }

        @Override
        protected Builder createCopy(List<Float> value) {
            return new Builder(value);
        }
    }
}

