/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.FloatEntryBuilder;
import endorh.simpleconfig.core.AtomicEntry;
import endorh.simpleconfig.core.BackingField;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.core.entry.AbstractRangedEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import endorh.simpleconfig.ui.impl.builders.FloatFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.FloatSliderBuilder;
import java.util.Optional;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FloatEntry
extends AbstractRangedEntry<Float, Number, Float>
implements AtomicEntry<Float> {
    @ApiStatus.Internal
    public FloatEntry(ConfigEntryHolder parent, String name, float value) {
        super(parent, name, Float.valueOf(value));
        this.commentMin = -3.4028234663852886E38;
        this.commentMax = 3.4028234663852886E38;
    }

    @Override
    @Nullable
    public Float fromConfig(@Nullable Number value) {
        return value != null ? Float.valueOf(value.floatValue()) : null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<Float, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        if (!this.asSlider) {
            FloatFieldBuilder valBuilder = (FloatFieldBuilder)((FloatFieldBuilder)builder.startFloatField(this.getDisplayName(), ((Float)this.get()).floatValue()).setMin((Float)this.min)).setMax((Float)this.max);
            return Optional.of(this.decorate(valBuilder));
        }
        FloatSliderBuilder valBuilder = (FloatSliderBuilder)((FloatSliderBuilder)((FloatSliderBuilder)((FloatSliderBuilder)new FloatSliderBuilder(builder, this.getDisplayName(), ((Float)this.get()).floatValue(), ((Float)this.min).floatValue(), ((Float)this.max).floatValue()).setSliderMin((Float)this.sliderMin)).setSliderMax((Float)this.sliderMax)).setSliderMap(this.sliderMap)).setTextGetter(this.sliderTextSupplier);
        return Optional.of(this.decorate(valBuilder));
    }

    public static class Builder
    extends AbstractRangedEntry.Builder<Float, Number, Float, FloatEntry, FloatEntryBuilder, Builder>
    implements FloatEntryBuilder {
        public Builder(Float value) {
            super(value, EntryType.of(Float.class, new EntryType[0]), "%.2f");
        }

        @Override
        @NotNull
        public FloatEntryBuilder bakeScale(float scale) {
            return (FloatEntryBuilder)this.baked(f -> Float.valueOf(f.floatValue() * scale), f -> Float.valueOf(f.floatValue() / scale));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public FloatEntryBuilder fieldScale(float scale) {
            if (scale == 0.0f || !Float.isFinite(scale)) {
                throw new IllegalArgumentException("Scale must be a non-zero finite number");
            }
            return (FloatEntryBuilder)this.field((V f) -> Float.valueOf(f.floatValue() * scale), (F f) -> Float.valueOf(f.floatValue() / scale), Float.class);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public FloatEntryBuilder fieldScale(String name, float scale) {
            return (FloatEntryBuilder)this.addField(BackingField.BackingFieldBinding.withName(name, BackingField.BackingFieldBuilder.of(f -> Float.valueOf(f.floatValue() * scale), EntryType.of(Float.class, new EntryType[0]))));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public FloatEntryBuilder addFieldScale(String suffix, float scale) {
            return (FloatEntryBuilder)this.addField(suffix, f -> Float.valueOf(f.floatValue() * scale), Float.class);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public FloatEntryBuilder add_field_scale(String suffix, float scale) {
            return (FloatEntryBuilder)this.add_field(suffix, f -> Float.valueOf(f.floatValue() * scale), Float.class);
        }

        @Override
        protected void checkBounds() {
            float sMax;
            this.min = Float.valueOf(this.min == null ? Float.NEGATIVE_INFINITY : ((Float)this.min).floatValue());
            this.max = Float.valueOf(this.max == null ? Float.POSITIVE_INFINITY : ((Float)this.max).floatValue());
            float sMin = this.sliderMin != null ? Math.max(((Float)this.min).floatValue(), ((Float)this.sliderMin).floatValue()) : ((Float)this.min).floatValue();
            float f = sMax = this.sliderMax != null ? Math.min(((Float)this.max).floatValue(), ((Float)this.sliderMax).floatValue()) : ((Float)this.max).floatValue();
            if (((Float)this.min).isNaN() || ((Float)this.max).isNaN()) {
                throw new IllegalArgumentException("NaN bound in float config entry");
            }
            if (this.asSlider && (Float.isInfinite(sMin) || Float.isInfinite(sMax))) {
                throw new IllegalArgumentException("Infinite bound in float config entry");
            }
            super.checkBounds();
        }

        @Override
        protected FloatEntry buildEntry(ConfigEntryHolder parent, String name) {
            return new FloatEntry(parent, name, ((Float)this.value).floatValue());
        }

        @Override
        @Contract(value="_ -> new", pure=true)
        protected Builder createCopy(Float value) {
            return new Builder(value);
        }
    }
}

