/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.SimpleConfigTextUtil;
import endorh.simpleconfig.api.entry.EnumEntryBuilder;
import endorh.simpleconfig.config.ClientConfig;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractConfigEntryBuilder;
import endorh.simpleconfig.core.AtomicEntry;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.gui.widget.combobox.wrapper.TypeWrapper;
import endorh.simpleconfig.ui.impl.builders.ComboBoxFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.EnumSelectorBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumEntry<E extends Enum<E>>
extends AbstractConfigEntry<E, E, E>
implements AtomicEntry<E> {
    protected final Class<E> enumClass;
    @Nullable
    protected final Set<E> allowedValues;
    protected final Map<String, E> nameMap;
    protected final Map<String, E> lowerCaseNameMap;
    @Nullable
    protected Boolean useComboBox;

    @ApiStatus.Internal
    public EnumEntry(ConfigEntryHolder parent, String name, E value, @Nullable Set<E> allowedValueSet) {
        super(parent, name, value);
        this.enumClass = ((Enum)value).getDeclaringClass();
        Set<E> set = this.allowedValues = allowedValueSet != null ? EnumSet.copyOf(allowedValueSet) : null;
        if (this.allowedValues != null) {
            this.allowedValues.add(value);
        }
        this.nameMap = Arrays.stream((Enum[])this.enumClass.getEnumConstants()).collect(Collectors.toMap(Enum::name, Function.identity()));
        this.lowerCaseNameMap = Arrays.stream((Enum[])this.enumClass.getEnumConstants()).collect(Collectors.toMap(e -> e.name().toLowerCase(), Function.identity(), (a, b) -> a));
    }

    public String presentName(E value) {
        String name = ((Enum)value).name();
        String lowerCaseName = name.toLowerCase();
        if (this.lowerCaseNameMap.get(lowerCaseName) == value) {
            name = lowerCaseName;
        }
        return name;
    }

    @Nullable
    public E parseName(String name) {
        Enum exact = (Enum)this.nameMap.get(name = name.trim().replace(' ', '_'));
        return (E)(exact != null ? exact : (Enum)this.lowerCaseNameMap.get(name.toLowerCase()));
    }

    public String forActualConfig(@Nullable E value) {
        if (value == null) {
            return null;
        }
        return this.presentName(value);
    }

    @Override
    @Nullable
    public E fromActualConfig(@Nullable Object value) {
        if (!(value instanceof String)) {
            return null;
        }
        return this.parseName((String)value);
    }

    @Override
    public boolean isValidValue(E value) {
        return super.isValidValue(value) && (this.allowedValues == null || this.allowedValues.contains(value));
    }

    @Override
    public List<String> getConfigCommentTooltips() {
        List<String> tooltips = super.getConfigCommentTooltips();
        tooltips.add("Options: " + Arrays.stream((Enum[])this.enumClass.getEnumConstants()).filter(e -> this.allowedValues == null || this.allowedValues.contains(e)).map(c -> "'" + this.presentName(c) + "'").collect(Collectors.joining(", ")));
        return tooltips;
    }

    @ApiStatus.Internal
    public Set<E> getAllowedValues() {
        return Collections.unmodifiableSet(this.allowedValues != null ? this.allowedValues : EnumSet.allOf(this.enumClass));
    }

    @Override
    protected Component getDebugDisplayName() {
        if (this.translation != null) {
            MutableComponent status;
            MutableComponent mutableComponent = status = I18n.m_118936_((String)this.translation) ? Component.m_237113_((String)"\u2714 ") : Component.m_237113_((String)"\u2718 ");
            if (this.tooltip != null) {
                status = status.m_7220_((Component)(I18n.m_118936_((String)this.tooltip) ? Component.m_237113_((String)"\u2714 ").m_130940_(ChatFormatting.DARK_AQUA) : Component.m_237113_((String)"_ ").m_130940_(ChatFormatting.DARK_AQUA)));
            }
            boolean correct = this.defValue instanceof EnumEntryBuilder.TranslatedEnum || Arrays.stream((Enum[])this.enumClass.getEnumConstants()).allMatch(e -> I18n.m_118936_((String)this.getEnumTranslationKey(e)));
            status = status.m_7220_((Component)(correct ? Component.m_237113_((String)"\u2714 ").m_130940_(ChatFormatting.LIGHT_PURPLE) : Component.m_237113_((String)"\u2718 ").m_130940_(ChatFormatting.LIGHT_PURPLE)));
            ChatFormatting format = I18n.m_118936_((String)this.translation) ? (correct ? ChatFormatting.DARK_GREEN : ChatFormatting.GOLD) : ChatFormatting.RED;
            return Component.m_237113_((String)"").m_7220_((Component)status.m_7220_((Component)Component.m_237113_((String)this.translation)).m_130940_(format));
        }
        return Component.m_237113_((String)"").m_7220_((Component)Component.m_237113_((String)("\u26a0 " + this.name)).m_130940_(ChatFormatting.DARK_RED));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addTranslationsDebugInfo(List<Component> tooltip) {
        super.addTranslationsDebugInfo(tooltip);
        if (this.parent != null) {
            if (this.defValue instanceof EnumEntryBuilder.TranslatedEnum) {
                tooltip.add((Component)Component.m_237113_((String)" + Enum provides its own translations").m_130940_(ChatFormatting.GRAY));
            }
            tooltip.add((Component)Component.m_237113_((String)" + Enum translation keys:").m_130940_(ChatFormatting.GRAY));
            for (Enum elem : (Enum[])this.enumClass.getEnumConstants()) {
                String key = this.getEnumTranslationKey(elem);
                MutableComponent status = I18n.m_118936_((String)key) ? Component.m_237113_((String)"(\u2714 present)").m_130940_(ChatFormatting.DARK_GREEN) : (this.defValue instanceof EnumEntryBuilder.TranslatedEnum ? Component.m_237113_((String)"(not present)").m_130940_(ChatFormatting.DARK_GRAY) : Component.m_237113_((String)"(\u2718 missing)").m_130940_(ChatFormatting.RED));
                tooltip.add((Component)Component.m_237113_((String)"   > ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)key).m_130940_(ChatFormatting.DARK_AQUA)).m_130946_(" ").m_7220_((Component)status));
            }
        }
    }

    protected String getEnumTranslationKey(E item) {
        return this.parent.getRoot().getModId() + ".config.enum." + this.enumClass.getSimpleName() + "." + ((Enum)item).name();
    }

    protected String getEnumTooltipKey(E item) {
        return this.getEnumTranslationKey(item) + ":help";
    }

    @OnlyIn(value=Dist.CLIENT)
    protected Component enumName(E item) {
        if (item instanceof EnumEntryBuilder.TranslatedEnum) {
            return ((EnumEntryBuilder.TranslatedEnum)item).getDisplayName();
        }
        String key = this.getEnumTranslationKey(item);
        if (I18n.m_118936_((String)key)) {
            return Component.m_237115_((String)key);
        }
        return Component.m_237113_((String)((Enum)item).name());
    }

    @OnlyIn(value=Dist.CLIENT)
    protected List<Component> enumTooltip(E item) {
        if (item instanceof EnumEntryBuilder.TranslatedEnum) {
            return ((EnumEntryBuilder.TranslatedEnum)item).getHelpTooltip();
        }
        return SimpleConfigTextUtil.optSplitTtc(this.getEnumTooltipKey(item), new Object[0]);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<E, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        if (this.useComboBox != null ? this.useComboBox != false : ClientConfig.advanced.prefer_combo_box < ((Enum[])this.enumClass.getEnumConstants()).length) {
            List choices = Arrays.stream((Enum[])this.enumClass.getEnumConstants()).filter(e -> this.allowedValues == null || this.allowedValues.contains(e)).collect(Collectors.toList());
            ComboBoxFieldBuilder<Enum> valBuilder = builder.startComboBox(this.getDisplayName(), new ChoicesTypeWrapper<Enum>(choices, e -> e.name().toLowerCase(), this::enumName, this::enumTooltip), (Enum)this.get()).setSuggestionMode(false).setSuggestions(choices);
            return Optional.of(this.decorate(valBuilder));
        }
        EnumSelectorBuilder<Enum> valBuilder = builder.startEnumSelector(this.getDisplayName(), (Enum)this.get()).setEnumNameProvider(this::enumName).setEnumTooltipProvider(this::enumTooltip).setAllowedValues(this.allowedValues);
        return Optional.of(this.decorate(valBuilder));
    }

    @Override
    public boolean addCommandSuggestions(SuggestionsBuilder builder) {
        Enum[] values;
        super.addCommandSuggestions(builder);
        Enum current = (Enum)this.get();
        for (Enum value : values = (Enum[])this.enumClass.getEnumConstants()) {
            if (value == current || value == this.defValue || !this.isValidValue((E)value) || this.allowedValues != null && !this.allowedValues.contains(value)) continue;
            builder.suggest(this.forCommand(value));
        }
        return true;
    }

    public static class ChoicesTypeWrapper<V>
    implements TypeWrapper<V> {
        protected List<V> choices;
        protected Function<V, String> nameProvider;
        protected Function<V, Component> formattedNameProvider;
        protected Function<V, List<Component>> tooltipProvider;

        public ChoicesTypeWrapper(List<V> choices, Function<V, String> nameProvider, Function<V, Component> formattedNameProvider, Function<V, List<Component>> tooltipProvider) {
            this.choices = choices;
            this.nameProvider = nameProvider;
            this.formattedNameProvider = formattedNameProvider;
            this.tooltipProvider = tooltipProvider;
        }

        @Override
        public Pair<Optional<V>, Optional<Component>> parseElement(@NotNull String text) {
            Optional<Object> opt = this.choices.stream().filter(c -> text.equals(this.nameProvider.apply(c))).findFirst();
            Optional error = opt.isPresent() ? Optional.empty() : Optional.of(Component.m_237115_((String)"simpleconfig.config.error.unknown_value"));
            return Pair.of(opt, error);
        }

        @Override
        public Component getDisplayName(@NotNull V element) {
            return this.formattedNameProvider.apply(element);
        }

        @Override
        public List<Component> getHelpTooltip(@NotNull V element) {
            return this.tooltipProvider.apply(element);
        }

        @Override
        public String getName(@NotNull V element) {
            return this.nameProvider.apply(element);
        }
    }

    public static class Builder<E extends Enum<E>>
    extends AbstractConfigEntryBuilder<E, E, E, EnumEntry<E>, EnumEntryBuilder<E>, Builder<E>>
    implements EnumEntryBuilder<E> {
        protected final Class<E> enumClass;
        @Nullable
        protected Set<E> allowedValues = null;
        @Nullable
        protected Boolean useComboBox = null;

        public Builder(E value) {
            super(value, EntryType.of(((Enum)value).getDeclaringClass(), new EntryType[0]));
            this.enumClass = ((Enum)value).getDeclaringClass();
        }

        public Builder(Class<E> enumClass) {
            super(((Enum[])enumClass.getEnumConstants())[0], EntryType.of(enumClass, new EntryType[0]));
            this.enumClass = enumClass;
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder<E> useComboBox() {
            return this.useComboBox(true);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder<E> useComboBox(@Nullable Boolean useComboBox) {
            Builder copy = (Builder)this.copy();
            copy.useComboBox = useComboBox;
            return copy;
        }

        @Override
        @SafeVarargs
        @Contract(pure=true)
        @NotNull
        public final Builder<E> restrict(E ... values) {
            return this.restrict((Collection)Arrays.asList(values));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder<E> restrict(@Nullable Collection<E> values) {
            Builder copy = (Builder)this.copy();
            copy.allowedValues = values != null ? EnumSet.copyOf(values) : null;
            return copy;
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder<E> clearRestrictions() {
            return this.restrict((Collection)null);
        }

        @Override
        protected EnumEntry<E> buildEntry(ConfigEntryHolder parent, String name) {
            EnumEntry<Enum> entry = new EnumEntry<Enum>(parent, name, (Enum)this.value, this.allowedValues);
            entry.useComboBox = this.useComboBox;
            return entry;
        }

        @Override
        @Contract(value="_ -> new", pure=true)
        protected Builder<E> createCopy(E value) {
            Builder<E> copy = new Builder<E>(value);
            copy.useComboBox = this.useComboBox;
            copy.allowedValues = this.allowedValues != null ? EnumSet.copyOf(this.allowedValues) : null;
            return copy;
        }
    }
}

