/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import endorh.simpleconfig.api.AtomicEntryBuilder;
import endorh.simpleconfig.api.ConfigEntryBuilder;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.EntryTripleEntryBuilder;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractConfigEntryBuilder;
import endorh.simpleconfig.core.AtomicEntry;
import endorh.simpleconfig.core.DummyEntryHolder;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.ui.api.AbstractConfigListEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import endorh.simpleconfig.ui.impl.builders.TripleListEntryBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class EntryTripleEntry<L, M, R, LC, MC, RC, LG, MG, RG>
extends AbstractConfigEntry<Triple<L, M, R>, Triple<LC, MC, RC>, Triple<LG, MG, RG>>
implements AtomicEntry<Triple<LG, MG, RG>> {
    protected final AbstractConfigEntry<L, LC, LG> leftEntry;
    protected final AbstractConfigEntry<M, MC, MG> middleEntry;
    protected final AbstractConfigEntry<R, RC, RG> rightEntry;
    @Nullable
    protected Icon leftIcon;
    @Nullable
    protected Icon rightIcon;
    protected float leftWeight = 0.333f;
    protected float rightWeight = 0.333f;

    protected EntryTripleEntry(ConfigEntryHolder parent, String name, Triple<L, M, R> value, AbstractConfigEntry<L, LC, LG> leftEntry, AbstractConfigEntry<M, MC, MG> middleEntry, AbstractConfigEntry<R, RC, RG> rightEntry) {
        super(parent, name, value);
        this.leftEntry = leftEntry;
        this.middleEntry = middleEntry;
        this.rightEntry = rightEntry;
    }

    protected <E extends AbstractConfigEntry<L, LC, LG>> E getLeftEntry() {
        return (E)this.leftEntry;
    }

    protected <E extends AbstractConfigEntry<M, MC, MG>> E getMiddleEntry() {
        return (E)this.middleEntry;
    }

    protected <E extends AbstractConfigEntry<R, RC, RG>> E getRightEntry() {
        return (E)this.rightEntry;
    }

    public Triple<Object, Object, Object> forActualConfig(@Nullable Triple<LC, MC, RC> value) {
        if (value == null) {
            return null;
        }
        return Triple.of((Object)this.leftEntry.forActualConfig(value.getLeft()), (Object)this.middleEntry.forActualConfig(value.getMiddle()), (Object)this.rightEntry.forActualConfig(value.getRight()));
    }

    @Override
    @Nullable
    public Triple<LC, MC, RC> fromActualConfig(@Nullable Object value) {
        RC right;
        MC middle;
        LC left;
        if (value instanceof List) {
            List list = (List)value;
            if (list.size() != 3) {
                return null;
            }
            left = this.leftEntry.fromActualConfig(list.get(0));
            middle = this.middleEntry.fromActualConfig(list.get(1));
            right = this.rightEntry.fromActualConfig(list.get(2));
        } else if (value instanceof Triple) {
            Triple pair = (Triple)value;
            left = this.leftEntry.fromActualConfig(pair.getLeft());
            middle = this.middleEntry.fromActualConfig(pair.getMiddle());
            right = this.rightEntry.fromActualConfig(pair.getRight());
        } else {
            return null;
        }
        if (left == null && middle == null && right == null) {
            return null;
        }
        if (left == null) {
            left = this.leftEntry.forConfig(this.leftEntry.defValue);
        }
        if (middle == null) {
            middle = this.middleEntry.forConfig(this.middleEntry.defValue);
        }
        if (right == null) {
            right = this.rightEntry.forConfig(this.rightEntry.defValue);
        }
        return Triple.of(left, middle, right);
    }

    @Override
    public List<Component> getErrorsFromGUI(Triple<LG, MG, RG> value) {
        List<Component> errors = super.getErrorsFromGUI(value);
        errors.addAll(this.leftEntry.getErrorsFromGUI(value.getLeft()));
        errors.addAll(this.middleEntry.getErrorsFromGUI(value.getMiddle()));
        errors.addAll(this.rightEntry.getErrorsFromGUI(value.getRight()));
        return errors;
    }

    @Override
    public Triple<LC, MC, RC> forConfig(Triple<L, M, R> value) {
        return Triple.of(this.leftEntry.forConfig(value.getLeft()), this.middleEntry.forConfig(value.getMiddle()), this.rightEntry.forConfig(value.getRight()));
    }

    @Override
    @Nullable
    public Triple<L, M, R> fromConfig(@Nullable Triple<LC, MC, RC> value) {
        if (value == null) {
            return null;
        }
        L left = this.leftEntry.fromConfig(value.getLeft());
        M middle = this.middleEntry.fromConfig(value.getMiddle());
        R right = this.rightEntry.fromConfig(value.getRight());
        return left != null && middle != null && right != null ? Triple.of(left, middle, right) : null;
    }

    @Override
    public boolean hasPresentation() {
        return super.hasPresentation() || this.leftEntry.hasPresentation() || this.middleEntry.hasPresentation() || this.rightEntry.hasPresentation();
    }

    @Override
    protected Triple<L, M, R> doForPresentation(Triple<L, M, R> value) {
        return super.doForPresentation(Triple.of((Object)this.leftEntry.forPresentation(value.getLeft()), (Object)this.middleEntry.forPresentation(value.getMiddle()), (Object)this.rightEntry.forPresentation(value.getRight())));
    }

    @Override
    protected Triple<L, M, R> doFromPresentation(Triple<L, M, R> value) {
        value = super.doFromPresentation(value);
        return Triple.of((Object)this.leftEntry.fromPresentation(value.getLeft()), (Object)this.middleEntry.fromPresentation(value.getMiddle()), (Object)this.rightEntry.fromPresentation(value.getRight()));
    }

    @Override
    public Triple<LG, MG, RG> forGui(Triple<L, M, R> value) {
        return Triple.of(this.leftEntry.forGui(value.getLeft()), this.middleEntry.forGui(value.getMiddle()), this.rightEntry.forGui(value.getRight()));
    }

    @Override
    @Nullable
    public Triple<L, M, R> fromGui(@Nullable Triple<LG, MG, RG> value) {
        if (value == null) {
            return null;
        }
        L left = this.leftEntry.fromGui(value.getLeft());
        M middle = this.middleEntry.fromGui(value.getMiddle());
        R right = this.rightEntry.fromGui(value.getRight());
        return left != null && middle != null && right != null ? Triple.of(left, middle, right) : null;
    }

    @Override
    public List<String> getConfigCommentTooltips() {
        List<String> tooltips = super.getConfigCommentTooltips();
        String leftComment = this.leftEntry.getConfigCommentTooltip();
        String middleComment = this.middleEntry.getConfigCommentTooltip();
        String rightComment = this.rightEntry.getConfigCommentTooltip();
        tooltips.add("Triple: " + (leftComment.isEmpty() ? "?" : leftComment) + ", " + (middleComment.isEmpty() ? "?" : middleComment) + ", " + (rightComment.isEmpty() ? "?" : rightComment));
        return tooltips;
    }

    public <LGE extends AbstractConfigListEntry<LG>, MGE extends AbstractConfigListEntry<MG>, RGE extends AbstractConfigListEntry<RG>, LGEB extends FieldBuilder<LG, LGE, LGEB>, MGEB extends FieldBuilder<MG, MGE, MGEB>, RGEB extends FieldBuilder<RG, RGE, RGEB>> TripleListEntryBuilder<LG, MG, RG, LGE, MGE, RGE, LGEB, MGEB, RGEB> makeGUIBuilder(ConfigFieldBuilder builder, FieldBuilder<LG, LGE, ?> leftBuilder, FieldBuilder<MG, MGE, ?> middleBuilder, FieldBuilder<RG, RGE, ?> rightBuilder) {
        return builder.startTriple(this.getDisplayName(), leftBuilder, middleBuilder, rightBuilder, this.forGui((Triple)this.get()));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<Triple<LG, MG, RG>, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        TripleListEntryBuilder entryBuilder = this.makeGUIBuilder(builder, (FieldBuilder)((AtomicEntry)this.getLeftEntry()).buildAtomicChildGUIEntry(builder), (FieldBuilder)((AtomicEntry)this.getMiddleEntry()).buildAtomicChildGUIEntry(builder), (FieldBuilder)((AtomicEntry)this.getRightEntry()).buildAtomicChildGUIEntry(builder)).withIcons(this.leftIcon, this.rightIcon).withWeights(this.leftWeight, this.rightWeight);
        return Optional.of(this.decorate(entryBuilder));
    }

    public static class Builder<L, M, R, LC, MC, RC, LG, MG, RG, LS extends ConfigEntryBuilder<L, LC, LG, LS> & AtomicEntryBuilder, MS extends ConfigEntryBuilder<M, MC, MG, MS> & AtomicEntryBuilder, RS extends ConfigEntryBuilder<R, RC, RG, RS> & AtomicEntryBuilder, LB extends AbstractConfigEntryBuilder<L, LC, LG, ?, LS, LB>, MB extends AbstractConfigEntryBuilder<M, MC, MG, ?, MS, MB>, RB extends AbstractConfigEntryBuilder<R, RC, RG, ?, RS, RB>>
    extends AbstractConfigEntryBuilder<Triple<L, M, R>, Triple<LC, MC, RC>, Triple<LG, MG, RG>, EntryTripleEntry<L, M, R, LC, MC, RC, LG, MG, RG>, EntryTripleEntryBuilder<L, M, R, LC, MC, RC, LG, MG, RG>, Builder<L, M, R, LC, MC, RC, LG, MG, RG, LS, MS, RS, LB, MB, RB>>
    implements EntryTripleEntryBuilder<L, M, R, LC, MC, RC, LG, MG, RG> {
        protected LB leftBuilder;
        protected MB middleBuilder;
        protected RB rightBuilder;
        @Nullable
        protected Icon leftIcon;
        @Nullable
        protected Icon rightIcon;
        protected float leftWeight = 0.333f;
        protected float rightWeight = 0.333f;

        public Builder(Triple<L, M, R> value, LS leftBuilder, MS middleBuilder, RS rightBuilder) {
            super(value, EntryType.of(Triple.class, Builder.getEntryType(leftBuilder), Builder.getEntryType(middleBuilder), Builder.getEntryType(rightBuilder)));
            if (!(leftBuilder instanceof AbstractConfigEntryBuilder)) {
                throw new IllegalArgumentException("Mixed API use: builder not subclass of AbstractConfigEntryBuilder");
            }
            if (!(middleBuilder instanceof AbstractConfigEntryBuilder)) {
                throw new IllegalArgumentException("Mixed API use: builder not subclass of AbstractConfigEntryBuilder");
            }
            if (!(rightBuilder instanceof AbstractConfigEntryBuilder)) {
                throw new IllegalArgumentException("Mixed API use: builder not subclass of AbstractConfigEntryBuilder");
            }
            this.leftBuilder = (AbstractConfigEntryBuilder)leftBuilder;
            this.middleBuilder = (AbstractConfigEntryBuilder)middleBuilder;
            this.rightBuilder = (AbstractConfigEntryBuilder)rightBuilder;
        }

        public Builder(Triple<L, M, R> value, LB leftBuilder, MB middleBuilder, RB rightBuilder) {
            super(value, EntryType.of(Triple.class, Builder.getEntryType(leftBuilder), Builder.getEntryType(middleBuilder), Builder.getEntryType(rightBuilder)));
            this.leftBuilder = leftBuilder;
            this.middleBuilder = middleBuilder;
            this.rightBuilder = rightBuilder;
        }

        @Contract(pure=true)
        public Builder<L, M, R, LC, MC, RC, LG, MG, RG, LS, MS, RS, LB, MB, RB> withLeftIcon(@Nullable Icon leftIcon) {
            Builder copy = (Builder)this.copy();
            copy.leftIcon = leftIcon;
            return copy;
        }

        @Contract(pure=true)
        @NotNull
        public Builder<L, M, R, LC, MC, RC, LG, MG, RG, LS, MS, RS, LB, MB, RB> withRightIcon(@Nullable Icon rightIcon) {
            Builder copy = (Builder)this.copy();
            copy.rightIcon = rightIcon;
            return copy;
        }

        @Contract(pure=true)
        @NotNull
        public Builder<L, M, R, LC, MC, RC, LG, MG, RG, LS, MS, RS, LB, MB, RB> withIcons(@Nullable Icon leftIcon, @Nullable Icon rightIcon) {
            Builder copy = (Builder)this.copy();
            copy.leftIcon = leftIcon;
            copy.rightIcon = rightIcon;
            return copy;
        }

        @Contract(pure=true)
        public Builder<L, M, R, LC, MC, RC, LG, MG, RG, LS, MS, RS, LB, MB, RB> withWeights(@Range(from=0L, to=1L) double leftWeight, @Range(from=0L, to=1L) double rightWeight) {
            if (leftWeight < 0.0 || rightWeight < 0.0) {
                throw new IllegalArgumentException("Weights can be negative. Specifically: " + leftWeight + ", " + rightWeight);
            }
            if (leftWeight + rightWeight > 1.0) {
                throw new IllegalArgumentException("Weights must add to less than 1. Specifically: " + leftWeight + ", " + rightWeight);
            }
            Builder copy = (Builder)this.copy();
            copy.leftWeight = (float)leftWeight;
            copy.rightWeight = (float)rightWeight;
            return copy;
        }

        @Override
        protected EntryTripleEntry<L, M, R, LC, MC, RC, LG, MG, RG> buildEntry(ConfigEntryHolder parent, String name) {
            Object leftEntry = DummyEntryHolder.build(parent, this.leftBuilder);
            Object middleEntry = DummyEntryHolder.build(parent, this.middleBuilder);
            Object rightEntry = DummyEntryHolder.build(parent, this.rightBuilder);
            if (!(leftEntry instanceof AtomicEntry)) {
                throw new IllegalStateException("KeyEntryBuilder produced a non-key entry, violating its contract: " + this.leftBuilder.getClass().getSimpleName());
            }
            if (!(middleEntry instanceof AtomicEntry)) {
                throw new IllegalStateException("KeyEntryBuilder produced a non-key entry, violating its contract: " + this.middleBuilder.getClass().getSimpleName());
            }
            if (!(rightEntry instanceof AtomicEntry)) {
                throw new IllegalStateException("KeyEntryBuilder produced a non-key entry, violating its contract: " + this.rightBuilder.getClass().getSimpleName());
            }
            EntryTripleEntry entry = new EntryTripleEntry(parent, name, (Triple)this.value, leftEntry, middleEntry, rightEntry);
            entry.leftIcon = this.leftIcon;
            entry.rightIcon = this.rightIcon;
            entry.leftWeight = this.leftWeight;
            entry.rightWeight = this.rightWeight;
            return entry;
        }

        @Override
        @Contract(value="_ -> new", pure=true)
        protected Builder<L, M, R, LC, MC, RC, LG, MG, RG, LS, MS, RS, LB, MB, RB> createCopy(Triple<L, M, R> value) {
            Builder<L, M, R, LC, MC, RC, LG, MG, RG, LS, MS, RS, LB, MB, RB> copy = new Builder<L, M, R, LC, MC, RC, LG, MG, RG, LS, MS, RS, LB, MB, RB>(Triple.of((Object)value.getLeft(), (Object)value.getMiddle(), (Object)value.getRight()), this.leftBuilder, this.middleBuilder, this.rightBuilder);
            copy.leftIcon = this.leftIcon;
            copy.rightIcon = this.rightIcon;
            copy.leftWeight = this.leftWeight;
            copy.rightWeight = this.rightWeight;
            return copy;
        }
    }
}

