/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import endorh.simpleconfig.api.AtomicEntryBuilder;
import endorh.simpleconfig.api.ConfigEntryBuilder;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.EntryPairEntryBuilder;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractConfigEntryBuilder;
import endorh.simpleconfig.core.AtomicEntry;
import endorh.simpleconfig.core.DummyEntryHolder;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.ui.api.AbstractConfigListEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import endorh.simpleconfig.ui.impl.builders.PairListEntryBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class EntryPairEntry<L, R, LC, RC, LG, RG>
extends AbstractConfigEntry<Pair<L, R>, Pair<LC, RC>, Pair<LG, RG>>
implements AtomicEntry<Pair<LG, RG>> {
    @ApiStatus.Internal
    public final AbstractConfigEntry<L, LC, LG> leftEntry;
    @ApiStatus.Internal
    public final AbstractConfigEntry<R, RC, RG> rightEntry;
    protected float splitPos = 0.5f;
    @Nullable
    protected Icon middleIcon;

    protected EntryPairEntry(ConfigEntryHolder parent, String name, Pair<L, R> value, AbstractConfigEntry<L, LC, LG> leftEntry, AbstractConfigEntry<R, RC, RG> rightEntry) {
        super(parent, name, value);
        this.leftEntry = leftEntry;
        this.rightEntry = rightEntry;
    }

    @ApiStatus.Internal
    public <E extends AbstractConfigEntry<L, LC, LG>> E getLeftEntry() {
        return (E)this.leftEntry;
    }

    @ApiStatus.Internal
    public <E extends AbstractConfigEntry<R, RC, RG>> E getRightEntry() {
        return (E)this.rightEntry;
    }

    public Pair<Object, Object> forActualConfig(@Nullable Pair<LC, RC> value) {
        if (value == null) {
            return null;
        }
        return Pair.of((Object)this.leftEntry.forActualConfig(value.getLeft()), (Object)this.rightEntry.forActualConfig(value.getRight()));
    }

    @Override
    @Nullable
    public Pair<LC, RC> fromActualConfig(@Nullable Object value) {
        RC right;
        LC left;
        if (value instanceof List) {
            List list = (List)value;
            if (list.size() != 2) {
                return null;
            }
            left = this.leftEntry.fromActualConfig(list.get(0));
            right = this.rightEntry.fromActualConfig(list.get(1));
        } else if (value instanceof Pair) {
            Pair pair = (Pair)value;
            left = this.leftEntry.fromActualConfig(pair.getLeft());
            right = this.rightEntry.fromActualConfig(pair.getRight());
        } else {
            return null;
        }
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            left = this.leftEntry.forConfig(this.leftEntry.defValue);
        }
        if (right == null) {
            right = this.rightEntry.forConfig(this.rightEntry.defValue);
        }
        return Pair.of(left, right);
    }

    @Override
    public List<Component> getErrorsFromGUI(Pair<LG, RG> value) {
        List<Component> errors = super.getErrorsFromGUI(value);
        errors.addAll(this.leftEntry.getErrorsFromGUI(value.getLeft()));
        errors.addAll(this.rightEntry.getErrorsFromGUI(value.getRight()));
        return errors;
    }

    @Override
    public Pair<LC, RC> forConfig(Pair<L, R> value) {
        return Pair.of(this.leftEntry.forConfig(value.getLeft()), this.rightEntry.forConfig(value.getRight()));
    }

    @Override
    @Nullable
    public Pair<L, R> fromConfig(@Nullable Pair<LC, RC> value) {
        if (value == null) {
            return null;
        }
        L left = this.leftEntry.fromConfig(value.getLeft());
        R right = this.rightEntry.fromConfig(value.getRight());
        return left != null && right != null ? Pair.of(left, right) : null;
    }

    @Override
    public boolean hasPresentation() {
        return super.hasPresentation() || this.leftEntry.hasPresentation() || this.rightEntry.hasPresentation();
    }

    @Override
    protected Pair<L, R> doForPresentation(Pair<L, R> value) {
        return super.doForPresentation(Pair.of((Object)this.leftEntry.forPresentation(value.getLeft()), (Object)this.rightEntry.forPresentation(value.getRight())));
    }

    @Override
    protected Pair<L, R> doFromPresentation(Pair<L, R> value) {
        return super.doFromPresentation(Pair.of((Object)this.leftEntry.fromPresentation(value.getLeft()), (Object)this.rightEntry.fromPresentation(value.getRight())));
    }

    @Override
    public Pair<LG, RG> forGui(Pair<L, R> value) {
        return Pair.of(this.leftEntry.forGui(value.getLeft()), this.rightEntry.forGui(value.getRight()));
    }

    @Override
    @Nullable
    public Pair<L, R> fromGui(@Nullable Pair<LG, RG> value) {
        if (value == null) {
            return null;
        }
        L left = this.leftEntry.fromGui(value.getLeft());
        R right = this.rightEntry.fromGui(value.getRight());
        return left != null && right != null ? Pair.of(left, right) : null;
    }

    @Override
    public List<String> getConfigCommentTooltips() {
        List<String> tooltips = super.getConfigCommentTooltips();
        String leftComment = this.leftEntry.getConfigCommentTooltip();
        String rightComment = this.rightEntry.getConfigCommentTooltip();
        tooltips.add("Pair: " + (leftComment.isEmpty() ? "?" : leftComment) + ", " + (rightComment.isEmpty() ? "?" : rightComment));
        return tooltips;
    }

    public <LGE extends AbstractConfigListEntry<LG>, RGE extends AbstractConfigListEntry<RG>, LGEB extends FieldBuilder<LG, LGE, LGEB>, RGEB extends FieldBuilder<RG, RGE, RGEB>> PairListEntryBuilder<LG, RG, LGE, RGE, LGEB, RGEB> makeGUIBuilder(ConfigFieldBuilder builder, FieldBuilder<LG, LGE, ?> leftBuilder, FieldBuilder<RG, RGE, ?> rightBuilder) {
        return builder.startPair(this.getDisplayName(), leftBuilder, rightBuilder, this.forGui((Pair)this.get()));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<Pair<LG, RG>, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        PairListEntryBuilder entryBuilder = this.makeGUIBuilder(builder, (FieldBuilder)((AtomicEntry)this.getLeftEntry()).buildAtomicChildGUIEntry(builder), (FieldBuilder)((AtomicEntry)this.getRightEntry()).buildAtomicChildGUIEntry(builder)).withMiddleIcon(this.middleIcon).withSplitPos(this.splitPos);
        return Optional.of(this.decorate(entryBuilder));
    }

    public static class Builder<L, R, LC, RC, LG, RG, LS extends ConfigEntryBuilder<L, LC, LG, LS> & AtomicEntryBuilder, RS extends ConfigEntryBuilder<R, RC, RG, RS> & AtomicEntryBuilder, LB extends AbstractConfigEntryBuilder<L, LC, LG, ?, LS, LB>, RB extends AbstractConfigEntryBuilder<R, RC, RG, ?, RS, RB>>
    extends AbstractConfigEntryBuilder<Pair<L, R>, Pair<LC, RC>, Pair<LG, RG>, EntryPairEntry<L, R, LC, RC, LG, RG>, EntryPairEntryBuilder<L, R, LC, RC, LG, RG>, Builder<L, R, LC, RC, LG, RG, LS, RS, LB, RB>>
    implements EntryPairEntryBuilder<L, R, LC, RC, LG, RG> {
        protected LB leftBuilder;
        protected RB rightBuilder;
        protected float splitPos = 0.5f;
        @Nullable
        protected Icon middleIcon;

        public <LCB extends ConfigEntryBuilder<L, LC, LG, LCB> & AtomicEntryBuilder, RCB extends ConfigEntryBuilder<R, RC, RG, RCB> & AtomicEntryBuilder> Builder(Pair<L, R> value, LCB leftBuilder, RCB rightBuilder) {
            this(value, (AbstractConfigEntryBuilder)leftBuilder, (AbstractConfigEntryBuilder)rightBuilder);
        }

        public Builder(Pair<L, R> value, LB leftBuilder, RB rightBuilder) {
            super(value, EntryType.of(Pair.class, Builder.getEntryType(leftBuilder), Builder.getEntryType(rightBuilder)));
            this.leftBuilder = leftBuilder;
            this.rightBuilder = rightBuilder;
        }

        @Contract(pure=true)
        @NotNull
        public Builder<L, R, LC, RC, LG, RG, LS, RS, LB, RB> withMiddleIcon(@Nullable Icon icon) {
            Builder copy = (Builder)this.copy();
            copy.middleIcon = icon;
            return copy;
        }

        @Contract(pure=true)
        @NotNull
        public Builder<L, R, LC, RC, LG, RG, LS, RS, LB, RB> withSplitPosition(@Range(from=0L, to=1L) double splitPosition) {
            if (splitPosition < 0.0 || splitPosition > 1.0) {
                throw new IllegalArgumentException("Split position must be between 0~1. Specifically: " + splitPosition);
            }
            Builder copy = (Builder)this.copy();
            copy.splitPos = (float)splitPosition;
            return copy;
        }

        @Override
        protected EntryPairEntry<L, R, LC, RC, LG, RG> buildEntry(ConfigEntryHolder parent, String name) {
            Object leftEntry = DummyEntryHolder.build(parent, this.leftBuilder);
            Object rightEntry = DummyEntryHolder.build(parent, this.rightBuilder);
            if (!(leftEntry instanceof AtomicEntry)) {
                throw new IllegalArgumentException("KeyEntryBuilder produced non-key entry, violating its contract: " + this.leftBuilder.getClass().getSimpleName());
            }
            EntryPairEntry entry = new EntryPairEntry(parent, name, (Pair)this.value, leftEntry, rightEntry);
            entry.middleIcon = this.middleIcon;
            entry.splitPos = this.splitPos;
            return entry;
        }

        @Override
        protected Builder<L, R, LC, RC, LG, RG, LS, RS, LB, RB> createCopy(Pair<L, R> value) {
            Builder copy = new Builder(Pair.of(value), ((AbstractConfigEntryBuilder)this.leftBuilder).copy(), ((AbstractConfigEntryBuilder)this.rightBuilder).copy());
            copy.middleIcon = this.middleIcon;
            copy.splitPos = this.splitPos;
            return copy;
        }
    }
}

