/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.DoubleRangeEntryBuilder;
import endorh.simpleconfig.api.range.DoubleRange;
import endorh.simpleconfig.core.BackingField;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.core.entry.AbstractRangeEntry;
import endorh.simpleconfig.ui.api.AbstractConfigListEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.DoubleFieldBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class DoubleRangeEntry
extends AbstractRangeEntry.AbstractSizedRangeEntry<Double, DoubleRange, DoubleRangeEntry> {
    protected DoubleRangeEntry(ConfigEntryHolder parent, String name, DoubleRange value) {
        super(parent, name, value);
    }

    @Override
    protected Double deserializeElement(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected <EE extends AbstractConfigListEntry<Double>> EE buildLimitGUIEntry(ConfigFieldBuilder builder, String name, Double value) {
        return (EE)((DoubleFieldBuilder)((DoubleFieldBuilder)((DoubleFieldBuilder)((DoubleFieldBuilder)builder.startDoubleField((Component)Component.m_237113_((String)name), value).setDefaultValue(value)).setMin((Double)this.min)).setMax((Double)this.max)).setName(name)).build();
    }

    @Override
    public Optional<Component> getErrorFromGUI(DoubleRange value) {
        if (value.getMin() == null || value.getMax() == null) {
            return Optional.of(Component.m_237115_((String)"simpleconfig.config.error.invalid_float"));
        }
        return super.getErrorFromGUI(value);
    }

    public static class Builder
    extends AbstractRangeEntry.AbstractSizedRangeEntry.Builder<Double, DoubleRange, DoubleRangeEntry, DoubleRangeEntryBuilder, Builder>
    implements DoubleRangeEntryBuilder {
        public Builder(DoubleRange value) {
            super(value, DoubleRange.class);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public DoubleRangeEntryBuilder min(double min) {
            return (DoubleRangeEntryBuilder)this.min(Double.valueOf(min));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public DoubleRangeEntryBuilder max(double max) {
            return (DoubleRangeEntryBuilder)this.max(Double.valueOf(max));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public DoubleRangeEntryBuilder withBounds(double min, double max) {
            return (DoubleRangeEntryBuilder)this.withBounds(Double.valueOf(min), Double.valueOf(max));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public DoubleRangeEntryBuilder fieldScale(double scale) {
            return (DoubleRangeEntryBuilder)this.field(Builder.scale(scale), Builder.scale(1.0 / scale), DoubleRange.class);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public DoubleRangeEntryBuilder fieldScale(String name, double scale) {
            return (DoubleRangeEntryBuilder)this.addField(BackingField.BackingFieldBinding.withName(name, BackingField.BackingFieldBuilder.of(Builder.scale(scale), EntryType.of(DoubleRange.class, new EntryType[0]))));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public DoubleRangeEntryBuilder addFieldScale(String suffix, double scale) {
            return (DoubleRangeEntryBuilder)this.addField(suffix, Builder.scale(scale), DoubleRange.class);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public DoubleRangeEntryBuilder add_field_scale(String suffix, double scale) {
            return (DoubleRangeEntryBuilder)this.add_field(suffix, Builder.scale(scale), DoubleRange.class);
        }

        private static Function<DoubleRange, DoubleRange> scale(double scale) {
            if (scale == 0.0 || !Double.isFinite(scale)) {
                throw new IllegalArgumentException("Scale must be a non-zero finite number");
            }
            return d -> DoubleRange.of((Double)d.getMin() * scale, d.isExclusiveMin(), (Double)d.getMax() * scale, d.isExclusiveMax());
        }

        @Override
        protected DoubleRangeEntry buildEntry(ConfigEntryHolder parent, String name) {
            return new DoubleRangeEntry(parent, name, (DoubleRange)this.value);
        }

        @Override
        protected Builder createCopy(DoubleRange value) {
            return new Builder(value);
        }
    }
}

