/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.DoubleListEntryBuilder;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.core.entry.RangedListEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.DoubleListBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoubleListEntry
extends RangedListEntry<Double, Number, Double, DoubleListEntry> {
    @ApiStatus.Internal
    public DoubleListEntry(ConfigEntryHolder parent, String name, @Nullable List<Double> value) {
        super(parent, name, value);
    }

    @Override
    protected Double elemFromConfig(Number value) {
        return value != null ? Double.valueOf(value.doubleValue()) : null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<List<Double>, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        DoubleListBuilder valBuilder = builder.startDoubleList(this.getDisplayName(), (List)this.get());
        return Optional.of(this.decorate(valBuilder));
    }

    public static class Builder
    extends RangedListEntry.Builder<Double, Number, Double, DoubleListEntry, DoubleListEntryBuilder, Builder>
    implements DoubleListEntryBuilder {
        public Builder(List<Double> value) {
            super(value, EntryType.of(Double.class, new EntryType[0]));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public DoubleListEntryBuilder min(double min) {
            return (DoubleListEntryBuilder)super.min(min);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public DoubleListEntryBuilder max(double max) {
            return (DoubleListEntryBuilder)super.max(max);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public DoubleListEntryBuilder range(double min, double max) {
            return (DoubleListEntryBuilder)super.range(min, max);
        }

        @Override
        protected void checkBounds() {
            this.min = Double.valueOf(this.min != null ? (Double)this.min : Double.NEGATIVE_INFINITY);
            this.max = Double.valueOf(this.max != null ? (Double)this.max : Double.POSITIVE_INFINITY);
        }

        @Override
        protected DoubleListEntry buildEntry(ConfigEntryHolder parent, String name) {
            return new DoubleListEntry(parent, name, (List)this.value);
        }

        @Override
        @Contract(value="_ -> new", pure=true)
        protected Builder createCopy(List<Double> value) {
            return new Builder(value);
        }
    }
}

