/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.DoubleEntryBuilder;
import endorh.simpleconfig.core.AtomicEntry;
import endorh.simpleconfig.core.BackingField;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.core.entry.AbstractRangedEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.DoubleFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.DoubleSliderBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import java.util.Optional;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoubleEntry
extends AbstractRangedEntry<Double, Number, Double>
implements AtomicEntry<Double> {
    @ApiStatus.Internal
    public DoubleEntry(ConfigEntryHolder parent, String name, double value) {
        super(parent, name, value);
        this.commentMin = -1.7976931348623157E308;
        this.commentMax = Double.MAX_VALUE;
    }

    @Override
    @Nullable
    public Double fromConfig(@Nullable Number value) {
        return value != null ? Double.valueOf(value.doubleValue()) : null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<Double, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        if (!this.asSlider) {
            DoubleFieldBuilder valBuilder = (DoubleFieldBuilder)((DoubleFieldBuilder)builder.startDoubleField(this.getDisplayName(), (Double)this.get()).setMin((Double)this.min)).setMax((Double)this.max);
            return Optional.of(this.decorate(valBuilder));
        }
        DoubleSliderBuilder valBuilder = (DoubleSliderBuilder)((DoubleSliderBuilder)((DoubleSliderBuilder)((DoubleSliderBuilder)new DoubleSliderBuilder(builder, this.getDisplayName(), (Double)this.get(), (Double)this.min, (Double)this.max).setSliderMin((Double)this.sliderMin)).setSliderMax((Double)this.sliderMax)).setSliderMap(this.sliderMap)).setTextGetter(this.sliderTextSupplier);
        return Optional.of(this.decorate(valBuilder));
    }

    public static class Builder
    extends AbstractRangedEntry.Builder<Double, Number, Double, DoubleEntry, DoubleEntryBuilder, Builder>
    implements DoubleEntryBuilder {
        public Builder(Double value) {
            super(value, EntryType.of(Double.class, new EntryType[0]), "%.2f");
        }

        @Override
        @NotNull
        public DoubleEntryBuilder bakeScale(double scale) {
            return (DoubleEntryBuilder)this.baked(d -> d * scale, d -> d / scale);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public DoubleEntryBuilder fieldScale(double scale) {
            if (scale == 0.0 || !Double.isFinite(scale)) {
                throw new IllegalArgumentException("Scale must be a non-zero finite number");
            }
            return (DoubleEntryBuilder)this.field((V d) -> d * scale, (F d) -> d / scale, Double.class);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public DoubleEntryBuilder fieldScale(String name, double scale) {
            if (scale == 0.0 || !Double.isFinite(scale)) {
                throw new IllegalArgumentException("Scale must be a non-zero finite number");
            }
            return (DoubleEntryBuilder)this.addField(BackingField.BackingFieldBinding.withName(name, BackingField.BackingFieldBuilder.of(f -> f * scale, EntryType.of(Double.class, new EntryType[0]))));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public DoubleEntryBuilder addFieldScale(String suffix, double scale) {
            if (scale == 0.0 || !Double.isFinite(scale)) {
                throw new IllegalArgumentException("Scale must be a non-zero finite number");
            }
            return (DoubleEntryBuilder)this.addField(suffix, f -> f * scale, Double.class);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public DoubleEntryBuilder add_field_scale(String suffix, double scale) {
            if (scale == 0.0 || !Double.isFinite(scale)) {
                throw new IllegalArgumentException("Scale must be a non-zero finite number");
            }
            return (DoubleEntryBuilder)this.add_field(suffix, f -> f * scale, Double.class);
        }

        @Override
        protected void checkBounds() {
            double sMax;
            this.min = Double.valueOf(this.min == null ? Double.NEGATIVE_INFINITY : (Double)this.min);
            this.max = Double.valueOf(this.max == null ? Double.POSITIVE_INFINITY : (Double)this.max);
            double sMin = this.sliderMin != null ? Math.max((Double)this.min, (Double)this.sliderMin) : (Double)this.min;
            double d = sMax = this.sliderMax != null ? Math.min((Double)this.max, (Double)this.sliderMax) : (Double)this.max;
            if (((Double)this.min).isNaN() || ((Double)this.max).isNaN()) {
                throw new IllegalArgumentException("NaN bound in double config entry");
            }
            if (this.asSlider && (Double.isInfinite(sMin) || Double.isInfinite(sMax))) {
                throw new IllegalArgumentException("Infinite bound in double config entry");
            }
            super.checkBounds();
        }

        @Override
        protected DoubleEntry buildEntry(ConfigEntryHolder parent, String name) {
            return new DoubleEntry(parent, name, (Double)this.value);
        }

        @Override
        protected Builder createCopy(Double value) {
            return new Builder(value);
        }
    }
}

