/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import com.google.common.collect.Lists;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.CompoundTagEntryBuilder;
import endorh.simpleconfig.api.ui.TextFormatter;
import endorh.simpleconfig.core.entry.AbstractSerializableEntry;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.SnbtPrinterTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class CompoundTagEntry
extends AbstractSerializableEntry<CompoundTag> {
    @ApiStatus.Internal
    public CompoundTagEntry(ConfigEntryHolder parent, String name, CompoundTag value) {
        super(parent, name, value, CompoundTag.class);
    }

    @Override
    protected String serialize(CompoundTag value) {
        return new SnbtPrinterTagVisitor("", 0, (List)Lists.newArrayList()).m_178141_((Tag)value);
    }

    @Override
    @Nullable
    protected CompoundTag deserialize(String value) {
        try {
            StringReader reader = new StringReader(value);
            CompoundTag tag = new TagParser(reader).m_129373_();
            reader.skipWhitespace();
            return reader.canRead() ? null : tag;
        }
        catch (CommandSyntaxException ignored) {
            return null;
        }
    }

    @Override
    protected Optional<Component> getErrorMessage(String value) {
        return Optional.of(Component.m_237115_((String)"simpleconfig.config.error.invalid_nbt"));
    }

    @Override
    protected TextFormatter getTextFormatter() {
        return TextFormatter.forLanguageOrDefault("snbt", TextFormatter.DEFAULT);
    }

    public static class Builder
    extends AbstractSerializableEntry.Builder<CompoundTag, CompoundTagEntry, CompoundTagEntryBuilder, Builder>
    implements CompoundTagEntryBuilder {
        public Builder(CompoundTag value) {
            super(value, CompoundTag.class);
        }

        @Override
        protected CompoundTagEntry buildEntry(ConfigEntryHolder parent, String name) {
            return new CompoundTagEntry(parent, name, (CompoundTag)this.value);
        }

        @Override
        protected Builder createCopy(CompoundTag value) {
            return new Builder(value);
        }
    }
}

