/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.google.common.collect.Maps;
import endorh.simpleconfig.api.AtomicEntryBuilder;
import endorh.simpleconfig.api.ConfigEntryBuilder;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.EntryTag;
import endorh.simpleconfig.api.entry.CommentedConfigEntryBuilder;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractConfigEntryBuilder;
import endorh.simpleconfig.core.AtomicEntry;
import endorh.simpleconfig.core.DummyEntryHolder;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.core.entry.BeanEntry;
import endorh.simpleconfig.core.entry.BeanProxy;
import endorh.simpleconfig.core.wrap.CommentedConfigProxy;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.BeanFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommentedConfigEntry
extends AbstractConfigEntry<CommentedConfig, CommentedConfig, CommentedConfig> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CommentedConfigProxy proxy;
    private final Map<String, AbstractConfigEntry<?, ?, ?>> entries;
    @Nullable
    private String caption;
    @Nullable
    private Function<CommentedConfig, Icon> iconProvider = null;
    private final boolean hasSubPresentation;

    protected CommentedConfigEntry(ConfigEntryHolder parent, String name, CommentedConfig defValue, CommentedConfigProxy proxy2, Map<String, AbstractConfigEntry<?, ?, ?>> entries2) {
        super(parent, name, defValue);
        this.proxy = proxy2;
        this.entries = entries2;
        this.hasSubPresentation = entries2.values().stream().anyMatch(AbstractConfigEntry::hasPresentation);
    }

    public CommentedConfigProxy getProxy() {
        return this.proxy;
    }

    public AbstractConfigEntry<?, ?, ?> getEntry(String name) {
        return this.entries.get(name);
    }

    @Override
    public boolean hasPresentation() {
        return super.hasPresentation() || this.hasSubPresentation;
    }

    @Override
    protected CommentedConfig doForPresentation(CommentedConfig value) {
        if (!this.hasSubPresentation) {
            return super.doForPresentation(value);
        }
        return super.doForPresentation(this.proxy.createFrom(value, (Map<String, Object>)Maps.transformEntries((Map)Maps.filterEntries(this.entries, e -> ((AbstractConfigEntry)e.getValue()).hasPresentation()), (n, v) -> v.forPresentation(this.proxy.get(value, (String)n)))));
    }

    @Override
    protected CommentedConfig doFromPresentation(CommentedConfig value) {
        value = super.doFromPresentation(value);
        if (!this.hasSubPresentation) {
            return value;
        }
        CommentedConfig vv = value;
        return this.proxy.createFrom(value, (Map<String, Object>)Maps.transformEntries((Map)Maps.filterEntries(this.entries, e -> ((AbstractConfigEntry)e.getValue()).hasPresentation()), (n, v) -> v.fromPresentation(this.proxy.get(vv, (String)n))));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<CommentedConfig, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        BeanFieldBuilder<CommentedConfig> fieldBuilder = builder.startBeanField(this.getDisplayName(), (CommentedConfig)this.forGui((CommentedConfig)this.get()), this.proxy).withIcon(this.iconProvider).overrideEquals();
        this.entries.forEach((name, entry) -> {
            if (name.equals(this.caption)) {
                if (entry instanceof AtomicEntry) {
                    AtomicEntry keyEntry = (AtomicEntry)((Object)entry);
                    BeanEntry.addCaption(builder, (BeanFieldBuilder)fieldBuilder.withoutTags(EntryTag.NON_PERSISTENT, entry.copyTag), name, keyEntry);
                    return;
                }
                LOGGER.warn("Caption entry {} is not atomic, ignoring", (Object)this.getGlobalPath());
            }
            entry.buildGUIEntry(builder).ifPresent(g -> fieldBuilder.add((String)name, (FieldBuilder<?, ?, ?>)g.withoutTags(EntryTag.NON_PERSISTENT, entry.copyTag)));
        });
        return Optional.of(this.decorate(fieldBuilder));
    }

    public static class Builder
    extends AbstractConfigEntryBuilder<CommentedConfig, CommentedConfig, CommentedConfig, CommentedConfigEntry, CommentedConfigEntryBuilder, Builder>
    implements CommentedConfigEntryBuilder {
        private final Map<String, AbstractConfigEntryBuilder<?, ?, ?, ?, ?, ?>> entries = new LinkedHashMap();
        @Nullable
        private String caption;
        @Nullable
        private Function<CommentedConfig, Icon> iconProvider = null;

        public Builder(CommentedConfig value) {
            super(value, EntryType.unchecked(CommentedConfig.class));
        }

        @Override
        @NotNull
        public Builder add(String name, ConfigEntryBuilder<?, ?, ?, ?> entryBuilder) {
            Builder copy = (Builder)this.copy();
            if (!(entryBuilder instanceof AbstractConfigEntryBuilder)) {
                throw new IllegalArgumentException("ConfigEntryBuilder not instance of AbstractConfigEntryBuilder");
            }
            copy.entries.put(name, (AbstractConfigEntryBuilder)entryBuilder);
            return copy;
        }

        @Override
        @NotNull
        public <CB extends ConfigEntryBuilder<?, ?, ?, ?> & AtomicEntryBuilder> CommentedConfigEntryBuilder caption(String name, CB entryBuilder) {
            CommentedConfigEntryBuilder copy = this.add(name, (ConfigEntryBuilder)entryBuilder);
            ((Builder)copy).caption = name;
            return copy;
        }

        @Override
        @NotNull
        public CommentedConfigEntryBuilder withoutCaption() {
            Builder copy = (Builder)this.copy();
            copy.caption = null;
            return copy;
        }

        @Override
        @NotNull
        public CommentedConfigEntryBuilder withIcon(Function<CommentedConfig, Icon> icon) {
            Builder copy = (Builder)this.copy();
            copy.iconProvider = icon;
            return copy;
        }

        @Override
        protected CommentedConfigEntry buildEntry(ConfigEntryHolder parent, String name) {
            LinkedHashMap entries2 = new LinkedHashMap();
            this.entries.forEach((n, e) -> entries2.put((String)n, (AbstractConfigEntry<?, ?, ?>)DummyEntryHolder.build(parent, e)));
            CommentedConfigProxy proxy2 = new CommentedConfigProxy(entries2);
            CommentedConfigEntry entry = new CommentedConfigEntry(parent, name, (CommentedConfig)this.value, proxy2, entries2);
            String prefix = entry.getTranslation();
            entries2.forEach((n, e) -> {
                String propKey = proxy2.getTranslation((String)n);
                String key = prefix + propKey;
                e.setTranslation(key);
                e.setTooltipKey(key + ":help");
                e.setName(propKey);
            });
            entry.caption = this.caption;
            entry.iconProvider = this.iconProvider;
            return entry;
        }

        @Override
        protected Builder createCopy(CommentedConfig value) {
            Builder copy = new Builder(value);
            copy.entries.putAll(this.entries);
            copy.caption = this.caption;
            copy.iconProvider = this.iconProvider;
            return copy;
        }

        private static <V, G> BeanProxy.IBeanGuiAdapter createAdapter(AbstractConfigEntry<V, ?, G> entry) {
            return BeanProxy.IBeanGuiAdapter.of(v -> {
                try {
                    return entry.forGui(v);
                }
                catch (ClassCastException e) {
                    return null;
                }
            }, entry::fromGui);
        }
    }
}

