/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.ButtonEntryBuilder;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.core.entry.GUIOnlyEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.ButtonFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ButtonEntry
extends GUIOnlyEntry<Consumer<ConfigEntryHolder>, Runnable, ButtonEntry> {
    protected Supplier<Component> buttonLabelSupplier = () -> Component.m_237113_((String)"");

    public ButtonEntry(ConfigEntryHolder parent, String name, Consumer<ConfigEntryHolder> value) {
        super(parent, name, value, false, Consumer.class);
    }

    @Override
    public Runnable forGui(Consumer<ConfigEntryHolder> value) {
        return () -> value.accept(this.parent);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<Runnable, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        ButtonFieldBuilder entryBuilder = builder.startButton(this.getDisplayName(), this.forGui((Consumer)this.get())).withButtonLabel(this.buttonLabelSupplier);
        return Optional.of(entryBuilder);
    }

    public static class Builder
    extends GUIOnlyEntry.Builder<Consumer<ConfigEntryHolder>, Runnable, ButtonEntry, ButtonEntryBuilder, Builder>
    implements ButtonEntryBuilder {
        protected Supplier<Component> buttonLabelSupplier = () -> Component.m_237115_((String)"simpleconfig.label.run");

        public Builder(Consumer<ConfigEntryHolder> value) {
            super(value, EntryType.of(Void.class, new EntryType[0]));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder label(String translation) {
            Builder copy = (Builder)this.copy();
            MutableComponent ttc = Component.m_237115_((String)translation);
            copy.buttonLabelSupplier = () -> ttc;
            return copy;
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder label(Component label) {
            Builder copy = (Builder)this.copy();
            copy.buttonLabelSupplier = () -> label;
            return copy;
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder label(Supplier<Component> label) {
            Builder copy = (Builder)this.copy();
            copy.buttonLabelSupplier = label;
            return copy;
        }

        @Override
        protected ButtonEntry buildEntry(ConfigEntryHolder parent, String name) {
            ButtonEntry entry = new ButtonEntry(parent, name, (Consumer)this.value);
            entry.buttonLabelSupplier = this.buttonLabelSupplier;
            return entry;
        }

        @Override
        @Contract(value="_ -> new", pure=true)
        protected Builder createCopy(Consumer<ConfigEntryHolder> value) {
            Builder copy = new Builder(value);
            copy.buttonLabelSupplier = this.buttonLabelSupplier;
            return copy;
        }
    }
}

