/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.BooleanEntryBuilder;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractConfigEntryBuilder;
import endorh.simpleconfig.core.AtomicEntry;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.BooleanToggleBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BooleanEntry
extends AbstractConfigEntry<Boolean, Boolean, Boolean>
implements AtomicEntry<Boolean> {
    protected BooleanEntryBuilder.BooleanDisplayer yesNoSupplier = BooleanEntryBuilder.BooleanDisplayer.TRUE_FALSE;
    private static final Pattern TRUE_PATTERN = Pattern.compile("^\\s*+(?i:true|on|enabled?|0*+1(?:\\.0*+)?|0x0*+1)\\s*+$");
    private static final Pattern FALSE_PATTERN = Pattern.compile("^\\s*+(?i:false|off|disabled?|0++(?:\\.0*+)?|0x0++)\\s*+$");

    @ApiStatus.Internal
    public BooleanEntry(ConfigEntryHolder parent, String name, boolean value) {
        super(parent, name, value);
    }

    protected String[] getLabels() {
        String falseS;
        String trueS;
        if (this.yesNoSupplier != null && !(trueS = this.yesNoSupplier.getSerializableName(true)).equals(falseS = this.yesNoSupplier.getSerializableName(false))) {
            return new String[]{trueS, falseS};
        }
        return new String[]{"true", "false"};
    }

    @Override
    public Object forActualConfig(@Nullable Boolean value) {
        if (value == null) {
            return null;
        }
        String[] labels = this.getLabels();
        if ("true".equals(labels[0]) && "false".equals(labels[1])) {
            return value;
        }
        return labels[value != false ? 0 : 1];
    }

    @Override
    @Nullable
    public Boolean fromActualConfig(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String s = ((String)value).trim().toLowerCase();
            String[] labels = this.getLabels();
            if (labels[0].equals(s)) {
                return true;
            }
            if (labels[1].equals(s)) {
                return false;
            }
            if (labels[0].startsWith(s) && !labels[1].startsWith(s)) {
                return true;
            }
            if (labels[1].startsWith(s) && !labels[0].startsWith(s)) {
                return false;
            }
            if (TRUE_PATTERN.matcher(s).matches()) {
                return true;
            }
            if (FALSE_PATTERN.matcher(s).matches()) {
                return false;
            }
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue() != 0.0;
        }
        return null;
    }

    @Override
    public List<String> getConfigCommentTooltips() {
        List<String> tooltips = super.getConfigCommentTooltips();
        String[] labels = this.getLabels();
        tooltips.add(labels[0] + "/" + labels[1]);
        return tooltips;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<Boolean, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        BooleanToggleBuilder valBuilder = builder.startBooleanToggle(this.getDisplayName(), (Boolean)this.get()).setYesNoTextSupplier(this.yesNoSupplier::getDisplayName);
        return Optional.of(this.decorate(valBuilder));
    }

    @Override
    @Nullable
    public String forCommand(Boolean value) {
        return value == null ? null : (value != false ? "true" : "false");
    }

    @Override
    public boolean addCommandSuggestions(SuggestionsBuilder builder) {
        boolean current = (Boolean)this.get();
        MutableComponent msg = null;
        if (((Boolean)this.defValue).booleanValue()) {
            msg = Component.m_237115_((String)"simpleconfig.command.suggest.default");
        } else if (current) {
            msg = Component.m_237115_((String)"simpleconfig.command.suggest.current");
        }
        if (msg != null) {
            builder.suggest("true", (Message)msg);
        } else {
            builder.suggest("true");
        }
        msg = null;
        if (!((Boolean)this.defValue).booleanValue()) {
            msg = Component.m_237115_((String)"simpleconfig.command.suggest.default");
        } else if (!current) {
            msg = Component.m_237115_((String)"simpleconfig.command.suggest.current");
        }
        if (msg != null) {
            builder.suggest("false", (Message)msg);
        } else {
            builder.suggest("false");
        }
        return true;
    }

    public static class Builder
    extends AbstractConfigEntryBuilder<Boolean, Boolean, Boolean, BooleanEntry, BooleanEntryBuilder, Builder>
    implements BooleanEntryBuilder {
        protected BooleanEntryBuilder.BooleanDisplayer yesNoSupplier = BooleanEntryBuilder.BooleanDisplayer.TRUE_FALSE;

        public Builder(Boolean value) {
            super(value, EntryType.of(Boolean.class, new EntryType[0]));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder text(BooleanEntryBuilder.BooleanDisplayer displayAdapter) {
            String falseS;
            Builder copy = (Builder)this.copy();
            String trueS = displayAdapter.getSerializableName(true).trim().toLowerCase();
            if (trueS.equals(falseS = displayAdapter.getSerializableName(false).trim().toLowerCase())) {
                throw new IllegalArgumentException("Illegal boolean displayer: Serializable names must differ in lowercase after trimming");
            }
            copy.yesNoSupplier = displayAdapter;
            return copy;
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder text(String translation) {
            Builder copy = (Builder)this.copy();
            MutableComponent yes = Component.m_237115_((String)(translation + ".true"));
            MutableComponent no = Component.m_237115_((String)(translation + ".false"));
            copy.yesNoSupplier = b -> b ? yes : no;
            return copy;
        }

        @Override
        protected BooleanEntry buildEntry(ConfigEntryHolder parent, String name) {
            BooleanEntry e = new BooleanEntry(parent, name, (Boolean)this.value);
            e.yesNoSupplier = this.yesNoSupplier;
            return e;
        }

        @Override
        protected Builder createCopy(Boolean value) {
            Builder copy = new Builder(value);
            copy.yesNoSupplier = this.yesNoSupplier;
            return copy;
        }
    }
}

