/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.api.entry.BlockEntryBuilder;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractConfigEntryBuilder;
import endorh.simpleconfig.core.AtomicEntry;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.gui.widget.combobox.SimpleComboBoxModel;
import endorh.simpleconfig.ui.impl.builders.ComboBoxFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class BlockEntry
extends AbstractConfigEntry<Block, String, Block>
implements AtomicEntry<Block> {
    @NotNull
    protected Predicate<Block> filter;

    @ApiStatus.Internal
    public BlockEntry(ConfigEntryHolder parent, String name, @Nullable Block value, Predicate<Block> filter) {
        super(parent, name, value != null ? value : Blocks.f_50016_);
        this.filter = filter != null ? filter : b -> true;
    }

    @Override
    public String forConfig(Block value) {
        return ForgeRegistries.BLOCKS.getKey((Object)value).toString();
    }

    @Override
    @Nullable
    public Block fromConfig(@Nullable String value) {
        if (value == null) {
            return null;
        }
        try {
            ResourceLocation registryName = new ResourceLocation(value);
            Block item = ForgeRegistries.BLOCKS.containsKey(registryName) ? (Block)ForgeRegistries.BLOCKS.getValue(registryName) : null;
            return this.filter.test(item) || item == this.defValue ? item : null;
        }
        catch (ResourceLocationException e) {
            return null;
        }
    }

    protected List<Block> supplyOptions() {
        return ForgeRegistries.BLOCKS.getValues().stream().filter(this.filter).collect(Collectors.toList());
    }

    @Override
    public List<String> getConfigCommentTooltips() {
        List<String> tooltips = super.getConfigCommentTooltips();
        tooltips.add("Block: namespace:path");
        return tooltips;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<Block, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        ComboBoxFieldBuilder<Block> entryBuilder = builder.startComboBox(this.getDisplayName(), ComboBoxFieldBuilder.ofBlock(), (Block)this.forGui((Block)this.get())).setSuggestionProvider(new SimpleComboBoxModel(this::supplyOptions)).setSuggestionMode(false);
        return Optional.of(this.decorate(entryBuilder));
    }

    @Override
    public boolean addCommandSuggestions(SuggestionsBuilder builder) {
        super.addCommandSuggestions(builder);
        Block current = (Block)this.get();
        for (Block o : this.supplyOptions()) {
            if (o.equals(current) || o.equals(this.defValue) || !this.isValidValue(o)) continue;
            builder.suggest(this.forCommand(o));
        }
        return true;
    }

    public static class Builder
    extends AbstractConfigEntryBuilder<Block, String, Block, BlockEntry, BlockEntryBuilder, Builder>
    implements BlockEntryBuilder {
        private static final Logger LOGGER = LogManager.getLogger();
        @Nullable
        protected Predicate<Block> filter = null;
        @Nullable
        protected TagKey<Block> tag = null;

        public Builder(Block value) {
            super(value, EntryType.of(Block.class, new EntryType[0]));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder setRequireGroup(boolean requireGroup) {
            return (Builder)this.copy();
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder from(Predicate<Block> filter) {
            Builder copy = (Builder)this.copy();
            copy.filter = filter;
            return copy;
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder from(List<Block> choices) {
            ArrayList<Block> listCopy = new ArrayList<Block>(choices);
            return this.from(listCopy::contains);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder from(Block ... choices) {
            List<Block> listCopy = Arrays.asList(choices);
            return this.from(listCopy::contains);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder from(TagKey<Block> tag) {
            Builder copy = (Builder)this.copy();
            copy.tag = tag;
            return copy;
        }

        @Override
        protected BlockEntry buildEntry(ConfigEntryHolder parent, String name) {
            if (parent.getRoot().getType() != SimpleConfig.Type.SERVER && this.tag != null) {
                throw new IllegalArgumentException("Cannot use tag item filters in non-server config entry");
            }
            if (this.tag != null) {
                Predicate<Block> inTag = i -> ForgeRegistries.BLOCKS.tags().getTag(this.tag).contains(i);
                Predicate<Block> predicate = this.filter = this.filter != null ? this.filter.and(inTag) : inTag;
            }
            if (this.filter != null && !this.filter.test((Block)this.value)) {
                LOGGER.warn("Block entry's default value doesn't match its filter");
            }
            Predicate<Block> filter = this.filter != null ? this.filter : b -> true;
            return new BlockEntry(parent, name, (Block)this.value, filter);
        }

        @Override
        protected Builder createCopy(Block value) {
            Builder copy = new Builder(value);
            copy.filter = this.filter;
            copy.tag = this.tag;
            return copy;
        }
    }
}

