/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import endorh.simpleconfig.core.entry.BeanEntry;
import endorh.simpleconfig.core.entry.BeanProxy;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.error.YAMLException;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.introspector.Property;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.introspector.PropertyUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class BeanProxyImpl<B>
implements BeanProxy<B> {
    private static final PropertyUtils utils = new PropertyUtils();
    private final Class<B> type;
    private final Map<String, Property> properties;
    private final Map<String, BeanProxy.IBeanGuiAdapter> adapters;

    public BeanProxyImpl(Class<B> type, Map<String, BeanProxy.IBeanGuiAdapter> adapters) {
        this.type = type;
        this.adapters = adapters;
        try {
            Set<Property> set = utils.getProperties(type);
            this.properties = new LinkedHashMap<String, Property>(set.size());
            for (Property prop : set) {
                this.properties.put(prop.getName(), prop);
            }
        }
        catch (YAMLException e) {
            throw new BeanEntry.ConfigBeanIntrospectionException("Invalid Java Bean for config entry: " + type.getCanonicalName(), e);
        }
    }

    @Override
    public B create(@Nullable Map<String, Object> props) {
        try {
            B bean = this.type.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (props != null) {
                props.forEach((name, value) -> {
                    Property prop = this.properties.get(name);
                    if (prop != null) {
                        try {
                            prop.set(bean, value);
                        }
                        catch (Exception e) {
                            throw new BeanEntry.ConfigBeanAccessException("Cannot copy value of Java Bean property: " + this.type.getCanonicalName() + "$" + prop.getName(), e);
                        }
                    }
                });
            }
            return bean;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new BeanEntry.ConfigBeanAccessException("Cannot create instance of Java Bean for config entry: " + this.type.getCanonicalName(), e);
        }
    }

    @Override
    public B createFrom(B def, @Nullable Map<String, Object> props) {
        Object bean = this.create();
        for (Property prop : this.properties.values()) {
            String name = prop.getName();
            try {
                prop.set(bean, props != null && props.containsKey(name) ? props.get(name) : prop.get(def));
            }
            catch (Exception e) {
                throw new BeanEntry.ConfigBeanAccessException("Cannot copy value of Java Bean property: " + this.type.getCanonicalName() + "$" + name, e);
            }
        }
        return bean;
    }

    @Override
    public B createFromGUI(B def, @Nullable Map<String, Object> props) {
        Object bean = this.create();
        for (Property prop : this.properties.values()) {
            String name = prop.getName();
            try {
                BeanProxy.IBeanGuiAdapter adapter = this.adapters.get(name);
                prop.set(bean, props != null && props.containsKey(name) ? (adapter != null ? adapter.fromGui(props.get(name)) : props.get(name)) : prop.get(def));
            }
            catch (Exception e) {
                throw new BeanEntry.ConfigBeanAccessException("Cannot copy value of Java Bean property: " + this.type.getCanonicalName() + "$" + name, e);
            }
        }
        return bean;
    }

    @Override
    public Object get(B bean, String name) {
        try {
            return this.properties.get(name).get(bean);
        }
        catch (YAMLException e) {
            throw new BeanEntry.ConfigBeanAccessException("Cannot get Java Bean property " + this.type.getCanonicalName() + "$" + name, e);
        }
    }

    @Override
    public Object getGUI(B bean, String name) {
        BeanProxy.IBeanGuiAdapter adapter = this.adapters.get(name);
        if (adapter != null) {
            return adapter.forGui(this.get(bean, name));
        }
        return this.get(bean, name);
    }

    @Override
    public String getTypeName() {
        return this.getType().getCanonicalName();
    }

    @Override
    public String getPropertyName(String name) {
        return this.getTypeName() + "$" + name;
    }

    @Override
    public String getTypeTranslation() {
        return this.getType().getSimpleName();
    }

    @Override
    public String getTranslation(String property) {
        return property;
    }

    public Class<B> getType() {
        return this.type;
    }

    public Map<String, Property> getPropertyMap() {
        return this.properties;
    }

    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public Collection<Property> getProperties() {
        return this.properties.values();
    }
}

