/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import endorh.simpleconfig.api.AtomicEntryBuilder;
import endorh.simpleconfig.api.ConfigEntryBuilder;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.EntryTag;
import endorh.simpleconfig.api.entry.BeanEntryBuilder;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractConfigEntryBuilder;
import endorh.simpleconfig.core.AtomicEntry;
import endorh.simpleconfig.core.DummyEntryHolder;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.core.entry.BeanProxy;
import endorh.simpleconfig.core.entry.BeanProxyImpl;
import endorh.simpleconfig.core.reflection.BeanClassParser;
import endorh.simpleconfig.ui.api.AbstractConfigListEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.BeanFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeanEntry<B>
extends AbstractConfigEntry<B, Map<String, Object>, B> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final BeanProxyImpl<B> proxy;
    private final Map<String, AbstractConfigEntry<?, ?, ?>> entries;
    @Nullable
    private String caption;
    @Nullable
    private Function<B, Icon> iconProvider;
    private final boolean hasSubPresentation;
    private boolean overrideEquals;
    private static final Pattern LINE_BREAK = Pattern.compile("\\R");

    public BeanEntry(ConfigEntryHolder parent, String name, B defValue, BeanProxyImpl<B> proxy2, Map<String, AbstractConfigEntry<?, ?, ?>> entries2) {
        super(parent, name, defValue);
        this.proxy = proxy2;
        this.entries = entries2;
        this.hasSubPresentation = entries2.values().stream().anyMatch(AbstractConfigEntry::hasPresentation);
    }

    public BeanProxy<B> getProxy() {
        return this.proxy;
    }

    public AbstractConfigEntry<?, ?, ?> getEntry(String name) {
        return this.entries.get(name);
    }

    @Override
    public Map<String, Object> forConfig(B value) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(this.proxy.getProperties().size());
        for (String name : this.proxy.getPropertyNames()) {
            try {
                AbstractConfigEntry<?, ?, ?> entry = this.entries.get(name);
                if (entry == null) continue;
                Object v = this.proxy.get(value, name);
                if (v == null) {
                    throw new ConfigBeanNullPropertyException(this.proxy.getPropertyName(name));
                }
                map.put(name, entry.forConfig(v));
            }
            catch (ClassCastException e) {
                throw new ConfigBeanAccessException("Error reading Java Bean for config entry " + this.getGlobalPath(), e);
            }
        }
        return map;
    }

    @Override
    @Nullable
    public B fromConfig(@Nullable Map<String, Object> value) {
        if (value == null) {
            return null;
        }
        return (B)this.proxy.createFrom(this.defValue, Maps.transformEntries((Map)Maps.filterKeys(this.entries, this.proxy.getPropertyNames()::contains), (n, v) -> v.fromConfigOrDefault(value.get(n))));
    }

    @Override
    public boolean hasPresentation() {
        return super.hasPresentation() || this.hasSubPresentation;
    }

    @Override
    protected B doForPresentation(B value) {
        if (!this.hasSubPresentation) {
            return super.doForPresentation(value);
        }
        return super.doForPresentation(this.proxy.createFrom(value, Maps.transformEntries((Map)Maps.filterEntries(this.entries, e -> this.proxy.getPropertyNames().contains(e.getKey()) && ((AbstractConfigEntry)e.getValue()).hasPresentation()), (n, v) -> v.forPresentation(this.proxy.get(value, (String)n)))));
    }

    @Override
    protected B doFromPresentation(B value) {
        value = super.doFromPresentation(value);
        if (!this.hasSubPresentation) {
            return value;
        }
        B vv = value;
        return this.proxy.createFrom(value, Maps.transformEntries((Map)Maps.filterEntries(this.entries, e -> this.proxy.getPropertyNames().contains(e.getKey()) && ((AbstractConfigEntry)e.getValue()).hasPresentation()), (n, v) -> v.fromPresentation(this.proxy.get(vv, (String)n))));
    }

    @Override
    public Object forActualConfig(@Nullable Map<String, Object> value) {
        if (value == null) {
            return null;
        }
        LinkedHashMap map = new LinkedHashMap(value.size());
        this.entries.forEach((name, entry) -> {
            Object gui = value.get(name);
            try {
                AbstractConfigEntry c = entry;
                map.put(name, c.forActualConfig(gui));
            }
            catch (ClassCastException e) {
                LOGGER.error("Error serializing bean entry property \"" + name + "\": " + this.getGlobalPath(), (Throwable)e);
            }
        });
        return map.isEmpty() ? null : map;
    }

    @Override
    @Nullable
    public Map<String, Object> fromActualConfig(@Nullable Object value) {
        if (value instanceof List) {
            List seq = (List)value;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (Object o : seq) {
                Object val;
                AbstractConfigEntry<?, ?, ?> entry;
                String key;
                Map.Entry e;
                if (o instanceof Map) {
                    Map mm = (Map)o;
                    if (mm.entrySet().size() != 1) {
                        return null;
                    }
                    e = (Map.Entry)mm.entrySet().stream().findFirst().orElseThrow(IllegalStateException::new);
                    key = BeanEntry.tryCast(e.getKey(), String.class);
                    entry = this.entries.get(key);
                    if (entry == null) continue;
                    val = entry.fromActualConfig(e.getValue());
                    if (key == null || val == null) {
                        return null;
                    }
                    map.put(key, val);
                    continue;
                }
                if (!(o instanceof Config)) continue;
                Config config = (Config)o;
                if (config.entrySet().size() != 1) {
                    return null;
                }
                e = (Config.Entry)config.entrySet().stream().findFirst().orElseThrow(IllegalStateException::new);
                key = e.getKey();
                entry = this.entries.get(key);
                if (entry == null) continue;
                val = entry.fromActualConfig(e.getValue());
                if (key == null || val == null) {
                    return null;
                }
                map.put(key, val);
            }
            return map;
        }
        if (value instanceof Config) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (CommentedConfig.Entry e : ((CommentedConfig)value).entrySet()) {
                String key = e.getKey();
                AbstractConfigEntry<?, ?, ?> entry = this.entries.get(key);
                if (entry == null) continue;
                Object val = entry.fromActualConfig(e.getValue());
                if (key == null || val == null) {
                    return null;
                }
                map.put(key, val);
            }
            return map;
        }
        if (value instanceof Map) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (Map.Entry e : ((Map)value).entrySet()) {
                String key = BeanEntry.tryCast(e.getKey(), String.class);
                AbstractConfigEntry<?, ?, ?> entry = this.entries.get(key);
                if (entry == null) continue;
                Object val = entry.fromActualConfig(e.getValue());
                if (key == null || val == null) {
                    return null;
                }
                map.put(key, val);
            }
            return map;
        }
        return null;
    }

    @Override
    public boolean areEqual(B current, B candidate) {
        if (this.overrideEquals) {
            for (Map.Entry<String, AbstractConfigEntry<?, ?, ?>> e : this.entries.entrySet()) {
                String name = e.getKey();
                AbstractConfigEntry<?, ?, ?> entry = e.getValue();
                if (entry.areEqual(this.proxy.get(current, name), this.proxy.get(candidate, name))) continue;
                return false;
            }
            return true;
        }
        return super.areEqual(current, candidate);
    }

    @Override
    public List<String> getConfigCommentTooltips() {
        List<String> comments = super.getConfigCommentTooltips();
        comments.add("Object: \n  " + this.entries.entrySet().stream().map(e -> (String)e.getKey() + ": " + LINE_BREAK.matcher(((AbstractConfigEntry)e.getValue()).getConfigCommentTooltip()).replaceAll("\n  ").trim()).collect(Collectors.joining("\n  ")));
        return comments;
    }

    @Nullable
    protected static <T> T tryCast(Object value, Class<T> type) {
        return type.isInstance(value) ? (T)type.cast(value) : null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<B, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        BeanFieldBuilder fieldBuilder = builder.startBeanField(this.getDisplayName(), this.forGui(this.get()), this.proxy).withIcon(this.iconProvider);
        this.entries.forEach((name, entry) -> {
            if (name.equals(this.caption)) {
                if (!(entry instanceof AtomicEntry)) {
                    LOGGER.debug("Caption for Bean entry is not a key entry: " + this.getGlobalPath());
                } else {
                    AtomicEntry keyEntry = (AtomicEntry)((Object)entry);
                    BeanEntry.addCaption(builder, (BeanFieldBuilder)fieldBuilder.withoutTags(EntryTag.NON_PERSISTENT, entry.copyTag), name, keyEntry);
                    return;
                }
            }
            entry.buildGUIEntry(builder).ifPresent(g -> fieldBuilder.add((String)name, (FieldBuilder<?, ?, ?>)g.withoutTags(EntryTag.NON_PERSISTENT, entry.copyTag)));
        });
        return Optional.of(this.decorate(fieldBuilder));
    }

    @ApiStatus.Internal
    public static <B, KG, E extends AbstractConfigListEntry<KG>, FB extends FieldBuilder<KG, E, FB>> void addCaption(ConfigFieldBuilder builder, BeanFieldBuilder<B> fieldBuilder, String name, AtomicEntry<KG> keyEntry) {
        fieldBuilder.caption(name, keyEntry.buildAtomicChildGUIEntry(builder));
    }

    public static class ConfigBeanNullPropertyException
    extends RuntimeException {
        private static String getMessage(String path) {
            return "Null bean property value: " + path + "\nConfigurable beans cannot have nullable properties.";
        }

        public ConfigBeanNullPropertyException(String path) {
            super(ConfigBeanNullPropertyException.getMessage(path));
        }

        public ConfigBeanNullPropertyException(String path, Throwable cause) {
            super(ConfigBeanNullPropertyException.getMessage(path), cause);
        }
    }

    public static class ConfigBeanAccessException
    extends RuntimeException {
        public ConfigBeanAccessException(String message) {
            super(message);
        }

        public ConfigBeanAccessException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class ConfigBeanIntrospectionException
    extends RuntimeException {
        public ConfigBeanIntrospectionException(String message) {
            super(message);
        }

        public ConfigBeanIntrospectionException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class Builder<B>
    extends AbstractConfigEntryBuilder<B, Map<String, Object>, B, BeanEntry<B>, BeanEntryBuilder<B>, Builder<B>>
    implements BeanEntryBuilder<B> {
        private static final Map<Class<?>, Boolean> NON_REFLEXIVE_TYPES = new HashMap();
        private final Class<B> beanType;
        private final Map<String, AbstractConfigEntryBuilder<?, ?, ?, ?, ?, ?>> entries = new LinkedHashMap();
        @Nullable
        private String caption = null;
        @Nullable
        private Function<B, Icon> iconProvider = null;
        private boolean allowUneditableProperties = false;

        public static <B> BeanEntryBuilder<B> create(B value) {
            return BeanClassParser.create(value);
        }

        public Builder(B value) {
            super(value, EntryType.unchecked(value.getClass()));
            this.beanType = value.getClass();
        }

        @Override
        @NotNull
        public BeanEntryBuilder<B> allowUneditableProperties(boolean allowUneditable) {
            Builder copy = (Builder)this.copy();
            copy.allowUneditableProperties = allowUneditable;
            return copy;
        }

        @Override
        protected BeanEntry<B> buildEntry(ConfigEntryHolder parent, String name) {
            LinkedHashMap entries2 = new LinkedHashMap();
            this.entries.forEach((n, e) -> entries2.put((String)n, (AbstractConfigEntry<?, ?, ?>)DummyEntryHolder.build(parent, e)));
            BeanProxyImpl proxy2 = new BeanProxyImpl(this.beanType, (Map)Util.m_137469_(new HashMap(), m -> entries2.forEach((n, e) -> m.put(n, Builder.createAdapter(e)))));
            String prefix = entries2.values().stream().map(e -> e.getRoot().getModId()).findFirst().orElse("") + ".config.bean." + proxy2.getTypeTranslation() + ".";
            entries2.forEach((n, e) -> {
                String key = prefix + proxy2.getTranslation((String)n);
                e.setTranslation(key);
                e.setTooltipKey(key + ":help");
                e.setName(proxy2.getTranslation((String)n));
            });
            HashSet names = Sets.newHashSet(proxy2.getPropertyNames());
            for (String n2 : entries2.keySet()) {
                if (names.remove(n2)) continue;
                throw new ConfigBeanIntrospectionException("No bean property for name " + n2 + " within bean class " + proxy2.getTypeName());
            }
            BeanEntry<Object> entry = new BeanEntry<Object>(parent, name, this.value, proxy2, entries2);
            if (!this.allowUneditableProperties && !names.isEmpty()) {
                throw new ConfigBeanIntrospectionException("Found uneditable properties in bean class " + proxy2.getTypeName() + ": [" + String.join((CharSequence)", ", names) + "]\nCall allowUneditableProperties() to allow them, or define config entries for them.\n  at " + entry.getGlobalPath());
            }
            entries2.keySet().forEach(n -> {
                if (proxy2.get((B)this.value, (String)n) == null) {
                    throw new ConfigBeanNullPropertyException(proxy2.getPropertyName((String)n));
                }
            });
            entry.overrideEquals = NON_REFLEXIVE_TYPES.computeIfAbsent(this.beanType, t -> {
                boolean nonReflexive;
                boolean bl = nonReflexive = !this.value.equals(proxy2.createFrom(this.value));
                if (nonReflexive) {
                    LOGGER.info("Bean type " + proxy2.getTypeName() + " has a non-reflexive equals method. It'll be compared based on its defined property entries instead.");
                }
                return nonReflexive;
            });
            entry.caption = this.caption;
            entry.iconProvider = this.iconProvider;
            return entry;
        }

        private static <V, G> BeanProxy.IBeanGuiAdapter createAdapter(AbstractConfigEntry<V, ?, G> entry) {
            return BeanProxy.IBeanGuiAdapter.of(v -> {
                try {
                    return entry.forGui(v);
                }
                catch (ClassCastException e) {
                    return null;
                }
            }, entry::fromGui);
        }

        @Override
        @NotNull
        public Builder<B> add(String name, ConfigEntryBuilder<?, ?, ?, ?> entryBuilder) {
            Builder copy = (Builder)this.copy();
            if (!(entryBuilder instanceof AbstractConfigEntryBuilder)) {
                throw new IllegalArgumentException("ConfigEntryBuilder not instance of AbstractConfigEntryBuilder");
            }
            copy.entries.put(name, (AbstractConfigEntryBuilder)entryBuilder);
            return copy;
        }

        @Override
        @NotNull
        public <CB extends ConfigEntryBuilder<?, ?, ?, ?> & AtomicEntryBuilder> BeanEntryBuilder<B> caption(String name, CB entryBuilder) {
            BeanEntryBuilder copy = this.add(name, (ConfigEntryBuilder)entryBuilder);
            ((Builder)copy).caption = name;
            return copy;
        }

        @Override
        @NotNull
        public BeanEntryBuilder<B> withoutCaption() {
            Builder copy = (Builder)this.copy();
            copy.caption = null;
            return copy;
        }

        @Override
        @NotNull
        public BeanEntryBuilder<B> withIcon(Function<B, Icon> icon) {
            Builder copy = (Builder)this.copy();
            copy.iconProvider = icon;
            return copy;
        }

        @Override
        protected Builder<B> createCopy(B value) {
            Builder<B> copy = new Builder<B>(value);
            copy.entries.putAll(this.entries);
            copy.caption = this.caption;
            copy.iconProvider = this.iconProvider;
            copy.allowUneditableProperties = this.allowUneditableProperties;
            return copy;
        }
    }
}

