/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.SerializableEntryBuilder;
import endorh.simpleconfig.api.ui.TextFormatter;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractConfigEntryBuilder;
import endorh.simpleconfig.core.AtomicEntry;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.gui.widget.combobox.SimpleComboBoxModel;
import endorh.simpleconfig.ui.gui.widget.combobox.wrapper.StringTypeWrapper;
import endorh.simpleconfig.ui.gui.widget.combobox.wrapper.TypeWrapper;
import endorh.simpleconfig.ui.impl.builders.ComboBoxFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import endorh.simpleconfig.ui.impl.builders.TextFieldBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSerializableEntry<V>
extends AbstractConfigEntry<V, String, String>
implements AtomicEntry<String> {
    private static final Map<Class<?>, Boolean> NON_REFLEXIVE_TYPES = new HashMap();
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    protected Supplier<List<V>> suggestionSupplier;
    protected boolean overrideEquals;

    protected AbstractSerializableEntry(ConfigEntryHolder parent, String name, V value, Class<?> typeClass) {
        super(parent, name, value);
        this.typeClass = typeClass;
    }

    protected abstract String serialize(V var1);

    @Nullable
    protected abstract V deserialize(String var1);

    @Override
    public String forGui(V value) {
        return value != null ? this.serialize(value) : "";
    }

    @Override
    @Nullable
    public V fromGui(@Nullable String value) {
        return value != null ? (V)this.deserialize(value) : null;
    }

    @Override
    public String forConfig(V value) {
        return value != null ? this.serialize(value) : "";
    }

    @Override
    @Nullable
    public V fromConfig(@Nullable String value) {
        return value != null ? (V)this.deserialize(value) : null;
    }

    @Override
    public boolean areEqual(V current, V candidate) {
        return this.overrideEquals ? Objects.equals(this.serialize(current), this.serialize(candidate)) : super.areEqual(current, candidate);
    }

    protected Optional<Component> getErrorMessage(String value) {
        return Optional.of(Component.m_237115_((String)"simpleconfig.config.error.invalid_value_generic"));
    }

    @Override
    public Optional<Component> getErrorFromGUI(String value) {
        Optional<Component> opt = super.getErrorFromGUI(value);
        if (opt.isEmpty() && this.fromGui(value) == null && value != null) {
            return this.getErrorMessage(value);
        }
        return opt;
    }

    @Override
    public List<String> getConfigCommentTooltips() {
        List<String> tooltips = super.getConfigCommentTooltips();
        String typeComment = this.getTypeComment();
        if (typeComment != null) {
            tooltips.add(typeComment);
        }
        return tooltips;
    }

    @Nullable
    protected String getTypeComment() {
        return this.typeClass.getSimpleName();
    }

    protected TextFormatter getTextFormatter() {
        return TextFormatter.DEFAULT;
    }

    protected TypeWrapper<String> getTypeWrapper() {
        return new SerializableTypeWrapper(this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<String, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        if (this.suggestionSupplier != null) {
            ComboBoxFieldBuilder<Object> valBuilder = builder.startComboBox(this.getDisplayName(), new StringTypeWrapper(), this.forGui(this.get())).setSuggestionProvider(new SimpleComboBoxModel(() -> this.suggestionSupplier.get().stream().map(this::serialize).collect(Collectors.toList())));
            return Optional.of(this.decorate(valBuilder));
        }
        TextFieldBuilder valBuilder = builder.startTextField(this.getDisplayName(), (String)this.forGui(this.get())).setTextFormatter(this.getTextFormatter());
        return Optional.of(this.decorate(valBuilder));
    }

    public static class SerializableTypeWrapper<V>
    extends StringTypeWrapper {
        protected final AbstractSerializableEntry<V> entry;

        public SerializableTypeWrapper(AbstractSerializableEntry<V> entry) {
            this.entry = entry;
        }

        @Override
        @Nullable
        public TextFormatter getTextFormatter() {
            return this.entry.getTextFormatter();
        }
    }

    public static abstract class Builder<V, Entry extends AbstractSerializableEntry<V>, Self extends SerializableEntryBuilder<V, Self>, SelfImpl extends Builder<V, Entry, Self, SelfImpl>>
    extends AbstractConfigEntryBuilder<V, String, String, Entry, Self, SelfImpl>
    implements SerializableEntryBuilder<V, Self> {
        @Nullable
        protected Supplier<List<V>> suggestionSupplier = null;

        protected Builder(V value) {
            this(value, value.getClass());
        }

        protected Builder(V value, Class<?> typeClass) {
            this(value, EntryType.unchecked(typeClass));
        }

        protected Builder(V value, EntryType<?> type) {
            super(value, type);
        }

        @Override
        @SafeVarargs
        @NotNull
        public final Self suggest(V ... suggestions) {
            return this.suggest(Arrays.asList(suggestions));
        }

        @Override
        @NotNull
        public Self suggest(@NotNull List<V> suggestions) {
            return this.suggest(() -> suggestions);
        }

        @Override
        @NotNull
        public Self suggest(Supplier<List<V>> suggestionSupplier) {
            Builder copy = (Builder)this.copy();
            copy.suggestionSupplier = suggestionSupplier;
            return (Self)((SerializableEntryBuilder)copy.castSelf());
        }

        @Override
        public SelfImpl copy(V value) {
            Builder copy = (Builder)super.copy(value);
            copy.suggestionSupplier = this.suggestionSupplier;
            return (SelfImpl)copy;
        }

        @Override
        protected Entry build(@NotNull ConfigEntryHolder parent, String name) {
            AbstractSerializableEntry entry = (AbstractSerializableEntry)super.build(parent, name);
            entry.suggestionSupplier = this.suggestionSupplier;
            entry.overrideEquals = NON_REFLEXIVE_TYPES.computeIfAbsent(this.typeClass, t -> {
                boolean nonReflexive;
                boolean bl = nonReflexive = !this.value.equals(entry.deserialize(entry.serialize(this.value)));
                if (nonReflexive) {
                    LOGGER.info("Serializable type " + t.getName() + " does not have a reflexive equals method. Their config entries will be compared by their serialization instead.");
                }
                return nonReflexive;
            });
            return (Entry)entry;
        }
    }
}

