/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import com.google.common.collect.Lists;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.ResourceEntryBuilder;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractConfigEntryBuilder;
import endorh.simpleconfig.core.AtomicEntry;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.ui.gui.widget.combobox.SimpleComboBoxModel;
import endorh.simpleconfig.ui.impl.builders.ComboBoxFieldBuilder;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractResourceEntry<Self extends AbstractResourceEntry<Self>>
extends AbstractConfigEntry<ResourceLocation, String, ResourceLocation>
implements AtomicEntry<ResourceLocation> {
    protected SimpleComboBoxModel<ResourceLocation> suggestionProvider;

    public AbstractResourceEntry(ConfigEntryHolder parent, String name, @Nullable ResourceLocation value) {
        super(parent, name, value != null ? value : new ResourceLocation(""));
    }

    @Override
    public String forConfig(ResourceLocation value) {
        return value.toString();
    }

    @Override
    @Nullable
    public ResourceLocation fromConfig(@Nullable String value) {
        if (value == null) {
            return null;
        }
        try {
            return new ResourceLocation(value);
        }
        catch (ResourceLocationException e) {
            return null;
        }
    }

    @Nullable
    protected String getTypeComment() {
        return null;
    }

    @Override
    public List<String> getConfigCommentTooltips() {
        List<String> tooltips = super.getConfigCommentTooltips();
        Object typeComment = this.getTypeComment();
        typeComment = typeComment != null ? (String)typeComment + ": " : "";
        tooltips.add((String)typeComment + "namespace:path");
        return tooltips;
    }

    @Override
    protected ComboBoxFieldBuilder<ResourceLocation> decorate(ComboBoxFieldBuilder<ResourceLocation> builder) {
        builder = super.decorate(builder);
        builder.setSuggestionProvider(this.suggestionProvider);
        builder.setSuggestionMode(true);
        return builder;
    }

    public static abstract class Builder<Entry extends AbstractResourceEntry<Entry>, Self extends ResourceEntryBuilder<Self>, SelfImpl extends Builder<Entry, Self, SelfImpl>>
    extends AbstractConfigEntryBuilder<ResourceLocation, String, ResourceLocation, Entry, Self, SelfImpl>
    implements ResourceEntryBuilder<Self> {
        protected Supplier<List<ResourceLocation>> suggestionSupplier = Lists::newArrayList;
        protected boolean suggestionMode = true;

        public Builder(ResourceLocation value, EntryType<?> type) {
            super(value, type);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Self suggest(Supplier<List<ResourceLocation>> suggestionSupplier) {
            Builder copy = (Builder)this.copy();
            copy.suggestionSupplier = suggestionSupplier;
            return (Self)((ResourceEntryBuilder)copy.castSelf());
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Self suggest(List<ResourceLocation> suggestions) {
            Builder copy = (Builder)this.copy();
            copy.suggestionSupplier = () -> suggestions;
            return (Self)((ResourceEntryBuilder)copy.castSelf());
        }

        @Override
        protected Entry build(@NotNull ConfigEntryHolder parent, String name) {
            AbstractResourceEntry entry = (AbstractResourceEntry)super.build(parent, name);
            entry.suggestionProvider = new SimpleComboBoxModel(this.suggestionSupplier);
            return (Entry)entry;
        }

        @Override
        public SelfImpl copy(ResourceLocation value) {
            Builder copy = (Builder)super.copy(value);
            copy.suggestionSupplier = this.suggestionSupplier;
            copy.suggestionMode = this.suggestionMode;
            return (SelfImpl)copy;
        }
    }
}

