/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.RangedEntryBuilder;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractConfigEntryBuilder;
import endorh.simpleconfig.core.EntryType;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRangedEntry<V extends Comparable<V>, Config, Gui>
extends AbstractConfigEntry<V, Config, Gui> {
    protected V min;
    protected V max;
    @Nullable
    protected V sliderMin;
    @Nullable
    protected V sliderMax;
    protected boolean asSlider;
    protected Function<V, Component> sliderTextSupplier;
    protected RangedEntryBuilder.InvertibleDouble2DoubleFunction sliderMap;
    protected double commentMin = -2.147483648E9;
    protected double commentMax = 2.147483647E9;

    protected AbstractRangedEntry(ConfigEntryHolder parent, String name, V value) {
        super(parent, name, value);
    }

    @Override
    public List<String> getConfigCommentTooltips() {
        List<String> tooltips = super.getConfigCommentTooltips();
        String typeComment = this.getTypeComment();
        if (typeComment != null) {
            tooltips.add(typeComment);
        }
        tooltips.add("Range: " + this.getRangeComment());
        return tooltips;
    }

    public V getMin() {
        return this.min;
    }

    public V getMax() {
        return this.max;
    }

    @Nullable
    public V getSliderMin() {
        return this.sliderMin;
    }

    @Nullable
    public V getSliderMax() {
        return this.sliderMax;
    }

    public RangedEntryBuilder.InvertibleDouble2DoubleFunction getSliderMap() {
        return this.sliderMap;
    }

    @Nullable
    protected String getTypeComment() {
        return this.typeClass.getSimpleName();
    }

    protected String getRangeComment() {
        if (this.max == null && this.min == null) {
            return "~";
        }
        if (this.max instanceof Number || this.min instanceof Number) {
            boolean noMin;
            assert (this.max == null || this.max instanceof Number);
            assert (this.min == null || this.min instanceof Number);
            Number x = (Number)this.max;
            Number n = (Number)this.min;
            boolean noMax = x == null || x.doubleValue() >= this.commentMax;
            boolean bl = noMin = n == null || n.doubleValue() <= this.commentMin;
            if (noMax && noMin) {
                return "~";
            }
            if (noMax) {
                return ">= " + n;
            }
            if (noMin) {
                return "<= " + x;
            }
            return n + " ~ " + x;
        }
        if (this.max == null) {
            return ">= " + this.min;
        }
        if (this.min == null) {
            return "<= " + this.max;
        }
        return this.min + " ~ " + this.max;
    }

    @Override
    public Optional<Component> getErrorFromGUI(Gui value) {
        Optional<Component> error = super.getErrorFromGUI(value);
        if (error.isPresent()) {
            return error;
        }
        Comparable v = (Comparable)this.fromGui(value);
        if (v == null) {
            return Optional.of(Component.m_237115_((String)"simpleconfig.config.error.missing_value"));
        }
        if (this.min != null && this.min.compareTo((Comparable)v) > 0) {
            return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.too_small", (Object[])new Object[]{AbstractRangedEntry.coloredBound(this.min)}));
        }
        if (this.max != null && this.max.compareTo((Comparable)v) < 0) {
            return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.too_large", (Object[])new Object[]{AbstractRangedEntry.coloredBound(this.max)}));
        }
        return Optional.empty();
    }

    protected static MutableComponent coloredBound(Object bound) {
        return Component.m_237113_((String)String.valueOf(bound)).m_130940_(ChatFormatting.DARK_AQUA);
    }

    @Override
    protected Predicate<Object> createConfigValidator() {
        return o -> {
            if (o == null) {
                return false;
            }
            try {
                if (this.min instanceof Number || this.max instanceof Number) {
                    Number n = (Number)o;
                    if (this.min != null && ((Number)this.min).doubleValue() > n.doubleValue() || this.max != null && ((Number)this.max).doubleValue() < n.doubleValue()) {
                        return false;
                    }
                } else {
                    Comparable v = (Comparable)o;
                    if (this.min.compareTo((Comparable)v) > 0 || this.max.compareTo((Comparable)v) < 0) {
                        return false;
                    }
                }
            }
            catch (ClassCastException ignored) {
                return false;
            }
            return super.createConfigValidator().test(o);
        };
    }

    @Override
    public boolean addCommandSuggestions(SuggestionsBuilder builder) {
        super.addCommandSuggestions(builder);
        String minSerialized = this.forCommand(this.getMin());
        String maxSerialized = this.forCommand(this.getMax());
        if (minSerialized != null) {
            builder.suggest(minSerialized, (Message)Component.m_237115_((String)"simpleconfig.command.suggest.min"));
        }
        if (maxSerialized != null) {
            builder.suggest(maxSerialized, (Message)Component.m_237115_((String)"simpleconfig.command.suggest.max"));
        }
        return true;
    }

    public static abstract class Builder<V extends Comparable<V>, Config, Gui, Entry extends AbstractRangedEntry<V, Config, Gui>, Self extends RangedEntryBuilder<V, Config, Gui, Self>, SelfImpl extends Builder<V, Config, Gui, Entry, Self, SelfImpl>>
    extends AbstractConfigEntryBuilder<V, Config, Gui, Entry, Self, SelfImpl>
    implements RangedEntryBuilder<V, Config, Gui, Self> {
        protected String sliderFormat;
        protected V min;
        protected V max;
        @Nullable
        protected V sliderMin;
        @Nullable
        protected V sliderMax;
        protected boolean asSlider;
        protected Function<V, Component> sliderTextSupplier;
        @Nullable
        protected RangedEntryBuilder.InvertibleDouble2DoubleFunction sliderMap;

        public Builder(V value, EntryType<?> type) {
            this(value, type, "%d");
        }

        public Builder(V value, EntryType<?> type, String sliderFormat) {
            super(value, type);
            this.sliderFormat = sliderFormat;
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Self min(V min) {
            Builder copy = (Builder)this.copy();
            copy.min = min;
            return (Self)((RangedEntryBuilder)copy.castSelf());
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Self max(V max) {
            Builder copy = (Builder)this.copy();
            copy.max = max;
            return (Self)((RangedEntryBuilder)copy.castSelf());
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Self range(V min, V max) {
            Builder copy = (Builder)this.copy();
            copy.min = min;
            copy.max = max;
            return (Self)((RangedEntryBuilder)copy.castSelf());
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Self slider() {
            return this.slider(true);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Self slider(boolean asSlider) {
            if (asSlider) {
                return this.slider("simpleconfig.format.slider");
            }
            Builder copy = (Builder)this.copy();
            copy.asSlider = false;
            return (Self)((RangedEntryBuilder)copy.castSelf());
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Self slider(String sliderTextTranslation) {
            return this.slider((V v) -> Component.m_237110_((String)sliderTextTranslation, (Object[])new Object[]{String.format(this.sliderFormat, v)}));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Self slider(Function<V, Component> sliderTextSupplier) {
            Builder copy = (Builder)this.copy();
            copy.asSlider = true;
            copy.sliderTextSupplier = sliderTextSupplier;
            return (Self)((RangedEntryBuilder)copy.castSelf());
        }

        @Override
        @NotNull
        public Self sliderRange(V min, V max) {
            Builder copy = (Builder)this.copy();
            copy.asSlider = true;
            copy.sliderMin = min;
            copy.sliderMax = max;
            return (Self)((RangedEntryBuilder)copy.castSelf());
        }

        @Override
        @NotNull
        public Self sliderMap(@Nullable RangedEntryBuilder.InvertibleDouble2DoubleFunction map) {
            Builder copy = (Builder)this.copy();
            copy.asSlider = true;
            copy.sliderMap = map;
            return (Self)((RangedEntryBuilder)copy.castSelf());
        }

        protected void checkBounds() {
            if (((Comparable)this.value).compareTo(this.min) < 0 || ((Comparable)this.value).compareTo(this.max) > 0) {
                throw new IllegalArgumentException("Ranged entry's default value is not within bounds");
            }
        }

        @Override
        protected final Entry build(@NotNull ConfigEntryHolder parent, String name) {
            this.checkBounds();
            AbstractRangedEntry e = (AbstractRangedEntry)super.build(parent, name);
            e.min = this.min;
            e.max = this.max;
            e.sliderMin = this.sliderMin;
            e.sliderMax = this.sliderMax;
            e.asSlider = this.asSlider;
            e.sliderTextSupplier = this.sliderTextSupplier;
            e.sliderMap = this.sliderMap != null ? this.sliderMap : RangedEntryBuilder.InvertibleDouble2DoubleFunction.identity();
            return (Entry)e;
        }

        @Override
        public SelfImpl copy(V value) {
            Builder copy = (Builder)super.copy(value);
            copy.sliderFormat = this.sliderFormat;
            copy.min = this.min;
            copy.max = this.max;
            copy.sliderMin = this.sliderMin;
            copy.sliderMax = this.sliderMax;
            copy.asSlider = this.asSlider;
            copy.sliderTextSupplier = this.sliderTextSupplier;
            copy.sliderMap = this.sliderMap;
            return (SelfImpl)copy;
        }
    }
}

