/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.RangeEntryBuilder;
import endorh.simpleconfig.api.entry.SizedRangeEntryBuilder;
import endorh.simpleconfig.api.range.Range;
import endorh.simpleconfig.api.range.SizedRange;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractConfigEntryBuilder;
import endorh.simpleconfig.core.AtomicEntry;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.ui.api.AbstractConfigListEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import endorh.simpleconfig.ui.impl.builders.RangeListEntryBuilder;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRangeEntry<V extends Comparable<V>, R extends Range<V, R>>
extends AbstractConfigEntry<R, String, R>
implements AtomicEntry<R> {
    @Nullable
    protected V min = null;
    @Nullable
    protected V max = null;
    protected boolean canEditMinExclusiveness = false;
    protected boolean canEditMaxExclusiveness = false;
    protected double commentMin = -1.7976931348623157E308;
    protected double commentMax = Double.MAX_VALUE;
    protected static final Pattern RANGE_PATTERN = Pattern.compile("^\\s*+(?<lp>[(\\[])\\s*+(?<l>.*?)\\s*+,\\s*+(?<r>.*?)\\s*+(?<rp>[])])\\s*+$");

    protected AbstractRangeEntry(ConfigEntryHolder parent, String name, R value) {
        super(parent, name, value);
    }

    @Override
    public Optional<Component> getErrorFromGUI(R value) {
        if (value.getMin().compareTo(value.getMax()) > 0) {
            return Optional.of(Component.m_237115_((String)"simpleconfig.config.error.min_greater_than_max"));
        }
        return super.getErrorFromGUI(value);
    }

    protected String serializeElement(V element) {
        return String.valueOf(element);
    }

    @Nullable
    protected abstract V deserializeElement(String var1);

    @Override
    public String forConfig(R value) {
        return (value.isExclusiveMin() ? "(" : "[") + this.serializeElement(value.getMin()) + ", " + this.serializeElement(value.getMax()) + (value.isExclusiveMax() ? ")" : "]");
    }

    protected String getRangeComment() {
        if (this.max == null && this.min == null) {
            return "~";
        }
        if (this.max instanceof Number || this.min instanceof Number) {
            boolean noMin;
            assert (this.max == null || this.max instanceof Number);
            assert (this.min == null || this.min instanceof Number);
            Number x = (Number)this.max;
            Number n = (Number)this.min;
            boolean noMax = x == null || x.doubleValue() >= this.commentMax;
            boolean bl = noMin = n == null || n.doubleValue() <= this.commentMin;
            if (noMax && noMin) {
                return "~";
            }
            if (noMax) {
                return ">= " + n;
            }
            if (noMin) {
                return "<= " + x;
            }
            return n + " ~ " + x;
        }
        if (this.max == null) {
            return ">= " + this.min;
        }
        if (this.min == null) {
            return "<= " + this.max;
        }
        return this.min + " ~ " + this.max;
    }

    protected String getTypeComment() {
        return "Range: " + (this.canEditMinExclusiveness ? "[(" : (((Range)this.defValue).isExclusiveMin() ? "(" : "[")) + "min, max" + (this.canEditMaxExclusiveness ? ")]" : (((Range)this.defValue).isExclusiveMax() ? ")" : "]"));
    }

    @Override
    public List<String> getConfigCommentTooltips() {
        List<String> tooltips = super.getConfigCommentTooltips();
        tooltips.add(this.getTypeComment());
        tooltips.add("Bounds: " + this.getRangeComment());
        return tooltips;
    }

    @Override
    @Nullable
    public R fromConfig(@Nullable String value) {
        if (value == null) {
            return null;
        }
        Matcher m = RANGE_PATTERN.matcher(value);
        if (!m.matches()) {
            return null;
        }
        boolean minEx = m.group("lp").contains("(");
        boolean maxEx = m.group("rp").contains(")");
        V min = this.deserializeElement(m.group("l"));
        V max = this.deserializeElement(m.group("r"));
        return (R)((Range)this.defValue).create(min != null ? min : this.min, max != null ? max : this.max, minEx, maxEx);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<R, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        Range guiValue = (Range)this.forGui((Range)this.get());
        RangeListEntryBuilder entryBuilder = builder.startRange(this.getDisplayName(), guiValue, this.buildLimitGUIEntry(builder, "min", guiValue.getMin()), this.buildLimitGUIEntry(builder, "max", guiValue.getMax())).withMinExclusivenessEditable(this.canEditMinExclusiveness).withMaxExclusivenessEditable(this.canEditMaxExclusiveness);
        return Optional.of(this.decorate(entryBuilder));
    }

    @Override
    public boolean addCommandSuggestions(SuggestionsBuilder builder) {
        super.addCommandSuggestions(builder);
        Range value = (Range)this.get();
        Object maxSize = value.create(this.min, this.max, value.isExclusiveMin(), value.isExclusiveMax());
        if (this.isValidValue(maxSize)) {
            builder.suggest(this.forCommand(maxSize), (Message)Component.m_237115_((String)"simpleconfig.command.suggest.largest"));
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected abstract <EE extends AbstractConfigListEntry<V>> EE buildLimitGUIEntry(ConfigFieldBuilder var1, String var2, V var3);

    public static abstract class AbstractSizedRangeEntry<V extends Comparable<V>, R extends SizedRange<V, R>, E extends AbstractSizedRangeEntry<V, R, E>>
    extends AbstractRangeEntry<V, R> {
        protected double minSize = 0.0;
        protected double maxSize = Double.POSITIVE_INFINITY;

        protected AbstractSizedRangeEntry(ConfigEntryHolder parent, String name, R value) {
            super(parent, name, value);
        }

        @Override
        public Optional<Component> getErrorFromGUI(R value) {
            Optional<Component> opt = super.getErrorFromGUI(value);
            if (opt.isPresent()) {
                return opt;
            }
            double size = value.getSize();
            if (size < this.minSize) {
                return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.range_too_small", (Object[])new Object[]{this.minSize, size}));
            }
            if (size > this.maxSize) {
                return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.range_too_large", (Object[])new Object[]{this.maxSize, size}));
            }
            return Optional.empty();
        }

        public static abstract class Builder<V extends Comparable<V>, R extends SizedRange<V, R>, E extends AbstractSizedRangeEntry<V, R, E>, Self extends SizedRangeEntryBuilder<V, R, Self>, SelfImpl extends Builder<V, R, E, Self, SelfImpl>>
        extends endorh.simpleconfig.core.entry.AbstractRangeEntry$Builder<V, R, E, Self, SelfImpl>
        implements SizedRangeEntryBuilder<V, R, Self> {
            protected double minSize = 0.0;
            protected double maxSize = Double.POSITIVE_INFINITY;

            public Builder(R value, Class<R> typeClass) {
                super(value, (EntryType<?>)EntryType.unchecked(typeClass));
            }

            @Override
            @Contract(pure=true)
            @NotNull
            public Self allowEmpty(boolean empty) {
                return this.minSize(empty ? Double.NEGATIVE_INFINITY : 0.0);
            }

            @Override
            @Contract(pure=true)
            @NotNull
            public Self minSize(double size) {
                Builder copy = (Builder)this.copy();
                copy.minSize = size;
                return (Self)((SizedRangeEntryBuilder)copy.castSelf());
            }

            @Override
            @Contract(pure=true)
            @NotNull
            public Self maxSize(double size) {
                Builder copy = (Builder)this.copy();
                copy.maxSize = size;
                return (Self)((SizedRangeEntryBuilder)copy.castSelf());
            }

            @Override
            protected E build(@NotNull ConfigEntryHolder parent, String name) {
                AbstractSizedRangeEntry entry = (AbstractSizedRangeEntry)super.build(parent, name);
                entry.minSize = this.minSize;
                entry.maxSize = this.maxSize;
                return (E)entry;
            }

            @Override
            public SelfImpl copy(R value) {
                Builder copy = (Builder)super.copy(value);
                copy.minSize = this.minSize;
                copy.maxSize = this.maxSize;
                return (SelfImpl)copy;
            }
        }
    }

    public static abstract class Builder<V extends Comparable<V>, R extends Range<V, R>, E extends AbstractRangeEntry<V, R>, Self extends RangeEntryBuilder<V, R, Self>, SelfImpl extends Builder<V, R, E, Self, SelfImpl>>
    extends AbstractConfigEntryBuilder<R, String, R, E, Self, SelfImpl>
    implements RangeEntryBuilder<V, R, Self> {
        @Nullable
        protected V min;
        @Nullable
        protected V max;
        protected boolean canEditMinExclusiveness = false;
        protected boolean canEditMaxExclusiveness = false;

        public Builder(R value, EntryType<?> type) {
            super(value, type);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Self min(V min) {
            Builder copy = (Builder)this.copy();
            copy.min = min;
            return (Self)((RangeEntryBuilder)copy.castSelf());
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Self max(V max) {
            Builder copy = (Builder)this.copy();
            copy.max = max;
            return (Self)((RangeEntryBuilder)copy.castSelf());
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Self withBounds(V min, V max) {
            return this.min(min).max(max);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Self canEditMinExclusive() {
            return this.canEditMinExclusive(true);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Self canEditMinExclusive(boolean exclusive) {
            Builder copy = (Builder)this.copy();
            copy.canEditMinExclusiveness = exclusive;
            return (Self)((RangeEntryBuilder)copy.castSelf());
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Self canEditMaxExclusive() {
            return this.canEditMaxExclusive(true);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Self canEditMaxExclusive(boolean exclusive) {
            Builder copy = (Builder)this.copy();
            copy.canEditMaxExclusiveness = exclusive;
            return (Self)((RangeEntryBuilder)copy.castSelf());
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Self canEditExclusiveness(boolean min, boolean max) {
            return this.canEditMinExclusive(min).canEditMaxExclusive(max);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Self canEditExclusiveness() {
            return this.canEditExclusiveness(true);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Self canEditExclusiveness(boolean canEdit) {
            return this.canEditExclusiveness(canEdit, canEdit);
        }

        @Override
        public SelfImpl copy(R value) {
            Builder copy = (Builder)super.copy(value);
            copy.min = this.min;
            copy.max = this.max;
            copy.canEditMinExclusiveness = this.canEditMinExclusiveness;
            copy.canEditMaxExclusiveness = this.canEditMaxExclusiveness;
            return (SelfImpl)copy;
        }

        @Override
        protected E build(@NotNull ConfigEntryHolder parent, String name) {
            AbstractRangeEntry built = (AbstractRangeEntry)super.build(parent, name);
            built.min = this.min;
            built.max = this.max;
            built.canEditMinExclusiveness = this.canEditMinExclusiveness;
            built.canEditMaxExclusiveness = this.canEditMaxExclusiveness;
            return (E)built;
        }
    }
}

