/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.ListEntryBuilder;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractConfigEntryBuilder;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.ui.impl.builders.ListFieldBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractListEntry<V, Config, Gui, Self extends AbstractListEntry<V, Config, Gui, Self>>
extends AbstractConfigEntry<List<V>, List<Config>, List<Gui>> {
    protected Class<?> innerType;
    protected Function<V, Optional<Component>> elemErrorSupplier;
    protected boolean expand;
    protected int minSize = 0;
    protected int maxSize = Integer.MAX_VALUE;

    public AbstractListEntry(ConfigEntryHolder parent, String name, @Nullable List<V> value) {
        super(parent, name, value != null ? value : new ArrayList());
    }

    @Override
    public List<Gui> forGui(List<V> list) {
        return list.stream().map(this::elemForGui).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public List<V> fromGui(@Nullable List<Gui> list) {
        if (list == null) {
            return null;
        }
        ArrayList<V> res = new ArrayList<V>();
        for (Gui g : list) {
            V v = this.elemFromGui(g);
            if (v == null) {
                return null;
            }
            res.add(v);
        }
        return res;
    }

    @Override
    public List<Config> forConfig(List<V> list) {
        return list.stream().map(this::elemForConfig).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public List<V> fromConfig(@Nullable List<Config> list) {
        if (list == null) {
            return null;
        }
        ArrayList<V> res = new ArrayList<V>();
        for (Config c : list) {
            V v = this.elemFromConfig(c);
            if (v == null) {
                return null;
            }
            res.add(v);
        }
        return res;
    }

    protected Gui elemForGui(V value) {
        return (Gui)value;
    }

    @Nullable
    protected V elemFromGui(Gui value) {
        return (V)value;
    }

    protected Config elemForConfig(V value) {
        return (Config)value;
    }

    @Nullable
    protected V elemFromConfig(Config value) {
        return (V)value;
    }

    protected static Component addIndex(Component message, int index) {
        if (index < 0) {
            return message;
        }
        return message.m_6879_().m_130946_(", ").m_7220_((Component)Component.m_237110_((String)"simpleconfig.config.error.at_index", (Object[])new Object[]{Component.m_237113_((String)String.format("%d", index + 1)).m_130940_(ChatFormatting.DARK_AQUA)}));
    }

    @Override
    public List<Component> getErrorsFromGUI(List<Gui> value) {
        return Stream.concat(Stream.of(this.getErrorFromGUI(value)).filter(Optional::isPresent).map(Optional::get), IntStream.range(0, value.size()).boxed().flatMap(i -> this.getElementErrors((int)i, (Gui)value.get((int)i)).stream())).collect(Collectors.toList());
    }

    @Override
    public Optional<Component> getErrorFromGUI(List<Gui> value) {
        int size = value.size();
        if (size < this.minSize) {
            return Optional.of(Component.m_237110_((String)("simpleconfig.config.error.list." + (this.minSize == 1 ? "empty" : "min_size")), (Object[])new Object[]{Component.m_237113_((String)String.valueOf(this.minSize)).m_130940_(ChatFormatting.DARK_AQUA)}));
        }
        if (size > this.maxSize) {
            return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.list.max_size", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(this.maxSize)).m_130940_(ChatFormatting.DARK_AQUA)}));
        }
        return super.getErrorFromGUI(value);
    }

    public Optional<Component> getElementError(int index, Gui value) {
        V elem = this.elemFromGui(value);
        if (elem == null) {
            return Optional.of(AbstractListEntry.addIndex((Component)Component.m_237115_((String)"simpleconfig.config.error.missing_value"), index));
        }
        return this.elemErrorSupplier.apply(elem).map(e -> AbstractListEntry.addIndex(e, index));
    }

    public List<Component> getElementErrors(int index, Gui value) {
        return Stream.of(this.getElementError(index, value)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    @Nullable
    protected String getListTypeComment() {
        return null;
    }

    @Override
    public List<String> getConfigCommentTooltips() {
        List<String> tooltips = super.getConfigCommentTooltips();
        String typeComment = this.getListTypeComment();
        if (typeComment != null) {
            tooltips.add("List: " + typeComment);
        }
        return tooltips;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected <F extends ListFieldBuilder<Gui, ?, F>> F decorate(F builder) {
        builder = super.decorate(builder);
        ((ListFieldBuilder)((ListFieldBuilder)((ListFieldBuilder)builder.setCellErrorSupplier(this::getElementError)).setExpanded(this.expand)).setCaptionControlsEnabled(false)).setInsertInFront(false);
        return builder;
    }

    public static abstract class Builder<V, Config, Gui, Entry extends AbstractListEntry<V, Config, Gui, Entry>, Self extends ListEntryBuilder<V, Config, Gui, Self>, SelfImpl extends Builder<V, Config, Gui, Entry, Self, SelfImpl>>
    extends AbstractConfigEntryBuilder<List<V>, List<Config>, List<Gui>, Entry, Self, SelfImpl>
    implements ListEntryBuilder<V, Config, Gui, Self> {
        protected Function<V, Optional<Component>> elemErrorSupplier = v -> Optional.empty();
        protected boolean expand = false;
        protected Class<?> innerType;
        protected int minSize = 0;
        protected int maxSize = Integer.MAX_VALUE;

        public Builder(List<V> value, EntryType<?> innerType) {
            super(value, EntryType.of(List.class, innerType));
            this.innerType = innerType.type();
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Self expand() {
            return (Self)this.expand(true);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Self expand(boolean expand) {
            Builder copy = (Builder)this.copy();
            copy.expand = expand;
            return (Self)((ListEntryBuilder)copy.castSelf());
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Self minSize(int minSize) {
            Builder copy = (Builder)this.copy();
            copy.minSize = minSize;
            return (Self)((ListEntryBuilder)copy.castSelf());
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Self maxSize(int maxSize) {
            Builder copy = (Builder)this.copy();
            copy.maxSize = maxSize;
            return (Self)((ListEntryBuilder)copy.castSelf());
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Self elemError(Function<V, Optional<Component>> errorSupplier) {
            Builder copy = (Builder)this.copy();
            copy.elemErrorSupplier = errorSupplier;
            return (Self)((ListEntryBuilder)copy.castSelf());
        }

        @Override
        protected Entry build(@NotNull ConfigEntryHolder parent, String name) {
            AbstractListEntry e = (AbstractListEntry)super.build(parent, name);
            e.elemErrorSupplier = this.elemErrorSupplier;
            e.expand = this.expand;
            e.innerType = this.innerType;
            e.minSize = this.minSize;
            e.maxSize = this.maxSize;
            return (Entry)e;
        }

        @Override
        public SelfImpl copy(List<V> value) {
            Builder copy = (Builder)super.copy(value);
            copy.elemErrorSupplier = this.elemErrorSupplier;
            copy.expand = this.expand;
            copy.innerType = this.innerType;
            copy.minSize = this.minSize;
            copy.maxSize = this.maxSize;
            return (SelfImpl)copy;
        }
    }
}

