/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.commands;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.SimpleConfigImpl;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.Yaml;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.error.YAMLException;
import endorh.simpleconfig.yaml.SimpleConfigCommentedYamlFormat;
import java.io.StringReader;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleConfigValueArgumentType
implements ArgumentType<String> {
    private static final DynamicCommandExceptionType INVALID_YAML = new DynamicCommandExceptionType(m -> Component.m_237110_((String)"simpleconfig.command.error.invalid_yaml", (Object[])new Object[]{m}));
    @Nullable
    private final String modId;
    @Nullable
    private final SimpleConfig.EditType type;

    public static SimpleConfigValueArgumentType entryValue(@Nullable String modId, @Nullable SimpleConfig.EditType type) {
        return new SimpleConfigValueArgumentType(modId, type);
    }

    private SimpleConfigValueArgumentType(@Nullable String modId, @Nullable SimpleConfig.EditType type) {
        this.modId = modId;
        this.type = type;
    }

    @Nullable
    public SimpleConfigImpl getConfig(CommandContext<?> ctx) {
        SimpleConfig.Type configType;
        String modId = this.modId;
        SimpleConfig.EditType type = this.type;
        if (modId == null) {
            modId = (String)ctx.getArgument("modId", String.class);
        }
        if (type == null) {
            type = (SimpleConfig.EditType)((Object)ctx.getArgument("type", SimpleConfig.EditType.class));
        }
        if (SimpleConfigImpl.hasConfig(modId, configType = type.getType())) {
            return SimpleConfigImpl.getConfig(modId, configType);
        }
        return null;
    }

    public String parse(com.mojang.brigadier.StringReader reader) throws CommandSyntaxException {
        StringBuilder b = new StringBuilder();
        while (reader.canRead()) {
            b.append(reader.read());
        }
        String value = b.toString();
        Yaml yaml = SimpleConfigCommentedYamlFormat.getDefaultYaml();
        try {
            yaml.compose(new StringReader(value));
        }
        catch (YAMLException e) {
            throw INVALID_YAML.createWithContext((ImmutableStringReader)reader, (Object)e.getLocalizedMessage());
        }
        return value;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        String key = (String)context.getArgument("key", String.class);
        SimpleConfigImpl config = this.getConfig(context);
        if (config == null) {
            return Suggestions.empty();
        }
        try {
            AbstractConfigEntry entry = config.getEntry(key);
            return entry.addCommandSuggestions(builder) ? builder.buildFuture() : Suggestions.empty();
        }
        catch (SimpleConfig.NoSuchConfigEntryError e) {
            return Suggestions.empty();
        }
    }

    public static class Info
    implements ArgumentTypeInfo<SimpleConfigValueArgumentType, Template> {
        public void serializeToNetwork(Template t, FriendlyByteBuf buf) {
            buf.writeBoolean(t.modId != null);
            if (t.modId != null) {
                buf.m_130070_(t.modId);
            }
            buf.writeBoolean(t.type != null);
            if (t.type != null) {
                buf.m_130068_((Enum)t.type);
            }
        }

        @NotNull
        public Template deserializeFromNetwork(FriendlyByteBuf buf) {
            return new Template(buf.readBoolean() ? buf.m_130277_() : null, buf.readBoolean() ? (SimpleConfig.EditType)buf.m_130066_(SimpleConfig.EditType.class) : null);
        }

        public void serializeToJson(@NotNull Template t, @NotNull JsonObject obj) {
            obj.addProperty("modId", t.modId);
            obj.addProperty("type", t.type != null ? t.type.getAlias() : null);
        }

        @NotNull
        public Template unpack(@NotNull SimpleConfigValueArgumentType arg) {
            return new Template(arg.modId, arg.type);
        }

        public class Template
        implements ArgumentTypeInfo.Template<SimpleConfigValueArgumentType> {
            final String modId;
            final SimpleConfig.EditType type;

            public Template(String modId, SimpleConfig.EditType type) {
                this.modId = modId;
                this.type = type;
            }

            @NotNull
            public SimpleConfigValueArgumentType instantiate(@NotNull CommandBuildContext ctx) {
                return new SimpleConfigValueArgumentType(this.modId, this.type);
            }

            @NotNull
            public ArgumentTypeInfo<SimpleConfigValueArgumentType, ?> m_213709_() {
                return Info.this;
            }
        }
    }
}

