/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.commands;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.config.ServerConfig;
import endorh.simpleconfig.core.SimpleConfigImpl;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientSuggestionProvider;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleConfigTypeArgumentType
implements ArgumentType<SimpleConfig.EditType> {
    private static final DynamicCommandExceptionType UNKNOWN_TYPE = new DynamicCommandExceptionType(m -> Component.m_237110_((String)"simpleconfig.command.error.no_such_type", (Object[])new Object[]{m}));
    @Nullable
    private final String modId;
    private final boolean isRemote;

    public static SimpleConfigTypeArgumentType type(String modId, boolean isRemote) {
        return new SimpleConfigTypeArgumentType(modId, isRemote);
    }

    private SimpleConfigTypeArgumentType(@Nullable String modId, boolean isRemote) {
        this.modId = modId;
        this.isRemote = isRemote;
    }

    public SimpleConfig.EditType parse(StringReader reader) throws CommandSyntaxException {
        String alias = reader.readUnquotedString();
        SimpleConfig.EditType type = SimpleConfig.EditType.fromAlias(alias);
        if (type == null || type.isRemote() != this.isRemote) {
            throw UNKNOWN_TYPE.createWithContext((ImmutableStringReader)reader, (Object)alias);
        }
        return type;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        String modId;
        Object src = context.getSource();
        String string = modId = this.modId != null ? this.modId : (String)context.getArgument("modId", String.class);
        if (src instanceof ClientSuggestionProvider && this.denyPermission(modId)) {
            return Suggestions.empty();
        }
        SimpleConfigImpl.getAllConfigs().stream().filter(c -> c.getModId().equals(modId)).map(c -> c.getType().asEditType(this.isRemote)).filter(t -> t.isRemote() == this.isRemote).map(SimpleConfig.EditType::getAlias).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    @OnlyIn(value=Dist.CLIENT)
    private <S> boolean denyPermission(String modId) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        return player == null || !((ServerConfig.ConfigPermission)((Object)ServerConfig.permissions.permissionFor((Player)player, modId).getLeft())).canView();
    }

    public static class Info
    implements ArgumentTypeInfo<SimpleConfigTypeArgumentType, Template> {
        public void serializeToNetwork(Template t, FriendlyByteBuf buf) {
            buf.writeBoolean(t.modId != null);
            if (t.modId != null) {
                buf.m_130070_(t.modId);
            }
            buf.writeBoolean(t.isRemote);
        }

        @NotNull
        public Template deserializeFromNetwork(@NotNull FriendlyByteBuf buf) {
            return new Template(buf.readBoolean() ? buf.m_130136_(Short.MAX_VALUE) : null, buf.readBoolean());
        }

        public void serializeToJson(@NotNull Template t, @NotNull JsonObject obj) {
            obj.addProperty("modId", t.modId);
            obj.addProperty("isRemote", Boolean.valueOf(t.isRemote));
        }

        @NotNull
        public Template unpack(@NotNull SimpleConfigTypeArgumentType arg) {
            return new Template(arg.modId, arg.isRemote);
        }

        public class Template
        implements ArgumentTypeInfo.Template<SimpleConfigTypeArgumentType> {
            private final String modId;
            private final boolean isRemote;

            public Template(String modId, boolean isRemote) {
                this.modId = modId;
                this.isRemote = isRemote;
            }

            @NotNull
            public SimpleConfigTypeArgumentType instantiate(@NotNull CommandBuildContext ctx) {
                return new SimpleConfigTypeArgumentType(this.modId, this.isRemote);
            }

            @NotNull
            public ArgumentTypeInfo<SimpleConfigTypeArgumentType, ?> m_213709_() {
                return Info.this;
            }
        }
    }
}

