/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.commands;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.config.ServerConfig;
import endorh.simpleconfig.core.SimpleConfigImpl;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientSuggestionProvider;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;

public class SimpleConfigModIdArgumentType
implements ArgumentType<String> {
    private static final DynamicCommandExceptionType UNKNOWN_MOD = new DynamicCommandExceptionType(m -> Component.m_237110_((String)"simpleconfig.command.error.no_such_mod", (Object[])new Object[]{m}));
    boolean isRemote;

    public static SimpleConfigModIdArgumentType modId(boolean isRemote) {
        return new SimpleConfigModIdArgumentType(isRemote);
    }

    private SimpleConfigModIdArgumentType(boolean isRemote) {
        this.isRemote = isRemote;
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        String modId = reader.readUnquotedString();
        if (ModList.get().getMods().stream().noneMatch(m -> m.getModId().equals(modId))) {
            throw UNKNOWN_MOD.createWithContext((ImmutableStringReader)reader, (Object)modId);
        }
        return modId;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Object src = context.getSource();
        if (src instanceof ClientSuggestionProvider) {
            return this.listSuggestionsWithPermissions(builder);
        }
        Set<SimpleConfig.Type> types = this.isRemote ? SimpleConfig.Type.remoteTypes() : SimpleConfig.Type.localTypes();
        SimpleConfigImpl.getAllConfigs().stream().filter(c -> types.contains((Object)c.getType())).map(SimpleConfigImpl::getModId).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    @OnlyIn(value=Dist.CLIENT)
    private CompletableFuture<Suggestions> listSuggestionsWithPermissions(SuggestionsBuilder builder) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Set<SimpleConfig.Type> types = this.isRemote ? SimpleConfig.Type.remoteTypes() : SimpleConfig.Type.localTypes();
        SimpleConfigImpl.getAllConfigs().stream().filter(c -> types.contains((Object)c.getType())).map(SimpleConfigImpl::getModId).filter(arg_0 -> SimpleConfigModIdArgumentType.lambda$listSuggestionsWithPermissions$4((Player)player, arg_0)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static /* synthetic */ boolean lambda$listSuggestionsWithPermissions$4(Player player, String id) {
        return player == null || ((ServerConfig.ConfigPermission)((Object)ServerConfig.permissions.permissionFor(player, id).getLeft())).canView();
    }

    public static class Info
    implements ArgumentTypeInfo<SimpleConfigModIdArgumentType, Template> {
        public void serializeToNetwork(Template t, FriendlyByteBuf buf) {
            buf.writeBoolean(t.isRemote);
        }

        @NotNull
        public Template deserializeFromNetwork(FriendlyByteBuf buf) {
            return new Template(buf.readBoolean());
        }

        public void serializeToJson(@NotNull Template t, @NotNull JsonObject obj) {
            obj.addProperty("isRemote", Boolean.valueOf(t.isRemote));
        }

        @NotNull
        public Template unpack(@NotNull SimpleConfigModIdArgumentType arg) {
            return new Template(arg.isRemote);
        }

        public class Template
        implements ArgumentTypeInfo.Template<SimpleConfigModIdArgumentType> {
            private final boolean isRemote;

            public Template(boolean isRemote) {
                this.isRemote = isRemote;
            }

            @NotNull
            public SimpleConfigModIdArgumentType instantiate(@NotNull CommandBuildContext ctx) {
                return new SimpleConfigModIdArgumentType(this.isRemote);
            }

            @NotNull
            public ArgumentTypeInfo<SimpleConfigModIdArgumentType, ?> m_213709_() {
                return Info.this;
            }
        }
    }
}

