/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.commands;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.core.ByteBufUtils;
import endorh.simpleconfig.core.SimpleConfigImpl;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleConfigKeyArgumentType
implements ArgumentType<String> {
    @Nullable
    private final String modId;
    @Nullable
    private final SimpleConfig.EditType type;
    private final boolean includeGroups;

    public static SimpleConfigKeyArgumentType entryPath(@Nullable String modId, @Nullable SimpleConfig.EditType type, boolean includeGroups) {
        return new SimpleConfigKeyArgumentType(modId, type, includeGroups);
    }

    private SimpleConfigKeyArgumentType(@Nullable String modId, @Nullable SimpleConfig.EditType type, boolean includeGroups) {
        this.modId = modId;
        this.type = type;
        this.includeGroups = includeGroups;
    }

    @Nullable
    public SimpleConfigImpl getConfig(CommandContext<?> ctx) {
        SimpleConfig.Type configType;
        String modId = this.modId;
        SimpleConfig.EditType type = this.type;
        if (modId == null) {
            modId = (String)ctx.getArgument("modId", String.class);
        }
        if (type == null) {
            type = (SimpleConfig.EditType)((Object)ctx.getArgument("type", SimpleConfig.EditType.class));
        }
        if (SimpleConfigImpl.hasConfig(modId, configType = type.getType())) {
            return SimpleConfigImpl.getConfig(modId, configType);
        }
        return null;
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        return reader.readString();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        SimpleConfigImpl config = this.getConfig(context);
        if (config == null) {
            return Suggestions.empty();
        }
        Collection<String> paths = config.getPaths(this.includeGroups);
        for (String path : paths) {
            builder.suggest(StringArgumentType.escapeIfRequired((String)path));
        }
        return builder.buildFuture();
    }

    public static class Info
    implements ArgumentTypeInfo<SimpleConfigKeyArgumentType, Template> {
        public void serializeToNetwork(@NotNull Template t, @NotNull FriendlyByteBuf buf) {
            ByteBufUtils.writeNullable(buf, FriendlyByteBuf::m_130070_, t.modId);
            ByteBufUtils.writeNullable(buf, FriendlyByteBuf::m_130068_, t.type);
            buf.writeBoolean(t.includeGroups);
        }

        @NotNull
        public Template deserializeFromNetwork(@NotNull FriendlyByteBuf buf) {
            String modId = ByteBufUtils.readNullable(buf, FriendlyByteBuf::m_130277_);
            SimpleConfig.EditType type = ByteBufUtils.readNullable(buf, b -> (SimpleConfig.EditType)b.m_130066_(SimpleConfig.EditType.class));
            boolean includeGroups = buf.readBoolean();
            return new Template(modId, type, includeGroups);
        }

        public void serializeToJson(Template t, JsonObject obj) {
            obj.addProperty("modId", t.modId);
            obj.addProperty("type", t.type != null ? t.type.getAlias() : null);
            obj.addProperty("includeGroups", Boolean.valueOf(t.includeGroups));
        }

        @NotNull
        public Template unpack(@NotNull SimpleConfigKeyArgumentType arg) {
            return new Template(arg.modId, arg.type, arg.includeGroups);
        }

        public class Template
        implements ArgumentTypeInfo.Template<SimpleConfigKeyArgumentType> {
            private final String modId;
            private final SimpleConfig.EditType type;
            private final boolean includeGroups;

            public Template(String modId, SimpleConfig.EditType type, boolean includeGroups) {
                this.modId = modId;
                this.type = type;
                this.includeGroups = includeGroups;
            }

            @NotNull
            public SimpleConfigKeyArgumentType instantiate(@NotNull CommandBuildContext ctx) {
                return new SimpleConfigKeyArgumentType(this.modId, this.type, this.includeGroups);
            }

            @NotNull
            public ArgumentTypeInfo<SimpleConfigKeyArgumentType, ?> m_213709_() {
                return Info.this;
            }
        }
    }
}

