/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.config.ServerConfig;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractSimpleConfigEntryHolder;
import endorh.simpleconfig.core.SimpleConfigGUIManagerImpl;
import endorh.simpleconfig.core.SimpleConfigImpl;
import endorh.simpleconfig.core.commands.SimpleConfigKeyArgumentType;
import endorh.simpleconfig.core.commands.SimpleConfigValueArgumentType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="simpleconfig")
public class SimpleConfigCommand {
    private static final SimpleConfigCommand INSTANCE = new SimpleConfigCommand();
    private static final DynamicCommandExceptionType UNSUPPORTED_CONFIG = new DynamicCommandExceptionType(m -> Component.m_237110_((String)"simpleconfig.command.error.unsupported_config", (Object[])new Object[]{m}));
    private static final DynamicCommandExceptionType NO_PERMISSION = new DynamicCommandExceptionType(m -> Component.m_237110_((String)"simpleconfig.command.error.no_permission", (Object[])new Object[]{m}));
    private static final Logger LOGGER = LogManager.getLogger();
    @OnlyIn(value=Dist.CLIENT)
    private CommandClientTickExecutor clientTickExecutor;
    private Style keyStyle = Style.f_131099_.m_131148_(TextColor.m_131266_((int)10518720)).m_131155_(Boolean.valueOf(true));
    private Style modNameStyle = Style.f_131099_.m_131157_(ChatFormatting.AQUA).m_131136_(Boolean.valueOf(false));
    private Style typeStyle = Style.f_131099_.m_131157_(ChatFormatting.LIGHT_PURPLE);
    private Style valueStyle = Style.f_131099_.m_131157_(ChatFormatting.DARK_AQUA);
    private Style undoStyle = Style.f_131099_.m_131157_(ChatFormatting.BLUE);
    private Style copyStyle = Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x808080));

    public SimpleConfigCommand() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            this.clientTickExecutor = new CommandClientTickExecutor();
        });
    }

    protected boolean isRemote() {
        return true;
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        ModList.get().forEachModContainer((modId, container) -> Stream.of(SimpleConfig.Type.SERVER, SimpleConfig.Type.COMMON).forEach(type -> {
            SimpleConfigImpl config = SimpleConfigImpl.getConfigOrNull(modId, type);
            if (config != null) {
                SimpleConfig.EditType tt = type.asEditType(true);
                INSTANCE.register((CommandDispatcher<CommandSourceStack>)dispatcher, (String)modId, tt);
                LiteralArgumentBuilder<CommandSourceStack> root = config.getCommandRoot();
                if (root != null) {
                    INSTANCE.registerRoot((String)modId, tt, (CommandDispatcher<CommandSourceStack>)dispatcher, root);
                }
            }
        }));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onRegisterClientCommands(RegisterClientCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        ModList.get().forEachModContainer((modId, container) -> Stream.of(SimpleConfig.Type.CLIENT, SimpleConfig.Type.COMMON).forEach(type -> {
            SimpleConfigImpl config = SimpleConfigImpl.getConfigOrNull(modId, type);
            if (config != null) {
                SimpleConfig.EditType tt = type.asEditType(false);
                INSTANCE.registerClient((CommandDispatcher<CommandSourceStack>)dispatcher, (String)modId, tt);
                LiteralArgumentBuilder<CommandSourceStack> root = config.getCommandRoot();
                if (root != null) {
                    INSTANCE.registerClientRoot((String)modId, tt, (CommandDispatcher<CommandSourceStack>)dispatcher, root);
                }
            }
        }));
    }

    protected void register(CommandDispatcher<CommandSourceStack> dispatcher, String modId, SimpleConfig.EditType type) {
        boolean remote = true;
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"config").then(Commands.m_82127_((String)"get").then(this.buildGetCommand((LiteralArgumentBuilder<CommandSourceStack>)Commands.m_82127_((String)modId), modId, type, remote)))).then(Commands.m_82127_((String)"set").then(this.buildSetCommand((LiteralArgumentBuilder<CommandSourceStack>)Commands.m_82127_((String)modId), modId, type, remote)))).then(Commands.m_82127_((String)"reset").then(this.buildResetCommand((LiteralArgumentBuilder<CommandSourceStack>)Commands.m_82127_((String)modId), modId, type, remote)));
        dispatcher.register(command);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void registerClient(CommandDispatcher<CommandSourceStack> dispatcher, String modId, SimpleConfig.EditType type) {
        boolean remote = false;
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"config").then(Commands.m_82127_((String)"edit").then(Commands.m_82127_((String)modId).executes(c -> this.openConfigGUI((CommandContext<CommandSourceStack>)c, modId))))).then(Commands.m_82127_((String)"get").then(this.buildGetCommand((LiteralArgumentBuilder<CommandSourceStack>)Commands.m_82127_((String)modId), modId, type, remote)))).then(Commands.m_82127_((String)"set").then(this.buildSetCommand((LiteralArgumentBuilder<CommandSourceStack>)Commands.m_82127_((String)modId), modId, type, remote)))).then(Commands.m_82127_((String)"reset").then(this.buildResetCommand((LiteralArgumentBuilder<CommandSourceStack>)Commands.m_82127_((String)modId), modId, type, remote)));
        dispatcher.register(command);
    }

    protected void registerRoot(String modId, SimpleConfig.EditType type, CommandDispatcher<CommandSourceStack> dispatcher, LiteralArgumentBuilder<CommandSourceStack> root) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)root.then(this.buildGetCommand((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)Commands.m_82127_((String)"get").requires(this.permission(modId, false))), modId, type, true))).then(this.buildSetCommand((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)Commands.m_82127_((String)"set").requires(this.permission(modId, true))), modId, type, true))).then(this.buildResetCommand((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)Commands.m_82127_((String)"reset").requires(this.permission(modId, true))), modId, type, true));
        dispatcher.register(command);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void registerClientRoot(String modId, SimpleConfig.EditType type, CommandDispatcher<CommandSourceStack> dispatcher, LiteralArgumentBuilder<CommandSourceStack> root) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)root.then(Commands.m_82127_((String)"edit").executes(c -> this.openConfigGUI((CommandContext<CommandSourceStack>)c, modId)))).then(this.buildGetCommand((LiteralArgumentBuilder<CommandSourceStack>)Commands.m_82127_((String)"get"), modId, type, false))).then(this.buildSetCommand((LiteralArgumentBuilder<CommandSourceStack>)Commands.m_82127_((String)"set"), modId, type, false))).then(this.buildResetCommand((LiteralArgumentBuilder<CommandSourceStack>)Commands.m_82127_((String)"reset"), modId, type, false));
        dispatcher.register(command);
    }

    private LiteralArgumentBuilder<CommandSourceStack> buildGetCommand(LiteralArgumentBuilder<CommandSourceStack> builder, String modId, SimpleConfig.EditType type, boolean remote) {
        SimpleConfig.Type tt = type.getType();
        LiteralArgumentBuilder b = Commands.m_82127_((String)type.getAlias());
        if (remote) {
            b.requires(this.permission(modId, false));
        }
        b.then(Commands.m_82129_((String)"key", (ArgumentType)SimpleConfigKeyArgumentType.entryPath(modId, type, false)).executes(remote ? c -> this.getEntryValue((CommandContext<CommandSourceStack>)c, modId, tt) : c -> this.getClientEntryValue((CommandContext<CommandSourceStack>)c, modId, tt)));
        builder.then((ArgumentBuilder)b);
        return builder;
    }

    private LiteralArgumentBuilder<CommandSourceStack> buildSetCommand(LiteralArgumentBuilder<CommandSourceStack> builder, String modId, SimpleConfig.EditType type, boolean remote) {
        SimpleConfig.Type tt = type.getType();
        LiteralArgumentBuilder b = Commands.m_82127_((String)type.getAlias());
        if (remote) {
            b.requires(this.permission(modId, true));
        }
        b.then(Commands.m_82129_((String)"key", (ArgumentType)SimpleConfigKeyArgumentType.entryPath(modId, type, false)).then(Commands.m_82129_((String)"value", (ArgumentType)SimpleConfigValueArgumentType.entryValue(modId, type)).executes(remote ? c -> this.setEntryValue((CommandContext<CommandSourceStack>)c, modId, tt) : c -> this.setClientEntryValue((CommandContext<CommandSourceStack>)c, modId, tt))));
        builder.then((ArgumentBuilder)b);
        return builder;
    }

    private LiteralArgumentBuilder<CommandSourceStack> buildResetCommand(LiteralArgumentBuilder<CommandSourceStack> builder, String modId, SimpleConfig.EditType type, boolean remote) {
        SimpleConfig.Type tt = type.getType();
        LiteralArgumentBuilder b = Commands.m_82127_((String)type.getAlias());
        if (remote) {
            b.requires(this.permission(modId, true));
        }
        b.then(Commands.m_82129_((String)"key", (ArgumentType)SimpleConfigKeyArgumentType.entryPath(modId, type, true)).executes(remote ? c -> this.resetPath((CommandContext<CommandSourceStack>)c, modId, tt) : c -> this.resetClientPath((CommandContext<CommandSourceStack>)c, modId, tt)));
        builder.then((ArgumentBuilder)b);
        return builder;
    }

    private String getModId(CommandContext<?> ctx) {
        return (String)ctx.getArgument("modId", String.class);
    }

    private SimpleConfig.Type getType(CommandContext<?> ctx) {
        return ((SimpleConfig.EditType)((Object)ctx.getArgument("type", SimpleConfig.EditType.class))).getType();
    }

    private SimpleConfigImpl requireConfig(CommandContext<CommandSourceStack> ctx, String modId, SimpleConfig.Type type, boolean forWrite) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        if (!SimpleConfigImpl.hasConfig(modId, type)) {
            throw UNSUPPORTED_CONFIG.create((Object)modId);
        }
        if (forWrite ? !SimpleConfigCommand.getConfigPermission(src, modId).canEdit() : !SimpleConfigCommand.getConfigPermission(src, modId).canView()) {
            throw NO_PERMISSION.create((Object)modId);
        }
        return SimpleConfigImpl.getConfig(modId, type);
    }

    private SimpleConfigImpl requireClientConfig(String modId, SimpleConfig.Type type) throws CommandSyntaxException {
        if (!SimpleConfigImpl.hasConfig(modId, type)) {
            throw UNSUPPORTED_CONFIG.create((Object)modId);
        }
        return SimpleConfigImpl.getConfig(modId, type);
    }

    private static ServerConfig.ConfigPermission getConfigPermission(CommandSourceStack src, String modId) {
        ServerPlayer player = src.m_230896_();
        return player != null ? (ServerConfig.ConfigPermission)((Object)ServerConfig.permissions.permissionFor((Player)player, modId).getLeft()) : ServerConfig.permissions.datapack_permission;
    }

    protected int getEntryValue(CommandContext<CommandSourceStack> ctx, @Nullable String modId, @Nullable SimpleConfig.Type type) throws CommandSyntaxException {
        if (modId == null) {
            modId = this.getModId(ctx);
        }
        if (type == null) {
            type = this.getType(ctx);
        }
        SimpleConfigImpl config = this.requireConfig(ctx, modId, type, false);
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        String key = (String)ctx.getArgument("key", String.class);
        try {
            AbstractConfigEntry entry = config.getEntry(key);
            BaseCommand base = this.getBase(ctx, modId, 3);
            String serialized = entry.getForCommand();
            if (serialized == null) {
                src.m_81352_((Component)Component.m_237115_((String)"simpleconfig.command.error.get.unexpected"));
                LOGGER.error("Couldn't serialize entry value for command: {}", (Object)entry.getGlobalPath());
            }
            MutableComponent msg = Component.m_237110_((String)"simpleconfig.command.msg.get", (Object[])new Object[]{this.formatKey(modId, key, type, 50), this.formatValue(base, type, key, serialized, 60)});
            src.m_288197_(() -> msg, false);
            return 0;
        }
        catch (SimpleConfig.NoSuchConfigEntryError e) {
            src.m_81352_((Component)Component.m_237110_((String)"simpleconfig.command.error.no_such_entry", (Object[])new Object[]{this.formatKey(modId, key, type, 60)}));
        }
        catch (RuntimeException e) {
            src.m_81352_((Component)Component.m_237110_((String)"simpleconfig.command.error.get.unexpected", (Object[])new Object[]{this.formatKey(modId, key, type, 40)}));
            LOGGER.error("Unexpected error getting config entry", (Throwable)e);
        }
        return 1;
    }

    protected int getClientEntryValue(CommandContext<CommandSourceStack> ctx, @Nullable String modId, @Nullable SimpleConfig.Type type) throws CommandSyntaxException {
        if (modId == null) {
            modId = this.getModId(ctx);
        }
        if (type == null) {
            type = this.getType(ctx);
        }
        SimpleConfigImpl config = this.requireClientConfig(modId, type);
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        String key = (String)ctx.getArgument("key", String.class);
        try {
            AbstractConfigEntry entry = config.getEntry(key);
            BaseCommand base = this.getBase(ctx, modId, 3);
            String serialized = entry.getForCommand();
            if (serialized == null) {
                src.m_81352_((Component)Component.m_237115_((String)"simpleconfig.command.error.get.unexpected"));
                LOGGER.error("Couldn't serialize entry value for command: {}", (Object)entry.getGlobalPath());
            }
            MutableComponent msg = Component.m_237110_((String)"simpleconfig.command.msg.get", (Object[])new Object[]{this.formatKey(modId, key, type, 50), this.formatValue(base, type, key, serialized, 60)});
            src.m_288197_(() -> msg, false);
            return 0;
        }
        catch (SimpleConfig.NoSuchConfigEntryError e) {
            src.m_81352_((Component)Component.m_237110_((String)"simpleconfig.command.error.no_such_entry", (Object[])new Object[]{this.formatKey(modId, key, type, 60)}));
        }
        catch (RuntimeException e) {
            src.m_81352_((Component)Component.m_237110_((String)"simpleconfig.command.error.get.unexpected", (Object[])new Object[]{this.formatKey(modId, key, type, 40)}));
            LOGGER.error("Unexpected error getting config entry", (Throwable)e);
        }
        return 1;
    }

    protected int setEntryValue(CommandContext<CommandSourceStack> ctx, @Nullable String modId, @Nullable SimpleConfig.Type type) throws CommandSyntaxException {
        AbstractConfigEntry entry;
        if (modId == null) {
            modId = this.getModId(ctx);
        }
        if (type == null) {
            type = this.getType(ctx);
        }
        SimpleConfigImpl config = this.requireConfig(ctx, modId, type, true);
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        String key = (String)ctx.getArgument("key", String.class);
        String value = (String)ctx.getArgument("value", String.class);
        ServerPlayer player = src.m_230896_();
        if (!SimpleConfigCommand.getConfigPermission(src, config.getModId()).canEdit()) {
            src.m_81352_((Component)Component.m_237110_((String)"simpleconfig.command.error.no_permission", (Object[])new Object[]{config.getModName()}));
            return 1;
        }
        try {
            entry = config.getEntry(key);
        }
        catch (SimpleConfig.NoSuchConfigEntryError e) {
            src.m_81352_((Component)Component.m_237110_((String)"simpleconfig.command.error.no_such_entry", (Object[])new Object[]{this.formatKey(modId, key, type, 45)}));
            return 1;
        }
        try {
            String prev = entry.getForCommand();
            BaseCommand base = this.getBase(ctx, modId, 4);
            String undoCommand = base.resolve("set", type.asEditType(this.isRemote()).getAlias(), key, prev);
            Optional<Component> error = entry.getErrorFromCommand(value);
            if (error.isPresent()) {
                src.m_81352_((Component)Component.m_237110_((String)"simpleconfig.command.error.set.invalid_value", (Object[])new Object[]{error.get()}));
                return -1;
            }
            entry.setFromCommand(value);
            value = entry.getForCommand();
            int valueWidth = Math.min(55, value.length());
            int prevWidth = Math.min(35 - valueWidth, prev.length());
            MutableComponent undoLink = this.genUndoLink(undoCommand);
            MutableComponent formatvalue = this.formatValue(base, type, key, value, valueWidth);
            MutableComponent formatPrev = this.formatValue(base, type, key, prev, prevWidth);
            MutableComponent msg = Component.m_237110_((String)"simpleconfig.command.msg.set", (Object[])new Object[]{this.formatKey(modId, key, type, 45), undoLink, formatPrev, formatvalue});
            src.m_288197_(() -> msg, false);
            SimpleConfigCommand.broadcastToOtherOperators((Player)player, (Component)Component.m_237110_((String)"simpleconfig.command.msg.set.remote", (Object[])new Object[]{SimpleConfigCommand.playerName((Player)player), this.formatKey(modId, key, type, 40), undoLink, formatPrev, formatvalue}));
            config.update();
            return 0;
        }
        catch (SimpleConfig.InvalidConfigValueTypeException e) {
            src.m_81352_((Component)Component.m_237110_((String)"simpleconfig.command.error.set.invalid_type", (Object[])new Object[]{entry.getConfigCommentTooltip()}));
        }
        catch (SimpleConfig.InvalidConfigValueException e) {
            src.m_81352_((Component)Component.m_237110_((String)"simpleconfig.command.error.set.invalid_value", (Object[])new Object[]{entry.getConfigCommentTooltip()}));
        }
        catch (RuntimeException e) {
            src.m_81352_((Component)Component.m_237110_((String)"simpleconfig.command.error.set.unexpected", (Object[])new Object[]{this.formatKey(modId, key, type, 20)}));
            LOGGER.error("Unexpected error setting config entry", (Throwable)e);
        }
        return 1;
    }

    protected int setClientEntryValue(CommandContext<CommandSourceStack> ctx, @Nullable String modId, @Nullable SimpleConfig.Type type) throws CommandSyntaxException {
        AbstractConfigEntry entry;
        if (modId == null) {
            modId = this.getModId(ctx);
        }
        if (type == null) {
            type = this.getType(ctx);
        }
        SimpleConfigImpl config = this.requireClientConfig(modId, type);
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        String key = (String)ctx.getArgument("key", String.class);
        String value = (String)ctx.getArgument("value", String.class);
        try {
            entry = config.getEntry(key);
        }
        catch (SimpleConfig.NoSuchConfigEntryError e) {
            src.m_81352_((Component)Component.m_237110_((String)"simpleconfig.command.error.no_such_entry", (Object[])new Object[]{this.formatKey(modId, key, type, 45)}));
            return 1;
        }
        try {
            String prev = entry.getForCommand();
            BaseCommand base = this.getBase(ctx, modId, 4);
            String undoCommand = base.resolve("set", type.asEditType(this.isRemote()).getAlias(), key, prev);
            Optional<Component> error = entry.getErrorFromCommand(value);
            if (error.isPresent()) {
                src.m_81352_((Component)Component.m_237110_((String)"simpleconfig.command.error.set.invalid_value", (Object[])new Object[]{error.get()}));
                return -1;
            }
            entry.setFromCommand(value);
            value = entry.getForCommand();
            int valueWidth = Math.min(40, value.length());
            int prevWidth = Math.min(60 - valueWidth, prev.length());
            MutableComponent undoLink = this.genUndoLink(undoCommand);
            MutableComponent formatvalue = this.formatValue(base, type, key, value, valueWidth);
            MutableComponent formatPrev = this.formatValue(base, type, key, prev, prevWidth);
            MutableComponent msg = Component.m_237110_((String)"simpleconfig.command.msg.set", (Object[])new Object[]{this.formatKey(modId, key, type, 45), undoLink, formatPrev, formatvalue});
            src.m_288197_(() -> msg, false);
            config.update();
            return 0;
        }
        catch (SimpleConfig.InvalidConfigValueTypeException e) {
            src.m_81352_((Component)Component.m_237110_((String)"simpleconfig.command.error.set.invalid_type", (Object[])new Object[]{entry.getConfigCommentTooltip()}));
        }
        catch (SimpleConfig.InvalidConfigValueException e) {
            src.m_81352_((Component)Component.m_237110_((String)"simpleconfig.command.error.set.invalid_value", (Object[])new Object[]{entry.getConfigCommentTooltip()}));
        }
        catch (RuntimeException e) {
            src.m_81352_((Component)Component.m_237110_((String)"simpleconfig.command.error.set.unexpected", (Object[])new Object[]{this.formatKey(modId, key, type, 20)}));
            LOGGER.error("Unexpected error setting config entry", (Throwable)e);
        }
        return 1;
    }

    protected int resetPath(CommandContext<CommandSourceStack> ctx, @Nullable String modId, @Nullable SimpleConfig.Type type) throws CommandSyntaxException {
        if (modId == null) {
            modId = this.getModId(ctx);
        }
        if (type == null) {
            type = this.getType(ctx);
        }
        SimpleConfigImpl config = this.requireConfig(ctx, modId, type, true);
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        String key = (String)ctx.getArgument("key", String.class);
        ServerPlayer player = src.m_230896_();
        if (!SimpleConfigCommand.getConfigPermission(src, modId).canEdit()) {
            src.m_81352_((Component)Component.m_237110_((String)"simpleconfig.command.error.no_permission", (Object[])new Object[]{config.getModName()}));
            return 1;
        }
        try {
            if (config.hasEntry(key)) {
                AbstractConfigEntry entry = config.getEntry(key);
                String prev = entry.getForCommand();
                BaseCommand base = this.getBase(ctx, modId, 3);
                String undoCommand = base.resolve("set", type.asEditType(this.isRemote()).getAlias(), key, prev);
                config.reset(key);
                String value = entry.getForCommand();
                int valueWidth = Math.min(40, value.length());
                int prevWidth = Math.min(60 - valueWidth, prev.length());
                MutableComponent undoLink = this.genUndoLink(undoCommand);
                MutableComponent formatPrev = this.formatValue(base, type, key, prev, prevWidth);
                MutableComponent formatValue = this.formatValue(base, type, key, value, valueWidth);
                MutableComponent msg = Component.m_237110_((String)"simpleconfig.command.msg.reset", (Object[])new Object[]{this.formatKey(modId, key, type, 45), undoLink, formatPrev, formatValue});
                src.m_288197_(() -> msg, false);
                SimpleConfigCommand.broadcastToOtherOperators((Player)player, (Component)Component.m_237110_((String)"simpleconfig.command.msg.reset.remote", (Object[])new Object[]{SimpleConfigCommand.playerName((Player)player), this.formatKey(modId, key, type, 40), undoLink, formatPrev, formatValue}));
                config.update();
            } else if (config.hasChild(key)) {
                AbstractSimpleConfigEntryHolder group2 = config.getChild(key);
                group2.reset();
                MutableComponent count = Component.m_237113_((String)String.valueOf(group2.getPaths(false).size())).m_130940_(ChatFormatting.DARK_AQUA);
                MutableComponent msg = Component.m_237110_((String)"simpleconfig.command.msg.reset_group", (Object[])new Object[]{this.formatKey(modId, key, type, 45), count});
                src.m_288197_(() -> msg, false);
                SimpleConfigCommand.broadcastToOtherOperators((Player)player, (Component)Component.m_237110_((String)"simpleconfig.command.msg.reset_group.remote", (Object[])new Object[]{SimpleConfigCommand.playerName((Player)player), this.formatKey(modId, key, type, 45), count}));
                config.update();
            } else {
                throw new SimpleConfig.NoSuchConfigEntryError(key);
            }
            return 0;
        }
        catch (SimpleConfig.NoSuchConfigEntryError e) {
            src.m_81352_((Component)Component.m_237110_((String)"simpleconfig.command.error.no_such_entry", (Object[])new Object[]{this.formatKey(modId, key, type, 50)}));
        }
        catch (RuntimeException e) {
            src.m_81352_((Component)Component.m_237110_((String)"simpleconfig.command.error.reset.unexpected", (Object[])new Object[]{this.formatKey(modId, key, type, 20)}));
            LOGGER.error("Unexpected error resetting config entry", (Throwable)e);
        }
        return 1;
    }

    protected int resetClientPath(CommandContext<CommandSourceStack> ctx, @Nullable String modId, @Nullable SimpleConfig.Type type) throws CommandSyntaxException {
        if (modId == null) {
            modId = this.getModId(ctx);
        }
        if (type == null) {
            type = this.getType(ctx);
        }
        SimpleConfigImpl config = this.requireClientConfig(modId, type);
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        String key = (String)ctx.getArgument("key", String.class);
        try {
            if (config.hasEntry(key)) {
                AbstractConfigEntry entry = config.getEntry(key);
                String prev = entry.getForCommand();
                BaseCommand base = this.getBase(ctx, modId, 3);
                String undoCommand = base.resolve("set", type.asEditType(this.isRemote()).getAlias(), key, prev);
                config.reset(key);
                String value = entry.getForCommand();
                int valueWidth = Math.min(40, value.length());
                int prevWidth = Math.min(60 - valueWidth, prev.length());
                MutableComponent undoLink = this.genUndoLink(undoCommand);
                MutableComponent formatPrev = this.formatValue(base, type, key, prev, prevWidth);
                MutableComponent formatValue = this.formatValue(base, type, key, value, valueWidth);
                MutableComponent msg = Component.m_237110_((String)"simpleconfig.command.msg.reset", (Object[])new Object[]{this.formatKey(modId, key, type, 45), undoLink, formatPrev, formatValue});
                src.m_288197_(() -> msg, false);
                config.update();
            } else if (config.hasChild(key)) {
                AbstractSimpleConfigEntryHolder group2 = config.getChild(key);
                group2.reset();
                MutableComponent count = Component.m_237113_((String)String.valueOf(group2.getPaths(false).size())).m_130940_(ChatFormatting.DARK_AQUA);
                MutableComponent msg = Component.m_237110_((String)"simpleconfig.command.msg.reset_group", (Object[])new Object[]{this.formatKey(modId, key, type, 45), count});
                src.m_288197_(() -> msg, false);
                config.update();
            } else {
                throw new SimpleConfig.NoSuchConfigEntryError(key);
            }
            return 0;
        }
        catch (SimpleConfig.NoSuchConfigEntryError e) {
            src.m_81352_((Component)Component.m_237110_((String)"simpleconfig.command.error.no_such_entry", (Object[])new Object[]{this.formatKey(modId, key, type, 50)}));
        }
        catch (RuntimeException e) {
            src.m_81352_((Component)Component.m_237110_((String)"simpleconfig.command.error.reset.unexpected", (Object[])new Object[]{this.formatKey(modId, key, type, 20)}));
            LOGGER.error("Unexpected error resetting config entry", (Throwable)e);
        }
        return 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected int openConfigGUI(CommandContext<CommandSourceStack> ctx, @Nullable String modId) throws CommandSyntaxException {
        if (modId == null) {
            modId = this.getModId(ctx);
        }
        if (!SimpleConfigGUIManagerImpl.INSTANCE.hasConfigGUI(modId)) {
            throw UNSUPPORTED_CONFIG.create((Object)modId);
        }
        String id = modId;
        this.clientTickExecutor.run(() -> SimpleConfigGUIManagerImpl.INSTANCE.showConfigGUI(id));
        return 0;
    }

    public static void broadcastToOtherOperators(@Nullable Player player, Component message) {
        if (player == null && !ServerConfig.permissions.broadcast_datapack_config_changes) {
            return;
        }
        ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_().stream().filter(p -> p.m_20310_(2) && p != player).forEach(p -> p.m_213846_(message));
    }

    public static MutableComponent playerName(@Nullable Player player) {
        if (player == null) {
            return Component.m_237113_((String)"<datapack>");
        }
        return Component.m_237113_((String)player.m_7755_().getString()).m_130940_(ChatFormatting.DARK_GREEN).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/msg " + player.m_6302_() + " ")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)player.m_7755_().m_6881_().m_130946_("\n").m_7220_((Component)Component.m_237113_((String)player.m_20149_()).m_130940_(ChatFormatting.GRAY)))).m_131138_(player.m_6302_()));
    }

    protected MutableComponent wrap(String text, int width, Style style, @Nullable MutableComponent tooltipTitle, @Nullable MutableComponent tooltipSubtitle, @Nullable ClickEvent clickEvent) {
        MutableComponent wrapped;
        if (clickEvent == null) {
            clickEvent = new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, text);
            if (tooltipSubtitle == null) {
                tooltipSubtitle = Component.m_237113_((String)"(").m_7220_((Component)Component.m_237115_((String)"chat.copy")).m_130946_(")").m_130940_(ChatFormatting.GRAY);
            }
        }
        ClickEvent ce = clickEvent;
        int length = text.length();
        if (length > width) {
            int cut = width < 23 ? width - 10 : 10;
            int rightCut = cut <= 0 ? 3 : length - width + cut + 3;
            MutableComponent ellipsis = Component.m_237113_((String)"...").m_130948_(style).m_130940_(ChatFormatting.GRAY);
            wrapped = width <= 3 ? ellipsis : (cut <= 0 ? ellipsis : Component.m_237113_((String)text.substring(0, cut)).m_130948_(style).m_7220_((Component)ellipsis)).m_7220_((Component)Component.m_237113_((String)text.substring(rightCut)).m_130948_(style));
        } else {
            wrapped = Component.m_237113_((String)text).m_130948_(style);
        }
        MutableComponent tooltip = Component.m_237113_((String)"");
        if (tooltipTitle != null) {
            tooltip.m_7220_((Component)tooltipTitle).m_130946_("\n");
        }
        tooltip.m_7220_((Component)Component.m_237113_((String)text).m_130948_(style));
        if (tooltipSubtitle != null) {
            tooltip.m_130946_("\n").m_7220_((Component)tooltipSubtitle);
        }
        wrapped.m_130938_(s -> s.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)tooltip)).m_131142_(ce));
        return wrapped;
    }

    protected MutableComponent formatKey(String modId, String key, SimpleConfig.Type type, int width) {
        return this.wrap(key, width, this.keyStyle, Component.m_237113_((String)SimpleConfigCommand.getModNameOrId(modId)).m_130948_(this.modNameStyle).m_130946_(" ").m_7220_((Component)Component.m_237113_((String)type.getAlias()).m_130948_(this.typeStyle)), null, null).m_130938_(s -> s.m_131138_(key));
    }

    private static String getModNameOrId(String modId) {
        Optional<IModInfo> first = ModList.get().getMods().stream().filter(m -> modId.equals(m.getModId())).findFirst();
        if (first.isPresent()) {
            return first.get().getDisplayName();
        }
        return modId;
    }

    protected MutableComponent createCopyButton(String text) {
        return Component.m_237113_((String)"\u29c9").m_130938_(s -> s.m_131157_(ChatFormatting.DARK_GRAY).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"chat.copy").m_130948_(this.copyStyle))).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, text)));
    }

    protected MutableComponent formatValue(BaseCommand baseCommand, SimpleConfig.Type type, String key, String value, int width) {
        return this.wrap(value, width, this.valueStyle, Component.m_237113_((String)key).m_130948_(this.keyStyle), Component.m_237113_((String)"(").m_7220_((Component)Component.m_237115_((String)"simpleconfig.command.help.set")).m_130946_(")").m_130940_(ChatFormatting.GRAY), new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, baseCommand.resolve("set", type.asEditType(this.isRemote()).getAlias(), key, value))).m_130946_(" ").m_7220_((Component)this.createCopyButton(value)).m_130938_(s -> s.m_131138_(value));
    }

    protected MutableComponent genUndoLink(String undoCommand) {
        return Component.m_237113_((String)"(").m_7220_((Component)Component.m_237115_((String)"simpleconfig.command.action.undo").m_130938_(s -> s.m_131146_(this.undoStyle).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"simpleconfig.command.help.undo").m_130940_(ChatFormatting.GRAY))).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, undoCommand)))).m_130946_(")").m_130940_(ChatFormatting.GRAY);
    }

    protected BaseCommand getBase(CommandContext<?> ctx, String modId, int args) {
        int i;
        String command = ctx.getInput();
        List nodes = ctx.getNodes();
        if (args >= nodes.size()) {
            throw new IllegalArgumentException("Not enough arguments in command, expected " + (args + 1) + " but found " + nodes.size() + "\n  Command: " + command);
        }
        StringBuilder b = new StringBuilder(command);
        for (i = 1; i < args; ++i) {
            b.delete(((ParsedCommandNode)nodes.get(nodes.size() - i - 1)).getRange().getEnd(), ((ParsedCommandNode)nodes.get(nodes.size() - i)).getRange().getEnd());
        }
        StringRange modIdRange = ((ParsedCommandNode)nodes.get(nodes.size() - i)).getRange();
        int end = modIdRange.getEnd();
        String id = b.substring(modIdRange.getStart(), end);
        b.delete(((ParsedCommandNode)nodes.get(nodes.size() - i - 1)).getRange().getEnd(), end);
        boolean hasModId = modId.equals(id);
        if (hasModId) {
            b.delete(((ParsedCommandNode)nodes.get(nodes.size() - ++i - 1)).getRange().getEnd(), ((ParsedCommandNode)nodes.get(nodes.size() - i)).getRange().getEnd());
        }
        b.insert(0, '/');
        return new BaseCommand(b.toString(), hasModId ? modId : null);
    }

    private Predicate<CommandSourceStack> permission(String modId, boolean forWrite) {
        return forWrite ? s -> SimpleConfigCommand.getConfigPermission(s, modId).canEdit() : s -> SimpleConfigCommand.getConfigPermission(s, modId).canView();
    }

    public Style getKeyStyle() {
        return this.keyStyle;
    }

    public void setKeyStyle(Style keyStyle) {
        this.keyStyle = keyStyle;
    }

    public Style getModNameStyle() {
        return this.modNameStyle;
    }

    public void setModNameStyle(Style modNameStyle) {
        this.modNameStyle = modNameStyle;
    }

    public Style getTypeStyle() {
        return this.typeStyle;
    }

    public void setTypeStyle(Style typeStyle) {
        this.typeStyle = typeStyle;
    }

    public Style getValueStyle() {
        return this.valueStyle;
    }

    public void setValueStyle(Style valueStyle) {
        this.valueStyle = valueStyle;
    }

    public Style getUndoStyle() {
        return this.undoStyle;
    }

    public void setUndoStyle(Style undoStyle) {
        this.undoStyle = undoStyle;
    }

    public Style getCopyStyle() {
        return this.copyStyle;
    }

    public void setCopyStyle(Style copyStyle) {
        this.copyStyle = copyStyle;
    }

    protected static class BaseCommand {
        private final String base;
        @Nullable
        private final String modId;

        public BaseCommand(String base, @Nullable String modId) {
            this.base = base;
            this.modId = modId;
        }

        public String resolve(String first, String ... args) {
            StringBuilder b = new StringBuilder(this.base);
            b.append(' ').append(first);
            if (this.modId != null) {
                b.append(' ').append(this.modId);
            }
            for (String arg : args) {
                b.append(' ').append(arg);
            }
            return b.toString();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class CommandClientTickExecutor {
        private final List<Runnable> tickActions = new ArrayList<Runnable>();

        public CommandClientTickExecutor() {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SubscribeEvent
        public void onTick(TickEvent.ClientTickEvent event) {
            List<Runnable> list = this.tickActions;
            synchronized (list) {
                this.tickActions.forEach(Runnable::run);
                this.tickActions.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Runnable runnable) {
            List<Runnable> list = this.tickActions;
            synchronized (list) {
                this.tickActions.add(runnable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearPending() {
            List<Runnable> list = this.tickActions;
            synchronized (list) {
                this.tickActions.clear();
            }
        }
    }
}

