/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.collect.Lists;
import endorh.simpleconfig.api.ConfigBuilderFactoryProxy;
import endorh.simpleconfig.api.ConfigCategoryBuilder;
import endorh.simpleconfig.api.ConfigEntryBuilder;
import endorh.simpleconfig.api.ConfigEntryHolderBuilder;
import endorh.simpleconfig.api.ConfigGroupBuilder;
import endorh.simpleconfig.api.EntryTag;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.api.SimpleConfigBuilder;
import endorh.simpleconfig.api.SimpleConfigTextUtil;
import endorh.simpleconfig.api.entry.CommentedConfigEntryBuilder;
import endorh.simpleconfig.api.entry.ConfigEntrySerializer;
import endorh.simpleconfig.api.entry.EntryListEntryBuilder;
import endorh.simpleconfig.api.entry.ListEntryBuilder;
import endorh.simpleconfig.api.entry.RangedEntryBuilder;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.config.CommonConfig;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractConfigEntryBuilder;
import endorh.simpleconfig.core.SimpleConfigBuilderImpl;
import endorh.simpleconfig.core.SimpleConfigImpl;
import endorh.simpleconfig.core.SimpleConfigModConfig;
import endorh.simpleconfig.core.entry.CommentedConfigEntry;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.DumperOptions;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.Yaml;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.error.YAMLException;
import endorh.simpleconfig.ui.hotkey.ConfigHotKeyManager;
import endorh.simpleconfig.yaml.SimpleConfigCommentedYamlFormat;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="simpleconfig", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SimpleConfigWrapper {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Method Range$getClazz;
    private static final Method Range$getMin;
    private static final Method Range$getMax;
    private static final Pattern EXTRA_FILE_NAME;
    private static final Pattern INDENT;
    private static final Pattern LINE_BREAK;
    private static final Pattern EXPERIMENTAL;
    private static final List<ValueSpecAdapter<?, ?>> ADAPTERS;

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLoadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            SimpleConfigWrapper.wrapConfigs();
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ConfigHotKeyManager::initHotKeyManager);
        });
    }

    public static void wrapConfigs() {
        ModList.get().forEachModContainer((modId, container) -> {
            if (!CommonConfig.menu.shouldWrapConfig(modId)) {
                return;
            }
            EnumMap<ModConfig.Type, ModConfig> configs = SimpleConfigWrapper.getConfigs(container);
            if (!configs.isEmpty()) {
                String displayName = container.getModInfo().getDisplayName();
                String logName = displayName + " (" + modId + ")";
                for (SimpleConfig.Type type : SimpleConfig.Type.values()) {
                    ModConfig.Type configType = type.asConfigType();
                    String tt = type.getAlias();
                    try {
                        if (configs.containsKey(configType)) {
                            ModConfig config = configs.get(configType);
                            List<Object> extraConfigs = SimpleConfigWrapper.collectExtraConfigFiles(container, config, type);
                            if (!(config instanceof SimpleConfigModConfig)) {
                                SimpleConfigBuilderImpl builder;
                                LOGGER.info("Wrapping " + tt + " config for mod {}", modId);
                                IConfigSpec s = config.getSpec();
                                if (!(s instanceof ForgeConfigSpec)) {
                                    throw new IllegalArgumentException("Config spec for mod " + container.getModInfo().getDisplayName() + " (" + container.getModId() + ") is not a ForgeConfigSpec");
                                }
                                ForgeConfigSpec spec = (ForgeConfigSpec)s;
                                if (extraConfigs.size() == 1) {
                                    extraConfigs = Collections.emptyList();
                                } else if (!extraConfigs.isEmpty()) {
                                    spec = null;
                                }
                                Pair<SimpleConfigBuilder, Map<String, ForgeConfigSpec>> pair = SimpleConfigWrapper.wrap(container, config, spec, extraConfigs);
                                SimpleConfigBuilderImpl simpleConfigBuilderImpl = builder = pair != null ? (SimpleConfigBuilderImpl)pair.getLeft() : null;
                                if (builder == null || builder.entries.isEmpty() && builder.categories.isEmpty() && builder.groups.isEmpty()) {
                                    LOGGER.warn("Unable to wrap " + tt + " config for mod {}: Wrapped config is empty", modId);
                                } else {
                                    builder.buildAndRegister(null, new WrappingConfigValueBuilder((ModContainer)container, config, (List<ModConfig>)extraConfigs, spec, (Map)pair.getRight()));
                                }
                            }
                        }
                        LOGGER.info("Wrapped " + tt + " config for mod " + logName);
                    }
                    catch (RuntimeException e) {
                        LOGGER.error("Error wrapping " + tt + " config for mod " + logName + "\nYou may report this error at the Simple Config issue tracker", (Throwable)e);
                    }
                }
            }
        });
    }

    private static List<ModConfig> collectExtraConfigFiles(ModContainer container, ModConfig config, SimpleConfig.Type type) {
        Set configs = (Set)ConfigTracker.INSTANCE.configSets().get(type.asConfigType());
        return configs.stream().filter(c -> c.getModId().equals(container.getModId())).filter(c -> !(c instanceof SimpleConfigModConfig)).collect(Collectors.toList());
    }

    private static Pair<SimpleConfigBuilder, Map<String, ForgeConfigSpec>> wrap(ModContainer container, ModConfig config, @Nullable ForgeConfigSpec spec, List<ModConfig> extraFiles) {
        if (config instanceof SimpleConfigModConfig) {
            return null;
        }
        SimpleConfig.Type type = SimpleConfig.Type.fromConfigType(config.getType());
        SimpleConfigBuilderImpl builder = (SimpleConfigBuilderImpl)ConfigBuilderFactoryProxy.config(config.getModId(), type);
        if (spec != null) {
            SimpleConfigWrapper.wrapConfig(builder, spec.getValues(), spec.getSpec(), "");
        }
        HashMap<String, ForgeConfigSpec> extraSpecs = new HashMap<String, ForgeConfigSpec>();
        for (ModConfig extra : extraFiles) {
            IConfigSpec iConfigSpec = extra.getSpec();
            if (!(iConfigSpec instanceof ForgeConfigSpec)) {
                throw new IllegalArgumentException("Config spec for mod " + container.getModInfo().getDisplayName() + " (" + container.getModId() + ") is not a ForgeConfigSpec");
            }
            ForgeConfigSpec extraSpec = (ForgeConfigSpec)iConfigSpec;
            Object key = SimpleConfigWrapper.extractExtraFileName(extra);
            if (builder.categories.containsKey(key)) {
                LOGGER.warn("Extra config file {} for mod {} has the same name as an existing config category", (Object)extra.getFileName(), (Object)container.getModId());
                key = "file/" + (String)key;
                if (builder.categories.containsKey(key)) {
                    LOGGER.warn("Extra config file {} for mod {} could not be wrapped, because it's fallback category name: {} is already in use", (Object)extra.getFileName(), (Object)container.getModId(), key);
                    continue;
                }
            }
            extraSpecs.put((String)key, extraSpec);
            ConfigCategoryBuilder categoryBuilder = ConfigBuilderFactoryProxy.category((String)key).withIcon(SimpleConfigIcons.MinecraftOptions.FILE).withColor(-2143141310).withDescription(() -> SimpleConfigTextUtil.splitTtc("simpleconfig.ui.config.file", Component.m_237113_((String)extra.getFileName()).m_130940_(ChatFormatting.DARK_AQUA)));
            SimpleConfigWrapper.wrapConfig(categoryBuilder, extraSpec.getValues(), extraSpec.getSpec(), (String)key);
            builder.n(categoryBuilder);
        }
        return Pair.of((Object)builder, extraSpecs);
    }

    private static String extractExtraFileName(ModConfig config) {
        Matcher matcher = EXTRA_FILE_NAME.matcher(config.getFileName());
        if (matcher.matches()) {
            return matcher.group("name").replace('.', ' ');
        }
        return config.getFileName();
    }

    private static void wrapConfig(ConfigEntryHolderBuilder<?> builder, UnmodifiableConfig values, UnmodifiableConfig spec, String path) {
        Map specMap = values.valueMap();
        for (Map.Entry specEntry : specMap.entrySet()) {
            String key = (String)specEntry.getKey();
            String entryPath = path.isEmpty() ? key : path + "." + key;
            Object specValue = specEntry.getValue();
            if (specValue instanceof UnmodifiableConfig) {
                UnmodifiableConfig subSpec = (UnmodifiableConfig)specValue;
                if (builder instanceof SimpleConfigBuilder) {
                    SimpleConfigBuilder configBuilder = (SimpleConfigBuilder)builder;
                    if (CommonConfig.menu.wrap_top_level_groups_as_categories) {
                        ConfigCategoryBuilder categoryBuilder = ConfigBuilderFactoryProxy.category(key);
                        SimpleConfigWrapper.wrapConfig(categoryBuilder, subSpec, spec, entryPath);
                        configBuilder.n(categoryBuilder);
                        continue;
                    }
                }
                ConfigGroupBuilder groupBuilder = ConfigBuilderFactoryProxy.group(key, true);
                SimpleConfigWrapper.wrapConfig(groupBuilder, subSpec, spec, entryPath);
                builder.n(groupBuilder);
                continue;
            }
            if (!(specValue instanceof ForgeConfigSpec.ConfigValue)) continue;
            ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)specValue;
            Object o = spec.get(configValue.getPath());
            if (o instanceof ForgeConfigSpec.ValueSpec) {
                ForgeConfigSpec.ValueSpec s = (ForgeConfigSpec.ValueSpec)o;
                Optional<ConfigEntryBuilder<?, ?, ?, ?>> opt = SimpleConfigWrapper.wrapValue(s);
                if (opt.isPresent()) {
                    builder.add(key, opt.get());
                    continue;
                }
                LOGGER.warn("Could not wrap config value: " + entryPath + " of type " + configValue.getClass().getCanonicalName());
                continue;
            }
            LOGGER.warn("Invalid value spec: " + o + " for entry " + entryPath);
        }
    }

    private static Optional<ConfigEntryBuilder<?, ?, ?, ?>> wrapValue(ForgeConfigSpec.ValueSpec spec) {
        Class<?> clazz = SimpleConfigWrapper.guessValueClass(spec);
        for (ValueSpecAdapter<?, ?> adapter : ADAPTERS) {
            if (!adapter.getClazz().isAssignableFrom(clazz)) continue;
            return Optional.ofNullable(adapter.createBuilder(spec));
        }
        return Optional.empty();
    }

    private static Optional<ConfigEntryBuilder<?, ?, ?, ?>> wrapValue(Object defValue, @Nullable Predicate<Object> validator) {
        if (defValue == null) {
            return Optional.empty();
        }
        Class<?> clazz = defValue.getClass();
        for (ValueSpecAdapter<?, ?> adapter : ADAPTERS) {
            if (!adapter.getClazz().isAssignableFrom(clazz)) continue;
            return Optional.ofNullable(adapter.createBuilder(defValue, validator));
        }
        return Optional.empty();
    }

    private static Class<?> guessValueClass(ForgeConfigSpec.ValueSpec spec) {
        Class<?> clazz = spec.getClazz();
        if (clazz != Object.class) {
            return clazz;
        }
        clazz = SimpleConfigWrapper.tryGetClassFromRange(spec);
        if (clazz != null) {
            return clazz;
        }
        return spec.getDefault().getClass();
    }

    @Nullable
    private static Class<?> tryGetClassFromRange(ForgeConfigSpec.ValueSpec spec) {
        if (Range$getClazz == null) {
            return null;
        }
        ForgeConfigSpec.Range range = spec.getRange();
        if (range == null) {
            return null;
        }
        try {
            Object clazz = Range$getClazz.invoke((Object)range, new Object[0]);
            return clazz instanceof Class ? (Class)clazz : null;
        }
        catch (IllegalAccessException | InvocationTargetException ignored) {
            return null;
        }
    }

    @Nullable
    private static <T> Pair<T, T> tryGetRange(ForgeConfigSpec.ValueSpec spec, Class<T> clazz) {
        if (Range$getMin == null) {
            return null;
        }
        ForgeConfigSpec.Range range = spec.getRange();
        if (range == null) {
            return null;
        }
        try {
            Object min = Range$getMin.invoke((Object)range, new Object[0]);
            Object max = Range$getMax.invoke((Object)range, new Object[0]);
            return clazz.isInstance(min) && clazz.isInstance(max) ? Pair.of(clazz.cast(min), clazz.cast(max)) : null;
        }
        catch (IllegalAccessException | InvocationTargetException ignored) {
            return null;
        }
    }

    private static <B extends ConfigEntryBuilder<?, ?, ?, B>> B decorateBuilder(ConfigEntryBuilder<?, ?, ?, ?> builder, @Nullable ForgeConfigSpec.ValueSpec spec, @Nullable Predicate<Object> validator) {
        if (spec != null) {
            String comment;
            builder = builder.restart(spec.needsWorldRestart());
            String translation = spec.getTranslationKey();
            if (translation != null) {
                builder = ((AbstractConfigEntryBuilder)builder).translation(translation);
            }
            if ((comment = spec.getComment()) != null) {
                ArrayList<Component> tooltip = new ArrayList<Component>();
                String[] lines = LINE_BREAK.split(comment);
                int commonIndent = Arrays.stream(lines).mapToInt(l -> {
                    Matcher m = INDENT.matcher((CharSequence)l);
                    if (!m.matches()) {
                        return 0;
                    }
                    return m.end();
                }).min().orElse(0);
                for (String l2 : lines) {
                    l2 = l2.substring(commonIndent);
                    MutableComponent ll = Component.m_237113_((String)l2).m_130940_(ChatFormatting.GRAY);
                    Matcher m = EXPERIMENTAL.matcher(l2);
                    if (m.find()) {
                        builder = builder.withTags(EntryTag.EXPERIMENTAL);
                        if (FMLEnvironment.dist == Dist.CLIENT) {
                            ll = SimpleConfigTextUtil.applyStyle((Component)ll, ChatFormatting.GOLD, m.start(), m.end());
                        }
                    }
                    tooltip.add((Component)ll);
                }
                builder = (ConfigEntryBuilder)builder.tooltip(tooltip);
            }
            builder = (ConfigEntryBuilder)builder.configError(t -> !spec.test(t) ? Optional.of(Component.m_237110_((String)"simpleconfig.config.error.invalid_value_generic", (Object[])new Object[]{t})) : Optional.empty());
        } else if (validator != null) {
            builder = (ConfigEntryBuilder)builder.configError(t -> !validator.test(t) ? Optional.of(Component.m_237110_((String)"simpleconfig.config.error.invalid_value_generic", (Object[])new Object[]{t})) : Optional.empty());
        }
        return (B)builder;
    }

    private static <V> void reg(Class<V> clazz, IValueSpecAdapter<V, V> adapter) {
        SimpleConfigWrapper.reg(clazz, Function.identity(), adapter);
    }

    private static <V extends Comparable<V>, CC, C extends CC> void regRanged(Class<C> clazz, Function<CC, V> transform, IRangedValueSpecAdapter<V, CC> adapter) {
        SimpleConfigWrapper.reg(clazz, transform, (s, v, validator) -> {
            Pair p;
            RangedEntryBuilder<Comparable<Object>, Object, Object, Object> builder = adapter.createBuilder(v);
            Pair pair = p = s != null ? SimpleConfigWrapper.tryGetRange(s, clazz) : null;
            if (p != null) {
                Comparable min = (Comparable)transform.apply(p.getLeft());
                Comparable max = (Comparable)transform.apply(p.getRight());
                if (min.compareTo(v) <= 0 && max.compareTo(v) >= 0) {
                    builder = builder.range(min, (Comparable)transform.apply(p.getRight()));
                }
            }
            return builder;
        });
    }

    private static <V, CC, C extends CC> void reg(Class<C> clazz, Function<CC, V> transform, IValueSpecAdapter<V, CC> adapter) {
        ADAPTERS.add(new ValueSpecAdapter<V, C>(clazz, transform, adapter));
    }

    private static ListEntryBuilder<?, ?, ?, ?> guessListType(List<?> defValue, Predicate<Object> validator) {
        ListEntryBuilder b;
        if (defValue.isEmpty()) {
            b = SimpleConfigWrapper.guessListTypeFromValidator(validator);
        } else if (SimpleConfigWrapper.allInstance(defValue, Boolean.class)) {
            b = ConfigBuilderFactoryProxy.list(ConfigBuilderFactoryProxy.bool(false), SimpleConfigWrapper.castList(defValue));
        } else if (SimpleConfigWrapper.allInstance(defValue, Integer.class)) {
            b = ConfigBuilderFactoryProxy.list(ConfigBuilderFactoryProxy.number(!validator.test(Collections.singletonList(0)) ? 1 : 0), SimpleConfigWrapper.castList(defValue));
        } else if (SimpleConfigWrapper.allInstance(defValue, Long.class)) {
            b = ConfigBuilderFactoryProxy.list(ConfigBuilderFactoryProxy.number(!validator.test(Collections.singletonList(0L)) ? 1L : 0L), SimpleConfigWrapper.castList(defValue));
        } else if (SimpleConfigWrapper.allInstance(defValue, Float.class)) {
            b = ConfigBuilderFactoryProxy.list(ConfigBuilderFactoryProxy.number(!validator.test(Collections.singletonList(Float.valueOf(0.0f))) ? 1.0f : 0.0f), SimpleConfigWrapper.castList(defValue));
        } else if (SimpleConfigWrapper.allInstance(defValue, Double.class)) {
            b = ConfigBuilderFactoryProxy.list(ConfigBuilderFactoryProxy.number(!validator.test(Collections.singletonList(0.0)) ? 1.0 : 0.0), SimpleConfigWrapper.castList(defValue));
        } else if (SimpleConfigWrapper.allInstance(defValue, Byte.class)) {
            b = ConfigBuilderFactoryProxy.list(ConfigBuilderFactoryProxy.number(!validator.test(Collections.singletonList((byte)0)) ? (byte)1 : 0), SimpleConfigWrapper.castList(defValue));
        } else if (SimpleConfigWrapper.allInstance(defValue, Short.class)) {
            b = ConfigBuilderFactoryProxy.list(ConfigBuilderFactoryProxy.number(!validator.test(Collections.singletonList((short)0)) ? (short)1 : 0), SimpleConfigWrapper.castList(defValue));
        } else if (SimpleConfigWrapper.allInstance(defValue, String.class)) {
            b = ConfigBuilderFactoryProxy.list(ConfigBuilderFactoryProxy.string(""), SimpleConfigWrapper.castList(defValue));
        } else if (SimpleConfigWrapper.allInstance(defValue, Enum.class)) {
            b = ConfigBuilderFactoryProxy.list(ConfigBuilderFactoryProxy.option((Enum)defValue.get(0)), SimpleConfigWrapper.castList(defValue));
        } else if (SimpleConfigWrapper.allInstance(defValue, List.class)) {
            Predicate<Object> subValidator = o -> validator.test(Collections.singletonList(o));
            Optional<List> opt = defValue.stream().map(e -> (List)e).filter(e -> !e.isEmpty()).findFirst();
            ListEntryBuilder<?, ?, ?, ?> sub = opt.isPresent() ? SimpleConfigWrapper.guessListType(opt.get(), subValidator) : SimpleConfigWrapper.guessListTypeFromValidator(subValidator);
            b = SimpleConfigWrapper.wrapSubList(sub, defValue);
        } else {
            b = SimpleConfigWrapper.allInstance(defValue, CommentedConfig.class) ? ConfigBuilderFactoryProxy.list(SimpleConfigWrapper.guessMapType(defValue, o -> validator.test(List.of(o)))) : ConfigBuilderFactoryProxy.list(ConfigBuilderFactoryProxy.entry("", new YamlConfigSerializer()), new Object[]{defValue});
        }
        if (!validator.test(Lists.newArrayList())) {
            b = (EntryListEntryBuilder)b.minSize(1);
        }
        return b;
    }

    private static CommentedConfigEntryBuilder guessMapType(List<CommentedConfig> defValues, Predicate<CommentedConfig> validator) {
        Map defEntries = defValues.stream().map(Config::valueMap).reduce((a, b) -> (Map)Util.m_137469_(new HashMap(), m -> {
            m.putAll(b);
            m.putAll(a);
        })).orElse(Collections.emptyMap());
        CommentedConfig defValue = defValues.stream().findFirst().orElse(CommentedConfig.inMemory());
        CommentedConfigEntryBuilder b2 = new CommentedConfigEntry.Builder(defValue);
        for (Map.Entry e : defEntries.entrySet()) {
            String k = (String)e.getKey();
            Optional<ConfigEntryBuilder<?, ?, ?, ?>> opt = SimpleConfigWrapper.wrapValue(e.getValue(), null);
            if (opt.isPresent()) {
                AbstractConfigEntryBuilder eb = (AbstractConfigEntryBuilder)opt.get();
                b2 = b2.add(k, (ConfigEntryBuilder)eb);
                continue;
            }
            LOGGER.warn("Unable to wrap map config entry sub-entry: " + k);
        }
        return b2;
    }

    private static <V, C, G, B extends ListEntryBuilder<V, C, G, B>> ListEntryBuilder<?, ?, ?, ?> wrapSubList(ListEntryBuilder<?, ?, ?, ?> sub, List<?> subList) {
        return ConfigBuilderFactoryProxy.list(sub, subList);
    }

    private static boolean allInstance(List<?> list, Class<?> clazz) {
        return list.stream().allMatch(clazz::isInstance);
    }

    private static <T> List<T> castList(List<?> list) {
        return list;
    }

    private static ListEntryBuilder<?, ?, ?, ?> guessListTypeFromValidator(Predicate<Object> validator) {
        if (validator.test(Collections.singletonList("s"))) {
            return ConfigBuilderFactoryProxy.list(ConfigBuilderFactoryProxy.string(""));
        }
        if (validator.test(Collections.singletonList(true))) {
            return ConfigBuilderFactoryProxy.list(ConfigBuilderFactoryProxy.bool(false));
        }
        if (validator.test(Collections.singletonList(0))) {
            return ConfigBuilderFactoryProxy.list(ConfigBuilderFactoryProxy.number(0));
        }
        if (validator.test(Collections.singletonList(1))) {
            return ConfigBuilderFactoryProxy.list(ConfigBuilderFactoryProxy.number(1));
        }
        if (validator.test(Collections.singletonList(0L))) {
            return ConfigBuilderFactoryProxy.list(ConfigBuilderFactoryProxy.number(0L));
        }
        if (validator.test(Collections.singletonList(1L))) {
            return ConfigBuilderFactoryProxy.list(ConfigBuilderFactoryProxy.number(1L));
        }
        if (validator.test(Collections.singletonList(Float.valueOf(0.0f)))) {
            return ConfigBuilderFactoryProxy.list(ConfigBuilderFactoryProxy.number(0.0f));
        }
        if (validator.test(Collections.singletonList(Float.valueOf(1.0f)))) {
            return ConfigBuilderFactoryProxy.list(ConfigBuilderFactoryProxy.number(1.0f));
        }
        if (validator.test(Collections.singletonList(0.0))) {
            return ConfigBuilderFactoryProxy.list(ConfigBuilderFactoryProxy.number(0.0));
        }
        if (validator.test(Collections.singletonList(1.0))) {
            return ConfigBuilderFactoryProxy.list(ConfigBuilderFactoryProxy.number(1.0));
        }
        if (validator.test(Collections.singletonList((byte)0))) {
            return ConfigBuilderFactoryProxy.list(ConfigBuilderFactoryProxy.number((byte)0));
        }
        if (validator.test(Collections.singletonList((byte)1))) {
            return ConfigBuilderFactoryProxy.list(ConfigBuilderFactoryProxy.number((byte)1));
        }
        if (validator.test(Collections.singletonList((short)0))) {
            return ConfigBuilderFactoryProxy.list(ConfigBuilderFactoryProxy.number((short)0));
        }
        if (validator.test(Collections.singletonList((short)1))) {
            return ConfigBuilderFactoryProxy.list(ConfigBuilderFactoryProxy.number((short)1));
        }
        return ConfigBuilderFactoryProxy.list(ConfigBuilderFactoryProxy.entry("", new YamlConfigSerializer()));
    }

    @ApiStatus.Internal
    public static EnumMap<ModConfig.Type, ModConfig> getConfigs(ModContainer container) {
        return (EnumMap)ObfuscationReflectionHelper.getPrivateValue(ModContainer.class, (Object)container, (String)"configs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Method getClazz = null;
        Method getMin = null;
        Method getMax = null;
        try {
            Class<?> cls = Class.forName("net.minecraftforge.common.ForgeConfigSpec$Range");
            getClazz = cls.getMethod("getClazz", new Class[0]);
            getClazz.setAccessible(true);
            getMin = cls.getMethod("getMin", new Class[0]);
            getMin.setAccessible(true);
            getMax = cls.getMethod("getMax", new Class[0]);
            getMax.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            LOGGER.error("Failed access ForgeConfigSpec.Range class", (Throwable)e);
        }
        finally {
            Range$getClazz = getClazz;
            Range$getMin = getMin;
            Range$getMax = getMax;
        }
        EXTRA_FILE_NAME = Pattern.compile("(?:.*?[/\\\\])?(?!.*[/\\\\])(?<name>[^.]*+)\\.\\w+$");
        INDENT = Pattern.compile("^\\s*+");
        LINE_BREAK = Pattern.compile("\\R");
        EXPERIMENTAL = Pattern.compile("EXPERIMENTAL", 2);
        ADAPTERS = new ArrayList();
        SimpleConfigWrapper.reg(Boolean.class, (s, v, t) -> ConfigBuilderFactoryProxy.bool(false));
        SimpleConfigWrapper.regRanged(Byte.class, Number::byteValue, ConfigBuilderFactoryProxy::number);
        SimpleConfigWrapper.regRanged(Short.class, Number::shortValue, ConfigBuilderFactoryProxy::number);
        SimpleConfigWrapper.regRanged(Integer.class, Number::intValue, ConfigBuilderFactoryProxy::number);
        SimpleConfigWrapper.regRanged(Long.class, Number::longValue, ConfigBuilderFactoryProxy::number);
        SimpleConfigWrapper.regRanged(Float.class, Number::floatValue, ConfigBuilderFactoryProxy::number);
        SimpleConfigWrapper.regRanged(Double.class, Number::doubleValue, ConfigBuilderFactoryProxy::number);
        SimpleConfigWrapper.reg(String.class, (s, v, t) -> ConfigBuilderFactoryProxy.string(v));
        SimpleConfigWrapper.reg(Enum.class, (s, v, t) -> ConfigBuilderFactoryProxy.option(v));
        SimpleConfigWrapper.reg(List.class, Function.identity(), (s, v, t) -> SimpleConfigWrapper.guessListType(v, t));
        SimpleConfigWrapper.reg(CommentedConfig.class, Function.identity(), (s, v, t) -> SimpleConfigWrapper.guessMapType(List.of(v), t));
    }

    public static class ValueSpecAdapter<V, C> {
        private final Class<? extends C> clazz;
        private final Function<C, V> transform;
        private final IValueSpecAdapter<V, C> adapter;

        public ValueSpecAdapter(Class<? extends C> clazz, Function<C, V> transform, IValueSpecAdapter<V, C> adapter) {
            this.clazz = clazz;
            this.transform = transform;
            this.adapter = adapter;
        }

        @Nullable
        public ConfigEntryBuilder<?, ?, ?, ?> createBuilder(ForgeConfigSpec.ValueSpec spec) {
            Object defValue = spec.getDefault();
            C def = this.clazz.cast(defValue);
            V value = this.transform.apply(def);
            return SimpleConfigWrapper.decorateBuilder(this.adapter.createCastBuilder(spec, value, arg_0 -> ((ForgeConfigSpec.ValueSpec)spec).test(arg_0)), spec, null);
        }

        @Nullable
        public ConfigEntryBuilder<?, ?, ?, ?> createBuilder(Object defValue, @Nullable Predicate<Object> validator) {
            C def = this.clazz.cast(defValue);
            V value = this.transform.apply(def);
            return SimpleConfigWrapper.decorateBuilder(this.adapter.createCastBuilder(null, value, validator != null ? validator : t -> true), null, validator);
        }

        public Class<? extends C> getClazz() {
            return this.clazz;
        }
    }

    @FunctionalInterface
    static interface IValueSpecAdapter<V, C> {
        public ConfigEntryBuilder<V, C, ?, ?> createBuilder(@Nullable ForgeConfigSpec.ValueSpec var1, V var2, Predicate<V> var3);

        default public <B extends ConfigEntryBuilder<?, ?, ?, B>> B createCastBuilder(@Nullable ForgeConfigSpec.ValueSpec spec, V defValue, Predicate<V> validator) {
            return (B)this.createBuilder(spec, defValue, validator);
        }
    }

    @FunctionalInterface
    static interface IRangedValueSpecAdapter<V extends Comparable<V>, C> {
        public RangedEntryBuilder<V, C, ?, ?> createBuilder(V var1);
    }

    public static class YamlConfigSerializer
    implements ConfigEntrySerializer<Object> {
        @Override
        public String serializeConfigEntry(Object value) {
            Yaml yaml = SimpleConfigCommentedYamlFormat.getDefaultYaml();
            try {
                return yaml.dumpAs(value, null, DumperOptions.FlowStyle.FLOW);
            }
            catch (YAMLException e) {
                return "";
            }
        }

        @Override
        public Optional<Object> deserializeConfigEntry(String value) {
            Yaml yaml = SimpleConfigCommentedYamlFormat.getDefaultYaml();
            try {
                return Optional.ofNullable(yaml.load(value));
            }
            catch (YAMLException e) {
                return Optional.empty();
            }
        }
    }

    protected static class WrappingConfigValueBuilder
    extends SimpleConfigBuilderImpl.ConfigValueBuilder {
        private final ModContainer container;
        private final ModConfig modConfig;
        private final Map<String, ModConfig> extraConfigs;
        private final ForgeConfigSpec spec;
        private final Map<String, ForgeConfigSpec> extraSpecs;
        private final Stack<UnmodifiableConfig> stack = new Stack();
        private final Stack<String> path = new Stack();

        protected WrappingConfigValueBuilder(ModContainer container, ModConfig modConfig, List<ModConfig> extraConfigs, ForgeConfigSpec spec, Map<String, ForgeConfigSpec> extraSpecs) {
            this.container = container;
            this.modConfig = modConfig;
            this.extraConfigs = extraConfigs.stream().collect(Collectors.toMap(c -> {
                IConfigSpec s = c.getSpec();
                return extraSpecs.entrySet().stream().filter(ss -> ss.getValue() == s).findFirst().map(Map.Entry::getKey).orElseThrow();
            }, Function.identity()));
            this.spec = spec;
            this.extraSpecs = extraSpecs;
            this.stack.push((UnmodifiableConfig)(spec != null ? this.spec.getValues() : CommentedConfig.inMemory()));
        }

        @Override
        public void buildModConfig(SimpleConfigImpl config) {
            config.build(this.container, this.modConfig, this.extraConfigs);
        }

        @Override
        public void build(AbstractConfigEntryBuilder<?, ?, ?, ?, ?, ?> entryBuilder, AbstractConfigEntry<?, ?, ?> entry) {
            Object o = this.getConfigValues().get(entry.name);
            if (!(o instanceof ForgeConfigSpec.ConfigValue)) {
                throw new IllegalStateException("Cannot wrap entry: " + entry.name);
            }
            entry.setConfigValue((ForgeConfigSpec.ConfigValue)o);
        }

        protected UnmodifiableConfig getConfigValues() {
            return this.stack.peek();
        }

        protected String getPath() {
            return String.join((CharSequence)".", this.path);
        }

        protected String getPath(String name) {
            String path = this.getPath();
            return path.isEmpty() ? name : path + "." + name;
        }

        @Override
        public boolean canBuildEntry(String name) {
            boolean r = this.getConfigValues().get(name) instanceof ForgeConfigSpec.ConfigValue;
            if (!r) {
                LOGGER.warn("Unexpected entry in wrapped config: " + this.getPath(name));
            }
            return r;
        }

        @Override
        public boolean canBuildSection(String name) {
            boolean r;
            boolean bl = r = this.getConfigValues().get(name) instanceof UnmodifiableConfig || this.extraSpecs.containsKey(name);
            if (!r) {
                LOGGER.warn("Unexpected section in wrapped config: " + this.getPath(name));
            }
            return r;
        }

        @Override
        public void enterSection(String name) {
            Object o = this.getConfigValues().get(name);
            if (o instanceof UnmodifiableConfig) {
                this.stack.push((UnmodifiableConfig)o);
            } else if (this.extraSpecs.containsKey(name)) {
                this.stack.push(this.extraSpecs.get(name).getValues());
            } else {
                throw new IllegalStateException("Cannot wrap config section: " + name);
            }
        }

        @Override
        public void exitSection() {
            this.stack.pop();
        }

        @Override
        public Pair<ForgeConfigSpec, List<ForgeConfigSpec>> build() {
            return Pair.of((Object)this.spec, new ArrayList<ForgeConfigSpec>(this.extraSpecs.values()));
        }
    }
}

