/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core;

import com.electronwill.nightconfig.core.CommentedConfig;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.config.ServerConfig;
import endorh.simpleconfig.core.SimpleConfigImpl;
import endorh.simpleconfig.core.SimpleConfigNetworkHandler;
import endorh.simpleconfig.core.SimpleConfigPaths;
import endorh.simpleconfig.core.SimpleConfigResourcePresetHandler;
import endorh.simpleconfig.ui.api.ConfigScreenBuilder;
import endorh.simpleconfig.ui.gui.widget.PresetPickerWidget;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.naming.NoPermissionException;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

class SimpleConfigSnapshotHandler
implements ConfigScreenBuilder.IConfigSnapshotHandler,
ConfigScreenBuilder.IRemoteConfigProvider {
    private final String modId;
    private final Map<SimpleConfig.Type, SimpleConfigImpl> configMap;
    private ConfigScreenBuilder.IConfigSnapshotHandler.IExternalChangeHandler externalChangeHandler;

    public SimpleConfigSnapshotHandler(Map<SimpleConfig.Type, SimpleConfigImpl> configMap) {
        this.configMap = configMap;
        this.modId = configMap.values().stream().findFirst().map(SimpleConfigImpl::getModId).orElse("");
    }

    @Override
    public CommentedConfig preserve(SimpleConfig.Type type, @Nullable Set<String> selectedPaths) {
        SimpleConfigImpl c = this.configMap.get((Object)type);
        if (c == null) {
            throw new IllegalArgumentException("Unsupported config type: " + type);
        }
        return c.takeSnapshot(true, false, selectedPaths);
    }

    @Override
    public void restore(CommentedConfig config, SimpleConfig.Type type, @Nullable Set<String> selectedPaths) {
        SimpleConfigImpl c = this.configMap.get((Object)type);
        if (c == null) {
            return;
        }
        c.loadSnapshot(config, true, false, selectedPaths);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canSaveRemote() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91403_() == null || mc.f_91074_ == null) {
            return false;
        }
        return ((ServerConfig.PresetPermission)((Object)ServerConfig.permissions.permissionFor((Player)mc.f_91074_, this.modId).getRight())).canSave();
    }

    @Override
    public CompletableFuture<CommentedConfig> getPresetSnapshot(PresetPickerWidget.Preset preset) {
        SimpleConfigImpl c = this.configMap.get((Object)preset.getType());
        if (c == null) {
            return SimpleConfigSnapshotHandler.failedFuture(new IllegalArgumentException("Missing config type"));
        }
        switch (preset.getLocation()) {
            case LOCAL: {
                CompletableFuture<CommentedConfig> future = c.getLocalPreset(preset.getName());
                if (!future.isDone()) {
                    future.completeExceptionally(new IllegalStateException("Local presets must resolve immediately"));
                }
                return future;
            }
            case REMOTE: {
                return c.getRemotePreset(preset.getName());
            }
            case RESOURCE: {
                return CompletableFuture.completedFuture(SimpleConfigResourcePresetHandler.INSTANCE.getResourcePreset(this.modId, preset));
            }
        }
        return SimpleConfigSnapshotHandler.failedFuture(new IllegalArgumentException("Unknown preset location: " + preset.getLocation()));
    }

    @Override
    public CommentedConfig getLocal(String name, SimpleConfig.Type type) {
        SimpleConfigImpl c = this.configMap.get((Object)type);
        if (c == null) {
            throw new IllegalArgumentException("Missing config type");
        }
        CompletableFuture<CommentedConfig> future = c.getLocalPreset(name);
        if (!future.isDone()) {
            throw new IllegalStateException("Uncompleted future");
        }
        return future.getNow(null);
    }

    @Override
    public CompletableFuture<CommentedConfig> getRemote(String name, SimpleConfig.Type type) {
        SimpleConfigImpl c = this.configMap.get((Object)type);
        return c != null ? c.getRemotePreset(name) : SimpleConfigSnapshotHandler.failedFuture(new IllegalArgumentException("Missing config type"));
    }

    @Override
    public CommentedConfig getResource(String name, SimpleConfig.Type type) {
        PresetPickerWidget.Preset p = PresetPickerWidget.Preset.remote(name, type);
        return SimpleConfigResourcePresetHandler.INSTANCE.getResourcePreset(this.modId, p);
    }

    @Override
    public Optional<Throwable> saveLocal(String name, SimpleConfig.Type type, CommentedConfig config) {
        SimpleConfigImpl c = this.configMap.get((Object)type);
        if (c != null) {
            return SimpleConfigSnapshotHandler.getException(c.saveLocalPreset(name, config));
        }
        return Optional.empty();
    }

    @Override
    public CompletableFuture<Void> saveRemote(String name, SimpleConfig.Type type, CommentedConfig config) {
        if (!this.canSaveRemote()) {
            return SimpleConfigSnapshotHandler.failedFuture(new NoPermissionException("Cannot save remote preset"));
        }
        SimpleConfigImpl c = this.configMap.get((Object)type);
        return c != null ? c.saveRemotePreset(name, config) : SimpleConfigSnapshotHandler.failedFuture(new IllegalArgumentException("Missing config type"));
    }

    @Override
    public Optional<Throwable> deleteLocal(String name, SimpleConfig.Type type) {
        return this.saveLocal(name, type, null);
    }

    @Override
    public CompletableFuture<Void> deleteRemote(String name, SimpleConfig.Type type) {
        return this.saveRemote(name, type, null);
    }

    @Override
    public List<PresetPickerWidget.Preset> getLocalPresets() {
        Pattern pattern;
        SimpleConfigImpl c = this.configMap.get((Object)SimpleConfig.Type.CLIENT);
        if (c == null) {
            return Collections.emptyList();
        }
        File dir = SimpleConfigPaths.LOCAL_PRESETS_DIR.toFile();
        File[] files = dir.listFiles((arg_0, arg_1) -> SimpleConfigSnapshotHandler.lambda$getLocalPresets$0(pattern = Pattern.compile("^(?<file>" + c.getModId() + "-(?<type>\\w++)-(?<name>.+))\\.yaml$"), arg_0, arg_1));
        return files == null ? Collections.emptyList() : Arrays.stream(files).map(f -> {
            Matcher m = pattern.matcher(f.getName());
            if (!m.matches()) {
                return null;
            }
            return PresetPickerWidget.Preset.local(m.group("name"), SimpleConfig.Type.fromAlias(m.group("type")));
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public CompletableFuture<List<PresetPickerWidget.Preset>> getRemotePresets() {
        SimpleConfigImpl c = this.configMap.get((Object)SimpleConfig.Type.SERVER);
        if (c == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return SimpleConfigNetworkHandler.requestPresetList(c.getModId());
    }

    @Override
    public List<PresetPickerWidget.Preset> getResourcePresets() {
        return SimpleConfigResourcePresetHandler.INSTANCE.getResourcePresets(this.modId);
    }

    @Override
    public ConfigScreenBuilder.IConfigSnapshotHandler.IExternalChangeHandler getExternalChangeHandler() {
        return this.externalChangeHandler;
    }

    @Override
    public void setExternalChangeHandler(ConfigScreenBuilder.IConfigSnapshotHandler.IExternalChangeHandler handler) {
        this.externalChangeHandler = handler;
    }

    @Override
    public void notifyExternalChanges(SimpleConfig config) {
        SimpleConfigImpl c = (SimpleConfigImpl)config;
        if (this.externalChangeHandler != null && this.configMap.containsValue(c)) {
            c.loadGUIExternalChanges();
            this.externalChangeHandler.handleExternalChange(c.getType().asEditType(false));
        }
    }

    protected static <T> CompletableFuture<T> failedFuture(Throwable throwable) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(throwable);
        return future;
    }

    protected static Optional<Throwable> getException(CompletableFuture<?> future) {
        if (future.isCompletedExceptionally()) {
            try {
                future.getNow(null);
                return Optional.empty();
            }
            catch (CompletionException e) {
                return Optional.of(e.getCause());
            }
        }
        return Optional.empty();
    }

    @Override
    public CompletableFuture<CommentedConfig> getRemoteConfig(SimpleConfig.EditType type) {
        if (!type.isOnlyRemote()) {
            return SimpleConfigSnapshotHandler.failedFuture(new IllegalArgumentException("Config type is not remote! Cannot get from remote: " + type.getAlias()));
        }
        SimpleConfig.Type configType = type.getType();
        if (configType != SimpleConfig.Type.COMMON) {
            return SimpleConfigSnapshotHandler.failedFuture(new IllegalArgumentException("Unsupported remote config type: " + type.getAlias()));
        }
        SimpleConfigImpl config = this.configMap.get((Object)configType);
        if (config == null) {
            return SimpleConfigSnapshotHandler.failedFuture(new IllegalArgumentException("Missing config type: " + type.getAlias()));
        }
        return SimpleConfigNetworkHandler.requestServerCommonConfig(this.modId);
    }

    @Override
    public boolean mayHaveRemoteConfig(SimpleConfig.EditType type) {
        if (type != SimpleConfig.EditType.SERVER_COMMON) {
            return false;
        }
        SimpleConfigImpl config = this.configMap.get((Object)SimpleConfig.Type.COMMON);
        return config != null && !Minecraft.m_91087_().m_91090_() && ((ServerConfig.ConfigPermission)((Object)ServerConfig.permissions.permissionFor(this.modId).getLeft())).canView();
    }

    @Override
    public void loadRemoteConfig(SimpleConfig.EditType type, CommentedConfig snapshot, boolean asExternal) {
        if (!type.isOnlyRemote()) {
            throw new IllegalArgumentException("Config type is not remote! Cannot get from remote: " + type.getAlias());
        }
        SimpleConfig.Type configType = type.getType();
        if (configType != SimpleConfig.Type.COMMON) {
            throw new IllegalArgumentException("Unsupported remote config type: " + type.getAlias());
        }
        SimpleConfigImpl config = this.configMap.get((Object)configType);
        if (asExternal) {
            config.loadGUIRemoteExternalChanges(snapshot);
        } else {
            config.loadSnapshot(snapshot, true, true);
        }
    }

    @Override
    public void saveRemoteConfig(SimpleConfig.EditType type, boolean requiresRestart) {
        if (!type.isOnlyRemote()) {
            throw new IllegalArgumentException("Config type is not remote! Cannot save to remote: " + type.getAlias());
        }
        SimpleConfig.Type configType = type.getType();
        if (configType != SimpleConfig.Type.COMMON) {
            throw new IllegalArgumentException("Unsupported remote config type: " + type.getAlias());
        }
        SimpleConfigImpl config = this.configMap.get((Object)configType);
        CommentedConfig snapshot = config.takeSnapshot(true, true);
        SimpleConfigNetworkHandler.saveServerCommonConfig(this.modId, config, requiresRestart, snapshot);
    }

    private static /* synthetic */ boolean lambda$getLocalPresets$0(Pattern pattern, File d, String name) {
        return pattern.matcher(name).matches();
    }
}

