/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.core.SimpleConfigImpl;
import endorh.simpleconfig.shadowed.org.yaml.snakeyaml.error.YAMLException;
import endorh.simpleconfig.ui.gui.widget.PresetPickerWidget;
import endorh.simpleconfig.yaml.SimpleConfigCommentedYamlFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SimpleConfigResourcePresetHandler
extends SimplePreparableReloadListener<Loader> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(PresetsDescriptor.class, (Object)new PresetsDescriptor.Serializer()).create();
    private static final TypeToken<Map<String, PresetsDescriptor>> TYPE = new TypeToken<Map<String, PresetsDescriptor>>(){};
    public static final SimpleConfigResourcePresetHandler INSTANCE = new SimpleConfigResourcePresetHandler();
    private final Map<String, Map<PresetPickerWidget.Preset, CommentedConfig>> presetRegistry = Maps.newHashMap();

    public List<PresetPickerWidget.Preset> getResourcePresets(String modId) {
        return new ArrayList<PresetPickerWidget.Preset>(this.presetRegistry.getOrDefault(modId, Collections.emptyMap()).keySet());
    }

    public CommentedConfig getResourcePreset(String modId, PresetPickerWidget.Preset preset) {
        return this.presetRegistry.get(modId).get(preset);
    }

    @NotNull
    protected Loader prepare(@NotNull ResourceManager manager, @NotNull ProfilerFiller profiler) {
        Loader l = new Loader();
        profiler.m_7242_();
        for (String namespace : manager.m_7187_()) {
            profiler.m_6180_(namespace);
            try {
                for (Resource index : manager.m_213829_(new ResourceLocation(namespace, "config-presets.json"))) {
                    profiler.m_6180_(index.m_215506_());
                    try (InputStream is = index.m_215507_();
                         InputStreamReader r = new InputStreamReader(is, StandardCharsets.UTF_8);){
                        profiler.m_6180_("parse");
                        Map map = (Map)GsonHelper.m_13767_((Gson)GSON, (Reader)r, TYPE);
                        profiler.m_6182_("register");
                        if (map != null) {
                            map.forEach((k, v) -> l.registerPresets(namespace, (String)k, (PresetsDescriptor)v));
                        }
                        profiler.m_7238_();
                    }
                    catch (RuntimeException e) {
                        LOGGER.warn("Invalid config-presets.json in resourcepack: '{}'", (Object)index.m_215506_(), (Object)e);
                    }
                    profiler.m_7238_();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            profiler.m_7238_();
        }
        profiler.m_7241_();
        return l;
    }

    protected void apply(@NotNull Loader l, @NotNull ResourceManager manager, @NotNull ProfilerFiller profiler) {
        this.presetRegistry.clear();
        l.getPresetMap().forEach((modId, m) -> {
            SimpleConfigCommentedYamlFormat format;
            Map mm = this.presetRegistry.computeIfAbsent((String)modId, i -> Maps.newHashMap());
            if (SimpleConfigImpl.hasConfig(modId, SimpleConfig.Type.CLIENT)) {
                format = SimpleConfigCommentedYamlFormat.forConfig(SimpleConfigImpl.getConfig(modId, SimpleConfig.Type.CLIENT));
            } else if (SimpleConfigImpl.hasConfig(modId, SimpleConfig.Type.SERVER)) {
                format = SimpleConfigCommentedYamlFormat.forConfig(SimpleConfigImpl.getConfig(modId, SimpleConfig.Type.SERVER));
            } else {
                return;
            }
            m.forEach((preset, location) -> {
                try {
                    CommentedConfig config = format.createParser(false).parse(new InputStreamReader(manager.m_215593_(new ResourceLocation(location.m_135827_(), "config-presets/" + location.m_135815_())).m_215507_()));
                    mm.put(preset, config);
                }
                catch (YAMLException e) {
                    LOGGER.warn("Invalid config preset: " + location, (Throwable)e);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            if (mm.isEmpty()) {
                this.presetRegistry.remove(modId);
            }
        });
    }

    public static class Loader {
        private final Map<String, Map<PresetPickerWidget.Preset, ResourceLocation>> presetMap = Maps.newHashMap();

        public void registerPresets(String namespace, String modId, PresetsDescriptor descriptor) {
            PresetPickerWidget.Preset preset;
            ResourceLocation r;
            String fileName;
            Map map = this.presetMap.computeIfAbsent(modId, m -> Maps.newHashMap());
            for (String name : descriptor.clientPresets) {
                fileName = modId + "-client-" + name + ".yaml";
                r = new ResourceLocation(namespace, fileName);
                preset = PresetPickerWidget.Preset.resource(name, SimpleConfig.Type.CLIENT);
                map.put(preset, r);
            }
            for (String name : descriptor.commonPresets) {
                fileName = modId + "-common-" + name + ".yaml";
                r = new ResourceLocation(namespace, fileName);
                preset = PresetPickerWidget.Preset.resource(name, SimpleConfig.Type.COMMON);
                map.put(preset, r);
            }
            for (String name : descriptor.serverPresets) {
                fileName = modId + "-server-" + name + ".yaml";
                r = new ResourceLocation(namespace, fileName);
                preset = PresetPickerWidget.Preset.resource(name, SimpleConfig.Type.SERVER);
                map.put(preset, r);
            }
            if (map.isEmpty()) {
                this.presetMap.remove(modId);
            }
        }

        public Map<String, Map<PresetPickerWidget.Preset, ResourceLocation>> getPresetMap() {
            return this.presetMap;
        }
    }

    public record PresetsDescriptor(Set<String> clientPresets, Set<String> commonPresets, Set<String> serverPresets) {

        public static class Serializer
        implements JsonDeserializer<PresetsDescriptor>,
        JsonSerializer<PresetsDescriptor> {
            public PresetsDescriptor deserialize(JsonElement json, Type type, JsonDeserializationContext ctx) throws JsonParseException {
                JsonObject obj = GsonHelper.m_13918_((JsonElement)json, (String)"mod config presets");
                Optional<String> first = obj.entrySet().stream().map(Map.Entry::getKey).filter(k -> !"client".equals(k) && !"server".equals(k) && !"common".equals(k)).findFirst();
                if (first.isPresent()) {
                    throw new JsonSyntaxException("Unknown preset type: " + first.get());
                }
                JsonArray client = GsonHelper.m_13832_((JsonObject)obj, (String)"client", (JsonArray)new JsonArray());
                JsonArray common = GsonHelper.m_13832_((JsonObject)obj, (String)"common", (JsonArray)new JsonArray());
                JsonArray server = GsonHelper.m_13832_((JsonObject)obj, (String)"server", (JsonArray)new JsonArray());
                HashSet<String> clientPresets = new HashSet<String>();
                HashSet<String> commonPresets = new HashSet<String>();
                HashSet<String> serverPresets = new HashSet<String>();
                for (JsonElement item : client) {
                    clientPresets.add(GsonHelper.m_13805_((JsonElement)item, (String)"preset name"));
                }
                for (JsonElement item : common) {
                    commonPresets.add(GsonHelper.m_13805_((JsonElement)item, (String)"preset name"));
                }
                for (JsonElement item : server) {
                    serverPresets.add(GsonHelper.m_13805_((JsonElement)item, (String)"preset name"));
                }
                return new PresetsDescriptor(clientPresets, commonPresets, serverPresets);
            }

            public JsonElement serialize(PresetsDescriptor src, Type typeOfSrc, JsonSerializationContext ctx) {
                JsonObject obj = new JsonObject();
                ArrayList<String> clientPresets = new ArrayList<String>(src.clientPresets);
                ArrayList<String> commonPresets = new ArrayList<String>(src.commonPresets);
                ArrayList<String> serverPresets = new ArrayList<String>(src.serverPresets);
                obj.add("client", ctx.serialize(clientPresets));
                obj.add("common", ctx.serialize(commonPresets));
                obj.add("server", ctx.serialize(serverPresets));
                return obj;
            }
        }
    }
}

