/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.WritingException;
import com.google.common.collect.Lists;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.config.ServerConfig;
import endorh.simpleconfig.core.SimpleConfigImpl;
import endorh.simpleconfig.core.SimpleConfigPaths;
import endorh.simpleconfig.core.SimpleConfigSnapshotHandler;
import endorh.simpleconfig.core.wrap.MinecraftServerConfigWrapper;
import endorh.simpleconfig.ui.api.ConfigScreenBuilder;
import endorh.simpleconfig.ui.gui.widget.PresetPickerWidget;
import endorh.simpleconfig.ui.hotkey.ConfigHotKeyLogger;
import endorh.simpleconfig.ui.hotkey.SavedHotKeyGroupPickerWidget;
import endorh.simpleconfig.yaml.SimpleConfigCommentedYamlFormat;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.naming.NoPermissionException;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.HandshakeHandler;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class SimpleConfigNetworkHandler {
    private static final String MINECRAFT_MOD_ID = "minecraft";
    public static Style ALLOWED_UPDATE_STYLE = Style.f_131099_.m_131157_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(true));
    public static Style DENIED_UPDATE_STYLE = Style.f_131099_.m_131157_(ChatFormatting.GOLD).m_131155_(Boolean.valueOf(true));
    public static Style ERROR_UPDATE_STYLE = Style.f_131099_.m_131157_(ChatFormatting.DARK_RED).m_131155_(Boolean.valueOf(true));
    public static Style REQUIRES_RESTART_STYLE = Style.f_131099_.m_131157_(ChatFormatting.DARK_PURPLE).m_131155_(Boolean.valueOf(true));
    public static Style ALLOWED_SNAPSHOT_UPDATE_STYLE = ALLOWED_UPDATE_STYLE;
    public static Style DENIED_SNAPSHOT_UPDATE_STYLE = DENIED_UPDATE_STYLE;
    private static final Method ModConfig$setConfigData;
    private static final Method ModConfig$fireEvent;
    private static final Constructor<ModConfigEvent.Reloading> Reloading$$init;
    private static final boolean reflectionSucceeded;
    private static final Logger LOGGER;
    private static final String CHANNEL_PROTOCOL_VERSION = "1";
    private static final ResourceLocation CHANNEL_NAME;
    private static final SimpleChannel CHANNEL;
    private static int ID_COUNT;
    private static int loginID;
    private static int dedicatedServerLoginID;
    private static boolean isConnectedToDedicatedServer;

    private static void broadcastToOperators(Component message) {
        ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_().stream().filter(p -> p.m_20310_(2)).forEach(p -> p.m_213846_(message));
    }

    @ApiStatus.Internal
    protected static void trySetConfigData(ModConfig config, CommentedConfig configData) {
        if (!reflectionSucceeded) {
            throw new ConfigUpdateReflectionError();
        }
        try {
            ModConfig$setConfigData.invoke((Object)config, configData);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ConfigUpdateReflectionError(e);
        }
    }

    @ApiStatus.Internal
    protected static void tryFireEvent(ModConfig config, ModConfigEvent event) {
        if (!reflectionSucceeded) {
            throw new ConfigUpdateReflectionError();
        }
        try {
            ModConfig$fireEvent.invoke((Object)config, event);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ConfigUpdateReflectionError(e);
        }
    }

    @ApiStatus.Internal
    protected static ModConfigEvent.Reloading newReloading(ModConfig config) {
        if (!reflectionSucceeded) {
            throw new ConfigUpdateReflectionError();
        }
        try {
            return Reloading$$init.newInstance(config);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ConfigUpdateReflectionError(e);
        }
    }

    private static void tryUpdateConfig(SimpleConfigImpl config, byte[] fileData, boolean set) {
        ModConfig modConfig = config.getModConfig();
        CommentedConfig sentConfig = SimpleConfigNetworkHandler.deserializeSnapshot(config, fileData);
        if (sentConfig == null) {
            return;
        }
        try {
            Map<String, ModConfig> extraConfigs = config.getExtraModConfigs();
            extraConfigs.forEach((id, extra) -> {
                Object sub = sentConfig.remove(id);
                if (sub instanceof CommentedConfig) {
                    CommentedConfig subConfig = (CommentedConfig)sub;
                    SimpleConfigNetworkHandler.putOrSet(set, extra, subConfig);
                }
                extra.getSpec().afterReload();
                SimpleConfigNetworkHandler.tryFireEvent(extra, (ModConfigEvent)SimpleConfigNetworkHandler.newReloading(extra));
            });
        }
        catch (ParsingException | IllegalStateException e) {
            LOGGER.error("Failed to parse synced server config for mod " + config.getModId(), e);
        }
        if (modConfig == null) {
            config.loadSnapshot(sentConfig, false, false);
        } else {
            try {
                SimpleConfigNetworkHandler.putOrSet(set, modConfig, sentConfig);
                modConfig.getSpec().afterReload();
                SimpleConfigNetworkHandler.tryFireEvent(modConfig, (ModConfigEvent)SimpleConfigNetworkHandler.newReloading(modConfig));
            }
            catch (ParsingException | IllegalStateException e) {
                LOGGER.error("Failed to parse synced server config for mod " + config.getModId(), e);
            }
        }
    }

    private static void putOrSet(boolean set, ModConfig config, CommentedConfig data) {
        if (set) {
            SimpleConfigNetworkHandler.trySetConfigData(config, data);
        } else {
            config.getConfigData().putAll((UnmodifiableConfig)data);
        }
    }

    protected static CommentedConfig deserializeSnapshot(SimpleConfigImpl config, byte[] fileData) {
        SimpleConfigCommentedYamlFormat format = config.getConfigFormat();
        try {
            return (CommentedConfig)format.createParser(false).parse(new ByteArrayInputStream(fileData));
        }
        catch (ParsingException | IllegalStateException e) {
            LOGGER.error("Failed to parse synced server config for mod " + config.getModId(), e);
            return null;
        }
    }

    protected static byte[] serializeSnapshot(SimpleConfigImpl config, @Nullable CommentedConfig snapshot) {
        try {
            if (snapshot == null) {
                snapshot = config.takeSnapshot(false, false);
            }
            if (snapshot instanceof CommentedFileConfig) {
                return Files.readAllBytes(((CommentedFileConfig)snapshot).getNioPath());
            }
            ByteArrayOutputStream arrayWriter = new ByteArrayOutputStream();
            SimpleConfigCommentedYamlFormat format = config.getConfigFormat();
            format.createWriter(false).write((UnmodifiableConfig)snapshot, arrayWriter);
            return arrayWriter.toByteArray();
        }
        catch (IOException error) {
            throw new RuntimeException("IO error reading config file", error);
        }
    }

    public static SimpleChannel getChannel() {
        return CHANNEL;
    }

    public static boolean isServerReady() {
        if (FMLEnvironment.dist != Dist.DEDICATED_SERVER) {
            return false;
        }
        return ServerLifecycleHooks.getCurrentServer() != null;
    }

    public static boolean isConnectedToSimpleConfigServer() {
        ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
        if (connection == null) {
            return false;
        }
        return SimpleConfigNetworkHandler.getChannel().isRemotePresent(connection.m_104910_());
    }

    public static boolean isConnectedToDedicatedServer() {
        return isConnectedToDedicatedServer;
    }

    @ApiStatus.Internal
    public static void registerPackets() {
        if (ID_COUNT != 0) {
            throw new IllegalStateException("Packets registered twice!");
        }
        SimpleConfigNetworkHandler.registerServer(SSimpleConfigSyncPacket::new);
        SimpleConfigNetworkHandler.registerServer(SSimpleConfigSavedPresetPacket::new);
        SimpleConfigNetworkHandler.registerServer(SSimpleConfigPresetListPacket::new);
        SimpleConfigNetworkHandler.registerServer(SSimpleConfigPresetPacket::new);
        SimpleConfigNetworkHandler.registerServer(SSimpleConfigSavedHotKeyGroupsPacket::new);
        SimpleConfigNetworkHandler.registerServer(SSavedHotKeyGroupPacket::new);
        SimpleConfigNetworkHandler.registerServer(SSaveRemoteHotKeyGroupPacket::new);
        SimpleConfigNetworkHandler.registerServer(SSimpleConfigServerCommonConfigPacket::new);
        SimpleConfigNetworkHandler.registerServer(SSimpleConfigPatchReportPacket::new);
        SimpleConfigNetworkHandler.registerServer(SSimpleConfigServerPropertiesPacket::new);
        SimpleConfigNetworkHandler.registerClient(CSimpleConfigSyncPacket::new);
        SimpleConfigNetworkHandler.registerClient(CSimpleConfigSavePresetPacket::new);
        SimpleConfigNetworkHandler.registerClient(CSimpleConfigRequestPresetListPacket::new);
        SimpleConfigNetworkHandler.registerClient(CSimpleConfigRequestPresetPacket::new);
        SimpleConfigNetworkHandler.registerClient(CSimpleConfigRequestSavedHotKeyGroupsPacket::new);
        SimpleConfigNetworkHandler.registerClient(CRequestSavedHotKeyGroupPacket::new);
        SimpleConfigNetworkHandler.registerClient(CSaveRemoteHotKeyGroupPacket::new);
        SimpleConfigNetworkHandler.registerClient(CSimpleConfigRequestServerCommonConfigPacket::new);
        SimpleConfigNetworkHandler.registerClient(CSimpleConfigSaveServerCommonConfigPacket::new);
        SimpleConfigNetworkHandler.registerClient(CSimpleConfigReleaseServerCommonConfigPacket::new);
        SimpleConfigNetworkHandler.registerClient(CSimpleConfigApplyPatchPacket::new);
        SimpleConfigNetworkHandler.registerClient(CSimpleConfigServerPropertiesRequestPacket::new);
        SimpleConfigNetworkHandler.registerLogin(CAcknowledgePacket::new);
        SimpleConfigNetworkHandler.registerLogin(SLoginConfigDataPacket::new, SimpleConfigNetworkHandler::getLoginConfigDataPackets);
        SimpleConfigNetworkHandler.registerLogin(SDedicatedServerLoginPacket::new, isLocal -> Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)MINECRAFT_MOD_ID, (Object)new SDedicatedServerLoginPacket(isLocal == false))}));
    }

    private static <Packet extends CAbstractPacket> void registerClient(Supplier<Packet> factory) {
        SimpleConfigNetworkHandler.registerMessage(factory, NetworkDirection.PLAY_TO_SERVER);
    }

    private static <Packet extends SAbstractPacket> void registerServer(Supplier<Packet> factory) {
        SimpleConfigNetworkHandler.registerMessage(factory, NetworkDirection.PLAY_TO_CLIENT);
    }

    private static <Packet extends AbstractPacket> void registerMessage(Supplier<Packet> factory, @Nullable NetworkDirection direction) {
        AbstractPacket msg = (AbstractPacket)factory.get();
        Class<?> msgClass = msg.getClass();
        CHANNEL.messageBuilder(msgClass, ID_COUNT++, direction).encoder(AbstractPacket::write).decoder(AbstractPacket.decoder(factory)).consumerMainThread(AbstractPacket::handle).add();
    }

    private static <Packet extends SAbstractLoginPacket> void registerLogin(Supplier<Packet> factory, Function<Boolean, List<Pair<String, Packet>>> packetListBuilder) {
        SAbstractLoginPacket msg = (SAbstractLoginPacket)factory.get();
        Class<?> msgClass = msg.getClass();
        CHANNEL.messageBuilder(msgClass, ID_COUNT++, NetworkDirection.LOGIN_TO_CLIENT).loginIndex(ILoginPacket::getLoginIndex, ILoginPacket::setLoginIndex).encoder(AbstractPacket::write).decoder(AbstractPacket.decoder(factory)).consumerMainThread(HandshakeHandler.biConsumerFor(SAbstractLoginPacket::handleWithReply)).buildLoginPacketList(packetListBuilder).add();
    }

    private static <Packet extends CAbstractLoginPacket> void registerLogin(Supplier<Packet> factory) {
        CAbstractLoginPacket msg = (CAbstractLoginPacket)factory.get();
        Class<?> msgClass = msg.getClass();
        CHANNEL.messageBuilder(msgClass, ID_COUNT++, NetworkDirection.LOGIN_TO_SERVER).loginIndex(ILoginPacket::getLoginIndex, ILoginPacket::setLoginIndex).encoder(AbstractPacket::write).decoder(AbstractPacket.decoder(factory)).consumerMainThread(HandshakeHandler.indexFirst(CAbstractLoginPacket::handle)).add();
    }

    protected static List<Pair<String, SLoginConfigDataPacket>> getLoginConfigDataPackets(boolean isLocal) {
        return SimpleConfigImpl.getConfigModIds().stream().map(id -> SimpleConfigImpl.hasConfig(id, SimpleConfig.Type.SERVER) ? SimpleConfigImpl.getConfig(id, SimpleConfig.Type.SERVER) : null).filter(c -> c != null && !c.isWrapper()).map(c -> Pair.of((Object)c.getModId(), (Object)new SLoginConfigDataPacket(c.getModId(), SimpleConfigNetworkHandler.serializeSnapshot(c, null)))).collect(Collectors.toList());
    }

    @ApiStatus.Internal
    public static CompletableFuture<CommentedConfig> requestServerCommonConfig(String modId) {
        if (!SimpleConfigNetworkHandler.isConnectedToSimpleConfigServer()) {
            return SimpleConfigSnapshotHandler.failedFuture(new IllegalStateException("Not connected to SimpleConfig server"));
        }
        CompletableFuture<CommentedConfig> future = new CompletableFuture<CommentedConfig>();
        new CSimpleConfigRequestServerCommonConfigPacket(modId, future).send();
        return future;
    }

    @ApiStatus.Internal
    public static void saveServerCommonConfig(String modId, SimpleConfigImpl config, boolean requiresRestart, CommentedConfig snapshot) {
        if (!SimpleConfigNetworkHandler.isConnectedToSimpleConfigServer()) {
            throw new IllegalStateException("Not connected to SimpleConfig server");
        }
        new CSimpleConfigSaveServerCommonConfigPacket(modId, requiresRestart, SimpleConfigNetworkHandler.serializeSnapshot(config, snapshot)).send();
    }

    @ApiStatus.Internal
    public static boolean applyRemoteSnapshot(SimpleConfigImpl config, CommentedConfig snapshot, List<Component> report) {
        if (!(SimpleConfigNetworkHandler.isConnectedToSimpleConfigServer() && config.getType().isRemote() && ((ServerConfig.ConfigPermission)((Object)ServerConfig.permissions.permissionFor(config.getModId()).getLeft())).canEdit())) {
            return false;
        }
        new CSimpleConfigApplyPatchPacket(config, snapshot, report).send();
        return true;
    }

    @ApiStatus.Internal
    protected static CompletableFuture<List<PresetPickerWidget.Preset>> requestPresetList(String modId) {
        if (!SimpleConfigNetworkHandler.isConnectedToSimpleConfigServer()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        CompletableFuture<List<PresetPickerWidget.Preset>> future = new CompletableFuture<List<PresetPickerWidget.Preset>>();
        new CSimpleConfigRequestPresetListPacket(modId, future).send();
        return future;
    }

    @ApiStatus.Internal
    protected static CompletableFuture<CommentedConfig> requestRemotePreset(String modId, SimpleConfig.Type type, String snapshotName) {
        if (!SimpleConfigNetworkHandler.isConnectedToSimpleConfigServer()) {
            return SimpleConfigSnapshotHandler.failedFuture(new IllegalStateException("Not connected to SimpleConfig server"));
        }
        CompletableFuture<CommentedConfig> future = new CompletableFuture<CommentedConfig>();
        Triple key = Triple.of((Object)modId, (Object)((Object)type), (Object)snapshotName);
        CompletableFuture<CommentedConfig> prev = CSimpleConfigRequestPresetPacket.FUTURES.get(key);
        if (prev != null) {
            prev.cancel(false);
        }
        CSimpleConfigRequestPresetPacket.FUTURES.put((Triple<String, SimpleConfig.Type, String>)key, future);
        new CSimpleConfigRequestPresetPacket(modId, type, snapshotName).send();
        return future;
    }

    @ApiStatus.Internal
    protected static CompletableFuture<Void> saveRemotePreset(String modId, SimpleConfig.Type type, String snapshotName, CommentedConfig config) {
        if (!SimpleConfigNetworkHandler.isConnectedToSimpleConfigServer()) {
            return SimpleConfigSnapshotHandler.failedFuture(new IllegalStateException("Not connected to SimpleConfig server"));
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        CSimpleConfigSavePresetPacket.FUTURES.put((Triple<String, SimpleConfig.Type, String>)Triple.of((Object)modId, (Object)((Object)type), (Object)snapshotName), future);
        try {
            new CSimpleConfigSavePresetPacket(modId, type, snapshotName, config).send();
        }
        catch (SimpleConfigSyncException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    @ApiStatus.Internal
    public static CompletableFuture<List<SavedHotKeyGroupPickerWidget.RemoteSavedHotKeyGroup>> getRemoteSavedHotKeyGroups() {
        if (!SimpleConfigNetworkHandler.isConnectedToSimpleConfigServer()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        CompletableFuture<List<SavedHotKeyGroupPickerWidget.RemoteSavedHotKeyGroup>> future = new CompletableFuture<List<SavedHotKeyGroupPickerWidget.RemoteSavedHotKeyGroup>>();
        new CSimpleConfigRequestSavedHotKeyGroupsPacket(future).send();
        return future;
    }

    @ApiStatus.Internal
    public static CompletableFuture<byte[]> getRemoteSavedHotKeyGroup(String name) {
        if (!SimpleConfigNetworkHandler.isConnectedToSimpleConfigServer()) {
            return SimpleConfigSnapshotHandler.failedFuture(new IllegalStateException("Not connected to SimpleConfig server"));
        }
        CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
        new CRequestSavedHotKeyGroupPacket(name, future).send();
        return future;
    }

    @ApiStatus.Internal
    public static CompletableFuture<Boolean> saveRemoteHotKeyGroup(String name, byte @Nullable [] data) {
        if (!SimpleConfigNetworkHandler.isConnectedToSimpleConfigServer()) {
            return SimpleConfigSnapshotHandler.failedFuture(new IllegalStateException("Not connected to SimpleConfig server"));
        }
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        new CSaveRemoteHotKeyGroupPacket(name, data, future).send();
        return future;
    }

    @ApiStatus.Internal
    public static CompletableFuture<Pair<Boolean, CommentedConfig>> requestServerProperties() {
        if (!SimpleConfigNetworkHandler.isConnectedToSimpleConfigServer()) {
            return SimpleConfigSnapshotHandler.failedFuture(new IllegalStateException("Not connected to SimpleConfig server"));
        }
        CompletableFuture<Pair<Boolean, CommentedConfig>> future = new CompletableFuture<Pair<Boolean, CommentedConfig>>();
        CSimpleConfigServerPropertiesRequestPacket.FUTURE = future;
        new CSimpleConfigServerPropertiesRequestPacket().send();
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        LOGGER = LogManager.getLogger();
        String errorFmt = "Could not access %s by reflection\nSimpleConfig won't be able to sync server config modifications in-game";
        boolean success = false;
        Method setConfigData = null;
        String member = null;
        Method fireEvent = null;
        Constructor reloading = null;
        try {
            member = "ModConfig$setConfigData method";
            setConfigData = ModConfig.class.getDeclaredMethod("setConfigData", CommentedConfig.class);
            setConfigData.setAccessible(true);
            member = "ModConfig$fireEvent method";
            fireEvent = ModConfig.class.getDeclaredMethod("fireEvent", IConfigEvent.class);
            fireEvent.setAccessible(true);
            member = "ModConfig$Reloading constructor";
            reloading = ModConfigEvent.Reloading.class.getDeclaredConstructor(ModConfig.class);
            reloading.setAccessible(true);
            success = true;
        }
        catch (NoSuchMethodException e) {
            LOGGER.error(String.format("Could not access %s by reflection\nSimpleConfig won't be able to sync server config modifications in-game", member));
        }
        finally {
            ModConfig$setConfigData = setConfigData;
            ModConfig$fireEvent = fireEvent;
            Reloading$$init = reloading;
            reflectionSucceeded = success;
        }
        CHANNEL_NAME = new ResourceLocation("simpleconfig", "config");
        CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)CHANNEL_NAME, () -> CHANNEL_PROTOCOL_VERSION, CHANNEL_PROTOCOL_VERSION::equals, CHANNEL_PROTOCOL_VERSION::equals);
        ID_COUNT = 0;
        loginID = 0;
        dedicatedServerLoginID = -1;
        isConnectedToDedicatedServer = false;
    }

    public static class ConfigUpdateReflectionError
    extends RuntimeException {
        private ConfigUpdateReflectionError(Throwable cause) {
            super("Something went wrong updating the server configs", cause);
        }

        private ConfigUpdateReflectionError() {
            super("Something went wrong updating the server configs");
        }
    }

    protected static abstract class AbstractPacket {
        protected AbstractPacket() {
        }

        protected abstract void handle(Supplier<NetworkEvent.Context> var1);

        public abstract void write(FriendlyByteBuf var1);

        public abstract void read(FriendlyByteBuf var1);

        public static <Packet extends AbstractPacket> Function<FriendlyByteBuf, Packet> decoder(Supplier<Packet> factory) {
            return buf -> {
                AbstractPacket p = (AbstractPacket)factory.get();
                p.read((FriendlyByteBuf)buf);
                return p;
            };
        }
    }

    protected static abstract class SAbstractLoginPacket
    extends SAbstractPacket
    implements ILoginPacket {
        private int loginIndex;

        protected SAbstractLoginPacket() {
        }

        @Override
        public int getLoginIndex() {
            return this.loginIndex;
        }

        @Override
        public void setLoginIndex(int loginIndex) {
            this.loginIndex = loginIndex;
        }

        public void handle(HandshakeHandler handler, Supplier<NetworkEvent.Context> ctxSupplier) {
            this.handle(ctxSupplier);
        }

        public void handleWithReply(HandshakeHandler handler, Supplier<NetworkEvent.Context> ctxSupplier) {
            this.handleWithReply(ctxSupplier);
        }

        public static void handle(HandshakeHandler handler, SAbstractLoginPacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
            packet.handle(handler, ctxSupplier);
        }

        public static void handleWithReply(HandshakeHandler handler, SAbstractLoginPacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
            packet.handleWithReply(handler, ctxSupplier);
        }
    }

    protected static abstract class CAbstractLoginPacket
    extends CAbstractPacket
    implements ILoginPacket {
        private int loginIndex;

        protected CAbstractLoginPacket() {
        }

        @Override
        public int getLoginIndex() {
            return this.loginIndex;
        }

        @Override
        public void setLoginIndex(int loginIndex) {
            this.loginIndex = loginIndex;
        }

        public void handle(HandshakeHandler handler, Supplier<NetworkEvent.Context> ctxSupplier) {
            this.handle(ctxSupplier);
        }

        public static void handle(HandshakeHandler handler, CAbstractLoginPacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
            packet.handle(handler, ctxSupplier);
        }
    }

    protected static class CSimpleConfigRequestServerCommonConfigPacket
    extends CAbstractPacket {
        public static Map<String, CompletableFuture<CommentedConfig>> FUTURES = new HashMap<String, CompletableFuture<CommentedConfig>>();
        private String modId;

        public CSimpleConfigRequestServerCommonConfigPacket() {
        }

        public CSimpleConfigRequestServerCommonConfigPacket(String modId, CompletableFuture<CommentedConfig> future) {
            this.modId = modId;
            CompletableFuture<CommentedConfig> prev = FUTURES.get(modId);
            if (prev != null) {
                prev.cancel(false);
            }
            FUTURES.put(modId, future);
        }

        @Override
        public void onServer(NetworkEvent.Context ctx) {
            ServerPlayer sender = ctx.getSender();
            String modName = SimpleConfigImpl.getModNameOrId(this.modId);
            if (sender == null) {
                throw new IllegalStateException("Received server config update from non-player source for mod \"" + modName + "\"");
            }
            String senderName = sender.m_6302_();
            if (!SimpleConfigImpl.hasConfig(this.modId, SimpleConfig.Type.COMMON) || !((ServerConfig.ConfigPermission)((Object)ServerConfig.permissions.permissionFor((Player)sender, this.modId).getLeft())).canView()) {
                new SSimpleConfigServerCommonConfigPacket(this.modId, null).sendTo(sender);
            } else {
                SimpleConfigImpl config = SimpleConfigImpl.getConfig(this.modId, SimpleConfig.Type.COMMON);
                config.addRemoteListener((Player)sender);
                byte[] snapshot = SimpleConfigNetworkHandler.serializeSnapshot(config, null);
                new SSimpleConfigServerCommonConfigPacket(this.modId, snapshot).sendTo(sender);
                LOGGER.info("Sending server common config for mod \"" + modName + "\" to player \"" + senderName + "\"");
            }
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.m_130070_(this.modId);
        }

        @Override
        public void read(FriendlyByteBuf buf) {
            this.modId = buf.m_130136_(Short.MAX_VALUE);
        }
    }

    protected static class CSimpleConfigSaveServerCommonConfigPacket
    extends CAbstractPacket {
        private String modId;
        private boolean requireRestart;
        private byte @Nullable [] snapshot;

        public CSimpleConfigSaveServerCommonConfigPacket() {
        }

        public CSimpleConfigSaveServerCommonConfigPacket(String modId, boolean requireRestart, byte @Nullable [] snapshot) {
            this.modId = modId;
            this.requireRestart = requireRestart;
            this.snapshot = snapshot;
        }

        @Override
        public void onServer(NetworkEvent.Context ctx) {
            ServerPlayer sender = ctx.getSender();
            String modName = SimpleConfigImpl.getModNameOrId(this.modId);
            if (sender == null) {
                throw new IllegalStateException("Received server config update from non-player source for mod \"" + modName + "\"");
            }
            String senderName = sender.m_6302_();
            if (!SimpleConfigImpl.hasConfig(this.modId, SimpleConfig.Type.COMMON)) {
                return;
            }
            if (!((ServerConfig.ConfigPermission)((Object)ServerConfig.permissions.permissionFor((Player)sender, this.modId).getLeft())).canEdit()) {
                LOGGER.warn("Player \"" + senderName + "\" attempted to save server common config for mod \"" + modName + "\"");
                SimpleConfigNetworkHandler.broadcastToOperators((Component)Component.m_237110_((String)"simpleconfig.config.msg.tried_to_update_by", (Object[])new Object[]{senderName, modName}).m_130948_(DENIED_UPDATE_STYLE));
                return;
            }
            try {
                SimpleConfigImpl config = SimpleConfigImpl.getConfig(this.modId, SimpleConfig.Type.COMMON);
                SimpleConfigNetworkHandler.tryUpdateConfig(config, this.snapshot, false);
            }
            catch (ConfigUpdateReflectionError e) {
                e.printStackTrace();
                LOGGER.error("Error updating server config for mod \"" + modName + "\"");
                SimpleConfigNetworkHandler.broadcastToOperators((Component)Component.m_237110_((String)"simpleconfig.config.msg.error_updating_by", (Object[])new Object[]{modName, senderName, e.getMessage()}).m_130948_(ERROR_UPDATE_STYLE));
                return;
            }
            LOGGER.info("Server common config for mod \"" + modName + "\" has been updated by authorized player \"" + senderName + "\"");
            MutableComponent msg = Component.m_237110_((String)"simpleconfig.config.msg.updated_by", (Object[])new Object[]{modName, senderName}).m_130948_(ALLOWED_UPDATE_STYLE);
            if (this.requireRestart) {
                msg = msg.m_130946_("\n").m_7220_((Component)Component.m_237115_((String)"simpleconfig.config.msg.server_changes_require_restart").m_130948_(REQUIRES_RESTART_STYLE));
            }
            SimpleConfigNetworkHandler.broadcastToOperators((Component)msg);
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.m_130070_(this.modId);
            buf.writeBoolean(this.requireRestart);
            buf.writeBoolean(this.snapshot != null);
            if (this.snapshot != null) {
                buf.m_130087_(this.snapshot);
            }
        }

        @Override
        public void read(FriendlyByteBuf buf) {
            this.modId = buf.m_130136_(Short.MAX_VALUE);
            this.requireRestart = buf.readBoolean();
            this.snapshot = buf.readBoolean() ? buf.m_130052_() : null;
        }
    }

    protected static class CSimpleConfigApplyPatchPacket
    extends CAbstractPacket {
        private String modId;
        private SimpleConfig.Type type;
        private List<Component> report;
        private byte @Nullable [] snapshot;

        public CSimpleConfigApplyPatchPacket() {
        }

        public CSimpleConfigApplyPatchPacket(SimpleConfigImpl config, CommentedConfig snapshot, List<Component> report) {
            this.modId = config.getModId();
            this.type = config.getType();
            this.snapshot = SimpleConfigNetworkHandler.serializeSnapshot(config, snapshot);
            this.report = report;
        }

        @Override
        public void onServer(NetworkEvent.Context ctx) {
            ServerPlayer sender = ctx.getSender();
            String modName = SimpleConfigImpl.getModNameOrId(this.modId);
            if (sender == null) {
                throw new IllegalStateException("Received server config update from non-player source for mod \"" + modName + "\"");
            }
            String senderName = sender.m_6302_();
            if (!SimpleConfigImpl.hasConfig(this.modId, this.type)) {
                return;
            }
            if (!((ServerConfig.ConfigPermission)((Object)ServerConfig.permissions.permissionFor((Player)sender, this.modId).getLeft())).canEdit()) {
                LOGGER.warn("Player \"" + senderName + "\" attempted to apply patch to config for mod \"" + modName + "\"");
                return;
            }
            try {
                SimpleConfigImpl config = SimpleConfigImpl.getConfig(this.modId, this.type);
                SimpleConfigNetworkHandler.tryUpdateConfig(config, this.snapshot, false);
            }
            catch (ConfigUpdateReflectionError e) {
                e.printStackTrace();
                LOGGER.error("Error applying snapshot to config for mod \"" + modName + "\"");
                SimpleConfigNetworkHandler.broadcastToOperators((Component)Component.m_237110_((String)"simpleconfig.config.msg.error_updating_by", (Object[])new Object[]{modName, senderName, e.getMessage()}).m_130948_(ERROR_UPDATE_STYLE));
                return;
            }
            LOGGER.info("Snapshot applied to config for mod \"" + modName + "\" by player " + sender);
            if (this.report.isEmpty()) {
                SimpleConfigNetworkHandler.broadcastToOperators((Component)Component.m_237110_((String)"simpleconfig.config.msg.patched_by", (Object[])new Object[]{modName, senderName}).m_130948_(ALLOWED_UPDATE_STYLE));
            } else {
                new SSimpleConfigPatchReportPacket((Component)Component.m_237110_((String)"simpleconfig.hotkey.remote", (Object[])new Object[]{sender.m_7755_()}), this.report).sendToOpsExcept(sender);
            }
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.m_130070_(this.modId);
            buf.m_130068_((Enum)this.type);
            buf.writeBoolean(this.snapshot != null);
            if (this.snapshot != null) {
                buf.m_130087_(this.snapshot);
            }
            buf.m_130130_(this.report.size());
            this.report.forEach(arg_0 -> ((FriendlyByteBuf)buf).m_130083_(arg_0));
        }

        @Override
        public void read(FriendlyByteBuf buf) {
            this.modId = buf.m_130136_(Short.MAX_VALUE);
            this.type = (SimpleConfig.Type)buf.m_130066_(SimpleConfig.Type.class);
            this.snapshot = buf.readBoolean() ? buf.m_130052_() : null;
            int size = buf.m_130242_();
            ArrayList<Component> report = new ArrayList<Component>(size);
            for (int i = 0; i < size; ++i) {
                report.add(buf.m_130238_());
            }
            this.report = report;
        }
    }

    protected static class CSimpleConfigRequestPresetListPacket
    extends CAbstractPacket {
        private static final Map<String, CompletableFuture<List<PresetPickerWidget.Preset>>> FUTURES = new HashMap<String, CompletableFuture<List<PresetPickerWidget.Preset>>>();
        protected String modId;

        public CSimpleConfigRequestPresetListPacket() {
        }

        public CSimpleConfigRequestPresetListPacket(String modId, CompletableFuture<List<PresetPickerWidget.Preset>> future) {
            this.modId = modId;
            CompletableFuture<List<PresetPickerWidget.Preset>> prev = FUTURES.get(modId);
            if (prev != null) {
                prev.cancel(true);
            }
            FUTURES.put(modId, future);
        }

        @Override
        public void onServer(NetworkEvent.Context ctx) {
            ServerPlayer sender = ctx.getSender();
            if (sender == null) {
                return;
            }
            File dir = SimpleConfigPaths.getRemotePresetsDir().toFile();
            if (!dir.isDirectory()) {
                return;
            }
            Pattern pat = Pattern.compile("^(?<file>" + Pattern.quote(this.modId) + "-(?<type>\\w++)-(?<name>.*)\\.yaml)$");
            File[] files = dir.listFiles((d, name) -> pat.matcher(name).matches());
            if (files == null) {
                return;
            }
            List<PresetPickerWidget.Preset> names = Arrays.stream(files).map(f -> {
                Matcher m = pat.matcher(f.getName());
                if (!m.matches()) {
                    return null;
                }
                return PresetPickerWidget.Preset.remote(m.group("name"), SimpleConfig.Type.fromAlias(m.group("type")));
            }).filter(Objects::nonNull).collect(Collectors.toList());
            LOGGER.info("Sending server preset list for mod \"" + this.modId + "\" to player \"" + sender.m_6302_() + "\"");
            new SSimpleConfigPresetListPacket(this.modId, names).sendTo(sender);
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.m_130070_(this.modId);
        }

        @Override
        public void read(FriendlyByteBuf buf) {
            this.modId = buf.m_130136_(Short.MAX_VALUE);
        }
    }

    protected static class CSimpleConfigRequestPresetPacket
    extends CAbstractPacket {
        protected static final Map<Triple<String, SimpleConfig.Type, String>, CompletableFuture<CommentedConfig>> FUTURES = new HashMap<Triple<String, SimpleConfig.Type, String>, CompletableFuture<CommentedConfig>>();
        protected String modId;
        protected SimpleConfig.Type type;
        protected String presetName;

        public CSimpleConfigRequestPresetPacket() {
        }

        public CSimpleConfigRequestPresetPacket(String modId, SimpleConfig.Type type, String presetName) {
            this.modId = modId;
            this.type = type;
            this.presetName = presetName;
        }

        @Override
        public void onServer(NetworkEvent.Context ctx) {
            String tt;
            String fileName;
            ServerPlayer sender = ctx.getSender();
            if (sender == null) {
                return;
            }
            Path dir = SimpleConfigPaths.getRemotePresetsDir();
            File file = dir.resolve(fileName = this.modId + "-" + (tt = this.type.getAlias()) + "-" + this.presetName + ".yaml").toFile();
            if (!file.isFile()) {
                new SSimpleConfigPresetPacket(this.modId, this.type, this.presetName, null, "File does not exist").sendTo(sender);
            }
            try {
                new SSimpleConfigPresetPacket(this.modId, this.type, this.presetName, FileUtils.readFileToByteArray((File)file), null).sendTo(sender);
            }
            catch (IOException e) {
                new SSimpleConfigPresetPacket(this.modId, this.type, this.presetName, null, e.getMessage()).sendTo(sender);
            }
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.m_130070_(this.modId);
            buf.m_130068_((Enum)this.type);
            buf.m_130070_(this.presetName);
        }

        @Override
        public void read(FriendlyByteBuf buf) {
            this.modId = buf.m_130136_(Short.MAX_VALUE);
            this.type = (SimpleConfig.Type)buf.m_130066_(SimpleConfig.Type.class);
            this.presetName = buf.m_130136_(Short.MAX_VALUE);
        }
    }

    protected static class CSimpleConfigSavePresetPacket
    extends CAbstractPacket {
        public static Map<Triple<String, SimpleConfig.Type, String>, CompletableFuture<Void>> FUTURES = new HashMap<Triple<String, SimpleConfig.Type, String>, CompletableFuture<Void>>();
        protected String modId;
        protected SimpleConfig.Type type;
        protected String presetName;
        protected byte @Nullable [] fileData;

        public CSimpleConfigSavePresetPacket() {
        }

        public CSimpleConfigSavePresetPacket(String modId, SimpleConfig.Type type, String presetName, @Nullable CommentedConfig data) {
            this.modId = modId;
            this.type = type;
            this.presetName = presetName;
            if (data != null) {
                SimpleConfigImpl config = SimpleConfigImpl.getConfig(modId, SimpleConfig.Type.SERVER);
                SimpleConfigCommentedYamlFormat format = config.getConfigFormat();
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                try {
                    format.createWriter(false).write((UnmodifiableConfig)data, os);
                }
                catch (WritingException e) {
                    throw new SimpleConfigSyncException("Error writing config snapshot", e);
                }
                this.fileData = os.toByteArray();
            } else {
                this.fileData = null;
            }
        }

        @Override
        public void onServer(NetworkEvent.Context ctx) {
            ServerPlayer sender = ctx.getSender();
            if (sender == null) {
                LOGGER.error("Received server config preset from non-player source for mod \"" + this.modId + "\"");
                return;
            }
            String tt = this.type.getAlias();
            String presetName = tt + "-" + this.presetName;
            String fileName = this.modId + "-" + presetName + ".yaml";
            String action = this.fileData == null ? "delete" : "save";
            SimpleConfigImpl.getConfig(this.modId, SimpleConfig.Type.SERVER);
            String modName = SimpleConfigImpl.getModNameOrId(this.modId);
            String senderName = sender.m_6302_();
            try {
                if (!((ServerConfig.PresetPermission)((Object)ServerConfig.permissions.permissionFor((Player)sender, this.modId).getRight())).canSave()) {
                    throw new NoPermissionException("No permission for server presets for mod " + modName);
                }
                Path dir = SimpleConfigPaths.getRemotePresetsDir();
                File dest = dir.resolve(fileName).toFile();
                if (this.fileData != null) {
                    if (dest.isDirectory()) {
                        throw new IllegalStateException("File already exists and is a directory");
                    }
                    FileUtils.writeByteArrayToFile((File)dest, (byte[])this.fileData);
                } else {
                    BasicFileAttributes attr = Files.readAttributes(dest.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                    if (attr.isDirectory()) {
                        throw new IllegalStateException("File is a directory");
                    }
                    if (!dest.exists() || !attr.isRegularFile()) {
                        throw new IllegalArgumentException("File does not exist");
                    }
                    if (!dest.delete()) {
                        throw new IllegalStateException("Unable to delete file");
                    }
                }
                SimpleConfigNetworkHandler.broadcastToOperators((Component)Component.m_237110_((String)("simpleconfig.config.msg.snapshot." + tt + "." + action + "d_by"), (Object[])new Object[]{this.presetName, modName, senderName}).m_130948_(ALLOWED_SNAPSHOT_UPDATE_STYLE));
                LOGGER.info("Server config preset \"" + presetName + "\" for mod \"" + modName + "\" has been " + action + "d by player \"" + senderName + "\"");
                new SSimpleConfigSavedPresetPacket(this.modId, this.type, this.presetName, null).sendTo(sender);
            }
            catch (IOException | RuntimeException e) {
                SimpleConfigNetworkHandler.broadcastToOperators((Component)Component.m_237110_((String)"simpleconfig.config.msg.snapshot.error_updating_by", (Object[])new Object[]{this.presetName, modName, senderName, e.getMessage()}).m_130948_(ERROR_UPDATE_STYLE));
                LOGGER.error("Error " + (this.fileData != null ? "saving" : "deleting") + " server config preset for mod \"" + modName + "\"");
                new SSimpleConfigSavedPresetPacket(this.modId, this.type, this.presetName, e.getClass().getSimpleName() + ": " + e.getMessage()).sendTo(sender);
            }
            catch (NoPermissionException e) {
                SimpleConfigNetworkHandler.broadcastToOperators((Component)Component.m_237110_((String)("simpleconfig.config.msg.snapshot." + tt + ".tried_to_" + action), (Object[])new Object[]{senderName, this.presetName, modName}).m_130948_(DENIED_SNAPSHOT_UPDATE_STYLE));
                LOGGER.warn("Player \"" + senderName + "\" tried to " + action + " a preset for the server config for mod \"" + modName + "\" without privileges");
                new SSimpleConfigSavedPresetPacket(this.modId, this.type, this.presetName, e.getClass().getSimpleName() + ": " + e.getMessage()).sendTo(sender);
            }
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.m_130070_(this.modId);
            buf.m_130068_((Enum)this.type);
            buf.m_130070_(this.presetName);
            buf.writeBoolean(this.fileData != null);
            if (this.fileData != null) {
                buf.m_130087_(this.fileData);
            }
        }

        @Override
        public void read(FriendlyByteBuf buf) {
            this.modId = buf.m_130136_(Short.MAX_VALUE);
            this.type = (SimpleConfig.Type)buf.m_130066_(SimpleConfig.Type.class);
            this.presetName = buf.m_130136_(Short.MAX_VALUE);
            this.fileData = buf.readBoolean() ? buf.m_130052_() : null;
        }
    }

    public static class SimpleConfigSyncException
    extends RuntimeException {
        public SimpleConfigSyncException(String message) {
            super(message);
        }

        public SimpleConfigSyncException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    protected static class CSimpleConfigRequestSavedHotKeyGroupsPacket
    extends CAbstractPacket {
        protected static CompletableFuture<List<SavedHotKeyGroupPickerWidget.RemoteSavedHotKeyGroup>> future = null;

        public CSimpleConfigRequestSavedHotKeyGroupsPacket() {
        }

        public CSimpleConfigRequestSavedHotKeyGroupsPacket(CompletableFuture<List<SavedHotKeyGroupPickerWidget.RemoteSavedHotKeyGroup>> future) {
            CSimpleConfigRequestSavedHotKeyGroupsPacket.future = future;
        }

        @Override
        public void onServer(NetworkEvent.Context ctx) {
            ServerPlayer sender = ctx.getSender();
            if (sender == null) {
                return;
            }
            File dir = SimpleConfigPaths.getRemoteHotKeyGroupsDir().toFile();
            if (!dir.isDirectory()) {
                return;
            }
            Pattern pat = Pattern.compile("^(?<name>.*)\\.yaml$");
            File[] files = dir.listFiles((d, name) -> pat.matcher(name).matches());
            if (files == null) {
                return;
            }
            List<SavedHotKeyGroupPickerWidget.RemoteSavedHotKeyGroup> groups = Arrays.stream(files).map(f -> {
                Matcher m = pat.matcher(f.getName());
                if (!m.matches()) {
                    return null;
                }
                return SavedHotKeyGroupPickerWidget.SavedHotKeyGroup.remote(m.group("name"));
            }).filter(Objects::nonNull).collect(Collectors.toList());
            new SSimpleConfigSavedHotKeyGroupsPacket(groups).sendTo(sender);
        }

        @Override
        public void write(FriendlyByteBuf buf) {
        }

        @Override
        public void read(FriendlyByteBuf buf) {
        }
    }

    protected static class CRequestSavedHotKeyGroupPacket
    extends CAbstractPacket {
        private static final Map<String, CompletableFuture<byte[]>> FUTURES = new HashMap<String, CompletableFuture<byte[]>>();
        private String name;

        public CRequestSavedHotKeyGroupPacket() {
        }

        public CRequestSavedHotKeyGroupPacket(String name, CompletableFuture<byte[]> future) {
            this.name = name;
            FUTURES.put(name, future);
        }

        @Override
        public void onServer(NetworkEvent.Context ctx) {
            ServerPlayer sender = ctx.getSender();
            if (sender == null) {
                return;
            }
            String fileName = this.name + ".yaml";
            File file = SimpleConfigPaths.getRemoteHotKeyGroupsDir().resolve(fileName).toFile();
            if (!file.isFile()) {
                new SSavedHotKeyGroupPacket(this.name, "Cannot find hotkey group " + this.name).sendTo(sender);
            }
            try {
                byte[] bytes = FileUtils.readFileToByteArray((File)file);
                new SSavedHotKeyGroupPacket(this.name, bytes).sendTo(sender);
            }
            catch (IOException e) {
                new SSavedHotKeyGroupPacket(this.name, e.getLocalizedMessage()).sendTo(sender);
            }
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.m_130070_(this.name);
        }

        @Override
        public void read(FriendlyByteBuf buf) {
            this.name = buf.m_130136_(Short.MAX_VALUE);
        }
    }

    protected static class CSaveRemoteHotKeyGroupPacket
    extends CAbstractPacket {
        private static final Map<String, CompletableFuture<Boolean>> FUTURES = new HashMap<String, CompletableFuture<Boolean>>();
        private String name;
        private byte @Nullable [] data;

        public CSaveRemoteHotKeyGroupPacket() {
        }

        public CSaveRemoteHotKeyGroupPacket(String name, byte @Nullable [] data, CompletableFuture<Boolean> future) {
            this.name = name;
            this.data = data;
            FUTURES.put(name, future);
        }

        @Override
        public void onServer(NetworkEvent.Context ctx) {
            ServerPlayer sender = ctx.getSender();
            if (sender == null) {
                return;
            }
            if (!ServerConfig.permissions.canEditServerHotKeys((Player)sender)) {
                LOGGER.warn("Attempt to " + (this.data != null ? "write" : "delete") + " server saved hotkey group \"" + this.name + "\" by player " + sender.m_6302_() + " denied");
                new SSaveRemoteHotKeyGroupPacket(this.name, "No permission to write server hotkeys").sendTo(sender);
            }
            LOGGER.info((this.data != null ? "Writing" : "Deleting") + " server saved hotkey group \"" + this.name + "\" by player " + sender.m_6302_());
            String fileName = this.name + ".yaml";
            File file = SimpleConfigPaths.getRemoteHotKeyGroupsDir().resolve(fileName).toFile();
            if (this.data == null) {
                if (!file.delete()) {
                    LOGGER.warn("Failed to delete server saved hotkey group \"" + this.name + "\"");
                    new SSaveRemoteHotKeyGroupPacket(this.name, "Cannot delete file " + fileName).sendTo(sender);
                }
                LOGGER.info("Successfully deleted server saved hotkey group \"" + this.name + "\"");
                new SSaveRemoteHotKeyGroupPacket(this.name).sendTo(sender);
            } else {
                try {
                    FileUtils.writeByteArrayToFile((File)file, (byte[])this.data);
                    LOGGER.info("Successfully saved server saved hotkey group \"" + this.name + "\"");
                    new SSaveRemoteHotKeyGroupPacket(this.name).sendTo(sender);
                }
                catch (IOException e) {
                    LOGGER.warn("Error saving server saved hotkey group \"" + this.name + "\"", (Throwable)e);
                    new SSaveRemoteHotKeyGroupPacket(this.name, e.getLocalizedMessage()).sendTo(sender);
                }
            }
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.m_130070_(this.name);
            buf.writeBoolean(this.data != null);
            if (this.data != null) {
                buf.m_130087_(this.data);
            }
        }

        @Override
        public void read(FriendlyByteBuf buf) {
            this.name = buf.m_130136_(Short.MAX_VALUE);
            this.data = buf.readBoolean() ? buf.m_130052_() : null;
        }
    }

    public static class CSimpleConfigServerPropertiesRequestPacket
    extends CAbstractPacket {
        private static CompletableFuture<Pair<Boolean, CommentedConfig>> FUTURE;

        @Override
        public void onServer(NetworkEvent.Context ctx) {
            ServerPlayer sender = ctx.getSender();
            if (sender == null) {
                LOGGER.warn("Received server properties request packet from null sender");
                return;
            }
            boolean dedicated = ServerLifecycleHooks.getCurrentServer().m_6982_();
            if (dedicated && ServerConfig.permissions.canAccessServerProperties((Player)sender)) {
                SimpleConfigImpl config = SimpleConfigImpl.getConfigOrNull(SimpleConfigNetworkHandler.MINECRAFT_MOD_ID, SimpleConfig.Type.SERVER);
                if (config != null) {
                    CommentedConfig snapshot = config.takeSnapshot(false, false, p -> p.startsWith("properties."));
                    if (!snapshot.isEmpty()) {
                        new SSimpleConfigServerPropertiesPacket(MinecraftServerConfigWrapper.areProtectedPropertiesEditable(), SimpleConfigNetworkHandler.serializeSnapshot(config, snapshot)).sendTo(sender);
                        return;
                    }
                    LOGGER.warn("No server properties to serialize");
                } else {
                    LOGGER.warn("Could not serialize server properties because Minecraft config wrapper is null");
                }
            } else if (dedicated) {
                LOGGER.info("Server properties not sent to player " + sender.m_6302_() + " as they don't have permission to access them.");
            }
            new SSimpleConfigServerPropertiesPacket(false, null).sendTo(sender);
        }

        @Override
        public void write(FriendlyByteBuf buf) {
        }

        @Override
        public void read(FriendlyByteBuf buf) {
        }
    }

    public static class SLoginConfigDataPacket
    extends SAbstractLoginPacket {
        private String modId;
        private byte[] fileData;

        public SLoginConfigDataPacket() {
        }

        public SLoginConfigDataPacket(String modId, byte[] fileData) {
            this.modId = modId;
            this.fileData = fileData;
        }

        @Override
        public void onClient(NetworkEvent.Context ctx) {
            if (!Minecraft.m_91087_().m_91090_()) {
                SimpleConfigImpl config = SimpleConfigImpl.getConfig(this.modId, SimpleConfig.Type.SERVER);
                SimpleConfigNetworkHandler.tryUpdateConfig(config, this.fileData, true);
            }
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.m_130070_(this.modId);
            buf.m_130087_(this.fileData);
        }

        @Override
        public void read(FriendlyByteBuf buf) {
            this.modId = buf.m_130136_(Short.MAX_VALUE);
            this.fileData = buf.m_130052_();
        }
    }

    protected static class SDedicatedServerLoginPacket
    extends SAbstractLoginPacket {
        private boolean isDedicatedServer;

        public SDedicatedServerLoginPacket() {
        }

        public SDedicatedServerLoginPacket(boolean isDedicatedServer) {
            this.isDedicatedServer = isDedicatedServer;
        }

        @Override
        public void onClient(NetworkEvent.Context ctx) {
            if (this.isDedicatedServer) {
                dedicatedServerLoginID = loginID;
            }
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.writeBoolean(this.isDedicatedServer);
        }

        @Override
        public void read(FriendlyByteBuf buf) {
            this.isDedicatedServer = buf.readBoolean();
        }
    }

    public static class SimpleConfigPermissionException
    extends RuntimeException {
        public SimpleConfigPermissionException(String message) {
            super(message);
        }

        public SimpleConfigPermissionException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class SSimpleConfigServerPropertiesPacket
    extends SAbstractPacket {
        private boolean protectedProperties;
        private byte @Nullable [] data;

        public SSimpleConfigServerPropertiesPacket() {
        }

        public SSimpleConfigServerPropertiesPacket(boolean protectedProperties, byte @Nullable [] data) {
            this.protectedProperties = protectedProperties;
            this.data = data;
        }

        @Override
        public void onClient(NetworkEvent.Context ctx) {
            CommentedConfig snapshot;
            SimpleConfigImpl config = SimpleConfigImpl.getConfigOrNull(SimpleConfigNetworkHandler.MINECRAFT_MOD_ID, SimpleConfig.Type.SERVER);
            CompletableFuture<Pair<Boolean, CommentedConfig>> future = CSimpleConfigServerPropertiesRequestPacket.FUTURE;
            CSimpleConfigServerPropertiesRequestPacket.FUTURE = null;
            if (config != null && this.data != null && (snapshot = SimpleConfigNetworkHandler.deserializeSnapshot(config, this.data)) != null) {
                future.complete((Pair<Boolean, CommentedConfig>)Pair.of((Object)this.protectedProperties, (Object)snapshot));
            }
            if (!future.isDone()) {
                future.completeExceptionally(new SimpleConfigPermissionException("Cannot fetch server properties"));
            }
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.writeBoolean(this.protectedProperties);
            buf.writeBoolean(this.data != null);
            if (this.data != null) {
                buf.m_130087_(this.data);
            }
        }

        @Override
        public void read(FriendlyByteBuf buf) {
            this.protectedProperties = buf.readBoolean();
            this.data = buf.readBoolean() ? buf.m_130052_() : null;
        }
    }

    protected static class SSaveRemoteHotKeyGroupPacket
    extends SAbstractPacket {
        private String name;
        @Nullable
        private String errorMsg;

        public SSaveRemoteHotKeyGroupPacket() {
        }

        public SSaveRemoteHotKeyGroupPacket(String name, @Nullable String errorMsg) {
            this.name = name;
            this.errorMsg = errorMsg;
        }

        public SSaveRemoteHotKeyGroupPacket(String name) {
            this(name, null);
        }

        @Override
        public void onClient(NetworkEvent.Context ctx) {
            CompletableFuture<Boolean> future = CSaveRemoteHotKeyGroupPacket.FUTURES.get(this.name);
            if (future != null && !future.isDone()) {
                if (this.errorMsg != null) {
                    future.completeExceptionally(new RemoteException(this.errorMsg));
                } else {
                    future.complete(true);
                }
            }
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.m_130070_(this.name);
            buf.writeBoolean(this.errorMsg != null);
            if (this.errorMsg != null) {
                buf.m_130070_(this.errorMsg);
            }
        }

        @Override
        public void read(FriendlyByteBuf buf) {
            this.name = buf.m_130136_(Short.MAX_VALUE);
            this.errorMsg = buf.readBoolean() ? buf.m_130136_(Short.MAX_VALUE) : null;
        }
    }

    protected static class SSavedHotKeyGroupPacket
    extends SAbstractPacket {
        private String name;
        private byte @Nullable [] data;
        @Nullable
        private String errorMsg;

        public SSavedHotKeyGroupPacket() {
        }

        private SSavedHotKeyGroupPacket(String name, byte @Nullable [] data, @Nullable String errorMsg) {
            this.name = name;
            this.data = data;
            this.errorMsg = errorMsg;
        }

        public SSavedHotKeyGroupPacket(String name, byte @NotNull [] data) {
            this(name, data, null);
        }

        public SSavedHotKeyGroupPacket(String name, @NotNull String errorMsg) {
            this(name, null, errorMsg);
        }

        @Override
        public void onClient(NetworkEvent.Context ctx) {
            CompletableFuture<byte[]> future = CRequestSavedHotKeyGroupPacket.FUTURES.get(this.name);
            if (future != null && !future.isDone()) {
                if (this.data == null) {
                    future.completeExceptionally(new RemoteException(this.errorMsg != null ? this.errorMsg : ""));
                } else {
                    future.complete(this.data);
                }
            }
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.m_130070_(this.name);
            buf.writeBoolean(this.data != null);
            if (this.data != null) {
                buf.m_130087_(this.data);
            }
            buf.writeBoolean(this.errorMsg != null);
            if (this.errorMsg != null) {
                buf.m_130070_(this.errorMsg);
            }
        }

        @Override
        public void read(FriendlyByteBuf buf) {
            this.name = buf.m_130136_(Short.MAX_VALUE);
            this.data = buf.readBoolean() ? buf.m_130052_() : null;
            this.errorMsg = buf.readBoolean() ? buf.m_130136_(Short.MAX_VALUE) : null;
        }
    }

    protected static class SSimpleConfigSavedHotKeyGroupsPacket
    extends SAbstractPacket {
        private List<SavedHotKeyGroupPickerWidget.RemoteSavedHotKeyGroup> groups;

        public SSimpleConfigSavedHotKeyGroupsPacket() {
        }

        public SSimpleConfigSavedHotKeyGroupsPacket(List<SavedHotKeyGroupPickerWidget.RemoteSavedHotKeyGroup> groups) {
            this.groups = groups;
        }

        @Override
        public void onClient(NetworkEvent.Context ctx) {
            CompletableFuture<List<SavedHotKeyGroupPickerWidget.RemoteSavedHotKeyGroup>> future = CSimpleConfigRequestSavedHotKeyGroupsPacket.future;
            if (future != null && !future.isDone()) {
                future.complete(this.groups);
            }
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.m_130130_(this.groups.size());
            for (SavedHotKeyGroupPickerWidget.RemoteSavedHotKeyGroup group2 : this.groups) {
                buf.m_130070_(group2.getName());
            }
        }

        @Override
        public void read(FriendlyByteBuf buf) {
            ArrayList<SavedHotKeyGroupPickerWidget.RemoteSavedHotKeyGroup> groups = new ArrayList<SavedHotKeyGroupPickerWidget.RemoteSavedHotKeyGroup>();
            for (int i = buf.m_130242_(); i > 0; --i) {
                groups.add(SavedHotKeyGroupPickerWidget.SavedHotKeyGroup.remote(buf.m_130136_(Short.MAX_VALUE)));
            }
            this.groups = groups;
        }
    }

    protected static class SSimpleConfigPresetPacket
    extends SAbstractPacket {
        protected String modId;
        protected SimpleConfig.Type type;
        protected String presetName;
        protected byte @Nullable [] fileData;
        @Nullable
        protected String errorMsg;

        public SSimpleConfigPresetPacket() {
        }

        public SSimpleConfigPresetPacket(String modId, SimpleConfig.Type type, String presetName, byte @Nullable [] fileData, @Nullable String errorMsg) {
            this.modId = modId;
            this.type = type;
            this.presetName = presetName;
            this.fileData = fileData;
            this.errorMsg = errorMsg;
        }

        @Override
        public void onClient(NetworkEvent.Context ctx) {
            CompletableFuture<CommentedConfig> future = CSimpleConfigRequestPresetPacket.FUTURES.remove(Triple.of((Object)this.modId, (Object)((Object)this.type), (Object)this.presetName));
            if (future != null) {
                if (this.fileData != null) {
                    SimpleConfigImpl config = Arrays.stream(SimpleConfig.Type.values()).filter(t -> SimpleConfigImpl.hasConfig(this.modId, t)).findFirst().map(t -> SimpleConfigImpl.getConfig(this.modId, t)).orElseThrow(IllegalStateException::new);
                    SimpleConfigCommentedYamlFormat format = config.getConfigFormat();
                    try {
                        CommentedConfig snapshot = (CommentedConfig)format.createParser(false).parse(new ByteArrayInputStream(this.fileData));
                        future.complete(snapshot);
                        return;
                    }
                    catch (ParsingException parseException) {
                        this.errorMsg = "Error parsing server snapshot:\n" + parseException.getMessage();
                    }
                }
                future.completeExceptionally(this.errorMsg != null ? new RemoteException(this.errorMsg) : new RemoteException());
            }
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.m_130070_(this.modId);
            buf.m_130068_((Enum)this.type);
            buf.m_130070_(this.presetName);
            buf.writeBoolean(this.fileData != null);
            if (this.fileData != null) {
                buf.m_130087_(this.fileData);
            }
            buf.writeBoolean(this.errorMsg != null);
            if (this.errorMsg != null) {
                buf.m_130070_(this.errorMsg);
            }
        }

        @Override
        public void read(FriendlyByteBuf buf) {
            this.modId = buf.m_130136_(Short.MAX_VALUE);
            this.type = (SimpleConfig.Type)buf.m_130066_(SimpleConfig.Type.class);
            this.presetName = buf.m_130136_(Short.MAX_VALUE);
            this.fileData = buf.readBoolean() ? buf.m_130052_() : null;
            this.errorMsg = buf.readBoolean() ? buf.m_130136_(Short.MAX_VALUE) : null;
        }
    }

    protected static class SSimpleConfigPresetListPacket
    extends SAbstractPacket {
        protected String modId;
        protected List<PresetPickerWidget.Preset> presets;

        public SSimpleConfigPresetListPacket() {
        }

        public SSimpleConfigPresetListPacket(String modId, List<PresetPickerWidget.Preset> presets) {
            this.modId = modId;
            this.presets = presets;
        }

        @Override
        public void onClient(NetworkEvent.Context ctx) {
            LOGGER.info("Received server preset list for mod \"" + this.modId + "\"");
            CompletableFuture<List<PresetPickerWidget.Preset>> future = CSimpleConfigRequestPresetListPacket.FUTURES.remove(this.modId);
            if (future != null) {
                future.complete(this.presets);
            }
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.m_130070_(this.modId);
            buf.m_130130_(this.presets.size());
            for (PresetPickerWidget.Preset preset : this.presets) {
                buf.m_130070_(preset.getName());
                buf.m_130068_((Enum)preset.getType());
            }
        }

        @Override
        public void read(FriendlyByteBuf buf) {
            this.modId = buf.m_130136_(Short.MAX_VALUE);
            this.presets = new ArrayList<PresetPickerWidget.Preset>();
            for (int i = buf.m_130242_(); i > 0; --i) {
                this.presets.add(PresetPickerWidget.Preset.remote(buf.m_130136_(Short.MAX_VALUE), (SimpleConfig.Type)buf.m_130066_(SimpleConfig.Type.class)));
            }
        }
    }

    protected static class SSimpleConfigSavedPresetPacket
    extends SAbstractPacket {
        protected String modId;
        protected SimpleConfig.Type type;
        protected String presetName;
        @Nullable
        protected String errorMsg;

        public SSimpleConfigSavedPresetPacket() {
        }

        public SSimpleConfigSavedPresetPacket(String modId, SimpleConfig.Type type, String presetName, @Nullable String errorMsg) {
            this.modId = modId;
            this.type = type;
            this.presetName = presetName;
            this.errorMsg = errorMsg;
        }

        @Override
        public void onClient(NetworkEvent.Context ctx) {
            CompletableFuture<Void> future = CSimpleConfigSavePresetPacket.FUTURES.remove(Triple.of((Object)this.modId, (Object)((Object)this.type), (Object)this.presetName));
            if (future == null) {
                return;
            }
            if (this.errorMsg != null) {
                future.completeExceptionally(new RemoteException(this.errorMsg));
            } else {
                future.complete(null);
            }
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.m_130070_(this.modId);
            buf.m_130068_((Enum)this.type);
            buf.m_130070_(this.presetName);
            buf.writeBoolean(this.errorMsg != null);
            if (this.errorMsg != null) {
                buf.m_130070_(this.errorMsg);
            }
        }

        @Override
        public void read(FriendlyByteBuf buf) {
            this.modId = buf.m_130136_(Short.MAX_VALUE);
            this.type = (SimpleConfig.Type)buf.m_130066_(SimpleConfig.Type.class);
            this.presetName = buf.m_130136_(Short.MAX_VALUE);
            this.errorMsg = buf.readBoolean() ? buf.m_130136_(Short.MAX_VALUE) : null;
        }
    }

    protected static class SSimpleConfigPatchReportPacket
    extends SAbstractPacket {
        private Component title;
        private List<Component> report;

        public SSimpleConfigPatchReportPacket() {
        }

        public SSimpleConfigPatchReportPacket(Component title, List<Component> report) {
            this.title = title;
            this.report = report;
        }

        @Override
        public void onClient(NetworkEvent.Context ctx) {
            if (this.title != null && this.report != null) {
                ConfigHotKeyLogger.logRemoteHotKey(this.title, this.report);
            }
            super.onClient(ctx);
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.m_130083_(this.title);
            buf.m_130130_(this.report.size());
            this.report.forEach(arg_0 -> ((FriendlyByteBuf)buf).m_130083_(arg_0));
        }

        @Override
        public void read(FriendlyByteBuf buf) {
            this.title = buf.m_130238_();
            int size = buf.m_130242_();
            ArrayList<Component> report = new ArrayList<Component>(size);
            for (int i = 0; i < size; ++i) {
                report.add(buf.m_130238_());
            }
            this.report = report;
        }
    }

    protected static class CSimpleConfigReleaseServerCommonConfigPacket
    extends CAbstractPacket {
        private String modId;

        public CSimpleConfigReleaseServerCommonConfigPacket() {
        }

        public CSimpleConfigReleaseServerCommonConfigPacket(String modId) {
            this.modId = modId;
        }

        @Override
        public void onServer(NetworkEvent.Context ctx) {
            ServerPlayer sender = ctx.getSender();
            String modName = SimpleConfigImpl.getModNameOrId(this.modId);
            if (sender == null) {
                throw new IllegalStateException("Received server config update from non-player source for mod \"" + modName + "\"");
            }
            String senderName = sender.m_6302_();
            if (!SimpleConfigImpl.hasConfig(this.modId, SimpleConfig.Type.COMMON)) {
                return;
            }
            if (!((ServerConfig.ConfigPermission)((Object)ServerConfig.permissions.permissionFor((Player)sender, this.modId).getLeft())).canEdit()) {
                LOGGER.warn("Player \"" + senderName + "\" attempted to release server common config for mod \"" + modName + "\"");
                return;
            }
            SimpleConfigImpl config = SimpleConfigImpl.getConfig(this.modId, SimpleConfig.Type.COMMON);
            config.removeRemoteListener((Player)sender);
            LOGGER.info("Released server common config for mod \"" + modName + "\" by player " + sender);
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.m_130070_(this.modId);
        }

        @Override
        public void read(FriendlyByteBuf buf) {
            this.modId = buf.m_130136_(Short.MAX_VALUE);
        }
    }

    protected static class SSimpleConfigServerCommonConfigPacket
    extends SAbstractPacket {
        private String modId;
        private byte @Nullable [] snapshot;

        public SSimpleConfigServerCommonConfigPacket() {
        }

        public SSimpleConfigServerCommonConfigPacket(SimpleConfigImpl config) {
            this(config.getModId(), SimpleConfigNetworkHandler.serializeSnapshot(config, null));
        }

        public SSimpleConfigServerCommonConfigPacket(String modId, byte @Nullable [] snapshot) {
            this.modId = modId;
            this.snapshot = snapshot;
        }

        @Override
        public void onClient(NetworkEvent.Context ctx) {
            CompletableFuture<CommentedConfig> future = CSimpleConfigRequestServerCommonConfigPacket.FUTURES.remove(this.modId);
            if (future == null) {
                SimpleConfigImpl config = SimpleConfigImpl.getConfig(this.modId, SimpleConfig.Type.COMMON);
                ConfigScreenBuilder.IConfigSnapshotHandler snapshotHandler = config.getSnapshotHandler();
                if (snapshotHandler == null) {
                    LOGGER.warn("No snapshot handler for mod \"" + this.modId + "\"");
                    this.sendUnsubscribeMessage();
                    return;
                }
                ConfigScreenBuilder.IConfigSnapshotHandler.IExternalChangeHandler handler = snapshotHandler.getExternalChangeHandler();
                if (handler == null) {
                    LOGGER.warn("No external change handler for mod \"" + this.modId + "\"");
                    this.sendUnsubscribeMessage();
                    return;
                }
                handler.handleRemoteConfigExternalChange(SimpleConfig.EditType.SERVER_COMMON, SimpleConfigNetworkHandler.deserializeSnapshot(config, this.snapshot));
            } else if (!future.isCancelled()) {
                SimpleConfigImpl config = SimpleConfigImpl.getConfig(this.modId, SimpleConfig.Type.COMMON);
                String modName = config.getModName();
                if (this.snapshot == null) {
                    future.complete(null);
                    LOGGER.info("Did not receive server common config for mod \"" + modName + "\"");
                    return;
                }
                future.complete(SimpleConfigNetworkHandler.deserializeSnapshot(config, this.snapshot));
                LOGGER.info("Received server common config for mod \"" + modName + "\"");
            }
        }

        protected void sendUnsubscribeMessage() {
            new CSimpleConfigReleaseServerCommonConfigPacket(this.modId).send();
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.m_130070_(this.modId);
            buf.writeBoolean(this.snapshot != null);
            if (this.snapshot != null) {
                buf.m_130087_(this.snapshot);
            }
        }

        @Override
        public void read(FriendlyByteBuf buf) {
            this.modId = buf.m_130136_(Short.MAX_VALUE);
            this.snapshot = buf.readBoolean() ? buf.m_130052_() : null;
        }
    }

    protected static class SSimpleConfigSyncPacket
    extends SAbstractPacket {
        protected String modId;
        protected byte[] snapshot;

        public SSimpleConfigSyncPacket() {
        }

        public SSimpleConfigSyncPacket(SimpleConfigImpl config) {
            this.modId = config.getModId();
            this.snapshot = SimpleConfigNetworkHandler.serializeSnapshot(config, null);
        }

        public SSimpleConfigSyncPacket(String modId, byte[] snapshot) {
            this.modId = modId;
            this.snapshot = snapshot;
        }

        @Override
        public void onClient(NetworkEvent.Context ctx) {
            if (!Minecraft.m_91087_().m_91090_()) {
                try {
                    SimpleConfigNetworkHandler.tryUpdateConfig(SimpleConfigImpl.getConfig(this.modId, SimpleConfig.Type.SERVER), this.snapshot, false);
                    LOGGER.debug("Updated server config for mod \"" + this.modId + "\"");
                }
                catch (ConfigUpdateReflectionError e) {
                    LOGGER.error("Error updating client config for mod \"" + this.modId + "\"", (Throwable)e);
                    SSimpleConfigSyncPacket.sendMessage((Component)Component.m_237110_((String)"simpleconfig.config.msg.error_updating_from_server", (Object[])new Object[]{SimpleConfigImpl.getModNameOrId(this.modId), e.getMessage()}));
                }
            }
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.m_130070_(this.modId);
            buf.m_130087_(this.snapshot);
        }

        @Override
        public void read(FriendlyByteBuf buf) {
            this.modId = buf.m_130136_(Short.MAX_VALUE);
            this.snapshot = buf.m_130052_();
        }
    }

    protected static class CSimpleConfigSyncPacket
    extends CAbstractPacket {
        protected String modId;
        protected byte[] snapshot;
        protected boolean requireRestart;

        public CSimpleConfigSyncPacket() {
        }

        public CSimpleConfigSyncPacket(SimpleConfigImpl config) {
            this.modId = config.getModId();
            this.snapshot = SimpleConfigNetworkHandler.serializeSnapshot(config, null);
            this.requireRestart = config.anyDirtyRequiresRestart();
        }

        @Override
        public void onServer(NetworkEvent.Context ctx) {
            ServerPlayer sender = ctx.getSender();
            SimpleConfigImpl config = SimpleConfigImpl.getConfig(this.modId, SimpleConfig.Type.SERVER);
            String modName = SimpleConfigImpl.getModNameOrId(this.modId);
            if (sender == null) {
                throw new IllegalStateException("Received server config update from non-player source for mod \"" + modName + "\"");
            }
            String senderName = sender.m_6302_();
            if (!((ServerConfig.ConfigPermission)((Object)ServerConfig.permissions.permissionFor((Player)sender, this.modId).getLeft())).canEdit()) {
                LOGGER.warn("Player \"" + senderName + "\" tried to modify the server config for mod \"" + modName + "\" without privileges");
                SimpleConfigNetworkHandler.broadcastToOperators((Component)Component.m_237110_((String)"simpleconfig.config.msg.tried_to_update_by", (Object[])new Object[]{senderName, modName}).m_130948_(DENIED_UPDATE_STYLE));
                new SSimpleConfigSyncPacket(this.modId, this.snapshot).sendTo(sender);
                return;
            }
            try {
                SimpleConfigNetworkHandler.tryUpdateConfig(config, this.snapshot, false);
            }
            catch (ConfigUpdateReflectionError e) {
                e.printStackTrace();
                LOGGER.error("Error updating server config for mod \"" + modName + "\"");
                SimpleConfigNetworkHandler.broadcastToOperators((Component)Component.m_237110_((String)"simpleconfig.config.msg.error_updating_by", (Object[])new Object[]{modName, senderName, e.getMessage()}).m_130948_(ERROR_UPDATE_STYLE));
            }
            LOGGER.info("Server config for mod \"" + modName + "\" has been updated by authorized player \"" + senderName + "\"");
            MutableComponent msg = Component.m_237110_((String)"simpleconfig.config.msg.updated_by", (Object[])new Object[]{modName, senderName}).m_130948_(ALLOWED_UPDATE_STYLE);
            if (this.requireRestart) {
                msg = msg.m_130946_("\n").m_7220_((Component)Component.m_237115_((String)"simpleconfig.config.msg.server_changes_require_restart").m_130948_(REQUIRES_RESTART_STYLE));
            }
            SimpleConfigNetworkHandler.broadcastToOperators((Component)msg);
            new SSimpleConfigSyncPacket(this.modId, this.snapshot).sendExcept(sender);
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.m_130070_(this.modId);
            buf.m_130087_(this.snapshot);
            buf.writeBoolean(this.requireRestart);
        }

        @Override
        public void read(FriendlyByteBuf buf) {
            this.modId = buf.m_130136_(Short.MAX_VALUE);
            this.snapshot = buf.m_130052_();
            this.requireRestart = buf.readBoolean();
        }
    }

    protected static class CAcknowledgePacket
    extends CAbstractLoginPacket {
        protected CAcknowledgePacket() {
        }

        @Override
        public void onServer(NetworkEvent.Context ctx) {
            super.onServer(ctx);
        }

        @Override
        public void write(FriendlyByteBuf buf) {
        }

        @Override
        public void read(FriendlyByteBuf buf) {
        }
    }

    protected static interface ILoginPacket
    extends IntSupplier {
        public int getLoginIndex();

        public void setLoginIndex(int var1);

        @Override
        default public int getAsInt() {
            return this.getLoginIndex();
        }
    }

    protected static abstract class SAbstractPacket
    extends AbstractPacket {
        private static final PacketDistributor<ServerPlayer> EXCEPT = new PacketDistributor((distributor, supplier) -> arg_0 -> SAbstractPacket.lambda$static$2((Supplier)supplier, arg_0), NetworkDirection.PLAY_TO_CLIENT);
        private static final PacketDistributor<ServerPlayer> OPS_EXCEPT = new PacketDistributor((distributor, supplier) -> arg_0 -> SAbstractPacket.lambda$static$6((Supplier)supplier, arg_0), NetworkDirection.PLAY_TO_CLIENT);
        private static final PacketDistributor<Collection<? extends Player>> LIST = new PacketDistributor((distributor, supplier) -> arg_0 -> SAbstractPacket.lambda$static$10((Supplier)supplier, arg_0), NetworkDirection.PLAY_TO_CLIENT);

        protected SAbstractPacket() {
        }

        public static void sendMessage(Component message) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            player.m_213846_(message);
        }

        protected void handleWithReply(Supplier<NetworkEvent.Context> ctxSupplier) {
            NetworkEvent.Context ctx = ctxSupplier.get();
            this.handle(ctxSupplier);
            CHANNEL.reply((Object)new CAcknowledgePacket(), ctx);
        }

        @Override
        protected void handle(Supplier<NetworkEvent.Context> ctxSupplier) {
            NetworkEvent.Context ctx = ctxSupplier.get();
            ctx.setPacketHandled(true);
            this.onClient(ctx);
        }

        public void onClient(NetworkEvent.Context ctx) {
        }

        public void sendTo(ServerPlayer player) {
            CHANNEL.sendTo((Object)this, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }

        public void sendTo(Collection<? extends Player> players) {
            CHANNEL.send(LIST.with(() -> Lists.newArrayList((Iterable)players)), (Object)this);
        }

        public void sendExcept(ServerPlayer player) {
            CHANNEL.send(EXCEPT.with(() -> player), (Object)this);
        }

        public void sendToOpsExcept(ServerPlayer player) {
            CHANNEL.send(OPS_EXCEPT.with(() -> player), (Object)this);
        }

        public void sendToAll() {
            CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)this);
        }

        private static /* synthetic */ void lambda$static$10(Supplier supplier, Packet packet) {
            Collection players = (Collection)supplier.get();
            players.stream().filter(p -> p instanceof ServerPlayer).forEach(p -> ((ServerPlayer)p).f_8906_.m_9829_(packet));
        }

        private static /* synthetic */ void lambda$static$6(Supplier supplier, Packet packet) {
            ServerPlayer exception = (ServerPlayer)supplier.get();
            MinecraftServer server = exception.m_9236_().m_7654_();
            if (server == null) {
                return;
            }
            server.m_6846_().m_11314_().stream().filter(p -> exception != p && p.m_20310_(2)).forEach(p -> p.f_8906_.m_9829_(packet));
        }

        private static /* synthetic */ void lambda$static$2(Supplier supplier, Packet packet) {
            ServerPlayer exception = (ServerPlayer)supplier.get();
            MinecraftServer server = exception.m_9236_().m_7654_();
            if (server == null) {
                return;
            }
            server.m_6846_().m_11314_().stream().filter(p -> exception != p).forEach(p -> p.f_8906_.m_9829_(packet));
        }
    }

    protected static abstract class CAbstractPacket
    extends AbstractPacket {
        protected CAbstractPacket() {
        }

        @Override
        protected final void handle(Supplier<NetworkEvent.Context> ctxSupplier) {
            NetworkEvent.Context ctx = ctxSupplier.get();
            ctx.setPacketHandled(true);
            this.onServer(ctx);
        }

        public void onServer(NetworkEvent.Context ctx) {
        }

        public void send() {
            CHANNEL.sendToServer((Object)this);
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="simpleconfig")
    @ApiStatus.Internal
    public static class LoginEventSubscriber {
        @SubscribeEvent
        public static void onClientLogin(ClientPlayerNetworkEvent.LoggingIn event) {
            isConnectedToDedicatedServer = dedicatedServerLoginID == loginID++;
        }
    }
}

