/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core;

import endorh.simpleconfig.core.SimpleConfigFileTypeHandler;
import endorh.simpleconfig.core.SimpleConfigImpl;
import endorh.simpleconfig.yaml.SimpleConfigCommentedYamlFormat;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ConfigFileTypeHandler;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.jetbrains.annotations.NotNull;

public class SimpleConfigModConfig
extends ModConfig {
    private static final ConcurrentHashMap<String, ModConfig> FILE_MAP = Objects.requireNonNull((ConcurrentHashMap)ObfuscationReflectionHelper.getPrivateValue(ConfigTracker.class, (Object)ConfigTracker.INSTANCE, (String)"fileMap"));
    private final ConfigFileTypeHandler handler = SimpleConfigFileTypeHandler.YAML;
    private final SimpleConfigImpl config;
    private final SimpleConfigCommentedYamlFormat configFormat;

    public SimpleConfigModConfig(SimpleConfigImpl config, ModContainer container) {
        super(config.getType().asConfigType(), (IConfigSpec)config.spec, container, config.getFileName());
        this.config = config;
        this.configFormat = SimpleConfigCommentedYamlFormat.forConfig(config);
        FILE_MAP.remove(this.getFileName());
    }

    public SimpleConfigImpl getSimpleConfig() {
        return this.config;
    }

    public ConfigFileTypeHandler getHandler() {
        return this.handler;
    }

    public Path getFullPath() {
        return super.getFullPath();
    }

    public SimpleConfigCommentedYamlFormat getConfigFormat() {
        return this.configFormat;
    }

    @Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER}, modid="simpleconfig")
    public static class ServerLanguageReloadManager {
        @SubscribeEvent
        public static void onServerLanguageReloaded(ServerStartingEvent event) {
            SimpleConfigImpl.updateAllFileTranslations();
        }
    }

    public static class LanguageReloadManager
    implements PreparableReloadListener {
        public static final LanguageReloadManager INSTANCE = new LanguageReloadManager();

        @NotNull
        public CompletableFuture<Void> m_5540_(@NotNull PreparableReloadListener.PreparationBarrier stage, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller preparationsProfiler, @NotNull ProfilerFiller reloadProfiler, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
            return stage.m_6769_((Object)Unit.INSTANCE).thenRunAsync(SimpleConfigImpl::updateAllFileTranslations);
        }
    }
}

