/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingException;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.api.SimpleConfigCategory;
import endorh.simpleconfig.api.SimpleConfigTextUtil;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.config.ServerConfig;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractSimpleConfigEntryHolder;
import endorh.simpleconfig.core.ServerI18n;
import endorh.simpleconfig.core.SimpleConfigCategoryImpl;
import endorh.simpleconfig.core.SimpleConfigGroupImpl;
import endorh.simpleconfig.core.SimpleConfigModConfig;
import endorh.simpleconfig.core.SimpleConfigNetworkHandler;
import endorh.simpleconfig.core.SimpleConfigPaths;
import endorh.simpleconfig.core.SimpleConfigSnapshotHandler;
import endorh.simpleconfig.ui.api.ConfigCategoryBuilder;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.api.ConfigScreenBuilder;
import endorh.simpleconfig.ui.gui.AbstractConfigScreen;
import endorh.simpleconfig.yaml.NodeComments;
import endorh.simpleconfig.yaml.SimpleConfigCommentedYamlFormat;
import endorh.simpleconfig.yaml.SimpleConfigCommentedYamlWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleConfigImpl
extends AbstractSimpleConfigEntryHolder
implements SimpleConfig {
    private static final Map<Pair<String, SimpleConfig.Type>, SimpleConfigImpl> INSTANCES = new ConcurrentHashMap<Pair<String, SimpleConfig.Type>, SimpleConfigImpl>();
    @ApiStatus.Internal
    public static final SimpleConfigImpl DUMMY = new SimpleConfigImpl("", SimpleConfig.Type.SERVER, "dummy", null, null, null);
    private static final Pattern LINE_BREAK;
    protected final String defaultTitle;
    protected final String tooltip;
    @Nullable
    protected final Consumer<SimpleConfigImpl> saver;
    @Nullable
    protected final Consumer<SimpleConfig> baker;
    @Nullable
    protected final Object configClass;
    private final SimpleConfig.Type type;
    private final String modId;
    protected Icon defaultCategoryIcon;
    protected int defaultCategoryColor;
    protected Map<String, SimpleConfigCategoryImpl> categories = null;
    protected Map<String, SimpleConfigGroupImpl> groups = null;
    protected List<IGUIEntry> order;
    @Nullable
    protected ForgeConfigSpec spec;
    @Nullable
    protected List<ForgeConfigSpec> extraSpecs;
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    protected BiConsumer<SimpleConfig, ConfigScreenBuilder> decorator;
    @Nullable
    protected Predicate<SimpleConfigCategory> categoryFilter;
    @Nullable
    protected ResourceLocation background;
    protected boolean transparent;
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    protected AbstractConfigScreen gui;
    @Nullable
    protected ConfigScreenBuilder.IConfigSnapshotHandler snapshotHandler;
    protected Set<Player> remoteListeners = new HashSet<Player>();
    private ModConfig modConfig;
    private Map<String, ModConfig> extraModConfigs;
    private ModContainer modContainer;
    @Nullable
    private LiteralArgumentBuilder<CommandSourceStack> commandRoot;
    private Map<String, NodeComments> comments = new HashMap<String, NodeComments>();
    private final SimpleConfigCommentedYamlFormat configFormat = SimpleConfigCommentedYamlFormat.forConfig(this);

    @ApiStatus.Internal
    protected SimpleConfigImpl(String modId, SimpleConfig.Type type, String defaultTitle, @Nullable Consumer<SimpleConfig> baker, @Nullable Consumer<SimpleConfigImpl> saver, @Nullable Object configClass) {
        this.modId = modId;
        this.type = type;
        this.defaultTitle = defaultTitle;
        this.baker = baker;
        this.saver = saver;
        this.configClass = configClass;
        this.tooltip = defaultTitle + ":help";
        this.root = this;
        Pair key = Pair.of((Object)modId, (Object)((Object)type));
        if (INSTANCES.put((Pair<String, SimpleConfig.Type>)key, this) != null) {
            throw new IllegalStateException("Cannot create more than one config per type per mod");
        }
    }

    @ApiStatus.Internal
    public static SimpleConfigImpl getConfigOrNull(String modId, SimpleConfig.Type type) {
        return INSTANCES.get(Pair.of((Object)modId, (Object)((Object)type)));
    }

    @ApiStatus.Internal
    public static SimpleConfigImpl getConfig(String modId, SimpleConfig.Type type) {
        Pair key = Pair.of((Object)modId, (Object)((Object)type));
        if (!INSTANCES.containsKey(key)) {
            throw new IllegalStateException("Attempted to get unregistered config for mod id \"" + modId + "\" of type " + type);
        }
        return INSTANCES.get(key);
    }

    @ApiStatus.Internal
    public static boolean hasConfig(String modId, SimpleConfig.Type type) {
        return INSTANCES.containsKey(Pair.of((Object)modId, (Object)((Object)type)));
    }

    @ApiStatus.Internal
    public static Set<String> getConfigModIds() {
        return INSTANCES.keySet().stream().map(Pair::getLeft).collect(Collectors.toSet());
    }

    @ApiStatus.Internal
    public static Collection<SimpleConfigImpl> getAllConfigs() {
        return INSTANCES.values();
    }

    @ApiStatus.Internal
    public static String getModNameOrId(String modId) {
        Optional<IModInfo> first = ModList.get().getMods().stream().filter(m -> modId.equals(m.getModId())).findFirst();
        if (first.isPresent()) {
            return first.get().getDisplayName();
        }
        return modId;
    }

    @ApiStatus.Internal
    public static void updateAllFileTranslations() {
        INSTANCES.values().stream().filter(c -> c.modConfig != null && c.modConfig.getConfigData() != null && !c.isWrapper()).forEach(c -> c.spec.save());
    }

    @Override
    public boolean isWrapper() {
        return !(this.modConfig instanceof SimpleConfigModConfig) || !this.extraModConfigs.isEmpty();
    }

    @Override
    public Optional<Path> getFilePath() {
        ModConfig modConfig = this.getModConfig();
        return modConfig != null && modConfig.getConfigData() instanceof CommentedFileConfig ? Optional.of(modConfig.getFullPath()) : Optional.empty();
    }

    @Override
    public Optional<Path> getFilePath(String category) {
        ModConfig config = this.extraModConfigs.get(category);
        if (config == null) {
            return this.getFilePath();
        }
        return config.getConfigData() instanceof CommentedFileConfig ? Optional.of(config.getFullPath()) : Optional.empty();
    }

    @ApiStatus.Internal
    protected void build(Map<String, AbstractConfigEntry<?, ?, ?>> entries2, Map<String, SimpleConfigCategoryImpl> categories, Map<String, SimpleConfigGroupImpl> groups, List<IGUIEntry> order, @Nullable Pair<ForgeConfigSpec, List<ForgeConfigSpec>> spec, Icon icon, int color, @Nullable LiteralArgumentBuilder<CommandSourceStack> commandRoot) {
        if (this.entries != null) {
            throw new IllegalStateException("Called buildEntry() twice");
        }
        this.entries = entries2;
        this.categories = categories;
        this.groups = groups;
        this.order = order;
        this.spec = spec != null ? (ForgeConfigSpec)spec.getLeft() : null;
        this.extraSpecs = spec != null ? (List)spec.getRight() : null;
        HashMap<String, AbstractSimpleConfigEntryHolder> children = new HashMap<String, AbstractSimpleConfigEntryHolder>();
        children.putAll(this.categories);
        children.putAll(this.groups);
        this.children = Collections.unmodifiableMap(children);
        this.defaultCategoryIcon = icon;
        this.defaultCategoryColor = color;
        this.commandRoot = commandRoot;
    }

    @ApiStatus.Internal
    public void build(ModContainer container, ModConfig modConfig) {
        this.build(container, modConfig, Collections.emptyMap());
    }

    @ApiStatus.Internal
    public void build(ModContainer container, ModConfig modConfig, Map<String, ModConfig> extraConfigs) {
        this.modContainer = container;
        this.modConfig = modConfig;
        this.extraModConfigs = extraConfigs;
    }

    @Override
    public String getPath() {
        return this.getName();
    }

    @Override
    protected String getName() {
        return "SimpleConfig[" + this.getModId() + ", " + this.getType().name() + "]";
    }

    @Override
    @ApiStatus.Internal
    public String getFileName() {
        return String.format("%s-%s.yaml", this.getModId(), this.getType().getAlias());
    }

    @Override
    @Nullable
    public <T, C, Gui> AbstractConfigEntry<T, C, Gui> getEntryOrNull(String path) {
        AbstractConfigEntry<T, ?, ?> entry;
        if (path.startsWith(".")) {
            path = path.substring(1);
        }
        if ((entry = (AbstractConfigEntry<T, ?, ?>)this.entries.get(path)) == null) {
            entry = this.getSubEntry(path);
        }
        return entry;
    }

    @Override
    @Nullable
    public AbstractSimpleConfigEntryHolder getChildOrNull(String path) {
        String[] split = DOT.split(path, 2);
        if (split[0].isEmpty()) {
            return super.getChildOrNull(split[1]);
        }
        return super.getChildOrNull(path);
    }

    @Override
    protected <T> AbstractConfigEntry<T, ?, ?> getSubEntry(String path) {
        String[] split = DOT.split(path, 2);
        if (split[0].isEmpty()) {
            AbstractConfigEntry entry = (AbstractConfigEntry)this.entries.get(split[1]);
            if (entry != null) {
                return entry;
            }
            return super.getSubEntry(split[1]);
        }
        return super.getSubEntry(path);
    }

    protected void bakeFields() {
        for (SimpleConfigCategoryImpl cat : this.categories.values()) {
            cat.bakeFields();
        }
        for (SimpleConfigGroupImpl group2 : this.groups.values()) {
            group2.bakeFields();
        }
        for (AbstractConfigEntry entry : this.entries.values()) {
            entry.bakeField();
        }
    }

    @Override
    public void commitFields() {
        try {
            for (SimpleConfigCategoryImpl cat : this.categories.values()) {
                cat.commitFields();
            }
            for (SimpleConfigGroupImpl group2 : this.groups.values()) {
                group2.commitFields();
            }
            for (AbstractConfigEntry entry : this.entries.values()) {
                entry.commitField();
            }
        }
        catch (IllegalAccessException e) {
            throw new SimpleConfig.ConfigReflectiveOperationException("Could not access mod config field during config commit\n  Details: " + e.getMessage(), e);
        }
    }

    @Override
    public void bake() {
        this.bakeFields();
        for (SimpleConfigCategoryImpl cat : this.categories.values()) {
            cat.bake();
        }
        for (SimpleConfigGroupImpl group2 : this.groups.values()) {
            group2.bake();
        }
        if (this.baker != null) {
            this.baker.accept(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void removeGUI() {
        SimpleConfigImpl simpleConfigImpl = this;
        synchronized (simpleConfigImpl) {
            this.gui = null;
            this.snapshotHandler = null;
        }
        super.removeGUI();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void setGUI(AbstractConfigScreen gui, @Nullable ConfigScreenBuilder.IConfigSnapshotHandler handler) {
        this.gui = gui;
        this.snapshotHandler = handler;
    }

    @Nullable
    protected ConfigScreenBuilder.IConfigSnapshotHandler getSnapshotHandler() {
        return this.snapshotHandler;
    }

    public void save() {
        if (!this.canEdit()) {
            return;
        }
        this.bake();
        if (this.saver != null) {
            this.saver.accept(this);
        }
        this.markDirty(false);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void checkRestart() {
        LocalPlayer player;
        if (this.anyDirtyRequiresRestart() && (player = Minecraft.m_91087_().f_91074_) != null) {
            player.m_213846_((Component)Component.m_237115_((String)"simpleconfig.config.msg.client_changes_require_restart").m_130940_(ChatFormatting.GOLD));
        }
    }

    @ApiStatus.Internal
    public void sync() {
        if (this.type == SimpleConfig.Type.SERVER) {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                this.syncToServer();
            } else {
                this.syncToClients();
            }
        }
    }

    @ApiStatus.Internal
    public void update() {
        if (this.spec != null) {
            this.spec.save();
        }
        this.sync();
    }

    @ApiStatus.Internal
    public void syncToClients() {
        if (this.type == SimpleConfig.Type.SERVER) {
            new SimpleConfigNetworkHandler.SSimpleConfigSyncPacket(this).sendToAll();
        } else if (this.type == SimpleConfig.Type.COMMON) {
            new SimpleConfigNetworkHandler.SSimpleConfigServerCommonConfigPacket(this).sendTo(this.remoteListeners);
        }
    }

    @ApiStatus.Internal
    public void syncToServer() {
        if (SimpleConfigNetworkHandler.isConnectedToSimpleConfigServer()) {
            new SimpleConfigNetworkHandler.CSimpleConfigSyncPacket(this).send();
        }
    }

    @ApiStatus.Internal
    protected void addRemoteListener(Player listener) {
        this.remoteListeners.add(listener);
    }

    @ApiStatus.Internal
    protected void removeRemoteListener(Player listener) {
        this.remoteListeners.remove(listener);
    }

    @ApiStatus.Internal
    public CommentedConfig takeSnapshot(boolean fromGUI, boolean fromRemote) {
        return this.takeSnapshot(fromGUI, fromRemote, (Predicate<String>)null);
    }

    @ApiStatus.Internal
    public CommentedConfig takeSnapshot(boolean fromGUI, boolean fromRemote, @Nullable Set<String> selectedPaths) {
        if (selectedPaths != null) {
            selectedPaths = selectedPaths.stream().map(p -> p.startsWith(".") ? p.substring(1) : p).collect(Collectors.toSet());
        }
        return this.takeSnapshot(fromGUI, fromRemote, selectedPaths != null ? selectedPaths::contains : null);
    }

    @ApiStatus.Internal
    public CommentedConfig takeSnapshot(boolean fromGUI, boolean fromRemote, @Nullable Predicate<String> selectedPaths) {
        CommentedConfig config = CommentedConfig.of(LinkedHashMap::new, (ConfigFormat)SimpleConfigCommentedYamlFormat.forConfig(this));
        this.saveSnapshot(config, fromGUI, fromRemote, selectedPaths);
        return config;
    }

    @ApiStatus.Internal
    public void loadSnapshot(CommentedConfig config, boolean intoGUI, boolean forRemote) {
        this.loadSnapshot(config, intoGUI, forRemote, (Predicate<String>)null);
    }

    @ApiStatus.Internal
    public void loadSnapshot(CommentedConfig config, boolean intoGUI, boolean forRemote, @Nullable Set<String> selectedPaths) {
        this.loadSnapshot(config, intoGUI, forRemote, selectedPaths != null ? selectedPaths::contains : null);
    }

    @Override
    @ApiStatus.Internal
    public void loadSnapshot(CommentedConfig config, boolean intoGUI, boolean forRemote, @Nullable Predicate<String> selectedPaths) {
        this.loadSnapshot(config, intoGUI, forRemote, false, selectedPaths);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ApiStatus.Internal
    public void loadSnapshot(CommentedConfig config, boolean intoGUI, boolean forRemote, boolean opaque, @Nullable Predicate<String> selectedPaths) {
        if (intoGUI) {
            if (FMLEnvironment.dist != Dist.CLIENT) {
                throw new IllegalStateException("Cannot load snapshot into GUI on server");
            }
            AbstractConfigScreen screen = this.getGUI();
            if (screen == null) throw new IllegalStateException("Cannot load snapshot into GUI when no GUI is active");
            if (opaque) {
                screen.runUnrecordedAction(() -> super.loadSnapshot(config, true, forRemote, selectedPaths));
                return;
            } else {
                screen.runAtomicTransparentAction(() -> super.loadSnapshot(config, true, forRemote, selectedPaths));
            }
            return;
        } else {
            super.loadSnapshot(config, false, forRemote, selectedPaths);
        }
    }

    @SubscribeEvent
    protected void onModConfigEvent(ModConfigEvent event) {
        if (event instanceof ModConfigEvent.Unloading) {
            return;
        }
        ModConfig c = event.getConfig();
        if (c == this.getModConfig() || this.getExtraModConfigs().containsValue(c)) {
            this.bake();
            if (this.type == SimpleConfig.Type.SERVER || this.type == SimpleConfig.Type.COMMON) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> this::syncToClients);
            }
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                SimpleConfigImpl simpleConfigImpl = this;
                synchronized (simpleConfigImpl) {
                    ConfigScreenBuilder.IConfigSnapshotHandler handler = this.getSnapshotHandler();
                    if (handler != null) {
                        handler.notifyExternalChanges(this);
                    }
                }
            });
        }
    }

    @Override
    @NotNull
    public SimpleConfigCategoryImpl getCategory(String name) {
        if (!this.categories.containsKey(name)) {
            throw new SimpleConfig.NoSuchConfigCategoryError(this.getPath() + "." + name);
        }
        return this.categories.get(name);
    }

    @Override
    @NotNull
    public SimpleConfigGroupImpl getGroup(String path) {
        if (path.contains(".")) {
            String[] split = path.split("\\.", 2);
            if (this.groups.containsKey(split[0])) {
                return this.groups.get(split[1]).getGroup(split[1]);
            }
        } else if (this.groups.containsKey(path)) {
            return this.groups.get(path);
        }
        throw new SimpleConfig.NoSuchConfigGroupError(path);
    }

    protected Component getTitle() {
        if (I18n.m_118936_((String)this.defaultTitle)) {
            return Component.m_237115_((String)this.defaultTitle);
        }
        return Component.m_237115_((String)("simpleconfig.config.category." + this.getType().name().toLowerCase()));
    }

    protected String getHeaderComment() {
        Object type = this.getType().getAlias();
        type = Character.toUpperCase(((String)type).charAt(0)) + ((String)type).substring(1);
        boolean loaded = ServerI18n.hasKey("simpleconfig.config.title");
        String lang = loaded ? ServerI18n.getCurrentLanguage() : "<not loaded yet...>";
        String comment = loaded ? "\n" + ServerI18n.format("simpleconfig.config.header", new Object[0]) : "\nComments starting with 2 hash symbols (##) are documentation comments and will be reset if modified.";
        return SimpleConfigImpl.getModNameOrId(this.getModId()) + " - " + (String)type + " config\nLang: " + lang + comment;
    }

    @ApiStatus.Internal
    public Map<String, NodeComments> getComments() {
        this.updateComments(this.comments);
        String headerComment = this.getHeaderComment().trim();
        List headerLines = Arrays.stream(LINE_BREAK.split(headerComment)).map(l -> SimpleConfigCommentedYamlWriter.commentLine("# " + l)).collect(Collectors.toList());
        this.comments.put("", (NodeComments)Util.m_137469_((Object)new NodeComments(), c -> c.setBlockComments(headerLines)));
        return this.comments;
    }

    @ApiStatus.Internal
    public void loadComments(Map<String, NodeComments> comments) {
        this.comments = comments;
    }

    protected ConfigSpec buildConfigSpec() {
        ConfigSpec spec = new ConfigSpec();
        for (AbstractConfigEntry e : this.entries.values()) {
            e.buildSpec(spec, "");
        }
        for (AbstractSimpleConfigEntryHolder child : this.children.values()) {
            child.buildConfigSpec(spec, "");
        }
        return spec;
    }

    @Override
    public boolean canEdit() {
        return this.getType() != SimpleConfig.Type.SERVER || FMLEnvironment.dist == Dist.DEDICATED_SERVER || ((ServerConfig.ConfigPermission)((Object)ServerConfig.permissions.permissionFor(this.modId).getLeft())).canEdit();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void buildGUI(ConfigScreenBuilder configBuilder, boolean forRemote) {
        if (this.background != null) {
            configBuilder.setDefaultBackgroundTexture(this.background);
        }
        configBuilder.setTransparentBackground(this.transparent);
        ConfigFieldBuilder entryBuilder = configBuilder.entryBuilder();
        if (!this.order.isEmpty()) {
            ConfigCategoryBuilder category = configBuilder.getOrCreateCategory("", this.type.asEditType(forRemote));
            category.setEditable(this.canEdit());
            category.setTitle(this.getTitle());
            this.getFilePath().ifPresent(category::setContainingFile);
            category.setDescription(() -> I18n.m_118936_((String)this.tooltip) ? Optional.of(SimpleConfigTextUtil.splitTtc(this.tooltip, new Object[0]).toArray(new Component[0])) : Optional.empty());
            if (this.background != null) {
                category.setBackground(this.background);
            }
            category.setIcon(this.defaultCategoryIcon);
            category.setColor(this.defaultCategoryColor);
            for (IGUIEntry entry : this.order) {
                entry.buildGUI(category, entryBuilder, forRemote);
            }
        }
        for (SimpleConfigCategoryImpl cat : this.categories.values()) {
            if (this.categoryFilter != null && !this.categoryFilter.test(cat)) continue;
            cat.buildGUI(configBuilder, entryBuilder, forRemote);
        }
        if (this.decorator != null) {
            this.decorator.accept(this, configBuilder);
        }
    }

    protected CompletableFuture<Void> saveLocalPreset(String name, @Nullable CommentedConfig config) {
        String typePrefix = "-" + this.getType().getAlias() + "-";
        String fileName = this.getModId() + typePrefix + name + ".yaml";
        File dest = SimpleConfigPaths.LOCAL_PRESETS_DIR.resolve(fileName).toFile();
        if (dest.isDirectory()) {
            return SimpleConfigSnapshotHandler.failedFuture(new FileNotFoundException(dest.getPath()));
        }
        if (config != null) {
            SimpleConfigCommentedYamlFormat format = this.getConfigFormat();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                format.createWriter(false).write((UnmodifiableConfig)config, os);
            }
            catch (WritingException e) {
                return SimpleConfigSnapshotHandler.failedFuture(e);
            }
            byte[] bytes = os.toByteArray();
            try {
                FileUtils.writeByteArrayToFile((File)dest, (byte[])bytes);
                return CompletableFuture.completedFuture(null);
            }
            catch (IOException e) {
                return SimpleConfigSnapshotHandler.failedFuture(e);
            }
        }
        if (!dest.isFile()) {
            return SimpleConfigSnapshotHandler.failedFuture(new FileNotFoundException(dest.getPath()));
        }
        if (!dest.delete()) {
            return SimpleConfigSnapshotHandler.failedFuture(new IOException("Could not delete file " + dest.getPath()));
        }
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> saveRemotePreset(String name, CommentedConfig config) {
        return SimpleConfigNetworkHandler.saveRemotePreset(this.getModId(), this.type, name, config);
    }

    protected CompletableFuture<CommentedConfig> getLocalPreset(String name) {
        CompletableFuture<CommentedConfig> future = new CompletableFuture<CommentedConfig>();
        String prefix = "-" + this.getType().getAlias() + "-";
        File file = SimpleConfigPaths.LOCAL_PRESETS_DIR.resolve(this.getModId() + prefix + name + ".yaml").toFile();
        if (!file.isFile()) {
            future.completeExceptionally(new FileNotFoundException(file.getPath()));
            return future;
        }
        try {
            SimpleConfigCommentedYamlFormat format = this.getConfigFormat();
            CommentedConfig config = (CommentedConfig)format.createParser(false).parse(new ByteArrayInputStream(FileUtils.readFileToByteArray((File)file)));
            future.complete(config);
            return future;
        }
        catch (IOException e) {
            future.completeExceptionally(e);
            return future;
        }
    }

    protected CompletableFuture<CommentedConfig> getRemotePreset(String name) {
        return SimpleConfigNetworkHandler.requestRemotePreset(this.getModId(), this.type, name);
    }

    @Override
    public SimpleConfig.Type getType() {
        return this.type;
    }

    @Override
    public String getModId() {
        return this.modId;
    }

    @Override
    public String getModName() {
        return SimpleConfigImpl.getModNameOrId(this.modId);
    }

    @ApiStatus.Internal
    public SimpleConfigCommentedYamlFormat getConfigFormat() {
        return this.configFormat;
    }

    @ApiStatus.Internal
    public ModConfig getModConfig() {
        return this.modConfig;
    }

    @ApiStatus.Internal
    public Map<String, ModConfig> getExtraModConfigs() {
        return this.extraModConfigs;
    }

    @ApiStatus.Internal
    public ModContainer getModContainer() {
        return this.modContainer;
    }

    @ApiStatus.Internal
    @Nullable
    public LiteralArgumentBuilder<CommandSourceStack> getCommandRoot() {
        return this.commandRoot;
    }

    @Override
    @NotNull
    public AbstractSimpleConfigEntryHolder getParent() {
        throw new SimpleConfig.NoSuchConfigGroupError(this.getGlobalPath());
    }

    static {
        INSTANCES.remove(Pair.of((Object)"", (Object)((Object)SimpleConfig.Type.SERVER)));
        LINE_BREAK = Pattern.compile("\\R");
    }

    public static interface IGUIEntry {
        @ApiStatus.Internal
        public void buildGUI(ConfigCategoryBuilder var1, ConfigFieldBuilder var2, boolean var3);
    }
}

