/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core;

import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.api.SimpleConfigGroup;
import endorh.simpleconfig.api.SimpleConfigTextUtil;
import endorh.simpleconfig.config.ClientConfig;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractSimpleConfigEntryHolder;
import endorh.simpleconfig.core.AtomicEntry;
import endorh.simpleconfig.core.ServerI18n;
import endorh.simpleconfig.core.SimpleConfigCategoryImpl;
import endorh.simpleconfig.core.SimpleConfigImpl;
import endorh.simpleconfig.ui.api.AbstractConfigListEntry;
import endorh.simpleconfig.ui.api.ConfigCategoryBuilder;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.CaptionedSubCategoryBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import endorh.simpleconfig.ui.impl.builders.SubCategoryBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleConfigGroupImpl
extends AbstractSimpleConfigEntryHolder
implements SimpleConfigGroup,
SimpleConfigImpl.IGUIEntry {
    @Nullable
    public final SimpleConfigCategoryImpl category;
    @Nullable
    public final SimpleConfigGroupImpl parentGroup;
    public final String name;
    public boolean expanded;
    protected final String title;
    protected final String tooltip;
    protected Map<String, SimpleConfigGroupImpl> groups;
    protected List<SimpleConfigImpl.IGUIEntry> order;
    @Nullable
    protected Consumer<SimpleConfigGroup> baker;
    protected AbstractConfigEntry<?, ?, ?> heldEntry;

    @ApiStatus.Internal
    protected SimpleConfigGroupImpl(SimpleConfigImpl config, String name, String title, String tooltip, boolean expanded, @Nullable Consumer<SimpleConfigGroup> baker) {
        this.root = config;
        this.category = null;
        this.parentGroup = null;
        this.name = name;
        this.title = title;
        this.tooltip = tooltip;
        this.expanded = expanded;
        this.baker = baker;
    }

    @ApiStatus.Internal
    protected SimpleConfigGroupImpl(SimpleConfigGroupImpl parent, String name, String title, String tooltip, boolean expanded, @Nullable Consumer<SimpleConfigGroup> baker) {
        this.root = parent.root;
        this.category = parent.category;
        this.parentGroup = parent;
        this.name = name;
        this.title = title;
        this.tooltip = tooltip;
        this.expanded = expanded;
        this.baker = baker;
    }

    @ApiStatus.Internal
    protected SimpleConfigGroupImpl(@NotNull SimpleConfigCategoryImpl parent, String name, String title, String tooltip, boolean expanded, @Nullable Consumer<SimpleConfigGroup> baker) {
        this.root = parent.root;
        this.category = parent;
        this.parentGroup = null;
        this.name = name;
        this.title = title;
        this.tooltip = tooltip;
        this.expanded = expanded;
        this.baker = baker;
    }

    @ApiStatus.Internal
    protected void build(Map<String, AbstractConfigEntry<?, ?, ?>> entries2, Map<String, SimpleConfigGroupImpl> groups, List<SimpleConfigImpl.IGUIEntry> guiOrder, @Nullable AbstractConfigEntry<?, ?, ?> heldEntry) {
        if (this.entries != null) {
            throw new IllegalStateException("Called buildEntry() twice");
        }
        if (heldEntry != null && !(heldEntry instanceof AtomicEntry)) {
            throw new IllegalArgumentException("Held entry for group " + this.getPath() + " doesn't implement IKeyEntry");
        }
        this.entries = entries2;
        this.groups = groups;
        this.children = groups;
        this.order = guiOrder;
        this.heldEntry = heldEntry;
    }

    @Override
    public String getPath() {
        return this.parentGroup != null ? this.parentGroup.getPathPart() + this.name : (this.category != null ? this.category.getPathPart() + this.name : this.root.getPathPart() + this.name);
    }

    @Override
    @NotNull
    public AbstractSimpleConfigEntryHolder getParent() {
        return this.parentGroup != null ? this.parentGroup : (this.category != null ? (this.category.isRoot ? this.root : this.category) : this.root);
    }

    @Override
    protected String getName() {
        return this.name;
    }

    @Override
    protected String getConfigComment() {
        StringBuilder builder = new StringBuilder();
        if (this.title != null && ServerI18n.hasKey(this.title)) {
            String name = SimpleConfigTextUtil.stripFormattingCodes(ServerI18n.format(this.title, new Object[0]).trim());
            builder.append(name).append('\n');
            if (this.tooltip != null && ServerI18n.hasKey(this.tooltip)) {
                String tooltip = "  " + SimpleConfigTextUtil.stripFormattingCodes(ServerI18n.format(this.tooltip, new Object[0]).trim().replace("\n", "\n  "));
                builder.append(tooltip).append('\n');
            }
        }
        return builder.toString();
    }

    @Override
    @Nullable
    public SimpleConfigCategoryImpl getCategory() {
        return this.category;
    }

    @Override
    public SimpleConfigGroupImpl getGroup(String path) {
        if (path.contains(".")) {
            String[] split = path.split("\\.", 2);
            if (this.groups.containsKey(split[0])) {
                return this.groups.get(split[0]).getGroup(split[1]);
            }
        } else if (this.groups.containsKey(path)) {
            return this.groups.get(path);
        }
        throw new SimpleConfig.NoSuchConfigGroupError(path);
    }

    @Override
    public void markDirty(boolean dirty) {
        super.markDirty(dirty);
        if (dirty) {
            (this.parentGroup != null ? this.parentGroup : (this.category != null ? this.category : this.root)).markDirty(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected Component getTitle() {
        if (ClientConfig.advanced.translation_debug_mode) {
            return this.getDebugTitle();
        }
        if (!I18n.m_118936_((String)this.title)) {
            String[] split = this.title.split("\\.");
            return Component.m_237113_((String)split[split.length - 1]);
        }
        return Component.m_237115_((String)this.title);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected Component getDebugTitle() {
        if (this.title != null) {
            MutableComponent status;
            MutableComponent mutableComponent = status = I18n.m_118936_((String)this.title) ? Component.m_237113_((String)"\u2714 ") : Component.m_237113_((String)"\u2718 ");
            if (this.tooltip != null) {
                status = status.m_7220_((Component)(I18n.m_118936_((String)this.tooltip) ? Component.m_237113_((String)"\u2714 ").m_130940_(ChatFormatting.DARK_AQUA) : Component.m_237113_((String)"_ ").m_130940_(ChatFormatting.DARK_AQUA)));
            }
            ChatFormatting format = I18n.m_118936_((String)this.title) ? ChatFormatting.DARK_GREEN : ChatFormatting.RED;
            return Component.m_237113_((String)"").m_7220_((Component)status.m_7220_((Component)Component.m_237113_((String)this.title)).m_130940_(format));
        }
        return Component.m_237113_((String)"").m_7220_((Component)Component.m_237113_((String)("\u26a0 " + this.name)).m_130940_(ChatFormatting.DARK_RED));
    }

    @OnlyIn(value=Dist.CLIENT)
    protected Optional<Component[]> getDebugTooltip() {
        MutableComponent status;
        ArrayList<Component> lines = new ArrayList<Component>();
        lines.add((Component)Component.m_237113_((String)"Group Translation key:").m_130940_(ChatFormatting.GRAY));
        if (this.title != null) {
            status = I18n.m_118936_((String)this.title) ? Component.m_237113_((String)"(\u2714 present)").m_130940_(ChatFormatting.DARK_GREEN) : Component.m_237113_((String)"(\u2718 missing)").m_130940_(ChatFormatting.RED);
            lines.add((Component)Component.m_237113_((String)("   " + this.title + " ")).m_130940_(ChatFormatting.DARK_AQUA).m_7220_((Component)status));
        } else {
            lines.add((Component)Component.m_237113_((String)"   Error: couldn't map translation key").m_130940_(ChatFormatting.RED));
        }
        lines.add((Component)Component.m_237113_((String)"Tooltip key:").m_130940_(ChatFormatting.GRAY));
        if (this.tooltip != null) {
            status = I18n.m_118936_((String)this.tooltip) ? Component.m_237113_((String)"(\u2714 present)").m_130940_(ChatFormatting.DARK_GREEN) : Component.m_237113_((String)"(not present)").m_130940_(ChatFormatting.GOLD);
            lines.add((Component)Component.m_237113_((String)("   " + this.tooltip + " ")).m_130940_(ChatFormatting.DARK_AQUA).m_7220_((Component)status));
        } else {
            lines.add((Component)Component.m_237113_((String)"   Error: couldn't map tooltip translation key").m_130940_(ChatFormatting.RED));
        }
        AbstractConfigEntry.addTranslationsDebugSuffix(lines);
        return Optional.of(lines.toArray(new Component[0]));
    }

    @OnlyIn(value=Dist.CLIENT)
    protected Optional<Component[]> getTooltip() {
        if (ClientConfig.advanced.translation_debug_mode) {
            return this.getDebugTooltip();
        }
        if (this.tooltip != null && I18n.m_118936_((String)this.tooltip)) {
            return Optional.of((Component[])Arrays.stream(I18n.m_118938_((String)this.tooltip, (Object[])new Object[0]).split("\n")).map(Component::m_237113_).toArray(Component[]::new));
        }
        return Optional.empty();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected CaptionedSubCategoryBuilder<?, ?, ?> buildGUI(ConfigFieldBuilder entryBuilder, boolean forRemote) {
        SubCategoryBuilder group2 = this.heldEntry != null ? this.createAndDecorateGUI(entryBuilder, this.heldEntry, forRemote) : entryBuilder.startSubCategory(this.getTitle());
        ((CaptionedSubCategoryBuilder)group2.setExpanded(this.expanded).setTooltipSupplier(this::getTooltip)).setName(this.name);
        if (!this.order.isEmpty()) {
            for (SimpleConfigImpl.IGUIEntry entry : this.order) {
                if (entry instanceof AbstractConfigEntry) {
                    ((AbstractConfigEntry)entry).buildGUI(group2, entryBuilder, forRemote);
                    continue;
                }
                if (!(entry instanceof SimpleConfigGroupImpl)) continue;
                group2.add((FieldBuilder<?, ?, ?>)((SimpleConfigGroupImpl)entry).buildGUI(entryBuilder, forRemote));
            }
        }
        return group2;
    }

    @OnlyIn(value=Dist.CLIENT)
    private <T, CE extends AbstractConfigEntry<?, ?, T>> CaptionedSubCategoryBuilder<T, ?, ?> createAndDecorateGUI(ConfigFieldBuilder entryBuilder, AbstractConfigEntry<?, ?, T> heldEntry, boolean forRemote) {
        AbstractConfigEntry<?, ?, T> cast = heldEntry;
        Object builder = ((AtomicEntry)((Object)cast)).buildAtomicChildGUIEntry(entryBuilder);
        cast.decorateGUIBuilder((FieldBuilder<T, ?, ?>)builder, forRemote);
        return (CaptionedSubCategoryBuilder)this.makeGUI(entryBuilder, (FieldBuilder<T, ?, ?>)builder).withSaveConsumer(cast.createSaveConsumer());
    }

    @OnlyIn(value=Dist.CLIENT)
    private <T, HE extends AbstractConfigListEntry<T>, HEB extends FieldBuilder<T, HE, HEB>> CaptionedSubCategoryBuilder<T, ?, ?> makeGUI(ConfigFieldBuilder entryBuilder, FieldBuilder<T, ?, ?> builder) {
        return entryBuilder.startCaptionedSubCategory(this.getTitle(), builder);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @ApiStatus.Internal
    public void buildGUI(ConfigCategoryBuilder category, ConfigFieldBuilder entryBuilder, boolean forRemote) {
        category.addEntry(this.buildGUI(entryBuilder, forRemote));
    }

    @Override
    protected void bake() {
        for (SimpleConfigGroupImpl group2 : this.groups.values()) {
            group2.bake();
        }
        if (this.baker != null) {
            this.baker.accept(this);
        }
    }

    protected void bakeFields() {
        for (SimpleConfigGroupImpl group2 : this.groups.values()) {
            group2.bakeFields();
        }
        for (AbstractConfigEntry entry : this.entries.values()) {
            entry.bakeField();
        }
    }

    @Override
    public void commitFields() {
        try {
            for (SimpleConfigGroupImpl group2 : this.groups.values()) {
                group2.commitFields();
            }
            for (AbstractConfigEntry entry : this.entries.values()) {
                entry.commitField();
            }
        }
        catch (IllegalAccessException e) {
            throw new SimpleConfig.ConfigReflectiveOperationException("Could not access mod config field during config commit\n  Details: " + e.getMessage(), e);
        }
    }
}

