/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core;

import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.api.SimpleConfigGUIManager;
import endorh.simpleconfig.api.SimpleConfigTextUtil;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.config.ClientConfig;
import endorh.simpleconfig.config.CommonConfig;
import endorh.simpleconfig.config.ServerConfig;
import endorh.simpleconfig.core.SimpleConfigImpl;
import endorh.simpleconfig.core.SimpleConfigNetworkHandler;
import endorh.simpleconfig.core.SimpleConfigSnapshotHandler;
import endorh.simpleconfig.ui.api.ConfigScreenBuilder;
import endorh.simpleconfig.ui.api.IDialogCapableScreen;
import endorh.simpleconfig.ui.gui.AbstractConfigScreen;
import endorh.simpleconfig.ui.gui.DialogScreen;
import endorh.simpleconfig.ui.gui.InfoDialog;
import endorh.simpleconfig.ui.gui.widget.MultiFunctionImageButton;
import endorh.simpleconfig.ui.hotkey.ConfigHotKey;
import endorh.simpleconfig.ui.hotkey.HotKeyListDialog;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsScreen;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.gui.ModListScreen;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="simpleconfig")
public final class SimpleConfigGUIManagerImpl
implements SimpleConfigGUIManager {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final SimpleConfigGUIManagerImpl INSTANCE = new SimpleConfigGUIManagerImpl();
    private static final String MINECRAFT_MOD_ID = "minecraft";
    private final Map<String, Map<SimpleConfig.Type, SimpleConfigImpl>> modConfigs = Collections.synchronizedMap(new HashMap());
    private final Map<String, AbstractConfigScreen> activeScreens = new HashMap<String, AbstractConfigScreen>();
    private boolean addButton = false;
    private boolean autoAddedButton = false;
    private Comparator<SimpleConfigImpl> typeOrder = Comparator.comparing(SimpleConfigImpl::getType);
    private ResourceLocation defaultBackground = new ResourceLocation("textures/block/oak_planks.png");
    private int guiSession;
    private final Map<String, Integer> guiSessions = new HashMap<String, Integer>();
    private final Map<String, ConfigScreenBuilder.IConfigScreenGUIState> guiStates = new HashMap<String, ConfigScreenBuilder.IConfigScreenGUIState>();
    private Button lastOptionsButton = null;

    private SimpleConfigGUIManagerImpl() {
    }

    @ApiStatus.Internal
    public int getGuiSession() {
        return this.guiSession;
    }

    @Override
    public void setAddButton(boolean add) {
        this.addButton = add;
        this.autoAddedButton = true;
    }

    @Override
    @ApiStatus.Internal
    public boolean hasConfigGUI(String modId) {
        return this.modConfigs.containsKey(modId);
    }

    protected void registerConfig(SimpleConfigImpl config) {
        String modId = config.getModId();
        ModContainer container = config.getModContainer();
        Optional ext = ConfigScreenHandler.getScreenFactoryFor((IModInfo)container.getModInfo());
        if (config.isWrapper() && (!CommonConfig.menu.shouldWrapConfig(modId) || ext.isPresent() && !(ext.get() instanceof SimpleConfigGuiFactory) && !CommonConfig.menu.shouldReplaceMenu(modId))) {
            return;
        }
        if (!this.autoAddedButton) {
            this.addButton = true;
            this.autoAddedButton = true;
        }
        if (!this.modConfigs.containsKey(modId)) {
            this.modConfigs.computeIfAbsent(modId, s -> Collections.synchronizedMap(new HashMap())).put(config.getType(), config);
            container.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((BiFunction)new SimpleConfigGuiFactory(modId)));
        } else {
            this.modConfigs.get(modId).put(config.getType(), config);
        }
    }

    private void reRegisterMenus() {
        ModList.get().forEachModContainer((modId, container) -> {
            if (this.modConfigs.containsKey(modId)) {
                container.getCustomExtension(ConfigScreenHandler.ConfigScreenFactory.class).ifPresent(f -> {
                    if (!(f.screenFunction() instanceof SimpleConfigGuiFactory)) {
                        container.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((BiFunction)new SimpleConfigGuiFactory((String)modId)));
                    }
                });
            }
        });
    }

    public Screen getNoServerDialogScreen(Screen parent) {
        return new DialogScreen(parent, InfoDialog.create((Component)Component.m_237115_((String)"simpleconfig.error.no_server.dialog.title"), SimpleConfigTextUtil.splitTtc("simpleconfig.error.no_server.dialog.body", new Object[0]), d -> d.setConfirmText((Component)Component.m_237115_((String)"gui.ok"))));
    }

    public Screen getConfigGUIForHotKey(String modId, IDialogCapableScreen parent, HotKeyListDialog hotKeyDialog, ConfigHotKey hotkey) {
        AbstractConfigScreen screen = this.activeScreens.get(modId);
        Screen parentScreen = (Screen)parent;
        if (screen != null) {
            int prevSession = this.guiSession;
            this.guiSession = this.guiSessions.get(modId);
            screen.setEditedConfigHotKey(hotkey, r -> {
                screen.setEditedConfigHotKey(null, null);
                Minecraft.m_91087_().m_91152_(parentScreen);
                if (hotKeyDialog != null) {
                    parent.addDialog(hotKeyDialog);
                }
                this.guiSession = prevSession;
            });
            return screen;
        }
        Map<SimpleConfig.Type, SimpleConfigImpl> configs = this.modConfigs.get(modId);
        if (configs == null || configs.isEmpty()) {
            throw new IllegalArgumentException("No Simple Config GUI registered for mod id: \"" + modId + "\"");
        }
        Minecraft mc = Minecraft.m_91087_();
        boolean hasPermission = mc.f_91074_ != null && ((ServerConfig.ConfigPermission)((Object)ServerConfig.permissions.permissionFor((Player)mc.f_91074_, modId).getLeft())).canView();
        List<SimpleConfigImpl> orderedConfigs = configs.values().stream().filter(c -> c.getType() != SimpleConfig.Type.SERVER || hasPermission).sorted(this.typeOrder).toList();
        if (orderedConfigs.isEmpty()) {
            return this.getNoServerDialogScreen(parentScreen);
        }
        ConfigScreenBuilder builder = ConfigScreenBuilder.create(modId).setParentScreen(parentScreen).setSavingRunnable(() -> {}).setTitle((Component)Component.m_237110_((String)"simpleconfig.config.title", (Object[])new Object[]{SimpleConfigImpl.getModNameOrId(modId)})).setDefaultBackgroundTexture(this.defaultBackground).setPreviousGUIState(this.guiStates.get(modId)).setEditedConfigHotKey(hotkey, r -> {
            AbstractConfigScreen removed = this.activeScreens.remove(modId);
            this.guiStates.put(modId, removed.saveConfigScreenGUIState());
            this.guiSessions.remove(modId);
            if (configs.containsKey((Object)SimpleConfig.Type.COMMON) && !Minecraft.m_91087_().m_91090_() && hasPermission) {
                new SimpleConfigNetworkHandler.CSimpleConfigReleaseServerCommonConfigPacket(modId).send();
            }
            for (SimpleConfigImpl c : orderedConfigs) {
                c.removeGUI();
            }
            Minecraft.m_91087_().m_91152_(parentScreen);
            if (hotKeyDialog != null) {
                parent.addDialog(hotKeyDialog);
            }
        });
        for (SimpleConfigImpl config : orderedConfigs) {
            config.buildGUI(builder, false);
        }
        this.guiSessions.put(modId, ++this.guiSession);
        AbstractConfigScreen gui = builder.build();
        this.activeScreens.put(modId, gui);
        for (SimpleConfigImpl config : orderedConfigs) {
            config.setGUI(gui, null);
        }
        return gui;
    }

    @Override
    @Nullable
    public Screen getConfigGUI(String modId, Screen parent) {
        Map<SimpleConfig.Type, SimpleConfigImpl> configs = this.modConfigs.get(modId);
        if (configs == null || configs.isEmpty()) {
            throw new IllegalArgumentException("No Simple Config GUI registered for mod id: \"" + modId + "\"");
        }
        Minecraft mc = Minecraft.m_91087_();
        boolean hasPermission = mc.f_91074_ != null && ((ServerConfig.ConfigPermission)((Object)ServerConfig.permissions.permissionFor((Player)mc.f_91074_, modId).getLeft())).canView();
        List<SimpleConfigImpl> orderedConfigs = configs.values().stream().filter(c -> c.getType() != SimpleConfig.Type.SERVER || hasPermission).sorted(this.typeOrder).toList();
        if (orderedConfigs.isEmpty()) {
            return this.getNoServerDialogScreen(parent);
        }
        SimpleConfigSnapshotHandler handler = new SimpleConfigSnapshotHandler(configs);
        ConfigScreenBuilder builder = ConfigScreenBuilder.create(modId).setParentScreen(parent).setSavingRunnable(() -> {
            for (SimpleConfigImpl c : orderedConfigs) {
                if (!c.isDirty()) continue;
                c.save();
            }
        }).setPreviousGUIState(this.guiStates.get(modId)).setClosingRunnable(() -> {
            AbstractConfigScreen removed = this.activeScreens.remove(modId);
            this.guiStates.put(modId, removed.saveConfigScreenGUIState());
            if (configs.containsKey((Object)SimpleConfig.Type.COMMON) && !Minecraft.m_91087_().m_91090_() && hasPermission) {
                new SimpleConfigNetworkHandler.CSimpleConfigReleaseServerCommonConfigPacket(modId).send();
            }
            for (SimpleConfigImpl c : orderedConfigs) {
                c.removeGUI();
            }
        }).setTitle((Component)Component.m_237110_((String)"simpleconfig.config.title", (Object[])new Object[]{SimpleConfigImpl.getModNameOrId(modId)})).setDefaultBackgroundTexture(this.defaultBackground).setSnapshotHandler(handler).setRemoteCommonConfigProvider(handler);
        for (SimpleConfigImpl config : orderedConfigs) {
            config.buildGUI(builder, false);
            if (config.getType() != SimpleConfig.Type.COMMON || Minecraft.m_91087_().m_91090_() || !hasPermission) continue;
            config.buildGUI(builder, true);
        }
        this.guiSessions.put(modId, ++this.guiSession);
        AbstractConfigScreen gui = builder.build();
        this.activeScreens.put(modId, gui);
        for (SimpleConfigImpl config : orderedConfigs) {
            config.setGUI(gui, handler);
        }
        return gui;
    }

    @Override
    @Nullable
    public Screen getConfigGUI(String modId) {
        return this.getConfigGUI(modId, Minecraft.m_91087_().f_91080_);
    }

    @Override
    public void showConfigGUI(String modId) {
        Screen screen = this.getConfigGUI(modId);
        if (screen != null) {
            Minecraft.m_91087_().m_91152_(screen);
        }
    }

    public void showConfigGUIForHotKey(String modId, IDialogCapableScreen parent, HotKeyListDialog hotKeyDialog, ConfigHotKey hotKey) {
        Minecraft.m_91087_().m_91152_(this.getConfigGUIForHotKey(modId, parent, hotKeyDialog, hotKey));
    }

    @Override
    public void showModListGUI() {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91152_((Screen)new ModListScreen(mc.f_91080_));
    }

    @Override
    public void showConfigHotkeysGUI() {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91152_((Screen)new DialogScreen(mc.f_91080_, new HotKeyListDialog(null)));
    }

    public static Optional<Button> getOptionsButton(Screen gui, List<GuiEventListener> widgets, boolean checkDimensions) {
        int x = gui.f_96543_ / 2 - (gui instanceof TitleScreen ? 100 : 102);
        int y = gui instanceof TitleScreen ? gui.f_96544_ / 4 + 48 + 72 + 12 : gui.f_96544_ / 4 + 96 - 16;
        int width = 98;
        Optional<Button> opt = widgets.stream().filter(l -> l instanceof Button).map(l -> (Button)l).filter(b -> {
            TranslatableContents tc;
            ComponentContents contents = b.m_6035_().m_214077_();
            return contents instanceof TranslatableContents && "menu.options".equals((tc = (TranslatableContents)contents).m_237508_());
        }).findFirst().filter(b -> !checkDimensions || b.m_252754_() == x && b.m_252907_() == y && b.m_5711_() == width);
        if (opt.isEmpty()) {
            LOGGER.debug("Couldn't find options button in " + gui.getClass().getCanonicalName());
        }
        return opt;
    }

    public record SimpleConfigGuiFactory(String modId) implements BiFunction<Minecraft, Screen, Screen>
    {
        @Override
        public Screen apply(Minecraft minecraft, Screen screen) {
            Screen gui = INSTANCE.getConfigGUI(this.modId, screen);
            return gui != null ? gui : screen;
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD, modid="simpleconfig")
    private static class ModEventSubscriber {
        private ModEventSubscriber() {
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onLoadComplete(FMLLoadCompleteEvent event) {
            if (CommonConfig.menu.prevent_external_menu_replacement) {
                event.enqueueWork(INSTANCE::reRegisterMenus);
            }
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="simpleconfig")
    private static class EventSubscriber {
        private EventSubscriber() {
        }

        @SubscribeEvent
        public static void onGuiInit(ScreenEvent.Init.Post event) {
            if (!(SimpleConfigGUIManagerImpl.INSTANCE.addButton && ClientConfig.menu.add_pause_menu_button || ClientConfig.menu.options_button_behaviour != ClientConfig.OptionsButtonBehaviour.DEFAULT)) {
                return;
            }
            Screen gui = event.getScreen();
            boolean hasMinecraftOptionsGui = INSTANCE.hasConfigGUI(SimpleConfigGUIManagerImpl.MINECRAFT_MOD_ID);
            if (gui instanceof PauseScreen) {
                if (hasMinecraftOptionsGui) {
                    SimpleConfigGUIManagerImpl.getOptionsButton(gui, event.getListenersList(), false).ifPresent(b -> {
                        SimpleConfigGUIManagerImpl.INSTANCE.lastOptionsButton = b;
                    });
                }
                if (SimpleConfigGUIManagerImpl.INSTANCE.addButton && ClientConfig.menu.add_pause_menu_button) {
                    int x;
                    int w = 20;
                    int h = 20;
                    ImageButton modOptions = new ImageButton(x, switch (ClientConfig.menu.menu_button_position) {
                        case ClientConfig.PauseMenuButtonPosition.TOP_LEFT_CORNER -> {
                            x = 8;
                            yield 8;
                        }
                        case ClientConfig.PauseMenuButtonPosition.TOP_RIGHT_CORNER -> {
                            x = gui.f_96543_ - 28;
                            yield 8;
                        }
                        case ClientConfig.PauseMenuButtonPosition.BOTTOM_LEFT_CORNER -> {
                            x = 8;
                            yield gui.f_96544_ - 28;
                        }
                        case ClientConfig.PauseMenuButtonPosition.BOTTOM_RIGHT_CORNER -> {
                            x = gui.f_96543_ - 28;
                            yield gui.f_96544_ - 28;
                        }
                        case ClientConfig.PauseMenuButtonPosition.SPLIT_OPTIONS_BUTTON -> {
                            Optional<Button> opt = SimpleConfigGUIManagerImpl.getOptionsButton(gui, event.getListenersList(), true);
                            if (opt.isPresent()) {
                                Button options = opt.get();
                                options.m_93674_(options.m_5711_() - 20 - 4);
                                x = gui.f_96543_ / 2 - 102 + 98 - 20;
                                yield gui.f_96544_ / 4 + 96 - 16;
                            }
                        }
                        default -> {
                            x = gui.f_96543_ / 2 - 102 - w - 4;
                            yield gui.f_96544_ / 4 + 96 - 16;
                        }
                    }, w, h, 0, 0, 20, new ResourceLocation("simpleconfig", "textures/gui/simpleconfig/menu.png"), 32, 64, p -> INSTANCE.showModListGUI());
                    event.addListener((GuiEventListener)modOptions);
                }
            } else if (gui instanceof TitleScreen && hasMinecraftOptionsGui) {
                SimpleConfigGUIManagerImpl.getOptionsButton(gui, event.getListenersList(), false).ifPresent(b -> {
                    SimpleConfigGUIManagerImpl.INSTANCE.lastOptionsButton = b;
                });
            } else if (gui instanceof OptionsScreen) {
                OptionsScreen os = (OptionsScreen)gui;
                if (SimpleConfigGUIManagerImpl.INSTANCE.addButton && ClientConfig.menu.add_options_menu_button && hasMinecraftOptionsGui) {
                    MultiFunctionImageButton b2 = MultiFunctionImageButton.of(SimpleConfigIcons.Buttons.GEAR, MultiFunctionImageButton.ButtonAction.of(() -> Minecraft.m_91087_().m_91152_(INSTANCE.getConfigGUI(SimpleConfigGUIManagerImpl.MINECRAFT_MOD_ID, gui))).tooltip(SimpleConfigTextUtil.splitTtc("simpleconfig.ui.edit_with_simpleconfig", new Object[0])));
                    switch (ClientConfig.menu.options_menu_button_position) {
                        case TOP_LEFT_CORNER: {
                            b2.m_264152_(8, 8);
                            break;
                        }
                        case TOP_RIGHT_CORNER: {
                            b2.m_264152_(gui.f_96543_ - b2.m_5711_() - 8, 8);
                            break;
                        }
                        case BOTTOM_LEFT_CORNER: {
                            b2.m_264152_(8, gui.f_96544_ - b2.m_93694_() - 8);
                            break;
                        }
                        case BOTTOM_RIGHT_CORNER: {
                            b2.m_264152_(gui.f_96543_ - b2.m_5711_() - 8, gui.f_96544_ - b2.m_93694_() - 8);
                        }
                    }
                    event.addListener((GuiEventListener)b2);
                }
            }
        }

        @SubscribeEvent
        public static void onButtonClick(ScreenEvent.MouseButtonPressed.Pre event) {
            if (ClientConfig.menu.options_button_behaviour == ClientConfig.OptionsButtonBehaviour.DEFAULT || SimpleConfigGUIManagerImpl.INSTANCE.lastOptionsButton == null) {
                return;
            }
            Screen screen = Minecraft.m_91087_().f_91080_;
            if ((screen instanceof PauseScreen || screen instanceof TitleScreen) && SimpleConfigGUIManagerImpl.INSTANCE.lastOptionsButton.m_5953_(event.getMouseX(), event.getMouseY()) && (ClientConfig.menu.options_button_behaviour == ClientConfig.OptionsButtonBehaviour.MAIN_CLICK ? event.getButton() != 1 && !Screen.m_96638_() : event.getButton() == 1 || Screen.m_96638_()) && INSTANCE.hasConfigGUI(SimpleConfigGUIManagerImpl.MINECRAFT_MOD_ID)) {
                INSTANCE.showConfigGUI(SimpleConfigGUIManagerImpl.MINECRAFT_MOD_ID);
                event.setCanceled(true);
            }
        }
    }
}

