/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileWatcher;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.WritingMode;
import endorh.simpleconfig.core.SimpleConfigModConfig;
import endorh.simpleconfig.core.SimpleConfigNetworkHandler;
import endorh.simpleconfig.core.SimpleConfigPaths;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraftforge.fml.config.ConfigFileTypeHandler;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.ApiStatus;

public class SimpleConfigFileTypeHandler
extends ConfigFileTypeHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker CONFIG = MarkerManager.getMarker((String)"CONFIG");
    public static SimpleConfigFileTypeHandler YAML = new SimpleConfigFileTypeHandler();

    public Function<ModConfig, CommentedFileConfig> reader(Path configBasePath) {
        return config -> {
            if (!(config instanceof SimpleConfigModConfig)) {
                throw new IllegalArgumentException("SimpleConfigFileTypeHandler can only handle SimpleConfigModConfig");
            }
            SimpleConfigModConfig c = (SimpleConfigModConfig)((Object)config);
            Path configPath = configBasePath.resolve(c.getFileName());
            CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)configPath, (ConfigFormat)c.getConfigFormat()).sync().preserveInsertionOrder().autosave().onFileNotFound((newFile, configFormat) -> this.setupConfigFile((ModConfig)config, newFile, (ConfigFormat<?>)configFormat)).writingMode(WritingMode.REPLACE).build();
            LOGGER.debug(CONFIG, "Built YAML config for {}", (Object)configPath.toString());
            try {
                configData.load();
            }
            catch (ParsingException ex) {
                throw new ReportedException(CrashReport.m_127521_((Throwable)ex, (String)("Error reading config file " + c.getFileName())));
            }
            LOGGER.debug(CONFIG, "Loaded YAML config file {}", (Object)configPath.toString());
            try {
                FileWatcher.defaultInstance().addWatch(configPath, (Runnable)new SimpleConfigWatcher((ModConfig)config, configData, Thread.currentThread().getContextClassLoader()));
                LOGGER.debug(CONFIG, "Watching YAML config file {} for changes", (Object)configPath.toString());
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't watch config file", e);
            }
            return configData;
        };
    }

    public void unload(Path configBasePath, ModConfig config) {
        Path configPath = configBasePath.resolve(config.getFileName());
        try {
            FileWatcher.defaultInstance().removeWatch(configBasePath.resolve(config.getFileName()));
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed to remove config {} from tracker!", (Object)configPath.toString(), (Object)e);
        }
    }

    private boolean setupConfigFile(ModConfig modConfig, Path file, ConfigFormat<?> conf) throws IOException {
        Path p = SimpleConfigPaths.DEFAULT_SERVER_CONFIG_DIR.resolve(modConfig.getFileName());
        if (Files.exists(p, new LinkOption[0])) {
            LOGGER.info(CONFIG, "Loading default config file from path {}", (Object)p);
            Files.copy(p, file, new CopyOption[0]);
        } else {
            Files.createFile(file, new FileAttribute[0]);
            conf.initEmptyFile(file);
        }
        return true;
    }

    @ApiStatus.Internal
    public static class SimpleConfigWatcher
    implements Runnable {
        private final ModConfig modConfig;
        private final CommentedFileConfig commentedFileConfig;
        private final ClassLoader realClassLoader;

        SimpleConfigWatcher(ModConfig modConfig, CommentedFileConfig commentedFileConfig, ClassLoader classLoader) {
            this.modConfig = modConfig;
            this.commentedFileConfig = commentedFileConfig;
            this.realClassLoader = classLoader;
        }

        @Override
        public void run() {
            Thread.currentThread().setContextClassLoader(this.realClassLoader);
            if (!this.modConfig.getSpec().isCorrecting()) {
                try {
                    this.commentedFileConfig.load();
                    if (!this.modConfig.getSpec().isCorrect((CommentedConfig)this.commentedFileConfig)) {
                        LOGGER.warn(CONFIG, "Configuration file {} is not correct. Correcting", (Object)this.commentedFileConfig.getFile().getAbsolutePath());
                        ConfigFileTypeHandler.backUpConfig((CommentedFileConfig)this.commentedFileConfig);
                        this.modConfig.getSpec().correct((CommentedConfig)this.commentedFileConfig);
                        this.commentedFileConfig.save();
                    }
                }
                catch (ParsingException ex) {
                    throw new ConfigLoadingException(this.modConfig, (Exception)((Object)ex));
                }
                LOGGER.debug(CONFIG, "Config file {} changed, sending notifies", (Object)this.modConfig.getFileName());
                this.modConfig.getSpec().afterReload();
                try {
                    SimpleConfigNetworkHandler.tryFireEvent(this.modConfig, (ModConfigEvent)SimpleConfigNetworkHandler.newReloading(this.modConfig));
                }
                catch (RuntimeException e) {
                    LOGGER.error("Error updating config from file {}", (Object)this.modConfig.getFileName(), (Object)e);
                }
            }
        }
    }

    private static class ConfigLoadingException
    extends RuntimeException {
        public ConfigLoadingException(ModConfig config, Exception cause) {
            super("Failed loading config file " + config.getFileName() + " of type " + config.getType() + " for modid " + config.getModId(), cause);
        }
    }
}

